/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vim.sso.admin.client.vmomi.impl;

import com.vmware.vim.binding.sso.admin.ReplicationService;
import com.vmware.vim.binding.sso.fault.InternalFault;
import com.vmware.vim.binding.sso.fault.InvalidCredentials;
import com.vmware.vim.binding.sso.fault.NoPermission;
import com.vmware.vim.binding.sso.fault.NotAuthenticated;
import com.vmware.vim.binding.vmodl.Binary;
import com.vmware.vim.binding.vmodl.fault.InvalidArgument;
import com.vmware.vim.binding.vmodl.fault.NotSupported;
import com.vmware.vim.sso.admin.Replication;
import com.vmware.vim.sso.admin.client.vmomi.impl.VmomiClientCommand;
import com.vmware.vim.sso.admin.exception.InternalError;
import com.vmware.vim.sso.admin.exception.NoPermissionException;
import com.vmware.vim.sso.admin.exception.NotAuthenticatedException;
import com.vmware.vim.sso.admin.impl.util.ValidateUtil;
import com.vmware.vim.sso.admin.impl.util.VmodlTypeConversions;
import java.io.IOException;
import java.io.InputStream;

final class ReplicationImpl
implements Replication {
    private final ReplicationService _service;

    public ReplicationImpl(ReplicationService service) {
        assert (service != null);
        this._service = service;
    }

    public InputStream exportFullState() throws NotAuthenticatedException, NoPermissionException, UnsupportedOperationException, InternalError {
        return (InputStream)new VmomiClientCommand<InputStream>(){

            @Override
            public InputStream actionCommand() throws NotAuthenticated, NoPermission, InvalidCredentials, NotSupported, InternalFault {
                return VmodlTypeConversions.fromVmodl((Binary)ReplicationImpl.this._service.exportFullState());
            }
        }.executeEnsuringDomainErrorIs(NotAuthenticatedException.class);
    }

    public void importFullState(InputStream fullState) throws NotAuthenticatedException, NoPermissionException, IOException, UnsupportedOperationException, IllegalArgumentException, InternalError {
        ValidateUtil.validateNotNull((Object)fullState, (String)"Imported state");
        final Binary binary = VmodlTypeConversions.toVmodl((InputStream)fullState);
        new VmomiClientCommand<Void>(){

            @Override
            public Void actionCommand() throws NotAuthenticated, NoPermission, InvalidCredentials, NotSupported, InvalidArgument, InternalFault {
                ReplicationImpl.this._service.importFullState(binary);
                return null;
            }
        }.executeEnsuringDomainErrorIs(NotAuthenticatedException.class);
    }
}

