/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vim.vmomi.core.types.impl;

import com.vmware.vim.binding.vmodl.compatible;
import com.vmware.vim.binding.vmodl.internal;
import com.vmware.vim.binding.vmodl.service;
import com.vmware.vim.binding.vmodl.versionId;
import com.vmware.vim.binding.vmodl.wsdlName;
import com.vmware.vim.vmomi.core.types.VmodlVersion;
import com.vmware.vim.vmomi.core.types.VmodlVersionMap;
import com.vmware.vim.vmomi.core.types.VmomiService;
import com.vmware.vim.vmomi.core.types.impl.VmomiServiceImpl;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;

public class VmodlVersionImpl
implements VmodlVersion {
    public static final String INTERNAL_PREFIX = "internal";
    private Set<VmodlVersion> _parent;
    private AtomicReference<Set<VmodlVersion>> _compatible;
    private String _versionId;
    private String _wsdlNamespace;
    private VmomiService _service;
    private String _namespace;
    private boolean _shouldMarshallNamespace;
    private boolean _internal;
    private Class<?> _versionClass;

    public VmodlVersionImpl(Class<?> version) {
        this.init(version);
    }

    private void init(Class<?> version) {
        this._versionClass = version;
        this._parent = new HashSet<VmodlVersion>();
        compatible compatAnnotation = version.getAnnotation(compatible.class);
        if (compatAnnotation != null) {
            VmodlVersionMap map2 = VmodlVersionMap.Factory.getVmodlVersionMap();
            Class[] compatibleClass = compatAnnotation.value();
            for (int i = 0; i < compatibleClass.length; ++i) {
                VmodlVersion compatibleVersion = map2.getVersion(compatibleClass[i]);
                if (compatibleVersion == null) {
                    VmodlVersionImpl newVersion = new VmodlVersionImpl(compatibleClass[i]);
                    this._parent.add(newVersion);
                    continue;
                }
                this._parent.add(compatibleVersion);
            }
        }
        this._compatible = new AtomicReference();
        versionId versionIdAnnotation = version.getAnnotation(versionId.class);
        if (versionIdAnnotation != null) {
            this._versionId = versionIdAnnotation.value();
        }
        this._internal = version.getAnnotation(internal.class) != null;
        service serviceAnnotation = version.getAnnotation(service.class);
        this._service = serviceAnnotation != null ? new VmomiServiceImpl(serviceAnnotation) : VmomiServiceImpl.DEFAULT_SERVICE;
        wsdlName nsAnnotation = version.getAnnotation(wsdlName.class);
        this._namespace = nsAnnotation != null ? (this._wsdlNamespace = nsAnnotation.value()) : (this._internal ? INTERNAL_PREFIX + this._service.getServiceNamespace() : this._service.getServiceNamespace());
        this._shouldMarshallNamespace = this.computeShouldMarshallNamespace();
    }

    boolean computeShouldMarshallNamespace() {
        if ("".equals(this._service.getServiceNamespace())) {
            return false;
        }
        if (this._internal) {
            String internalPrefixed = INTERNAL_PREFIX + this._service.getServiceNamespace();
            return internalPrefixed.equals(this._namespace);
        }
        return this._service.getServiceNamespace().equals(this._namespace);
    }

    @Override
    public String getVersionId() {
        return this._versionId;
    }

    @Override
    public String getWsdlNamespace() {
        return this._wsdlNamespace;
    }

    @Override
    public boolean isCompatible(VmodlVersion version) {
        if (this._compatible.get() != null) {
            return this._compatible.get().contains(version);
        }
        HashSet<VmodlVersion> compatible2 = new HashSet<VmodlVersion>();
        this.resolveDependency(this, compatible2);
        this._compatible.compareAndSet(null, compatible2);
        return compatible2.contains(version);
    }

    private void resolveDependency(VmodlVersion version, Set<VmodlVersion> compatible2) {
        compatible2.add(version);
        Set<VmodlVersion> parent = version.getParentVersion();
        Iterator<VmodlVersion> it = parent.iterator();
        while (it.hasNext()) {
            this.resolveDependency(it.next(), compatible2);
        }
    }

    @Override
    public Set<VmodlVersion> getParentVersion() {
        return Collections.unmodifiableSet(this._parent);
    }

    @Override
    public boolean isInternal() {
        return this._internal;
    }

    @Override
    public Class<?> getVersionClass() {
        return this._versionClass;
    }

    public boolean equals(Object rhs) {
        if (this == rhs) {
            return true;
        }
        if (!(rhs instanceof VmodlVersion)) {
            return false;
        }
        return this._versionClass.equals(((VmodlVersion)rhs).getVersionClass());
    }

    public int hashCode() {
        return this._versionClass.hashCode();
    }

    public String toString() {
        return String.format("%1$s/%2$s", this.getWsdlNamespace(), this.getVersionId());
    }

    @Override
    public VmomiService getService() {
        return this._service;
    }

    @Override
    public String getNamespace() {
        return this._namespace;
    }

    @Override
    public boolean shouldMarshallNamespace() {
        return this._shouldMarshallNamespace;
    }
}

