/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vim.vmomi.core.util;

import com.vmware.vim.binding.vmodl.DataObject;
import com.vmware.vim.binding.vmodl.ManagedObject;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vim.vmomi.core.types.ComplexType;
import com.vmware.vim.vmomi.core.types.ComplexTypeField;
import com.vmware.vim.vmomi.core.types.VmodlArrayType;
import com.vmware.vim.vmomi.core.types.VmodlType;
import com.vmware.vim.vmomi.core.types.VmodlTypeMap;
import java.lang.reflect.Array;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;

public class EqualityUtil {
    private static final String KEY_PROP_NAME = "key";

    public static boolean areEqual(DataObject left, DataObject right) {
        return EqualityUtil.areComplexTypeEqual(left, right);
    }

    public static boolean areEqual(Object left, Object right) {
        return EqualityUtil.areEqual(left, right, null);
    }

    static boolean areEqual(Object left, Object right, VmodlType type) {
        if (left == right) {
            return true;
        }
        if (left == null ^ right == null) {
            return EqualityUtil.checkForEmptyArray(left, right, type);
        }
        if (left.getClass() != right.getClass()) {
            return false;
        }
        if (type == null || type.getKind() == VmodlType.Kind.ANY) {
            type = EqualityUtil.resolveDynamicType(left);
        }
        switch (type.getKind()) {
            case ARRAY: {
                VmodlArrayType arrType = (VmodlArrayType)type;
                if (EqualityUtil.isKeyedCollection(arrType)) {
                    return EqualityUtil.areKeyedArraysEqual(left, right, arrType.getComponentType());
                }
                return EqualityUtil.areArraysEqual(left, right, arrType.getComponentType());
            }
            case DATA_OBJECT: 
            case FAULT: {
                return EqualityUtil.areComplexTypeEqual(left, right);
            }
            case MANAGED_OBJECT: {
                return ((ManagedObject)left)._getRef().equals(((ManagedObject)right)._getRef());
            }
            case BOOL: 
            case BYTE: 
            case SHORT: 
            case INT: 
            case LONG: 
            case FLOAT: 
            case DOUBLE: 
            case STRING: 
            case DATETIME: 
            case METHOD_NAME: 
            case TYPE_NAME: 
            case MOREF: 
            case PROPERTY_PATH: 
            case URI: 
            case ENUM: 
            case BINARY: {
                return left.equals(right);
            }
        }
        throw new RuntimeException("Unexpected VmodlType: " + (Object)((Object)type.getKind()));
    }

    static boolean areComplexTypeEqual(Object left, Object right) {
        ComplexTypeField[] props;
        if (left == right) {
            return true;
        }
        if (left == null ^ right == null) {
            return false;
        }
        if (left.getClass() != right.getClass()) {
            return false;
        }
        ComplexType doType = (ComplexType)EqualityUtil.resolveDynamicType(left);
        for (ComplexTypeField prop : props = doType.getProperties()) {
            ComplexTypeField field = doType.getProperty(prop.getName());
            if (EqualityUtil.areEqual(field.get(left), field.get(right), field.getType())) continue;
            return false;
        }
        return true;
    }

    static boolean areKeyedEqual(int[] left, int[] right) {
        if (left.length != right.length) {
            return false;
        }
        int[] l = Arrays.copyOf(left, left.length);
        int[] r = Arrays.copyOf(right, right.length);
        Arrays.sort(l);
        Arrays.sort(r);
        return Arrays.equals(l, r);
    }

    static <T> boolean areKeyedEqual(T[] left, T[] right) {
        if (left.length != right.length) {
            return false;
        }
        HashSet<T> leftSet = new HashSet<T>(Arrays.asList(left));
        for (int i = 0; i < right.length; ++i) {
            if (leftSet.remove(right[i])) continue;
            return false;
        }
        return true;
    }

    static boolean areKeyedEqual(DataObject[] left, DataObject[] right) {
        if (left.length != right.length) {
            return false;
        }
        HashMap<Object, DataObject> leftMap = new HashMap<Object, DataObject>();
        for (DataObject dataObj : left) {
            leftMap.put(EqualityUtil.fetchKeyProperty(dataObj), dataObj);
        }
        for (DataObject dataObj : right) {
            Object key = EqualityUtil.fetchKeyProperty(dataObj);
            DataObject leftDataObj = (DataObject)leftMap.remove(key);
            if (leftDataObj == null) {
                return false;
            }
            if (EqualityUtil.areComplexTypeEqual(leftDataObj, dataObj)) continue;
            return false;
        }
        return true;
    }

    static Object fetchKeyProperty(DataObject keyedDo) {
        ComplexType doType = (ComplexType)EqualityUtil.resolveDynamicType(keyedDo);
        return doType.getProperty(KEY_PROP_NAME).get(keyedDo);
    }

    static boolean areKeyedArraysEqual(Object left, Object right, VmodlType compType) {
        if (left.getClass() != right.getClass()) {
            return false;
        }
        switch (compType.getKind()) {
            case DATA_OBJECT: {
                return EqualityUtil.areKeyedEqual((DataObject[])left, (DataObject[])right);
            }
            case INT: {
                return EqualityUtil.areKeyedEqual((int[])left, (int[])right);
            }
            case STRING: {
                return EqualityUtil.areKeyedEqual((String[])left, (String[])right);
            }
            case MOREF: {
                return EqualityUtil.areKeyedEqual((ManagedObjectReference[])left, (ManagedObjectReference[])right);
            }
            case MANAGED_OBJECT: {
                return EqualityUtil.areKeyedEqual(EqualityUtil.fetchMoRefs(left), EqualityUtil.fetchMoRefs(right));
            }
        }
        throw new RuntimeException("Unexpected array component type for keyed collection: " + (Object)((Object)compType.getKind()));
    }

    static boolean areArraysEqual(Object left, Object right, VmodlType compType) {
        if (left.getClass() != right.getClass()) {
            return false;
        }
        switch (compType.getKind()) {
            case BYTE: {
                return Arrays.equals((byte[])left, (byte[])right);
            }
            case SHORT: {
                return Arrays.equals((short[])left, (short[])right);
            }
            case INT: {
                return Arrays.equals((int[])left, (int[])right);
            }
            case LONG: {
                return Arrays.equals((long[])left, (long[])right);
            }
            case FLOAT: {
                return Arrays.equals((float[])left, (float[])right);
            }
            case DOUBLE: {
                return Arrays.equals((double[])left, (double[])right);
            }
            case BOOL: {
                return Arrays.equals((boolean[])left, (boolean[])right);
            }
            case DATA_OBJECT: 
            case FAULT: {
                return EqualityUtil.areComplexTypeArraysEqual(left, right, compType);
            }
            case MANAGED_OBJECT: {
                return Arrays.equals(EqualityUtil.fetchMoRefs(left), EqualityUtil.fetchMoRefs(right));
            }
            case ARRAY: 
            case STRING: 
            case DATETIME: 
            case METHOD_NAME: 
            case TYPE_NAME: 
            case MOREF: 
            case PROPERTY_PATH: 
            case URI: 
            case ENUM: 
            case BINARY: {
                return Arrays.equals((Object[])left, (Object[])right);
            }
            case ANY: {
                Object[] leftArray = (Object[])left;
                Object[] rightArray = (Object[])right;
                if (leftArray.length != rightArray.length) {
                    return false;
                }
                for (int i = 0; i < leftArray.length; ++i) {
                    if (EqualityUtil.areEqual(leftArray[i], rightArray[i])) continue;
                    return false;
                }
                return true;
            }
        }
        throw new RuntimeException("Unexpected array component VmodlType: " + (Object)((Object)compType.getKind()));
    }

    static boolean areComplexTypeArraysEqual(Object left, Object right, VmodlType compType) {
        if (Array.getLength(left) != Array.getLength(right)) {
            return false;
        }
        for (int i = 0; i < Array.getLength(left); ++i) {
            if (EqualityUtil.areComplexTypeEqual(Array.get(left, i), Array.get(right, i))) continue;
            return false;
        }
        return true;
    }

    static boolean checkForEmptyArray(Object left, Object right, VmodlType type) {
        Object nonNull;
        Object object = nonNull = left == null ? right : left;
        if (type == null || type.getKind() == VmodlType.Kind.ANY) {
            type = EqualityUtil.resolveDynamicType(nonNull);
        }
        if (type.getKind() == VmodlType.Kind.ARRAY) {
            return Array.getLength(nonNull) == 0;
        }
        return false;
    }

    static boolean isKeyedCollection(VmodlArrayType type) {
        VmodlType compType = type.getComponentType();
        switch (compType.getKind()) {
            case DATA_OBJECT: {
                return ((ComplexType)compType).getProperty(KEY_PROP_NAME) != null;
            }
            case INT: 
            case STRING: 
            case MOREF: {
                return true;
            }
        }
        return false;
    }

    static VmodlType resolveDynamicType(Object any) {
        VmodlType dynamicType = VmodlTypeMap.Factory.getTypeMap().getDynamicVmodlType(any);
        if (dynamicType == null) {
            throw new RuntimeException(String.format("Unable to determine dynamic type of '%1$s'", any.getClass()));
        }
        return dynamicType;
    }

    static ManagedObjectReference[] fetchMoRefs(Object moArray) {
        ManagedObject[] casted = (ManagedObject[])moArray;
        ManagedObjectReference[] result = new ManagedObjectReference[casted.length];
        for (int i = 0; i < casted.length; ++i) {
            result[i] = casted[i]._getRef();
        }
        return result;
    }
}

