/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vim.sso.client.impl;

import com.vmware.vim.sso.client.SamlToken;
import java.util.UUID;

public final class Util {
    public static String randomNCNameUUID() {
        return "_" + UUID.randomUUID();
    }

    public static String createRedactedDescription(SamlToken token) {
        return String.format("%s [subject=%s, groups=%s, delegactionChain=%s, startTime=%s, expirationTime=%s, renewable=%s, delegable=%s, isSolution=%s,confirmationType=%s]", token.getClass().getSimpleName(), Util.getTokenSubjectForLog(token), token.getGroupList(), token.getDelegationChain(), token.getStartTime(), token.getExpirationTime(), token.isRenewable(), token.isDelegable(), token.isSolution(), token.getConfirmationType());
    }

    static String getTokenSubjectForLog(SamlToken token) {
        String tokenSubject = null;
        if (token != null) {
            if (token.getSubject() != null) {
                tokenSubject = token.getSubject().toString();
            } else if (token.getSubjectNameId() != null) {
                tokenSubject = token.getSubjectNameId().toString();
            }
        }
        if (tokenSubject == null) {
            tokenSubject = "NULL";
        }
        return tokenSubject;
    }

    private Util() {
    }
}

