/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vim.binding.sso.admin;

import com.vmware.vim.binding.impl.vmodl.DynamicDataImpl;
import com.vmware.vim.binding.sso.admin.Domains;
import com.vmware.vim.binding.sso.admin.ExternalDomain;
import com.vmware.vim.binding.sso.admin.ExternalDomainDetails;
import com.vmware.vim.binding.sso.admin.fault.DirectoryServiceConnectionFault;
import com.vmware.vim.binding.sso.admin.fault.DomainNotFoundFault;
import com.vmware.vim.binding.sso.admin.fault.DuplicateDomainNameFault;
import com.vmware.vim.binding.sso.admin.fault.LocalOSDomainRegistrationFault;
import com.vmware.vim.binding.sso.fault.InvalidCredentials;
import com.vmware.vim.binding.sso.fault.NoPermission;
import com.vmware.vim.binding.sso.fault.NotAuthenticated;
import com.vmware.vim.binding.sso.version.version1;
import com.vmware.vim.binding.vmodl.ManagedObject;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vim.binding.vmodl.data;
import com.vmware.vim.binding.vmodl.faults;
import com.vmware.vim.binding.vmodl.managed;
import com.vmware.vim.binding.vmodl.managedObjectType;
import com.vmware.vim.binding.vmodl.map;
import com.vmware.vim.binding.vmodl.name;
import com.vmware.vim.binding.vmodl.optional;
import com.vmware.vim.binding.vmodl.privilege;
import com.vmware.vim.binding.vmodl.propertyOrder;
import com.vmware.vim.binding.vmodl.secret;
import com.vmware.vim.binding.vmodl.versionClass;
import com.vmware.vim.binding.vmodl.wsdlName;
import com.vmware.vim.vmomi.core.Future;
import java.net.URI;

@managed
@versionClass(value=version1.class)
@wsdlName(value="SsoAdminDomainManagementService")
public interface DomainManagementService
extends ManagedObject {
    @versionClass(value=version1.class)
    @wsdlName(value="ProbeConnectivity")
    @privilege(value="Sso.AdminServer.Administer")
    @faults(value={"SsoAdminFaultDirectoryServiceConnectionFault", "SsoFaultNotAuthenticated", "SsoFaultNoPermission", "SsoFaultInvalidCredentials"})
    public void probeConnectivity(@name(value="serviceUri") @versionClass(value=version1.class) URI var1, @name(value="authenticationType") @versionClass(value=version1.class) String var2, @name(value="authnCredentials") @versionClass(value=version1.class) @optional AuthenticationCredentails var3, Future<Void> var4);

    @wsdlName(value="ProbeConnectivity")
    public void probeConnectivity(URI var1, String var2, AuthenticationCredentails var3) throws DirectoryServiceConnectionFault, NotAuthenticated, NoPermission, InvalidCredentials;

    @versionClass(value=version1.class)
    @wsdlName(value="AddExternalDomain")
    @privilege(value="Sso.AdminServer.Administer")
    @faults(value={"SsoAdminFaultDuplicateDomainNameFault", "SsoFaultNotAuthenticated", "SsoFaultNoPermission", "SsoFaultInvalidCredentials"})
    public void addExternalDomain(@name(value="serverType") @versionClass(value=version1.class) String var1, @name(value="domainName") @versionClass(value=version1.class) String var2, @name(value="domainAlias") @versionClass(value=version1.class) @optional String var3, @name(value="details") @versionClass(value=version1.class) ExternalDomainDetails var4, @name(value="authenticationType") @versionClass(value=version1.class) String var5, @name(value="authnCredentials") @versionClass(value=version1.class) @optional AuthenticationCredentails var6, Future<Void> var7);

    @wsdlName(value="AddExternalDomain")
    public void addExternalDomain(String var1, String var2, String var3, ExternalDomainDetails var4, String var5, AuthenticationCredentails var6) throws DuplicateDomainNameFault, NotAuthenticated, NoPermission, InvalidCredentials;

    @versionClass(value=version1.class)
    @wsdlName(value="RegisterLocalOSDomain")
    @privilege(value="Sso.AdminServer.Administer")
    @faults(value={"SsoAdminFaultDuplicateDomainNameFault", "SsoFaultNotAuthenticated", "SsoFaultNoPermission", "SsoFaultInvalidCredentials", "SsoAdminFaultLocalOSDomainRegistrationFault"})
    public void registerLocalOSDomain(@name(value="domainName") @versionClass(value=version1.class) String var1, Future<Void> var2);

    @wsdlName(value="RegisterLocalOSDomain")
    public void registerLocalOSDomain(String var1) throws DuplicateDomainNameFault, NotAuthenticated, NoPermission, InvalidCredentials, LocalOSDomainRegistrationFault;

    @versionClass(value=version1.class)
    @wsdlName(value="GetDomains")
    @privilege(value="System.Read")
    @faults(value={"SsoFaultNotAuthenticated", "SsoFaultNoPermission", "SsoFaultInvalidCredentials"})
    public void getDomains(Future<Domains> var1);

    @wsdlName(value="GetDomains")
    public Domains getDomains() throws NotAuthenticated, NoPermission, InvalidCredentials;

    @versionClass(value=version1.class)
    @wsdlName(value="FindExternalDomain")
    @privilege(value="System.Read")
    @faults(value={"SsoFaultNotAuthenticated", "SsoFaultNoPermission", "SsoFaultInvalidCredentials"})
    public void findExternalDomain(@name(value="name") @versionClass(value=version1.class) String var1, @optional Future<ExternalDomain> var2);

    @wsdlName(value="FindExternalDomain")
    @optional
    public ExternalDomain findExternalDomain(String var1) throws NotAuthenticated, NoPermission, InvalidCredentials;

    @versionClass(value=version1.class)
    @wsdlName(value="GetSystemDomainName")
    @privilege(value="System.Anonymous")
    @faults(value={"SsoFaultInvalidCredentials"})
    public void getSystemDomainName(Future<String> var1);

    @wsdlName(value="GetSystemDomainName")
    public String getSystemDomainName() throws InvalidCredentials;

    @versionClass(value=version1.class)
    @wsdlName(value="GetLocalOSDomainName")
    @privilege(value="System.Read")
    @faults(value={"SsoFaultNotAuthenticated", "SsoFaultNoPermission", "SsoFaultInvalidCredentials"})
    public void getLocalOSDomainName(@optional Future<String> var1);

    @wsdlName(value="GetLocalOSDomainName")
    @optional
    public String getLocalOSDomainName() throws NotAuthenticated, NoPermission, InvalidCredentials;

    @versionClass(value=version1.class)
    @wsdlName(value="UpdateExternalDomainDetails")
    @privilege(value="Sso.AdminServer.Administer")
    @faults(value={"SsoAdminFaultDomainNotFoundFault", "SsoFaultNotAuthenticated", "SsoFaultNoPermission", "SsoFaultInvalidCredentials"})
    public void updateExternalDomainDetails(@name(value="name") @versionClass(value=version1.class) String var1, @name(value="details") @versionClass(value=version1.class) ExternalDomainDetails var2, Future<Void> var3);

    @wsdlName(value="UpdateExternalDomainDetails")
    public void updateExternalDomainDetails(String var1, ExternalDomainDetails var2) throws DomainNotFoundFault, NotAuthenticated, NoPermission, InvalidCredentials;

    @versionClass(value=version1.class)
    @wsdlName(value="UpdateExternalDomainAuthnType")
    @privilege(value="Sso.AdminServer.Administer")
    @faults(value={"SsoAdminFaultDomainNotFoundFault", "SsoFaultNotAuthenticated", "SsoFaultNoPermission", "SsoFaultInvalidCredentials"})
    public void updateExternalDomainAuthnType(@name(value="name") @versionClass(value=version1.class) String var1, @name(value="authnType") @versionClass(value=version1.class) String var2, @name(value="authnCredentials") @versionClass(value=version1.class) @optional AuthenticationCredentails var3, Future<Void> var4);

    @wsdlName(value="UpdateExternalDomainAuthnType")
    public void updateExternalDomainAuthnType(String var1, String var2, AuthenticationCredentails var3) throws DomainNotFoundFault, NotAuthenticated, NoPermission, InvalidCredentials;

    @versionClass(value=version1.class)
    @wsdlName(value="DeleteDomain")
    @privilege(value="Sso.AdminServer.Administer")
    @faults(value={"SsoAdminFaultDomainNotFoundFault", "SsoFaultNotAuthenticated", "SsoFaultNoPermission", "SsoFaultInvalidCredentials"})
    public void deleteDomain(@name(value="name") @versionClass(value=version1.class) String var1, Future<Void> var2);

    @wsdlName(value="DeleteDomain")
    public void deleteDomain(String var1) throws DomainNotFoundFault, NotAuthenticated, NoPermission, InvalidCredentials;

    @versionClass(value=version1.class)
    @wsdlName(value="GetSslCertificateManager")
    @privilege(value="System.Anonymous")
    @faults(value={"SsoFaultInvalidCredentials"})
    public void getSslCertificateManager(@managedObjectType(value="com.vmware.vim.binding.sso.admin.CertificateManager") Future<ManagedObjectReference> var1);

    @wsdlName(value="GetSslCertificateManager")
    @managedObjectType(value="com.vmware.vim.binding.sso.admin.CertificateManager")
    public ManagedObjectReference getSslCertificateManager() throws InvalidCredentials;

    @versionClass(value=version1.class)
    @wsdlName(value="SetDefaultDomains")
    @privilege(value="Sso.AdminServer.Administer")
    @faults(value={"SsoAdminFaultDomainNotFoundFault", "SsoAdminFaultDuplicateDomainNameFault", "SsoFaultNotAuthenticated", "SsoFaultNoPermission", "SsoFaultInvalidCredentials"})
    public void setDefaultDomains(@name(value="domainNames") @versionClass(value=version1.class) @optional @map String[] var1, Future<Void> var2);

    @wsdlName(value="SetDefaultDomains")
    public void setDefaultDomains(String[] var1) throws DomainNotFoundFault, DuplicateDomainNameFault, NotAuthenticated, NoPermission, InvalidCredentials;

    @versionClass(value=version1.class)
    @wsdlName(value="GetDefaultDomains")
    @privilege(value="Sso.AdminServer.Administer")
    @map
    @faults(value={"SsoFaultNotAuthenticated", "SsoFaultNoPermission", "SsoFaultInvalidCredentials"})
    public void getDefaultDomains(@optional @map Future<String[]> var1);

    @wsdlName(value="GetDefaultDomains")
    @optional
    public String[] getDefaultDomains() throws NotAuthenticated, NoPermission, InvalidCredentials;

    @versionClass(value=version1.class)
    @wsdlName(value="SsoAdminDomainManagementServiceAuthenticationCredentails")
    @data
    @propertyOrder(value={"username", "password"})
    public static class AuthenticationCredentails
    extends DynamicDataImpl {
        private static final long serialVersionUID = 1L;
        public String username;
        public String password;

        public AuthenticationCredentails() {
        }

        public AuthenticationCredentails(String username, String password) {
            this.username = username;
            this.password = password;
        }

        @versionClass(value=version1.class)
        public String getUsername() {
            return this.username;
        }

        @versionClass(value=version1.class)
        public void setUsername(String username) {
            this.username = username;
        }

        @secret
        @versionClass(value=version1.class)
        public String getPassword() {
            return this.password;
        }

        @secret
        @versionClass(value=version1.class)
        public void setPassword(String password) {
            this.password = password;
        }

        public String toString() {
            StringBuilder objString = new StringBuilder(80);
            objString.append("com.vmware.vim.binding.sso.admin.DomainManagementService.AuthenticationCredentails");
            objString.append(":\n");
            objString.append("username = ");
            objString.append(this.username);
            objString.append(",\n");
            objString.append("password = ");
            if (this.password == null) {
                objString.append("null");
            } else {
                objString.append("(not shown)");
            }
            objString.append("\ninherited from ");
            objString.append(super.toString());
            return objString.toString();
        }
    }
}

