/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vim.sso.admin;

import com.vmware.vim.sso.admin.impl.util.ValidateUtil;

public final class PasswordFormat {
    private final LengthRestriction _lengthRestriction;
    private final AlphabeticRestriction _alphabeticRestriction;
    private final int _minNumericCount;
    private final int _minSpecialCharCount;
    private final int _maxIdenticalAdjacentCharacters;

    public PasswordFormat(LengthRestriction lengthRestriction, AlphabeticRestriction alphabeticRestriction, int minNumericCount, int minSpecialCharCount, int maxIdenticalAdjacentCharacters) {
        ValidateUtil.validateNotNull(lengthRestriction, "lengthRestriction");
        ValidateUtil.validateNotNull(alphabeticRestriction, "alphabeticRestriction");
        this._lengthRestriction = lengthRestriction;
        this._alphabeticRestriction = alphabeticRestriction;
        this._minNumericCount = minNumericCount;
        this._minSpecialCharCount = minSpecialCharCount;
        this._maxIdenticalAdjacentCharacters = maxIdenticalAdjacentCharacters;
    }

    public LengthRestriction getLengthRestriction() {
        return this._lengthRestriction;
    }

    public AlphabeticRestriction getAlphabeticRestriction() {
        return this._alphabeticRestriction;
    }

    public int getMinNumericCount() {
        return this._minNumericCount;
    }

    public int getMinSpecialCharCount() {
        return this._minSpecialCharCount;
    }

    public int getMaxIdenticalAdjacentCharacters() {
        return this._maxIdenticalAdjacentCharacters;
    }

    public String toString() {
        return "PasswordFormat [lengthRestriction=" + this._lengthRestriction + ", alphabeticRestriction=" + this._alphabeticRestriction + ", minNumericCount=" + this._minNumericCount + ", minSpecialCharCount=" + this._minSpecialCharCount + ", maxIdenticalAdjacentCharacters=" + this._maxIdenticalAdjacentCharacters + "]";
    }

    public static final class AlphabeticRestriction {
        private final int _minAlphabeticCount;
        private final int _minUppercaseCount;
        private final int _minLowercaseCount;

        public AlphabeticRestriction(int minAlphabeticCount, int minUppercaseCount, int minLowercaseCount) {
            this._minAlphabeticCount = minAlphabeticCount;
            this._minUppercaseCount = minUppercaseCount;
            this._minLowercaseCount = minLowercaseCount;
        }

        public int getMinAlphabeticCount() {
            return this._minAlphabeticCount;
        }

        public int getMinUppercaseCount() {
            return this._minUppercaseCount;
        }

        public int getMinLowercaseCount() {
            return this._minLowercaseCount;
        }

        public String toString() {
            return "AlphabeticRestriction [minAlphabeticCount=" + this._minAlphabeticCount + ", minUppercaseCount=" + this._minUppercaseCount + ", minLowercaseCount=" + this._minLowercaseCount + "]";
        }
    }

    public static final class LengthRestriction {
        private final int _minLength;
        private final int _maxLength;

        public LengthRestriction(int minLength, int maxLength) {
            this._minLength = minLength;
            this._maxLength = maxLength;
        }

        public int getMinLength() {
            return this._minLength;
        }

        public int getMaxLength() {
            return this._maxLength;
        }

        public String toString() {
            return "LengthRestriction [minLength=" + this._minLength + ", maxLength=" + this._maxLength + "]";
        }
    }
}

