/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.o11n.tools.certs;

import com.vmware.o11n.tools.certs.VCOServerFileSystemHelper;
import com.vmware.o11n.tools.certs.VCOTrustStoreImportHelper;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.KeyStore;
import java.security.PrivateKey;
import java.security.cert.Certificate;
import java.security.spec.PKCS8EncodedKeySpec;
import org.bouncycastle.openssl.PEMReader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VCOSSLKeysChangeHelper {
    private static final Logger log = LoggerFactory.getLogger(VCOSSLKeysChangeHelper.class);

    public boolean changeSSLKeyPair(File publicDer, File privateDer, File keyStoreFileName) {
        try {
            PrivateKey privateKey;
            Certificate[] certificates;
            block5: {
                VCOTrustStoreImportHelper importHelper = new VCOTrustStoreImportHelper();
                certificates = importHelper.getCertificates(publicDer);
                byte[] keyAsBytes = new byte[(int)privateDer.length()];
                FileInputStream keyInputStream = new FileInputStream(privateDer);
                keyInputStream.read(keyAsBytes);
                keyInputStream.close();
                KeyFactory rSAKeyFactory = KeyFactory.getInstance("RSA");
                privateKey = null;
                try {
                    privateKey = rSAKeyFactory.generatePrivate(new PKCS8EncodedKeySpec(keyAsBytes));
                }
                catch (Exception e) {
                    FileReader pkr = new FileReader(privateDer);
                    PEMReader reader = new PEMReader(pkr);
                    Object o = null;
                    while ((o = reader.readObject()) != null) {
                        if (!(o instanceof KeyPair)) continue;
                        KeyPair kp = (KeyPair)o;
                        privateKey = kp.getPrivate();
                    }
                    reader.close();
                    pkr.close();
                    if (privateKey != null) break block5;
                    log.error("Invalid format ", e);
                    return false;
                }
            }
            KeyStore keyStore = KeyStore.getInstance("jks");
            FileInputStream jssecacertsInputStream = new FileInputStream(keyStoreFileName);
            keyStore.load(jssecacertsInputStream, "dunesdunes".toCharArray());
            jssecacertsInputStream.close();
            keyStore.deleteEntry("dunes");
            keyStore.setKeyEntry("dunes", privateKey, "dunesdunes".toCharArray(), certificates);
            FileOutputStream fos = new FileOutputStream(keyStoreFileName);
            keyStore.store(fos, "dunesdunes".toCharArray());
            fos.close();
            return true;
        }
        catch (Exception e) {
            log.error("Cannot change SSL key pair. ", e);
            return false;
        }
    }

    public boolean checkSSLKeyPairExists(File publicDer) {
        VCOTrustStoreImportHelper importHelper = new VCOTrustStoreImportHelper();
        Boolean bool = importHelper.importCertificates(publicDer);
        return bool == null;
    }

    public boolean changeSSLKeyPair(File publicDer, File privateDer) {
        VCOServerFileSystemHelper helper = new VCOServerFileSystemHelper();
        File keyStoreFileName = helper.getJSSECacertsFile();
        if (keyStoreFileName == null) {
            log.error("Cannot find the certificate file.");
            return Boolean.FALSE;
        }
        return this.changeSSLKeyPair(publicDer, privateDer, keyStoreFileName);
    }
}

