/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.o11n.tools.certs;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.channels.FileChannel;
import java.util.ArrayList;
import java.util.Collection;
import javax.xml.parsers.SAXParserFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class VCOServerFileSystemHelper {
    private static final Logger log = LoggerFactory.getLogger(VCOServerFileSystemHelper.class);

    public File getLocalFile(String id) {
        String OS = System.getProperty("os.name").toLowerCase();
        if (OS.contains("nt") || OS.contains("windows")) {
            String programFilesLocation = System.getenv("ProgramFiles");
            File installAnywhereRegistryDir = new File(programFilesLocation, "Zero G Registry");
            if (!installAnywhereRegistryDir.exists() || !installAnywhereRegistryDir.isDirectory()) {
                return null;
            }
            File installAnywhereRegistry = new File(installAnywhereRegistryDir, ".com.zerog.registry.xml");
            if (!installAnywhereRegistry.exists() || !installAnywhereRegistry.isFile()) {
                return null;
            }
            return this.getLocalFile(id, installAnywhereRegistry);
        }
        return null;
    }

    File getLocalFile(String registrySuffix, File installAnywhereRegistry) {
        try {
            BufferedReader r = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(installAnywhereRegistry), "UTF8"));
            Collection<String> cs = this.getVCORoots(r, registrySuffix);
            for (String s : cs) {
                File f = new File(s);
                if (!f.exists() || !f.isFile()) continue;
                return f;
            }
            return null;
        }
        catch (IOException e) {
            log.error("Cannot access InstallAnywhere registry", e);
            return null;
        }
    }

    Collection<String> getVCORoots(Reader is, final String id) {
        final ArrayList<String> roots = new ArrayList<String>();
        DefaultHandler myHandler = new DefaultHandler(){
            private boolean candidateElement = false;
            private String myCandidate = null;

            @Override
            public void startElement(String namespaceURI, String localName, String qualifiedName, Attributes attrs) throws SAXException {
                String ver;
                if ("component".equals(qualifiedName) && id.equals(attrs.getValue("ref_id")) && (ver = attrs.getValue("version")) != null && ver.startsWith("5.")) {
                    this.myCandidate = attrs.getValue("location");
                    roots.add(this.myCandidate);
                }
            }
        };
        SAXParserFactory factory = SAXParserFactory.newInstance();
        factory.setValidating(true);
        try {
            factory.newSAXParser().parse(new InputSource(is), myHandler);
        }
        catch (Exception e) {
            log.error(e.getMessage(), e);
        }
        try {
            is.close();
        }
        catch (IOException e) {
            log.error(e.getMessage(), e);
        }
        return roots;
    }

    public boolean backup(File jssecacerts, File backupDir) {
        File backup = new File(backupDir, "vCO.jssecacerts.backup");
        backup.getParentFile().mkdirs();
        return this.copy(jssecacerts, backup);
    }

    public boolean restore(File jssecacerts, File backupDir) {
        File backup = new File(backupDir, "vCO.jssecacerts.backup");
        File tempBak = new File(jssecacerts.getAbsolutePath() + ".changed");
        jssecacerts.renameTo(tempBak);
        boolean copy = this.copy(backup, jssecacerts);
        if (!copy) {
            tempBak.renameTo(jssecacerts);
        }
        return copy;
    }

    public File getJSSECacertsFile() {
        File result = this.getLocalFile("cc7a3bbd-1ee4-11b2-a417-fc7fd2c3b996");
        if (result == null) {
            result = this.getLocalFile("9f0b620c-1ee4-11b2-9710-b2a4ea0a4eb7");
            if (result != null && result.exists()) {
                return result;
            }
            return null;
        }
        return (result = new File(result.getParent(), "app-server/conf/security/jssecacerts")).exists() ? result : null;
    }

    public boolean copy(File in, File out) {
        try {
            FileChannel inChannel = new FileInputStream(in).getChannel();
            FileChannel outChannel = new FileOutputStream(out).getChannel();
            inChannel.transferTo(0L, inChannel.size(), outChannel);
            inChannel.close();
            outChannel.close();
            return true;
        }
        catch (IOException e) {
            log.error("Cannot copy the file " + in + " to " + out, e);
            e.printStackTrace();
            return false;
        }
    }
}

