/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vim.sso.client.impl;

import com.vmware.vim.sso.client.XmlParserFactory;
import java.io.IOException;
import java.io.StringReader;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class SecureXmlParserFactory
implements XmlParserFactory {
    private final Log log = LogFactory.getLog(SecureXmlParserFactory.class);
    private final EntityResolver nullEntityResolver = new EntityResolver(){

        @Override
        public InputSource resolveEntity(String publicId, String systemId) throws SAXException, IOException {
            SecureXmlParserFactory.this.log.warn((Object)String.format("A request to load DTD (system ID: %s, public ID: %s) was denied for security reasons. This may break a signature if the XML contains one.", systemId, publicId));
            return new InputSource(new StringReader(""));
        }
    };

    @Override
    public DocumentBuilder newDocumentBuilder() throws ParserConfigurationException {
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        dbf.setNamespaceAware(true);
        dbf.setValidating(false);
        this.trySetFeature(dbf, "http://xml.org/sax/features/validation", false);
        this.trySetFeature(dbf, "http://javax.xml.XMLConstants/feature/secure-processing", true);
        this.trySetFeature(dbf, "http://apache.org/xml/features/nonvalidating/load-dtd-grammar", false);
        this.trySetFeature(dbf, "http://apache.org/xml/features/nonvalidating/load-external-dtd", false);
        DocumentBuilder documentBuilder = dbf.newDocumentBuilder();
        documentBuilder.setEntityResolver(this.nullEntityResolver);
        return documentBuilder;
    }

    private void trySetFeature(DocumentBuilderFactory dbf, String featureKey, boolean value) {
        block2: {
            try {
                dbf.setFeature(featureKey, value);
            }
            catch (ParserConfigurationException e) {
                if (!this.log.isDebugEnabled()) break block2;
                this.log.debug((Object)("Couldn't apply feature " + featureKey + " to DocumentBuilderFactory " + dbf.getClass().getName() + " Can be safely ignored."));
            }
        }
    }
}

