/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vim.sso.client.impl;

import com.vmware.vim.sso.client.SamlToken;
import com.vmware.vim.sso.client.impl.exception.ParserException;
import java.io.StringWriter;
import java.util.UUID;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.w3c.dom.Node;

public final class Util {
    public static final String SSO_SYSTEM_DOMAIN = "System-Domain";

    private static Log getLog() {
        return LogFactory.getLog(Util.class);
    }

    public static String serializeToString(Node content) throws ParserException {
        TransformerFactory tf = TransformerFactory.newInstance();
        StringWriter writer = new StringWriter();
        try {
            Transformer trans = tf.newTransformer();
            trans.setOutputProperty("omit-xml-declaration", "yes");
            trans.transform(new DOMSource(content), new StreamResult(writer));
        }
        catch (TransformerException e) {
            String message = "Error while serializing Node to String";
            Util.getLog().error((Object)message);
            throw new ParserException(message, e);
        }
        return writer.toString();
    }

    public static String randomNCNameUUID() {
        return "_" + UUID.randomUUID();
    }

    public static String createRedactedDescription(SamlToken token) {
        return String.format("%s [subject=%s, groups=%s, delegactionChain=%s, startTime=%s, expirationTime=%s, renewable=%s, delegable=%s, isSolution=%s,confirmationType=%s]", new Object[]{token.getClass().getSimpleName(), token.getSubject(), token.getGroupList(), token.getDelegationChain(), token.getStartTime(), token.getExpirationTime(), token.isRenewable(), token.isDelegable(), token.isSolution(), token.getConfirmationType()});
    }

    private Util() {
    }
}

