/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vim.sso.client.impl.signature;

import com.vmware.vim.sso.client.SecurityTokenServiceConfig;
import com.vmware.vim.sso.client.impl.SoapMessage;
import com.vmware.vim.sso.client.impl.exception.ParserException;
import com.vmware.vim.sso.client.impl.signature.WsSecuritySignatureImpl;
import javax.xml.namespace.QName;
import org.oasis_open.docs.wss._2004._01.oasis_200401_wss_wssecurity_secext_1_0.KeyIdentifierType;
import org.oasis_open.docs.wss._2004._01.oasis_200401_wss_wssecurity_secext_1_0.ObjectFactory;
import org.oasis_open.docs.wss._2004._01.oasis_200401_wss_wssecurity_secext_1_0.SecurityTokenReferenceType;
import org.w3c.dom.Node;

public final class WsSecuritySignatureAssertion
extends WsSecuritySignatureImpl {
    private static final String WSSE11_NAMESPACE = "http://docs.oasis-open.org/wss/oasis-wss-wssecurity-secext-1.1.xsd";
    private static final String WSSE11_PREFIX = "wsse11";
    private static final String WSSE11_TOKEN_TYPE_ATTR_NAME = "TokenType";
    private static final String SAML_TOKEN_TYPE = "http://docs.oasis-open.org/wss/oasis-wss-saml-tokenprofile-1.1#SAMLV2.0";
    private static final String SAML_KEY_ID_TYPE = "http://docs.oasis-open.org/wss/oasis-wss-saml-token-profile-1.1#SAMLID";
    private final String _assertionId;

    public WsSecuritySignatureAssertion(SecurityTokenServiceConfig.HolderOfKeyConfig config, String assertionId) {
        super(config);
        assert (assertionId != null);
        this._assertionId = assertionId;
    }

    @Override
    protected Node createKeyInfoContent(SoapMessage message) throws ParserException {
        return this.createSecurityTokenReference();
    }

    @Override
    protected String addUseKeySignatureId(SoapMessage message) throws ParserException {
        return null;
    }

    private Node createSecurityTokenReference() throws ParserException {
        ObjectFactory secExtFactory = new ObjectFactory();
        SecurityTokenReferenceType stRef = secExtFactory.createSecurityTokenReferenceType();
        KeyIdentifierType ki = secExtFactory.createKeyIdentifierType();
        ki.setValue(this._assertionId);
        ki.setValueType(SAML_KEY_ID_TYPE);
        stRef.getAny().add(ki);
        stRef.getOtherAttributes().put(new QName(WSSE11_NAMESPACE, WSSE11_TOKEN_TYPE_ATTR_NAME, WSSE11_PREFIX), SAML_TOKEN_TYPE);
        return this.marshallJaxbElement(stRef).getFirstChild();
    }
}

