@echo off

rem ##############################################################################
rem #
rem # Copyright (c) 2013 VMware, Inc. All rights reserved.
rem # -- VMware Confidential
rem #
rem ##############################################################################

rem ##############################################################################
rem #
rem # Enter the information that this tool should use as default values. If any
rem # information is left blank, you can enter it interactively at the time it is
rem # needed.
rem #
rem # The certificate chain files are expected to contain a sequence of PEM (base64)
rem # encoded X.509 certificates ordered from the leaf certificate (that is, the
rem # certificate issued for the service being updated) to and including the
rem # self-signed authority certificate. For example:
rem #
rem # -----BEGIN CERTIFICATE-----
rem # ... base-64 data...
rem # This is the certificate the service will present for its own identity
rem # (a.k.a. the leaf certificate.)
rem # -----END CERTIFICATE-----
rem # -----BEGIN CERTIFICATE-----
rem # ... base-64 data...
rem # The issuer of the leaf certificate.
rem # -----END CERTIFICATE-----
rem # ...and so on...
rem # -----BEGIN CERTIFICATE-----
rem # ... base-64 data...
rem # The self-signed authority certificate.
rem # -----END CERTIFICATE-----
rem #
rem # The chain should not contain any text before the first "BEGIN CERTIFICATE"
rem # header.
rem #
rem # A private key file must contain a single PEM (base64) encoded PKCS#1 (RSA)
rem # private key. For compatibility with up-to-date Windows system the key size
rem # should be strictly larger than 1024 bits. The file should look as follows:
rem #
rem # -----BEGIN RSA PRIVATE KEY-----
rem # ... base-64 data ...
rem # -----END RSA PRIVATE KEY-----
rem #
rem #
rem ##############################################################################


rem ######################################################################################################
rem # Parameters for updating the Single Sign-On SSL Certificate

rem # sso_cert_chain
rem #    REQUIRED. Specifies a file containing the new SSL certificate chain for
rem #    Single Sign-On Server. See the comment at the beginning of this file
rem #    for details about the chain file format.
rem #
rem #    Example:
rem #      sso_cert_chain=C:\SSL Certificates\chain.pem
set sso_cert_chain=

rem # sso_private_key
rem #    REQUIRED. Specifies a file containing the new SSL private key for
rem #    Single Sign-On Server. See the comment at the beginning of this file
rem #    for details about the private key file format.
rem #
rem #    Example:
rem #      sso_private_key=C:\SSL Certificates\sso-cert.key
set sso_private_key=

rem # sso_node_type
rem #    REQUIRED. Specifies the type of the Single Sign-On installation. The possible
rem #    values are:
rem #      * Single : indicates a single node, basic installation. If you have a
rem #        multi-site setup but without HA, answer Single.
rem #
rem #      * HA_Primary : indicates the primary node of a HA cluster. Only select this
rem #        option if you have configured a load-balancer with SSL termination. If you
rem #        have installed in HA mode but still haven't configured a load balancer, or
rem #        if you are using load-balancer without SSL termination, then answer Single.
rem #
rem #      * HA_Failover : indicates a secondary (failover) node of a HA cluster. Only
rem #        select this option if you have configured a load-balancer with SSL
rem #        termination. If you have installed in HA mode but still haven't configured
rem #        a load balancer, or if you are using load-balancer without SSL termination,
rem #        then answer Single.
set sso_node_type=

rem sso_admin_user in the Common section should be filled in

rem # The following parameters are optional and only have effect if sso_node_type is HA_<any>.

rem # sso_admin_is_behind_lb
rem #    OPTIONAL. Specifies whether the Single Sign-On Administration Service is also
rem #    served from the load-balancers. Answer yes or no. If no answer is provided,
rem #    the default value is "no".
rem #
rem #    N.B. that the Single Sign-On Security Token Service and Single Sign-On Group
rem #    Check Service are always presumed to be served by the load-balancer in HA mode.
set sso_admin_is_behind_lb=

rem # sso_lb_certificate
rem #    OPTIONAL. Specifies a file containing the authority (self-signed) certificate
rem #    of the load-balancer. This parameter lets you fix the Lookup Service
rem #    records in cases where the load-balancer SSL configuration had been updated.
rem #    If no value is provided, the Lookup Service records for the load-balanced
rem #    Single Sign-On services are left untouched.
set sso_lb_certificate=

rem # sso_lb_hostname
rem #    OPTIONAL. Specifies the load-balancer address (IP or fully-qualified host name).
rem #    This parameter lets you fix the Lookup Service records in cases where
rem #    the load-balancer address had changed. If no value is provided, the Lookup
rem #    Service records for the load-balanced Single Sign-On services are left untouched.
set sso_lb_hostname=


rem ######################################################################################################
rem # Parameters for updating the Inventory Service SSL Certificate

rem # is_cert_chain
rem #    REQUIRED. Specifies a file containing the new SSL certificate chain for
rem #    Inventory Service. See the comment at the beginning of this file
rem #    for details about the chain file format.
rem #
rem #    Example:
rem #      is_cert_chain=C:\SSL Certificates\chain.pem
set is_cert_chain=

rem # is_private_key_new
rem #    REQUIRED. Specifies a file containing the new SSL private key for
rem #    Inventory Service. See the comment at the beginning of this file
rem #    for details about the private key file format.
rem #
rem #    Example:
rem #      is_private_key_new=C:\SSL Certificates\invsvc-cert.key
set is_private_key_new=


rem ######################################################################################################
rem # Parameters for updating the vCenter Server SSL Certificate

rem # vc_cert_chain
rem #    REQUIRED. Specifies a file containing the new SSL certificate chain for
rem #    vCenter Server. See the comment at the beginning of this file
rem #    for details about the chain file format.
rem #
rem #    Example:
rem #      vc_cert_chain=C:\SSL Certificates\chain.pem
set vc_cert_chain=

rem # vc_private_key
rem #    REQUIRED. Specifies a file containing the new SSL private key for
rem #    vCenter Server. See the comment at the beginning of this file
rem #    for details about the private key file format.
rem #
rem #    Example:
rem #      vc_private_key=C:\SSL Certificates\vc-cert.key
set vc_private_key=

rem vc_username in the common section should be filled


rem ######################################################################################################
rem # Parameters for updating the vSphere Web Client SSL Certificate

rem # ngc_cert_chain
rem #    REQUIRED. Specifies a file containing the new SSL certificate chain for
rem #    the vSphere Web Client. See the comment at the beginning of this file
rem #    for details about the chain file format.
rem #
rem #    Example:
rem #       ngc_cert_chain=C:\SSL Certificates\chain.pem
set ngc_cert_chain=

rem # ngc_private_key
rem #    REQUIRED. Specifies a file containing the new SSL private key for
rem #    the vSphere Web Client. See the comment at the beginning of this file
rem #    for details about the private key file format.
rem #
rem #    Example:
rem #       ngc_private_key=C:\SSL Certificates\ngc-cert.key
set ngc_private_key=
rem sso_admin_user in the Common section should be filled in


rem ######################################################################################################
rem # Parameters for updating the Lob Browser SSL Certificate

rem # logbrowser_cert_chain
rem #    REQUIRED. Specifies a file containing the new SSL certificate chain for
rem #    Log Browser Server. See the comment at the beginning of this file
rem #    for details about the chain file format.
rem #
rem #    Example:
rem #      logbrowser_cert_chain=C:\SSL Certificates\chain.pem
set logbrowser_cert_chain=

rem # logbrowser_private_key
rem #    REQUIRED. Specifies a file containing the new SSL private key for
rem #    Log Browser Server. See the comment at the beginning of this file
rem #    for details about the private key file format.
rem #
rem #    Example:
rem #      logbrowser_private_key=C:\SSL Certificates\logbrowser-cert.key
set logbrowser_private_key=

rem sso_admin_user in the Common section should be filled in


rem ######################################################################################################
rem # Parameters for updating the vCenter Orchestrator SSL Certificate

rem # vco_cert_chain
rem #    REQUIRED. Specifies a file containing the new SSL certificate chain for
rem #    vCenter Orchestrator Server and Configuration Service. See the
rem #    comment at the beginning of this file for details about the chain
rem #    file format.
rem #
rem #    Example:
rem #      vco_cert_chain=C:\VCO Certificates\chain.pem
set vco_cert_chain=

rem # vco_private_key
rem #    REQUIRED. Specifies a file containing the new SSL private key for
rem #    vCenter Orchestrator Server and Configuration Service.
rem #    See the comment at the beginning of this file
rem #    for details about the private key file format.
rem #
rem #    Example:
rem #      vco_private_key=C:\VCO Certificates\vco-cert.key
set vco_private_key=


rem ######################################################################################################
rem # Parameters for updating the vSphere Update Manager SSL Certificate

rem # vum_cert_chain
rem #    REQUIRED. Specifies a file containing the new SSL certificate chain for
rem #    VMware vSphere Update Manager. See the comment at the beginning
rem #    of this file for details about the chain file format. vSphere
rem #    Update Manager will also accept a chain that consists only of the leaf
rem #    certificate.
rem #
rem #    Example:
rem #      vum_cert_chain=C:\SSL Certificates\vum-cert.pem
set vum_cert_chain=

rem # vum_private_key
rem #    REQUIRED. Specifies a file containing the new SSL private key for
rem #    VMware vSphere Update Manager. See the comment at the beginning
rem #    of this file for details about the private key file format.
rem #
rem #    Example:
rem #      vum_private_key=C:\SSL Certificates\vum-cert.key
set vum_private_key=

rem vc_username in the common section should be filled in

rem ######################################################################################################
rem Common parameters

rem # sso_admin_user
rem #    REQUIRED (when specified by a section). Specifies the account
rem #    name which has Administrative priviliges in Single Sign-On service.
rem #
rem #    Example:
rem #      sso_admin_user=administrator@vsphere.local
set sso_admin_user=

rem # vc_username
rem #    REQUIRED (when specified by a section). Specifies the account
rem #    name to use to log in to vCenter Server.
rem #
rem #    Example:
rem #      vc_username=administrator
set vc_username=


rem ######################################################################################################
rem The following parameters will be used to generate a CSR.
rem Information about the server for which the CSR will be created:
rem Fully Qualified Domain Name (FQDN)
set gen_cert_server_fqdn=
rem IP Address
set gen_cert_server_ip=
rem short name
set gen_cert_server_short_name=

rem Country, State, City
set gen_cert_country=
set gen_cert_state=
set gen_cert_locality_name=
rem Name of the organization, Company Name
set gen_cert_organization_name=
rem OU - this will be the DN of the certificate which should be unique.
set gen_cert_organizational_unit_name=
rem variable key length. This property will not be online modifiable(through interactive mode). If you
rem need key length(more than 2K) it can be configured only from this property here.
rem Values smaller than 2048 are not supported.
set gen_cert_key_length=2048
rem end of CSR variables #################################################################################


rem ######################################################################################################
rem # The following parameters can be used to alter the tool's default behavior.
rem # Do not modify the value, just uncomment the variable definition to
rem # activate the behavior change. Use with caution.

rem # ssl_tool_no_admin_check
rem #    Allows the tool to be run by a user who does not have Windows
rem #    Administrator privileges.
rem ssl_tool_no_admin_check=1

rem # ssl_tool_no_pem_clean_check
rem #    Allows comments (text) before, after or between the individual
rem #    certificate entries in the certificate chain files.
rem #
rem #    Never use this option when updating the vCenter Server certificate
rem #    where comments are known to cause product issues.
rem ssl_tool_no_pem_clean_check=1

rem # ssl_tool_no_cert_san_check
rem #   Disables the check of certificate's SubjectAlternativeName-s (SAN)
rem #   against the name and the public IP addresses of the current machine.
rem #   Certificates with inappropriate SAN-s will work during the update but
rem #   will likely cause hostname verficiation errors at runtime.
rem ssl_tool_no_cert_san_check=1

rem # ssl_tool_no_key_len_check
rem #   Disables the check for the length of the certificate's public key.
rem #   Certificates with short (< 1024 bit) key length will not work on
rem #   up-to-date Windows systems.
rem ssl_tool_no_key_len_check=1

rem use this to set the appropriate message to be displayed to the user when
rem something wrong happens during some of the update procedures.
set last_error=

rem use this to set the location of the rollback backup folder to be located.
set ROLLBACK_BACKUP_FOLDER=%~dp0backup

rem use this to set the location of the logs folder.
rem example :
rem set LOGS_FOLDER=%TEMP%\ssl-updater\logs
set LOGS_FOLDER=%~dp0logs

rem use this to set the location of the parent folder in which CSR will be generated.
rem example :
rem set CSR_OUTPUT_FOLDER=%TEMP%\ssl-updater\requests
set CSR_OUTPUT_FOLDER=%~dp0requests
