@echo off

rem ##############################################################################
rem #
rem # Copyright (c) 2013 VMware, Inc. All rights reserved.
rem # -- VMware Confidential
rem #
rem ##############################################################################

rem ---------------------------------------------

rem - IS steps
rem # 0. Do all the validations (check whether IS is installed on the box through the registry)
rem # 1. Stop IS
rem # 2. Start IS

set _IS_REG_EXE=%windir%\system32\reg.exe

if NOT EXIST "%_IS_REG_EXE%" (
	set last_error=reg.exe is not present in the system32 directory.
	goto endError
)

set _IS_REG_PATH="HKLM\SOFTWARE\VMware, Inc.\VMware Infrastructure\Inventory Service"
set _IS_INSTALLATION_DIR=
rem fetch _IS_INSTALLATION_DIR
for /F "tokens=1,2*" %%i in ('%_IS_REG_EXE% query %_IS_REG_PATH% /v "InstallPath"') DO (
	if "%%i"=="InstallPath" (
		SET "_IS_INSTALLATION_DIR=%%k"
	)
)
if "%_IS_INSTALLATION_DIR%"=="" (
	set last_error=Failed to load the path from the registry. Inventory Service might not be installed.
	call "%~dp0common" "%last_error%"
	exit /B 2
)

rem stop IS
call "%~dp0common" Stopping Inventory Service
net STOP vimQueryService
if ERRORLEVEL 1 (
	set last_error=Cannot stop Inventory Service - errorlevel is %ERRORLEVEL%
	goto endError
)

rem start IS
call "%~dp0common" Starting Inventory service
net START vimQueryService
if ERRORLEVEL 1 (
	set last_error=Cannot start Inventory Service - errorlevel is %ERRORLEVEL%
	goto endError
)

call "%~dp0common" Successfully updated the Inventory Service trust to Single Sign-On
exit /B 0

:endError
call "%~dp0common" "%last_error%"
call "%~dp0common" Update Inventory Service trust operation ended with errors
exit /B 1