@echo off
set PRIORERRORLEVEL=%ERRORLEVEL%

rem ##############################################################################
rem #
rem # Copyright (c) 2013 VMware, Inc. All rights reserved.
rem # -- VMware Confidential
rem #
rem ##############################################################################
if /i [%~1] == [-sso] goto read_sso
if /i [%~1] == [-sso-rollback] goto read_sso_rollback
if /i [%~1] == [-is] goto read_is
if /i [%~1] == [-is-rollback] goto read_is_rollback
if /i [%~1] == [-vc] goto read_vc
if /i [%~1] == [-vc-rollback] goto read_vc_rollback
if /i [%~1] == [-vc-sso] goto read_vc_sso
if /i [%~1] == [-vco] goto read_vco
if /i [%~1] == [-vco-sso] goto read_vco_sso
if /i [%~1] == [-vco-vc] goto read_vco_vc
if /i [%~1] == [-ngc] goto read_ngc
if /i [%~1] == [-ngc-sso] goto read_ngc_sso
if /i [%~1] == [-ngc-rollback] goto read_ngc_sso
if /i [%~1] == [-logbrowser] goto read_logbrowser
if /i [%~1] == [-logbrowser-sso] goto read_logbrowser_sso
if /i [%~1] == [-logbrowser-rollback] goto read_logbrowser_rollback
if /i [%~1] == [-vum] goto read_vum
if /i [%~1] == [-vum-trust] goto read_vum_trust
if /i [%~1] == [-vum-rollback] goto read_vum_rollback
if /i [%~1] == [-clear-all] goto clearEnvironment

call "%~dp0common" Unrecognized parameter "%~1"
goto :commonExit


:read_sso
call:read-param-req "Enter location to the new Single Sign-On SSL chain" sso_cert_chain unquote rem .cer file in PEM format
call:read-param-req "Enter location to the new Single Sign-On private key" sso_private_key unquote rem .key file in PEM format
call:read-param-req "Enter Single Sign-On Administrator user" sso_admin_user
call:read-passwd "Enter Single Sign-On Administrator password" sso_admin_password

:askForLoadBalancer
call:read-param-req "Do you have a load balancer installed? (yes/no)" sso_have_lb
rem validate yes/no answer
if /i [%sso_have_lb%] == [no] goto :setLoadBalancer_NO
if /i [%sso_have_lb%] == [n] goto :setLoadBalancer_NO
if /i [%sso_have_lb%] == [yes] goto :askForPrimaryNode
if /i [%sso_have_lb%] == [y] goto :askForPrimaryNode
echo (%sso_have_lb%) is not a valid choice. Choose yes/no. 
set sso_have_lb=
goto :askForLoadBalancer

:setLoadBalancer_NO
set sso_node_type=Single
set sso_admin_is_behind_lb=
set sso_lb_certificate=
set sso_lb_hostname=
goto :commonExit

:askForPrimaryNode
call:read-param-req "Is the current machine hosting a primary Single Sign-On node? (yes/no)" sso_primary_node
rem validate yes/no answer
if /i [%sso_primary_node%] == [no] goto :setPrimaryNode_NO
if /i [%sso_primary_node%] == [n] goto :setPrimaryNode_NO
if /i [%sso_primary_node%] == [yes] goto :setPrimaryNode_YES
if /i [%sso_primary_node%] == [y] goto :setPrimaryNode_YES
echo (%sso_primary_node%) is not a valid choice. Choose yes/no. 
set sso_primary_node=
goto :askForPrimaryNode

:setPrimaryNode_YES
set sso_node_type=HA_Primary
:setPrimaryNode_NO
set sso_node_type=HA_Failover


:read_sso_optional
:askForAdminBehindLB
call:read-param "Is the Single Sign-On administration service accessed via the load balancer? (yes/no)" sso_admin_is_behind_lb
rem validate yes/no answer
if /i [%sso_admin_is_behind_lb%] == [no] goto :askForLBCert
if /i [%sso_admin_is_behind_lb%] == [n] goto :askForLBCert
if /i [%sso_admin_is_behind_lb%] == [yes] goto :askForLBCert
if /i [%sso_admin_is_behind_lb%] == [y] goto :askForLBCert
echo (%sso_admin_is_behind_lb%) is not a valid choice. Choose yes/no. 
set sso_admin_is_behind_lb=
goto askForAdminBehindLB

:askForLBCert
call:read-param "Enter the Single Sign-On HA Load Balancer certificate (optional)" sso_lb_certificate
call:read-param "Enter the Single Sign-On HA Load Balancer hostname (optional)" sso_lb_hostname
goto :commonExit

:read_sso_rollback
call:read-param-req "Enter Single Sign-On Administrator user" sso_admin_user
call:read-passwd "Enter Single Sign-On Administrator password" sso_admin_password
goto :commonExit

:read_is
call:read-param-req "Enter the location to the new Inventory Service SSL chain" is_cert_chain unquote rem .cer file in PEM format
call:read-param-req "Enter the location to the new Inventory Service private key" is_private_key_new unquote rem .key file in PEM format
:read_is_rollback
call:read-param-req "Enter the Single Sign-On Administrator user" sso_admin_user
call:read-passwd "Enter the Single Sign-On Administrator password" sso_admin_password
goto :commonExit

:read_vc
call:read-param-req "Enter location to the new vCenter Server SSL chain" vc_cert_chain unquote rem .cer file in PEM format
call:read-param-req "Enter location to the new vCenter Server private key" vc_private_key unquote rem .key file in PEM format
:read_vc_rollback
call:read-param-req "Enter vCenter Server administrator user name" vc_username rem the admin user
call:read-passwd "Enter vCenter Server administrator password" vc_password

echo "Important: Enter the password carefully. The Certificate Automation Update Tool does not check the validity of the vCenter Server database password." 2>&1
echo "A blank or incorrect password will leave the system in an inconsistent state, which will cause the vCenter Server to become unavailable. " 2>&1
echo "If the system becomes unstable due to a bad password, see the Troubleshooting Section of KB 2041600." 2>&1
call:read-passwd "Enter the vCenter Server original database password" vc_db_password

call:read-param-req "Enter Single Sign-On Administrator user" sso_admin_user
call:read-passwd "Enter Single Sign-On Administrator password" sso_admin_password
goto :commonExit

:read_vc_sso
call:read-param-req "Enter location to the new Single Sign-On SSL chain. If SSO is behind a Load Balancer, provide the Load Balancer CA certificate" sso_cert_chain unquote rem .cer file in PEM format
goto :commonExit

:read_vco
call:read-param-req "Enter location to the new vCenter Orchestrator SSL chain" vco_cert_chain unquote rem .cer file in PEM format
call:read-param-req "Enter location to the new vCenter Orchestrator private key" vco_private_key unquote rem .key file in PEM format
goto :commonExit

:read_vco_sso
call:read-param-req "Enter location to the new Single Sign-On SSL chain. If SSO is behind a Load Balancer, provide the Load Balancer CA certificate" sso_cert_chain unquote rem .cer file in PEM format
goto :commonExit

:read_vco_vc
call:read-param-req "Enter location to the new vCenter Server SSL chain" vc_cert_chain unquote rem .cer file in PEM format
goto :commonExit

:read_ngc
call:read-param-req "Enter location to the new Web Client SSL chain" ngc_cert_chain unquote rem .cer file in PEM format
call:read-param-req "Enter location to the new Web Client private key" ngc_private_key unquote rem .key file in PEM format
call:read-param-req "Enter Single Sign-On Administrator user" sso_admin_user
call:read-passwd "Enter Single Sign-On Administrator password" sso_admin_password
goto :commonExit

:read_ngc_sso
call:read-param-req "Enter Single Sign-On Administrator user" sso_admin_user
call:read-passwd "Enter Single Sign-On Administrator password" sso_admin_password
goto :commonExit

:read_logbrowser
call:read-param-req "Enter location to the new Log Browser SSL chain" logbrowser_cert_chain unquote rem .cer file in PEM format
call:read-param-req "Enter location to the new Log Browser private key" logbrowser_private_key unquote rem .key file in PEM format
call:read-param-req "Enter Single Sign-On Administrator user" sso_admin_user
call:read-passwd "Enter Single Sign-On Administrator password" sso_admin_password
goto :commonExit

:read_logbrowser_sso
call:read-param-req "Enter Single Sign-On Administrator user" sso_admin_user
call:read-passwd "Enter Single Sign-On Administrator password" sso_admin_password
call:read-param-req "Enter location to the new Single Sign-On SSL chain. If SSO is behind a Load Balancer, provide the Load Balancer CA certificate" sso_cert_chain unquote rem .cer file in PEM format
goto :commonExit

:read_logbrowser_rollback
call:read-param-req "Enter Single Sign-On Administrator user" sso_admin_user
call:read-passwd "Enter Single Sign-On Administrator password" sso_admin_password
goto :commonExit

:read_vum
call:read-param-req "Enter location to the new vSphere Update Manager SSL chain" vum_cert_chain unquote rem .cer file in PEM format
call:read-param-req "Enter location to the new vSphere Update Manager private key" vum_private_key unquote rem .key file in PEM format
:read_vum_trust
:read_vum_rollback
call:read-param-req "Enter vCenter Server administrator user name" vc_username
call:read-passwd "Enter vCenter Server administrator password" vc_password
goto :commonExit

:clearEnvironment
call:clearSSOParams
call:clearISParams
call:clearVCParams
call:clearVCOParams
call:clearNGCParams
call:clearLogBrowserParams
call:clearVUMParams
call:clearCSR
goto :commonExit
rem end cleanEnvironment

:clearCSR
set gen_cert_server_fqdn=
set gen_cert_server_ip=
set gen_cert_server_short_name=
set gen_cert_country=
set gen_cert_state=
set gen_cert_locality_name=
set gen_cert_organization_name=
set gen_cert_organizational_unit_name=

:clearSSOParams
set sso_cert_chain=
set sso_private_key=
set sso_master_password=
set sso_node_type=
set sso_admin_is_behind_lb=
set sso_lb_certificate=
set sso_lb_hostname=
goto :commonExit

:clearISParams
set is_cert_chain=
set is_private_key_new=
set sso_admin_user=
set sso_admin_password=
goto :commonExit

:clearVCParams
set vc_username=
set vc_password=
set vc_db_password=
set vc_cert_chain=
set vc_private_key=
goto :commonExit

:clearNGCParams
set ngc_cert_chain=
set ngc_private_key=
set sso_admin_user=
set sso_admin_password=
goto :commonExit

:clearLogBrowserParams
set logbrowser_cert_chain=
set logbrowser_private_key=
set sso_admin_user=
set sso_admin_password=
goto :commonExit

:clearVCOParams
set vco_cert_chain=
set vco_private_key=
goto :commonExit

:clearVUMParams
set vum_cert_chain=
set vum_private_key=
set vc_username=
set vc_password=
goto :commonExit

:clear_vc_sso
set sso_cert_chain=
goto :commonExit

:clear_vco_sso
set sso_cert_chain=
goto :commonExit

:clear_vco_vc
set vc_cert_chain=
goto :commonExit

:clear_ngc_sso
set sso_admin_user=
set sso_admin_password=
goto :commonExit


rem ##############################################################################
rem #
rem # This function is used to check if an environment variable is set:
rem #   -- if it is not set then ask the user interactively to set it
rem #   -- if it is set then output its value and ask the user if he wants to set
rem #      it to other value
rem #
rem # --first argument is the message to be displayed to ask the user to enter
rem #   interactively a value for a variable
rem # --second argument is the name of the environment variable
rem # --third argument is the default value of the environment variable
rem #
rem ##############################################################################
:read-param
rem echo all params %*
set input_msg=%~1
set param=%~2
set unquote=%~3
if defined %param% goto definedParam
set /p "%param%=%input_msg%: "

:endReadParam
set temp_var=

if [%unquote%] == [unquote] if defined %param% (
   call set "%param%=%%%param%:"=%%"
)

goto :eof

:definedParam
rem echo Parameter name : %param% is already set to %default_value%
rem the last space is for better view of the parameters in the console
call set "default_value=%%%param%%%"
set input_msg=%input_msg% (default value is: %default_value%): 
set temp_var=
set /p temp_var=%input_msg%
if not defined temp_var (
   rem echo using the default value
   goto :endReadParam
)

set "%param%=%temp_var%"
goto endReadParam
rem end read-param


rem ##############################################################################
rem #
rem # Like read-param, but forces the user to enter non-empty value.
rem #
rem ##############################################################################
:read-param-req
set input_msg=%~1
set param=%~2
set unquote=%~3

:read-param-req-loop
call:read-param "%input_msg%" "%param%" "%unquote%"
if not defined %param% (
   echo This parameter is required. Enter a non-empty value.
   goto read-param-req-loop
)

exit /b 0
rem end of function // goto:eof
rem ##############################################################################
rem #
rem # Reads a password into an environment variable without echoing the input
rem # to the screen. Second argument is the variable name; first argument is the
rem # prompt.
rem #
rem # If the variable is already set, the function does nothing.
rem #
rem ##############################################################################
:read-passwd
set param=%~2
rem if the password is somehow saved, means below is true - ask for new value
rem if --all mode is implemented then uncomment this
rem if defined %param% (
rem   call "%~dp0common" Parameter name : %param% is already set
rem   exit /b 0
rem )
<NUL set /p="%~1 (will not be echoed): "
for /f "delims=" %%i in ('CALL "%JAVA_HOME%\bin\java" -cp "%~dp0\sso-updater.jar" com.vmware.sso.cfg.AskPasswd') do set %param%=%%i
echo.
exit /b 0

:commonExit
exit /B %PRIORERRORLEVEL%
