
-- --------------------------------------------------
-- Entity Designer DDL Script for SQL Server 2005, 2008, and Azure
-- --------------------------------------------------
-- Date Created: 03/26/2012 12:02:59
-- Generated from EDMX file: C:\source\Trunk\src\models\ScvmmModel\DynamicOps.ScvmmModel\ScvmmModelEntities.edmx
-- --------------------------------------------------

SET QUOTED_IDENTIFIER OFF;
GO
USE [$(DBName)];
GO
IF SCHEMA_ID(N'DynamicOps.ScvmmModel') IS NULL EXECUTE(N'CREATE SCHEMA [DynamicOps.ScvmmModel]');
GO

-- --------------------------------------------------
-- Dropping existing FOREIGN KEY constraints
-- --------------------------------------------------

IF OBJECT_ID(N'[DynamicOps.ScvmmModel].[FK_ScvmmServerVMTemplate]', 'F') IS NOT NULL
    ALTER TABLE [DynamicOps.ScvmmModel].[VMTemplates] DROP CONSTRAINT [FK_ScvmmServerVMTemplate];
GO
IF OBJECT_ID(N'[DynamicOps.ScvmmModel].[FK_ScvmmServerHardwareProfile]', 'F') IS NOT NULL
    ALTER TABLE [DynamicOps.ScvmmModel].[HardwareProfiles] DROP CONSTRAINT [FK_ScvmmServerHardwareProfile];
GO
IF OBJECT_ID(N'[DynamicOps.ScvmmModel].[FK_ScvmmServerGuestOSProfile]', 'F') IS NOT NULL
    ALTER TABLE [DynamicOps.ScvmmModel].[GuestOSProfiles] DROP CONSTRAINT [FK_ScvmmServerGuestOSProfile];
GO
IF OBJECT_ID(N'[DynamicOps.ScvmmModel].[FK_ScvmmServerVirtualHardDisk]', 'F') IS NOT NULL
    ALTER TABLE [DynamicOps.ScvmmModel].[VirtualHardDisks] DROP CONSTRAINT [FK_ScvmmServerVirtualHardDisk];
GO
IF OBJECT_ID(N'[DynamicOps.ScvmmModel].[FK_ScvmmServerISO]', 'F') IS NOT NULL
    ALTER TABLE [DynamicOps.ScvmmModel].[ISOs] DROP CONSTRAINT [FK_ScvmmServerISO];
GO
IF OBJECT_ID(N'[DynamicOps.ScvmmModel].[FK_VMTemplateVirtualHardDisk_VMTemplate]', 'F') IS NOT NULL
    ALTER TABLE [DynamicOps.ScvmmModel].[VMTemplateVirtualHardDisk] DROP CONSTRAINT [FK_VMTemplateVirtualHardDisk_VMTemplate];
GO
IF OBJECT_ID(N'[DynamicOps.ScvmmModel].[FK_VMTemplateVirtualHardDisk_VirtualHardDisk]', 'F') IS NOT NULL
    ALTER TABLE [DynamicOps.ScvmmModel].[VMTemplateVirtualHardDisk] DROP CONSTRAINT [FK_VMTemplateVirtualHardDisk_VirtualHardDisk];
GO
IF OBJECT_ID(N'[DynamicOps.ScvmmModel].[FK_VMTemplateISO_VMTemplate]', 'F') IS NOT NULL
    ALTER TABLE [DynamicOps.ScvmmModel].[VMTemplateISO] DROP CONSTRAINT [FK_VMTemplateISO_VMTemplate];
GO
IF OBJECT_ID(N'[DynamicOps.ScvmmModel].[FK_VMTemplateISO_ISO]', 'F') IS NOT NULL
    ALTER TABLE [DynamicOps.ScvmmModel].[VMTemplateISO] DROP CONSTRAINT [FK_VMTemplateISO_ISO];
GO
IF OBJECT_ID(N'[DynamicOps.ScvmmModel].[FK_HardwareProfileISO_HardwareProfile]', 'F') IS NOT NULL
    ALTER TABLE [DynamicOps.ScvmmModel].[HardwareProfileISO] DROP CONSTRAINT [FK_HardwareProfileISO_HardwareProfile];
GO
IF OBJECT_ID(N'[DynamicOps.ScvmmModel].[FK_HardwareProfileISO_ISO]', 'F') IS NOT NULL
    ALTER TABLE [DynamicOps.ScvmmModel].[HardwareProfileISO] DROP CONSTRAINT [FK_HardwareProfileISO_ISO];
GO
IF OBJECT_ID(N'[DynamicOps.ScvmmModel].[FK_ScvmmServerVirtualNetwork]', 'F') IS NOT NULL
    ALTER TABLE [DynamicOps.ScvmmModel].[Networks] DROP CONSTRAINT [FK_ScvmmServerVirtualNetwork];
GO
IF OBJECT_ID(N'[DynamicOps.ScvmmModel].[FK_HardwareProfileNetwork_HardwareProfile]', 'F') IS NOT NULL
    ALTER TABLE [DynamicOps.ScvmmModel].[HardwareProfileVirtualNetwork] DROP CONSTRAINT [FK_HardwareProfileNetwork_HardwareProfile];
GO
IF OBJECT_ID(N'[DynamicOps.ScvmmModel].[FK_HardwareProfileNetwork_Network]', 'F') IS NOT NULL
    ALTER TABLE [DynamicOps.ScvmmModel].[HardwareProfileVirtualNetwork] DROP CONSTRAINT [FK_HardwareProfileNetwork_Network];
GO
IF OBJECT_ID(N'[DynamicOps.ScvmmModel].[FK_VMTemplateVirtualNetwork_VMTemplate]', 'F') IS NOT NULL
    ALTER TABLE [DynamicOps.ScvmmModel].[VMTemplateVirtualNetwork] DROP CONSTRAINT [FK_VMTemplateVirtualNetwork_VMTemplate];
GO
IF OBJECT_ID(N'[DynamicOps.ScvmmModel].[FK_VMTemplateVirtualNetwork_VirtualNetwork]', 'F') IS NOT NULL
    ALTER TABLE [DynamicOps.ScvmmModel].[VMTemplateVirtualNetwork] DROP CONSTRAINT [FK_VMTemplateVirtualNetwork_VirtualNetwork];
GO

-- --------------------------------------------------
-- Dropping existing tables
-- --------------------------------------------------

IF OBJECT_ID(N'[DynamicOps.ScvmmModel].[ScvmmServers]', 'U') IS NOT NULL
    DROP TABLE [DynamicOps.ScvmmModel].[ScvmmServers];
GO
IF OBJECT_ID(N'[DynamicOps.ScvmmModel].[VMTemplates]', 'U') IS NOT NULL
    DROP TABLE [DynamicOps.ScvmmModel].[VMTemplates];
GO
IF OBJECT_ID(N'[DynamicOps.ScvmmModel].[HardwareProfiles]', 'U') IS NOT NULL
    DROP TABLE [DynamicOps.ScvmmModel].[HardwareProfiles];
GO
IF OBJECT_ID(N'[DynamicOps.ScvmmModel].[VirtualHardDisks]', 'U') IS NOT NULL
    DROP TABLE [DynamicOps.ScvmmModel].[VirtualHardDisks];
GO
IF OBJECT_ID(N'[DynamicOps.ScvmmModel].[GuestOSProfiles]', 'U') IS NOT NULL
    DROP TABLE [DynamicOps.ScvmmModel].[GuestOSProfiles];
GO
IF OBJECT_ID(N'[DynamicOps.ScvmmModel].[Networks]', 'U') IS NOT NULL
    DROP TABLE [DynamicOps.ScvmmModel].[Networks];
GO
IF OBJECT_ID(N'[DynamicOps.ScvmmModel].[ISOs]', 'U') IS NOT NULL
    DROP TABLE [DynamicOps.ScvmmModel].[ISOs];
GO
IF OBJECT_ID(N'[DynamicOps.ScvmmModel].[VMTemplateVirtualHardDisk]', 'U') IS NOT NULL
    DROP TABLE [DynamicOps.ScvmmModel].[VMTemplateVirtualHardDisk];
GO
IF OBJECT_ID(N'[DynamicOps.ScvmmModel].[VMTemplateISO]', 'U') IS NOT NULL
    DROP TABLE [DynamicOps.ScvmmModel].[VMTemplateISO];
GO
IF OBJECT_ID(N'[DynamicOps.ScvmmModel].[HardwareProfileISO]', 'U') IS NOT NULL
    DROP TABLE [DynamicOps.ScvmmModel].[HardwareProfileISO];
GO
IF OBJECT_ID(N'[DynamicOps.ScvmmModel].[HardwareProfileVirtualNetwork]', 'U') IS NOT NULL
    DROP TABLE [DynamicOps.ScvmmModel].[HardwareProfileVirtualNetwork];
GO
IF OBJECT_ID(N'[DynamicOps.ScvmmModel].[VMTemplateVirtualNetwork]', 'U') IS NOT NULL
    DROP TABLE [DynamicOps.ScvmmModel].[VMTemplateVirtualNetwork];
GO

-- --------------------------------------------------
-- Creating all tables
-- --------------------------------------------------

-- Creating table 'ScvmmServers'
CREATE TABLE [DynamicOps.ScvmmModel].[ScvmmServers] (
    [Id] int IDENTITY(1,1) NOT NULL,
    [ManagementEndpointID] uniqueidentifier  NOT NULL
);
GO

-- Creating table 'VMTemplates'
CREATE TABLE [DynamicOps.ScvmmModel].[VMTemplates] (
    [Id] int IDENTITY(1,1) NOT NULL,
    [Name] nvarchar(max)  NOT NULL,
    [CPUCount] int  NOT NULL,
    [MemoryInMB] int  NOT NULL,
    [OperatingSystem] nvarchar(max)  NOT NULL,
    [CPUType] nvarchar(max)  NOT NULL,
    [Description] nvarchar(max)  NULL,
    [UniqueId] uniqueidentifier  NOT NULL,
    [IsCustomizable] bit  NOT NULL,
    [ScvmmServer_Id] int  NOT NULL
);
GO

-- Creating table 'HardwareProfiles'
CREATE TABLE [DynamicOps.ScvmmModel].[HardwareProfiles] (
    [Id] int IDENTITY(1,1) NOT NULL,
    [CPUCount] int  NOT NULL,
    [CPUType] nvarchar(max)  NOT NULL,
    [MemoryInMB] int  NOT NULL,
    [Name] nvarchar(max)  NULL,
    [Description] nvarchar(max)  NULL,
    [UniqueId] uniqueidentifier  NOT NULL,
    [ScvmmServer_Id] int  NOT NULL
);
GO

-- Creating table 'VirtualHardDisks'
CREATE TABLE [DynamicOps.ScvmmModel].[VirtualHardDisks] (
    [Id] int IDENTITY(1,1) NOT NULL,
    [VHDType] nvarchar(max)  NOT NULL,
    [Name] nvarchar(max)  NOT NULL,
    [Size] int  NOT NULL,
    [Description] nvarchar(max)  NULL,
    [UniqueId] uniqueidentifier  NOT NULL,
    [ScvmmServer_Id] int  NOT NULL
);
GO

-- Creating table 'GuestOSProfiles'
CREATE TABLE [DynamicOps.ScvmmModel].[GuestOSProfiles] (
    [Id] int IDENTITY(1,1) NOT NULL,
    [Name] nvarchar(128)  NOT NULL,
    [Description] nvarchar(256)  NULL,
    [UniqueId] uniqueidentifier  NOT NULL,
    [ScvmmServer_Id] int  NOT NULL
);
GO

-- Creating table 'Networks'
CREATE TABLE [DynamicOps.ScvmmModel].[Networks] (
    [Id] int IDENTITY(1,1) NOT NULL,
    [Name] nvarchar(128)  NOT NULL,
    [IsLogical] bit  NOT NULL,
    [Description] nvarchar(256)  NULL,
    [UniqueId] uniqueidentifier  NOT NULL,
    [ScvmmServer_Id] int  NOT NULL
);
GO

-- Creating table 'ISOs'
CREATE TABLE [DynamicOps.ScvmmModel].[ISOs] (
    [Id] int IDENTITY(1,1) NOT NULL,
    [Name] nvarchar(max)  NOT NULL,
    [Size] int  NOT NULL,
    [Description] nvarchar(max)  NULL,
    [UniqueId] uniqueidentifier  NOT NULL,
    [ScvmmServer_Id] int  NOT NULL
);
GO

-- Creating table 'VMTemplateVirtualHardDisk'
CREATE TABLE [DynamicOps.ScvmmModel].[VMTemplateVirtualHardDisk] (
    [VMTemplates_Id] int  NOT NULL,
    [VirtualHardDisks_Id] int  NOT NULL
);
GO

-- Creating table 'VMTemplateISO'
CREATE TABLE [DynamicOps.ScvmmModel].[VMTemplateISO] (
    [VMTemplates_Id] int  NOT NULL,
    [ISOs_Id] int  NOT NULL
);
GO

-- Creating table 'HardwareProfileISO'
CREATE TABLE [DynamicOps.ScvmmModel].[HardwareProfileISO] (
    [HardwareProfiles_Id] int  NOT NULL,
    [ISOs_Id] int  NOT NULL
);
GO

-- Creating table 'HardwareProfileVirtualNetwork'
CREATE TABLE [DynamicOps.ScvmmModel].[HardwareProfileVirtualNetwork] (
    [HardwareProfiles_Id] int  NOT NULL,
    [Networks_Id] int  NOT NULL
);
GO

-- Creating table 'VMTemplateVirtualNetwork'
CREATE TABLE [DynamicOps.ScvmmModel].[VMTemplateVirtualNetwork] (
    [VMTemplates_Id] int  NOT NULL,
    [Networks_Id] int  NOT NULL
);
GO

-- --------------------------------------------------
-- Creating all PRIMARY KEY constraints
-- --------------------------------------------------

-- Creating primary key on [Id] in table 'ScvmmServers'
ALTER TABLE [DynamicOps.ScvmmModel].[ScvmmServers]
ADD CONSTRAINT [PK_ScvmmServers]
    PRIMARY KEY CLUSTERED ([Id] ASC);
GO

-- Creating primary key on [Id] in table 'VMTemplates'
ALTER TABLE [DynamicOps.ScvmmModel].[VMTemplates]
ADD CONSTRAINT [PK_VMTemplates]
    PRIMARY KEY CLUSTERED ([Id] ASC);
GO

-- Creating primary key on [Id] in table 'HardwareProfiles'
ALTER TABLE [DynamicOps.ScvmmModel].[HardwareProfiles]
ADD CONSTRAINT [PK_HardwareProfiles]
    PRIMARY KEY CLUSTERED ([Id] ASC);
GO

-- Creating primary key on [Id] in table 'VirtualHardDisks'
ALTER TABLE [DynamicOps.ScvmmModel].[VirtualHardDisks]
ADD CONSTRAINT [PK_VirtualHardDisks]
    PRIMARY KEY CLUSTERED ([Id] ASC);
GO

-- Creating primary key on [Id] in table 'GuestOSProfiles'
ALTER TABLE [DynamicOps.ScvmmModel].[GuestOSProfiles]
ADD CONSTRAINT [PK_GuestOSProfiles]
    PRIMARY KEY CLUSTERED ([Id] ASC);
GO

-- Creating primary key on [Id] in table 'Networks'
ALTER TABLE [DynamicOps.ScvmmModel].[Networks]
ADD CONSTRAINT [PK_Networks]
    PRIMARY KEY CLUSTERED ([Id] ASC);
GO

-- Creating primary key on [Id] in table 'ISOs'
ALTER TABLE [DynamicOps.ScvmmModel].[ISOs]
ADD CONSTRAINT [PK_ISOs]
    PRIMARY KEY CLUSTERED ([Id] ASC);
GO

-- Creating primary key on [VMTemplates_Id], [VirtualHardDisks_Id] in table 'VMTemplateVirtualHardDisk'
ALTER TABLE [DynamicOps.ScvmmModel].[VMTemplateVirtualHardDisk]
ADD CONSTRAINT [PK_VMTemplateVirtualHardDisk]
    PRIMARY KEY NONCLUSTERED ([VMTemplates_Id], [VirtualHardDisks_Id] ASC);
GO

-- Creating primary key on [VMTemplates_Id], [ISOs_Id] in table 'VMTemplateISO'
ALTER TABLE [DynamicOps.ScvmmModel].[VMTemplateISO]
ADD CONSTRAINT [PK_VMTemplateISO]
    PRIMARY KEY NONCLUSTERED ([VMTemplates_Id], [ISOs_Id] ASC);
GO

-- Creating primary key on [HardwareProfiles_Id], [ISOs_Id] in table 'HardwareProfileISO'
ALTER TABLE [DynamicOps.ScvmmModel].[HardwareProfileISO]
ADD CONSTRAINT [PK_HardwareProfileISO]
    PRIMARY KEY NONCLUSTERED ([HardwareProfiles_Id], [ISOs_Id] ASC);
GO

-- Creating primary key on [HardwareProfiles_Id], [Networks_Id] in table 'HardwareProfileVirtualNetwork'
ALTER TABLE [DynamicOps.ScvmmModel].[HardwareProfileVirtualNetwork]
ADD CONSTRAINT [PK_HardwareProfileVirtualNetwork]
    PRIMARY KEY NONCLUSTERED ([HardwareProfiles_Id], [Networks_Id] ASC);
GO

-- Creating primary key on [VMTemplates_Id], [Networks_Id] in table 'VMTemplateVirtualNetwork'
ALTER TABLE [DynamicOps.ScvmmModel].[VMTemplateVirtualNetwork]
ADD CONSTRAINT [PK_VMTemplateVirtualNetwork]
    PRIMARY KEY NONCLUSTERED ([VMTemplates_Id], [Networks_Id] ASC);
GO

-- --------------------------------------------------
-- Creating all FOREIGN KEY constraints
-- --------------------------------------------------

-- Creating foreign key on [ScvmmServer_Id] in table 'VMTemplates'
ALTER TABLE [DynamicOps.ScvmmModel].[VMTemplates]
ADD CONSTRAINT [FK_ScvmmServerVMTemplate]
    FOREIGN KEY ([ScvmmServer_Id])
    REFERENCES [DynamicOps.ScvmmModel].[ScvmmServers]
        ([Id])
    ON DELETE CASCADE ON UPDATE NO ACTION;

-- Creating non-clustered index for FOREIGN KEY 'FK_ScvmmServerVMTemplate'
CREATE INDEX [IX_FK_ScvmmServerVMTemplate]
ON [DynamicOps.ScvmmModel].[VMTemplates]
    ([ScvmmServer_Id]);
GO

-- Creating foreign key on [ScvmmServer_Id] in table 'HardwareProfiles'
ALTER TABLE [DynamicOps.ScvmmModel].[HardwareProfiles]
ADD CONSTRAINT [FK_ScvmmServerHardwareProfile]
    FOREIGN KEY ([ScvmmServer_Id])
    REFERENCES [DynamicOps.ScvmmModel].[ScvmmServers]
        ([Id])
    ON DELETE CASCADE ON UPDATE NO ACTION;

-- Creating non-clustered index for FOREIGN KEY 'FK_ScvmmServerHardwareProfile'
CREATE INDEX [IX_FK_ScvmmServerHardwareProfile]
ON [DynamicOps.ScvmmModel].[HardwareProfiles]
    ([ScvmmServer_Id]);
GO

-- Creating foreign key on [ScvmmServer_Id] in table 'GuestOSProfiles'
ALTER TABLE [DynamicOps.ScvmmModel].[GuestOSProfiles]
ADD CONSTRAINT [FK_ScvmmServerGuestOSProfile]
    FOREIGN KEY ([ScvmmServer_Id])
    REFERENCES [DynamicOps.ScvmmModel].[ScvmmServers]
        ([Id])
    ON DELETE CASCADE ON UPDATE NO ACTION;

-- Creating non-clustered index for FOREIGN KEY 'FK_ScvmmServerGuestOSProfile'
CREATE INDEX [IX_FK_ScvmmServerGuestOSProfile]
ON [DynamicOps.ScvmmModel].[GuestOSProfiles]
    ([ScvmmServer_Id]);
GO

-- Creating foreign key on [ScvmmServer_Id] in table 'VirtualHardDisks'
ALTER TABLE [DynamicOps.ScvmmModel].[VirtualHardDisks]
ADD CONSTRAINT [FK_ScvmmServerVirtualHardDisk]
    FOREIGN KEY ([ScvmmServer_Id])
    REFERENCES [DynamicOps.ScvmmModel].[ScvmmServers]
        ([Id])
    ON DELETE CASCADE ON UPDATE NO ACTION;

-- Creating non-clustered index for FOREIGN KEY 'FK_ScvmmServerVirtualHardDisk'
CREATE INDEX [IX_FK_ScvmmServerVirtualHardDisk]
ON [DynamicOps.ScvmmModel].[VirtualHardDisks]
    ([ScvmmServer_Id]);
GO

-- Creating foreign key on [ScvmmServer_Id] in table 'ISOs'
ALTER TABLE [DynamicOps.ScvmmModel].[ISOs]
ADD CONSTRAINT [FK_ScvmmServerISO]
    FOREIGN KEY ([ScvmmServer_Id])
    REFERENCES [DynamicOps.ScvmmModel].[ScvmmServers]
        ([Id])
    ON DELETE CASCADE ON UPDATE NO ACTION;

-- Creating non-clustered index for FOREIGN KEY 'FK_ScvmmServerISO'
CREATE INDEX [IX_FK_ScvmmServerISO]
ON [DynamicOps.ScvmmModel].[ISOs]
    ([ScvmmServer_Id]);
GO

-- Creating foreign key on [VMTemplates_Id] in table 'VMTemplateVirtualHardDisk'
ALTER TABLE [DynamicOps.ScvmmModel].[VMTemplateVirtualHardDisk]
ADD CONSTRAINT [FK_VMTemplateVirtualHardDisk_VMTemplate]
    FOREIGN KEY ([VMTemplates_Id])
    REFERENCES [DynamicOps.ScvmmModel].[VMTemplates]
        ([Id])
    ON DELETE NO ACTION ON UPDATE NO ACTION;
GO

-- Creating foreign key on [VirtualHardDisks_Id] in table 'VMTemplateVirtualHardDisk'
ALTER TABLE [DynamicOps.ScvmmModel].[VMTemplateVirtualHardDisk]
ADD CONSTRAINT [FK_VMTemplateVirtualHardDisk_VirtualHardDisk]
    FOREIGN KEY ([VirtualHardDisks_Id])
    REFERENCES [DynamicOps.ScvmmModel].[VirtualHardDisks]
        ([Id])
    ON DELETE NO ACTION ON UPDATE NO ACTION;

-- Creating non-clustered index for FOREIGN KEY 'FK_VMTemplateVirtualHardDisk_VirtualHardDisk'
CREATE INDEX [IX_FK_VMTemplateVirtualHardDisk_VirtualHardDisk]
ON [DynamicOps.ScvmmModel].[VMTemplateVirtualHardDisk]
    ([VirtualHardDisks_Id]);
GO

-- Creating foreign key on [VMTemplates_Id] in table 'VMTemplateISO'
ALTER TABLE [DynamicOps.ScvmmModel].[VMTemplateISO]
ADD CONSTRAINT [FK_VMTemplateISO_VMTemplate]
    FOREIGN KEY ([VMTemplates_Id])
    REFERENCES [DynamicOps.ScvmmModel].[VMTemplates]
        ([Id])
    ON DELETE NO ACTION ON UPDATE NO ACTION;
GO

-- Creating foreign key on [ISOs_Id] in table 'VMTemplateISO'
ALTER TABLE [DynamicOps.ScvmmModel].[VMTemplateISO]
ADD CONSTRAINT [FK_VMTemplateISO_ISO]
    FOREIGN KEY ([ISOs_Id])
    REFERENCES [DynamicOps.ScvmmModel].[ISOs]
        ([Id])
    ON DELETE NO ACTION ON UPDATE NO ACTION;

-- Creating non-clustered index for FOREIGN KEY 'FK_VMTemplateISO_ISO'
CREATE INDEX [IX_FK_VMTemplateISO_ISO]
ON [DynamicOps.ScvmmModel].[VMTemplateISO]
    ([ISOs_Id]);
GO

-- Creating foreign key on [HardwareProfiles_Id] in table 'HardwareProfileISO'
ALTER TABLE [DynamicOps.ScvmmModel].[HardwareProfileISO]
ADD CONSTRAINT [FK_HardwareProfileISO_HardwareProfile]
    FOREIGN KEY ([HardwareProfiles_Id])
    REFERENCES [DynamicOps.ScvmmModel].[HardwareProfiles]
        ([Id])
    ON DELETE NO ACTION ON UPDATE NO ACTION;
GO

-- Creating foreign key on [ISOs_Id] in table 'HardwareProfileISO'
ALTER TABLE [DynamicOps.ScvmmModel].[HardwareProfileISO]
ADD CONSTRAINT [FK_HardwareProfileISO_ISO]
    FOREIGN KEY ([ISOs_Id])
    REFERENCES [DynamicOps.ScvmmModel].[ISOs]
        ([Id])
    ON DELETE NO ACTION ON UPDATE NO ACTION;

-- Creating non-clustered index for FOREIGN KEY 'FK_HardwareProfileISO_ISO'
CREATE INDEX [IX_FK_HardwareProfileISO_ISO]
ON [DynamicOps.ScvmmModel].[HardwareProfileISO]
    ([ISOs_Id]);
GO

-- Creating foreign key on [ScvmmServer_Id] in table 'Networks'
ALTER TABLE [DynamicOps.ScvmmModel].[Networks]
ADD CONSTRAINT [FK_ScvmmServerVirtualNetwork]
    FOREIGN KEY ([ScvmmServer_Id])
    REFERENCES [DynamicOps.ScvmmModel].[ScvmmServers]
        ([Id])
    ON DELETE CASCADE ON UPDATE NO ACTION;

-- Creating non-clustered index for FOREIGN KEY 'FK_ScvmmServerVirtualNetwork'
CREATE INDEX [IX_FK_ScvmmServerVirtualNetwork]
ON [DynamicOps.ScvmmModel].[Networks]
    ([ScvmmServer_Id]);
GO

-- Creating foreign key on [HardwareProfiles_Id] in table 'HardwareProfileVirtualNetwork'
ALTER TABLE [DynamicOps.ScvmmModel].[HardwareProfileVirtualNetwork]
ADD CONSTRAINT [FK_HardwareProfileNetwork_HardwareProfile]
    FOREIGN KEY ([HardwareProfiles_Id])
    REFERENCES [DynamicOps.ScvmmModel].[HardwareProfiles]
        ([Id])
    ON DELETE NO ACTION ON UPDATE NO ACTION;
GO

-- Creating foreign key on [Networks_Id] in table 'HardwareProfileVirtualNetwork'
ALTER TABLE [DynamicOps.ScvmmModel].[HardwareProfileVirtualNetwork]
ADD CONSTRAINT [FK_HardwareProfileNetwork_Network]
    FOREIGN KEY ([Networks_Id])
    REFERENCES [DynamicOps.ScvmmModel].[Networks]
        ([Id])
    ON DELETE NO ACTION ON UPDATE NO ACTION;

-- Creating non-clustered index for FOREIGN KEY 'FK_HardwareProfileNetwork_Network'
CREATE INDEX [IX_FK_HardwareProfileNetwork_Network]
ON [DynamicOps.ScvmmModel].[HardwareProfileVirtualNetwork]
    ([Networks_Id]);
GO

-- Creating foreign key on [VMTemplates_Id] in table 'VMTemplateVirtualNetwork'
ALTER TABLE [DynamicOps.ScvmmModel].[VMTemplateVirtualNetwork]
ADD CONSTRAINT [FK_VMTemplateVirtualNetwork_VMTemplate]
    FOREIGN KEY ([VMTemplates_Id])
    REFERENCES [DynamicOps.ScvmmModel].[VMTemplates]
        ([Id])
    ON DELETE NO ACTION ON UPDATE NO ACTION;
GO

-- Creating foreign key on [Networks_Id] in table 'VMTemplateVirtualNetwork'
ALTER TABLE [DynamicOps.ScvmmModel].[VMTemplateVirtualNetwork]
ADD CONSTRAINT [FK_VMTemplateVirtualNetwork_VirtualNetwork]
    FOREIGN KEY ([Networks_Id])
    REFERENCES [DynamicOps.ScvmmModel].[Networks]
        ([Id])
    ON DELETE NO ACTION ON UPDATE NO ACTION;

-- Creating non-clustered index for FOREIGN KEY 'FK_VMTemplateVirtualNetwork_VirtualNetwork'
CREATE INDEX [IX_FK_VMTemplateVirtualNetwork_VirtualNetwork]
ON [DynamicOps.ScvmmModel].[VMTemplateVirtualNetwork]
    ([Networks_Id]);
GO

-- --------------------------------------------------
-- Script has ended
-- --------------------------------------------------