
-- --------------------------------------------------
-- Entity Designer DDL Script for SQL Server 2005, 2008, and Azure
-- --------------------------------------------------
-- Date Created: 03/12/2013 09:56:37
-- Generated from EDMX file: C:\TFS\branches\Burma\03_Mandalay\src\models\VCNSModel\DynamicOps.VCNSModel\VCNSModelEntities.edmx
-- --------------------------------------------------

SET QUOTED_IDENTIFIER OFF;
GO
IF SCHEMA_ID(N'DynamicOps.VCNSModel') IS NULL EXECUTE(N'CREATE SCHEMA [DynamicOps.VCNSModel]');
GO

-- --------------------------------------------------
-- Dropping existing FOREIGN KEY constraints
-- --------------------------------------------------

IF OBJECT_ID(N'[DynamicOps.VCNSModel].[FK_DatacenterVCNSEndpoint]', 'F') IS NOT NULL
    ALTER TABLE [DynamicOps.VCNSModel].[Datacenters] DROP CONSTRAINT [FK_DatacenterVCNSEndpoint];
GO
IF OBJECT_ID(N'[DynamicOps.VCNSModel].[FK_SecurityTagVCNSEndpoint]', 'F') IS NOT NULL
    ALTER TABLE [DynamicOps.VCNSModel].[SecurityTags] DROP CONSTRAINT [FK_SecurityTagVCNSEndpoint];
GO
IF OBJECT_ID(N'[DynamicOps.VCNSModel].[FK_SecurityGroupDatacenter]', 'F') IS NOT NULL
    ALTER TABLE [DynamicOps.VCNSModel].[SecurityGroups] DROP CONSTRAINT [FK_SecurityGroupDatacenter];
GO
IF OBJECT_ID(N'[DynamicOps.VCNSModel].[FK_EdgeDatacenter]', 'F') IS NOT NULL
    ALTER TABLE [DynamicOps.VCNSModel].[Edges] DROP CONSTRAINT [FK_EdgeDatacenter];
GO
IF OBJECT_ID(N'[DynamicOps.VCNSModel].[FK_LoadBalancerEdge]', 'F') IS NOT NULL
    ALTER TABLE [DynamicOps.VCNSModel].[LoadBalancers] DROP CONSTRAINT [FK_LoadBalancerEdge];
GO
IF OBJECT_ID(N'[DynamicOps.VCNSModel].[FK_BackendpoolLoadBalancer]', 'F') IS NOT NULL
    ALTER TABLE [DynamicOps.VCNSModel].[Backendpools] DROP CONSTRAINT [FK_BackendpoolLoadBalancer];
GO
IF OBJECT_ID(N'[DynamicOps.VCNSModel].[FK_BackendpoolMember]', 'F') IS NOT NULL
    ALTER TABLE [DynamicOps.VCNSModel].[Members] DROP CONSTRAINT [FK_BackendpoolMember];
GO

-- --------------------------------------------------
-- Dropping existing tables
-- --------------------------------------------------

IF OBJECT_ID(N'[DynamicOps.VCNSModel].[VCNSEndpoints]', 'U') IS NOT NULL
    DROP TABLE [DynamicOps.VCNSModel].[VCNSEndpoints];
GO
IF OBJECT_ID(N'[DynamicOps.VCNSModel].[SecurityTags]', 'U') IS NOT NULL
    DROP TABLE [DynamicOps.VCNSModel].[SecurityTags];
GO
IF OBJECT_ID(N'[DynamicOps.VCNSModel].[Datacenters]', 'U') IS NOT NULL
    DROP TABLE [DynamicOps.VCNSModel].[Datacenters];
GO
IF OBJECT_ID(N'[DynamicOps.VCNSModel].[SecurityGroups]', 'U') IS NOT NULL
    DROP TABLE [DynamicOps.VCNSModel].[SecurityGroups];
GO
IF OBJECT_ID(N'[DynamicOps.VCNSModel].[Edges]', 'U') IS NOT NULL
    DROP TABLE [DynamicOps.VCNSModel].[Edges];
GO
IF OBJECT_ID(N'[DynamicOps.VCNSModel].[LoadBalancers]', 'U') IS NOT NULL
    DROP TABLE [DynamicOps.VCNSModel].[LoadBalancers];
GO
IF OBJECT_ID(N'[DynamicOps.VCNSModel].[Backendpools]', 'U') IS NOT NULL
    DROP TABLE [DynamicOps.VCNSModel].[Backendpools];
GO
IF OBJECT_ID(N'[DynamicOps.VCNSModel].[Members]', 'U') IS NOT NULL
    DROP TABLE [DynamicOps.VCNSModel].[Members];
GO

-- --------------------------------------------------
-- Creating all tables
-- --------------------------------------------------

-- Creating table 'VCNSEndpoints'
CREATE TABLE [DynamicOps.VCNSModel].[VCNSEndpoints] (
    [Id] int IDENTITY(1,1) NOT NULL,
    [ManagementEndpointId] uniqueidentifier  NOT NULL,
    [Address] nvarchar(max)  NOT NULL,
    [ConnectionCredentialId] uniqueidentifier  NOT NULL
);
GO

-- Creating table 'SecurityTags'
CREATE TABLE [DynamicOps.VCNSModel].[SecurityTags] (
    [Id] int IDENTITY(1,1) NOT NULL,
    [Name] nvarchar(max)  NOT NULL,
    [Description] nvarchar(max)  NULL,
    [ManagementObjectId] nvarchar(max)  NOT NULL,
    [Revision] int  NOT NULL,
    [VCNSEndpoint_Id] int  NOT NULL
);
GO

-- Creating table 'Datacenters'
CREATE TABLE [DynamicOps.VCNSModel].[Datacenters] (
    [Id] int IDENTITY(1,1) NOT NULL,
    [Revision] int  NOT NULL,
    [Name] nvarchar(max)  NOT NULL,
    [ManagementObjectId] nvarchar(max)  NOT NULL,
    [Description] nvarchar(max)  NULL,
    [VCNSEndpoint_Id] int  NOT NULL
);
GO

-- Creating table 'SecurityGroups'
CREATE TABLE [DynamicOps.VCNSModel].[SecurityGroups] (
    [Id] int IDENTITY(1,1) NOT NULL,
    [Revision] int  NOT NULL,
    [Description] nvarchar(max)  NULL,
    [Name] nvarchar(max)  NOT NULL,
    [ManagementObjectId] nvarchar(max)  NOT NULL,
    [InheritanceAllowed] bit  NOT NULL,
    [IsHidden] bit  NOT NULL,
    [Datacenter_Id] int  NOT NULL
);
GO

-- Creating table 'Edges'
CREATE TABLE [DynamicOps.VCNSModel].[Edges] (
    [Id] int IDENTITY(1,1) NOT NULL,
    [Name] nvarchar(max)  NOT NULL,
    [Revision] int  NOT NULL,
    [Description] nvarchar(max)  NULL,
    [ManagementObjectId] nvarchar(max)  NOT NULL,
    [State] nvarchar(max)  NOT NULL,
    [Datacenter_Id] int  NOT NULL
);
GO

-- Creating table 'LoadBalancers'
CREATE TABLE [DynamicOps.VCNSModel].[LoadBalancers] (
    [Id] int IDENTITY(1,1) NOT NULL,
    [Enabled] bit  NOT NULL,
    [Edge_Id] int  NOT NULL
);
GO

-- Creating table 'Backendpools'
CREATE TABLE [DynamicOps.VCNSModel].[Backendpools] (
    [Id] int IDENTITY(1,1) NOT NULL,
    [Name] nvarchar(max)  NOT NULL,
    [Description] nvarchar(max)  NULL,
    [VCNSId] int  NOT NULL,
    [LoadBalancer_Id] int  NOT NULL
);
GO

-- Creating table 'Members'
CREATE TABLE [DynamicOps.VCNSModel].[Members] (
    [Id] int IDENTITY(1,1) NOT NULL,
    [Address] nvarchar(max)  NOT NULL,
    [Weigh] int  NOT NULL,
    [BackendpoolId] int  NOT NULL,
    [VirtualMachineId] uniqueidentifier  NULL
);
GO

-- --------------------------------------------------
-- Creating all PRIMARY KEY constraints
-- --------------------------------------------------

-- Creating primary key on [Id] in table 'VCNSEndpoints'
ALTER TABLE [DynamicOps.VCNSModel].[VCNSEndpoints]
ADD CONSTRAINT [PK_VCNSEndpoints]
    PRIMARY KEY CLUSTERED ([Id] ASC);
GO

-- Creating primary key on [Id] in table 'SecurityTags'
ALTER TABLE [DynamicOps.VCNSModel].[SecurityTags]
ADD CONSTRAINT [PK_SecurityTags]
    PRIMARY KEY CLUSTERED ([Id] ASC);
GO

-- Creating primary key on [Id] in table 'Datacenters'
ALTER TABLE [DynamicOps.VCNSModel].[Datacenters]
ADD CONSTRAINT [PK_Datacenters]
    PRIMARY KEY CLUSTERED ([Id] ASC);
GO

-- Creating primary key on [Id] in table 'SecurityGroups'
ALTER TABLE [DynamicOps.VCNSModel].[SecurityGroups]
ADD CONSTRAINT [PK_SecurityGroups]
    PRIMARY KEY CLUSTERED ([Id] ASC);
GO

-- Creating primary key on [Id] in table 'Edges'
ALTER TABLE [DynamicOps.VCNSModel].[Edges]
ADD CONSTRAINT [PK_Edges]
    PRIMARY KEY CLUSTERED ([Id] ASC);
GO

-- Creating primary key on [Id] in table 'LoadBalancers'
ALTER TABLE [DynamicOps.VCNSModel].[LoadBalancers]
ADD CONSTRAINT [PK_LoadBalancers]
    PRIMARY KEY CLUSTERED ([Id] ASC);
GO

-- Creating primary key on [Id] in table 'Backendpools'
ALTER TABLE [DynamicOps.VCNSModel].[Backendpools]
ADD CONSTRAINT [PK_Backendpools]
    PRIMARY KEY CLUSTERED ([Id] ASC);
GO

-- Creating primary key on [Id] in table 'Members'
ALTER TABLE [DynamicOps.VCNSModel].[Members]
ADD CONSTRAINT [PK_Members]
    PRIMARY KEY CLUSTERED ([Id] ASC);
GO

-- --------------------------------------------------
-- Creating all FOREIGN KEY constraints
-- --------------------------------------------------

-- Creating foreign key on [VCNSEndpoint_Id] in table 'Datacenters'
ALTER TABLE [DynamicOps.VCNSModel].[Datacenters]
ADD CONSTRAINT [FK_DatacenterVCNSEndpoint]
    FOREIGN KEY ([VCNSEndpoint_Id])
    REFERENCES [DynamicOps.VCNSModel].[VCNSEndpoints]
        ([Id])
    ON DELETE CASCADE ON UPDATE NO ACTION;

-- Creating non-clustered index for FOREIGN KEY 'FK_DatacenterVCNSEndpoint'
CREATE INDEX [IX_FK_DatacenterVCNSEndpoint]
ON [DynamicOps.VCNSModel].[Datacenters]
    ([VCNSEndpoint_Id]);
GO

-- Creating foreign key on [VCNSEndpoint_Id] in table 'SecurityTags'
ALTER TABLE [DynamicOps.VCNSModel].[SecurityTags]
ADD CONSTRAINT [FK_SecurityTagVCNSEndpoint]
    FOREIGN KEY ([VCNSEndpoint_Id])
    REFERENCES [DynamicOps.VCNSModel].[VCNSEndpoints]
        ([Id])
    ON DELETE CASCADE ON UPDATE NO ACTION;

-- Creating non-clustered index for FOREIGN KEY 'FK_SecurityTagVCNSEndpoint'
CREATE INDEX [IX_FK_SecurityTagVCNSEndpoint]
ON [DynamicOps.VCNSModel].[SecurityTags]
    ([VCNSEndpoint_Id]);
GO

-- Creating foreign key on [Datacenter_Id] in table 'SecurityGroups'
ALTER TABLE [DynamicOps.VCNSModel].[SecurityGroups]
ADD CONSTRAINT [FK_SecurityGroupDatacenter]
    FOREIGN KEY ([Datacenter_Id])
    REFERENCES [DynamicOps.VCNSModel].[Datacenters]
        ([Id])
    ON DELETE CASCADE ON UPDATE NO ACTION;

-- Creating non-clustered index for FOREIGN KEY 'FK_SecurityGroupDatacenter'
CREATE INDEX [IX_FK_SecurityGroupDatacenter]
ON [DynamicOps.VCNSModel].[SecurityGroups]
    ([Datacenter_Id]);
GO

-- Creating foreign key on [Datacenter_Id] in table 'Edges'
ALTER TABLE [DynamicOps.VCNSModel].[Edges]
ADD CONSTRAINT [FK_EdgeDatacenter]
    FOREIGN KEY ([Datacenter_Id])
    REFERENCES [DynamicOps.VCNSModel].[Datacenters]
        ([Id])
    ON DELETE CASCADE ON UPDATE NO ACTION;

-- Creating non-clustered index for FOREIGN KEY 'FK_EdgeDatacenter'
CREATE INDEX [IX_FK_EdgeDatacenter]
ON [DynamicOps.VCNSModel].[Edges]
    ([Datacenter_Id]);
GO

-- Creating foreign key on [Edge_Id] in table 'LoadBalancers'
ALTER TABLE [DynamicOps.VCNSModel].[LoadBalancers]
ADD CONSTRAINT [FK_LoadBalancerEdge]
    FOREIGN KEY ([Edge_Id])
    REFERENCES [DynamicOps.VCNSModel].[Edges]
        ([Id])
    ON DELETE CASCADE ON UPDATE NO ACTION;

-- Creating non-clustered index for FOREIGN KEY 'FK_LoadBalancerEdge'
CREATE INDEX [IX_FK_LoadBalancerEdge]
ON [DynamicOps.VCNSModel].[LoadBalancers]
    ([Edge_Id]);
GO

-- Creating foreign key on [LoadBalancer_Id] in table 'Backendpools'
ALTER TABLE [DynamicOps.VCNSModel].[Backendpools]
ADD CONSTRAINT [FK_BackendpoolLoadBalancer]
    FOREIGN KEY ([LoadBalancer_Id])
    REFERENCES [DynamicOps.VCNSModel].[LoadBalancers]
        ([Id])
    ON DELETE CASCADE ON UPDATE NO ACTION;

-- Creating non-clustered index for FOREIGN KEY 'FK_BackendpoolLoadBalancer'
CREATE INDEX [IX_FK_BackendpoolLoadBalancer]
ON [DynamicOps.VCNSModel].[Backendpools]
    ([LoadBalancer_Id]);
GO

-- Creating foreign key on [BackendpoolId] in table 'Members'
ALTER TABLE [DynamicOps.VCNSModel].[Members]
ADD CONSTRAINT [FK_BackendpoolMember]
    FOREIGN KEY ([BackendpoolId])
    REFERENCES [DynamicOps.VCNSModel].[Backendpools]
        ([Id])
    ON DELETE CASCADE ON UPDATE NO ACTION;

-- Creating non-clustered index for FOREIGN KEY 'FK_BackendpoolMember'
CREATE INDEX [IX_FK_BackendpoolMember]
ON [DynamicOps.VCNSModel].[Members]
    ([BackendpoolId]);
GO

-- --------------------------------------------------
-- Script has ended
-- --------------------------------------------------