
-- --------------------------------------------------
-- Entity Designer DDL Script for SQL Server 2005, 2008, and Azure
-- --------------------------------------------------
-- Date Created: 03/06/2013 10:18:22
-- Generated from EDMX file: C:\WS\5.1.1.INTEGRATION.DEV\Integration\Common\Models\WorkQueue\DynamicOps.Integration.WorkQueue.Model\WorkQueueModelEntities.edmx
-- --------------------------------------------------

SET QUOTED_IDENTIFIER OFF;
GO
IF SCHEMA_ID(N'DynamicOps.WorkQueueModel') IS NULL EXECUTE(N'CREATE SCHEMA [DynamicOps.WorkQueueModel]');
GO

-- --------------------------------------------------
-- Dropping existing FOREIGN KEY constraints
-- --------------------------------------------------

IF OBJECT_ID(N'[DynamicOps.WorkQueueModel].[FK_WorkQueueWorkQueueElement]', 'F') IS NOT NULL
    ALTER TABLE [DynamicOps.WorkQueueModel].[WorkQueueElements] DROP CONSTRAINT [FK_WorkQueueWorkQueueElement];
GO
IF OBJECT_ID(N'[DynamicOps.WorkQueueModel].[FK_WorkQueueWorkQueueProperty]', 'F') IS NOT NULL
    ALTER TABLE [DynamicOps.WorkQueueModel].[WorkQueueProperties] DROP CONSTRAINT [FK_WorkQueueWorkQueueProperty];
GO
IF OBJECT_ID(N'[DynamicOps.WorkQueueModel].[FK_WorkQueueElementWorkQueueElementProperty]', 'F') IS NOT NULL
    ALTER TABLE [DynamicOps.WorkQueueModel].[WorkQueueElementProperties] DROP CONSTRAINT [FK_WorkQueueElementWorkQueueElementProperty];
GO
IF OBJECT_ID(N'[DynamicOps.WorkQueueModel].[FK_WorkQueueTypeWorkQueue]', 'F') IS NOT NULL
    ALTER TABLE [DynamicOps.WorkQueueModel].[WorkQueues] DROP CONSTRAINT [FK_WorkQueueTypeWorkQueue];
GO

-- --------------------------------------------------
-- Dropping existing tables
-- --------------------------------------------------

IF OBJECT_ID(N'[DynamicOps.WorkQueueModel].[WorkQueues]', 'U') IS NOT NULL
    DROP TABLE [DynamicOps.WorkQueueModel].[WorkQueues];
GO
IF OBJECT_ID(N'[DynamicOps.WorkQueueModel].[WorkQueueTypes]', 'U') IS NOT NULL
    DROP TABLE [DynamicOps.WorkQueueModel].[WorkQueueTypes];
GO
IF OBJECT_ID(N'[DynamicOps.WorkQueueModel].[WorkQueueElements]', 'U') IS NOT NULL
    DROP TABLE [DynamicOps.WorkQueueModel].[WorkQueueElements];
GO
IF OBJECT_ID(N'[DynamicOps.WorkQueueModel].[WorkQueueProperties]', 'U') IS NOT NULL
    DROP TABLE [DynamicOps.WorkQueueModel].[WorkQueueProperties];
GO
IF OBJECT_ID(N'[DynamicOps.WorkQueueModel].[WorkQueueElementProperties]', 'U') IS NOT NULL
    DROP TABLE [DynamicOps.WorkQueueModel].[WorkQueueElementProperties];
GO

-- --------------------------------------------------
-- Creating all tables
-- --------------------------------------------------

-- Creating table 'WorkQueues'
CREATE TABLE [DynamicOps.WorkQueueModel].[WorkQueues] (
    [Id] int IDENTITY(1,1) NOT NULL,
    [Name] nvarchar(256)  NOT NULL,
    [Description] nvarchar(256)  NULL,
    [EntityType] nvarchar(256)  NOT NULL,
    [Priority] int  NOT NULL,
    [Subtype] nvarchar(256)  NULL,
    [WorkQueueTypeId] int  NOT NULL,
    [Status] nvarchar(256)  NULL,
    [TotalNumber] int  NOT NULL,
    [RemainingNumber] int  NOT NULL,
    [TimeStamp] datetime  NOT NULL,
	UNIQUE ([Name], [WorkQueueTypeId])
);
GO

-- Creating table 'WorkQueueTypes'
CREATE TABLE [DynamicOps.WorkQueueModel].[WorkQueueTypes] (
    [Id] int  NOT NULL,
    [Name] nvarchar(256)  NOT NULL,
    [Description] nvarchar(256)  NULL,
	UNIQUE ([Name])
);
GO

-- Creating table 'WorkQueueElements'
CREATE TABLE [DynamicOps.WorkQueueModel].[WorkQueueElements] (
    [Id] int IDENTITY(1,1) NOT NULL,
    [EntityId] nvarchar(256)  NOT NULL,
    [Status] nvarchar(256)  NULL,
    [Priority] int  NOT NULL,
    [WorkQueueId] int  NOT NULL,
    [TimeStamp] datetime  NOT NULL
);
GO

-- Creating table 'WorkQueueProperties'
CREATE TABLE [DynamicOps.WorkQueueModel].[WorkQueueProperties] (
    [Id] int IDENTITY(1,1) NOT NULL,
    [Name] nvarchar(256)  NOT NULL,
    [Value] nvarchar(256)  NULL,
    [IsHidden] bit  NOT NULL,
    [IsRuntime] bit  NOT NULL,
    [IsEncrypted] bit  NOT NULL,
    [WorkQueueId] int  NOT NULL
);
GO

-- Creating table 'WorkQueueElementProperties'
CREATE TABLE [DynamicOps.WorkQueueModel].[WorkQueueElementProperties] (
    [Id] int IDENTITY(1,1) NOT NULL,
    [Name] nvarchar(256)  NOT NULL,
    [Value] nvarchar(256)  NULL,
    [IsHidden] bit  NOT NULL,
    [IsRuntime] bit  NOT NULL,
    [IsEncrypted] bit  NOT NULL,
    [WorkQueueElementId] int  NOT NULL
);
GO

-- --------------------------------------------------
-- Creating all PRIMARY KEY constraints
-- --------------------------------------------------

-- Creating primary key on [Id] in table 'WorkQueues'
ALTER TABLE [DynamicOps.WorkQueueModel].[WorkQueues]
ADD CONSTRAINT [PK_WorkQueues]
    PRIMARY KEY CLUSTERED ([Id] ASC);
GO

-- Creating primary key on [Id] in table 'WorkQueueTypes'
ALTER TABLE [DynamicOps.WorkQueueModel].[WorkQueueTypes]
ADD CONSTRAINT [PK_WorkQueueTypes]
    PRIMARY KEY CLUSTERED ([Id] ASC);
GO

-- Creating primary key on [Id] in table 'WorkQueueElements'
ALTER TABLE [DynamicOps.WorkQueueModel].[WorkQueueElements]
ADD CONSTRAINT [PK_WorkQueueElements]
    PRIMARY KEY CLUSTERED ([Id] ASC);
GO

-- Creating primary key on [Id] in table 'WorkQueueProperties'
ALTER TABLE [DynamicOps.WorkQueueModel].[WorkQueueProperties]
ADD CONSTRAINT [PK_WorkQueueProperties]
    PRIMARY KEY CLUSTERED ([Id] ASC);
GO

-- Creating primary key on [Id] in table 'WorkQueueElementProperties'
ALTER TABLE [DynamicOps.WorkQueueModel].[WorkQueueElementProperties]
ADD CONSTRAINT [PK_WorkQueueElementProperties]
    PRIMARY KEY CLUSTERED ([Id] ASC);
GO

-- --------------------------------------------------
-- Creating all FOREIGN KEY constraints
-- --------------------------------------------------

-- Creating foreign key on [WorkQueueId] in table 'WorkQueueElements'
ALTER TABLE [DynamicOps.WorkQueueModel].[WorkQueueElements]
ADD CONSTRAINT [FK_WorkQueueWorkQueueElement]
    FOREIGN KEY ([WorkQueueId])
    REFERENCES [DynamicOps.WorkQueueModel].[WorkQueues]
        ([Id])
    ON DELETE CASCADE ON UPDATE NO ACTION;

-- Creating non-clustered index for FOREIGN KEY 'FK_WorkQueueWorkQueueElement'
CREATE INDEX [IX_FK_WorkQueueWorkQueueElement]
ON [DynamicOps.WorkQueueModel].[WorkQueueElements]
    ([WorkQueueId]);
GO

-- Creating foreign key on [WorkQueueId] in table 'WorkQueueProperties'
ALTER TABLE [DynamicOps.WorkQueueModel].[WorkQueueProperties]
ADD CONSTRAINT [FK_WorkQueueWorkQueueProperty]
    FOREIGN KEY ([WorkQueueId])
    REFERENCES [DynamicOps.WorkQueueModel].[WorkQueues]
        ([Id])
    ON DELETE CASCADE ON UPDATE NO ACTION;

-- Creating non-clustered index for FOREIGN KEY 'FK_WorkQueueWorkQueueProperty'
CREATE INDEX [IX_FK_WorkQueueWorkQueueProperty]
ON [DynamicOps.WorkQueueModel].[WorkQueueProperties]
    ([WorkQueueId]);
GO

-- Creating foreign key on [WorkQueueElementId] in table 'WorkQueueElementProperties'
ALTER TABLE [DynamicOps.WorkQueueModel].[WorkQueueElementProperties]
ADD CONSTRAINT [FK_WorkQueueElementWorkQueueElementProperty]
    FOREIGN KEY ([WorkQueueElementId])
    REFERENCES [DynamicOps.WorkQueueModel].[WorkQueueElements]
        ([Id])
    ON DELETE CASCADE ON UPDATE NO ACTION;

-- Creating non-clustered index for FOREIGN KEY 'FK_WorkQueueElementWorkQueueElementProperty'
CREATE INDEX [IX_FK_WorkQueueElementWorkQueueElementProperty]
ON [DynamicOps.WorkQueueModel].[WorkQueueElementProperties]
    ([WorkQueueElementId]);
GO

-- Creating foreign key on [WorkQueueTypeId] in table 'WorkQueues'
ALTER TABLE [DynamicOps.WorkQueueModel].[WorkQueues]
ADD CONSTRAINT [FK_WorkQueueTypeWorkQueue]
    FOREIGN KEY ([WorkQueueTypeId])
    REFERENCES [DynamicOps.WorkQueueModel].[WorkQueueTypes]
        ([Id])
    ON DELETE NO ACTION ON UPDATE NO ACTION;

-- Creating non-clustered index for FOREIGN KEY 'FK_WorkQueueTypeWorkQueue'
CREATE INDEX [IX_FK_WorkQueueTypeWorkQueue]
ON [DynamicOps.WorkQueueModel].[WorkQueues]
    ([WorkQueueTypeId]);
GO


-- -------------------------------------------------
-- Manual changes
-- -------------------------------------------------

CREATE INDEX [IX_WorkQueueElementsEntityId]
ON [DynamicOps.WorkQueueModel].[WorkQueueElements]
	([EntityId])
GO

CREATE INDEX [IX_WorkQueueElementPropertiesName]
ON [DynamicOps.WorkQueueModel].[WorkQueueElementProperties]
	([Name])
GO

CREATE INDEX [IX_WorkQueuePropertiesName]
ON [DynamicOps.WorkQueueModel].[WorkQueueProperties]
	([Name])
GO

CREATE INDEX [IX_WorkQueueName]
ON [DynamicOps.WorkQueueModel].[WorkQueues]
	([Name])
GO

INSERT INTO [DynamicOps.WorkQueueModel].[WorkQueueTypes]
VALUES (1, 'Register', 'Bulk Import VMs Queue Type')

GO

IF EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[GetWorkQueueElementProperty]') AND type = N'FN')
DROP FUNCTION [dbo].[GetWorkQueueElementProperty]
GO
CREATE FUNCTION [dbo].[GetWorkQueueElementProperty] (@id int, @name nvarchar(256))
       RETURNS nvarchar(256) 
       AS
       BEGIN
              DECLARE @value nvarchar(256) 
              SELECT @value = Value
              FROM [DynamicOps.WorkQueueModel].WorkQueueElementProperties
              WHERE WorkQueueElementId = @id AND Name = @name
              RETURN @value
       END
GO

IF EXISTS (SELECT * FROM sys.views WHERE object_id = OBJECT_ID(N'[dbo].[BulkImportDetails]'))
DROP VIEW [dbo].[BulkImportDetails]
GO
CREATE VIEW [dbo].[BulkImportDetails]
AS
       SELECT 
              wqe.Id, 
  			  wqe.WorkQueueId as WorkQueueId, 
              ISNULL(vm.VirtualMachineName, N'Unknown') as Machine,
              ISNULL(vm.MachineType, 0) as MachineType,
              hr.HostReservationName as Reservation,
              s.StorageName as Storage,
              vmt.VirtualMachineTemplateName as Blueprint,
              dbo.GetWorkQueueElementProperty(wqe.Id, N'__Register.Owner') as [Owner],
              wqe.[Status]
       FROM [DynamicOps.WorkQueueModel].WorkQueueElements wqe
       LEFT JOIN VirtualMachine vm
              ON wqe.EntityId = vm.VirtualMachineID
       LEFT JOIN HostReservation hr
              ON hr.HostReservationID = dbo.GetWorkQueueElementProperty(wqe.Id, N'__Register.ReservationId')
       LEFT JOIN Storage s
              ON s.StorageID = dbo.GetWorkQueueElementProperty(wqe.Id, N'__Register.StorageId')
       LEFT JOIN VirtualMachineTemplate vmt
              ON vmt.VirtualMachineTemplateID = dbo.GetWorkQueueElementProperty(wqe.Id, N'__Register.BlueprintId')
GO

-- --------------------------------------------------
-- Script has ended
-- --------------------------------------------------