/* ---------------------------------------------------------------------- */
/* Tables                                                                 */
/* ---------------------------------------------------------------------- */

/* ---------------------------------------------------------------------- */
/* Add table "Alerts"                                              */
/* ---------------------------------------------------------------------- */

CREATE TABLE [Alerts] (
	[Id] int IDENTITY(1,1) NOT NULL,
	[AlertType] NVARCHAR(128) NOT NULL,
	[EnableAlert] BIT NOT NULL,
	[SendingFrequency] int DEFAULT 0 NOT NULL,
	[NotificationLastSentDate] DATETIME,
	[SendEmailToAdmin] BIT NOT NULL,
	CONSTRAINT [PK_Alerts] PRIMARY KEY ([Id])
)
GO

/* ---------------------------------------------------------------------- */
/* Add table "LicenseKeys"                                              */
/* ---------------------------------------------------------------------- */

CREATE TABLE [dbo].[LicenseKeys](
	[Id] [int] IDENTITY(1,1) NOT NULL,
	[SerialNumber] [nvarchar](29) NOT NULL,
	[LicenseEdition] [int] NOT NULL,
	[ExpirationDate] [datetime] NULL,
	[LicenseUnit] [int] NOT NULL,
	[LicensedUnits] [int] NULL,
	[UsedUnits] [int] NULL,
 CONSTRAINT [PK_LicenseKeys] PRIMARY KEY ([Id])
 )
GO


/* ---------------------------------------------------------------------- */
/* Add table "AlertItems"                                              */
/* ---------------------------------------------------------------------- */

CREATE TABLE [AlertItems] (
	[Id] int IDENTITY(1,1) NOT NULL,
	[PropertyName] NVARCHAR(128) NOT NULL,
	[ValueLimit] int NOT NULL,
	[AlertId] int NOT NULL,
	CONSTRAINT [PK_AlertItems] PRIMARY KEY ([Id])
)
GO

CREATE  INDEX [IDX_AlertItems] ON [AlertItems] ([PropertyName])
GO

/* ---------------------------------------------------------------------- */
/* Add table "AlertEmailAddresses"                                              */
/* ---------------------------------------------------------------------- */

CREATE TABLE [AlertEmailAddresses] (
	[Id] int IDENTITY(1,1) NOT NULL,
	[EmailAddress] NVARCHAR(256) NOT NULL,
	[AlertId] int NOT NULL,	
	CONSTRAINT [PK_AlertEmailAddresses] PRIMARY KEY ([Id])
)
GO

/* ---------------------------------------------------------------------- */
/* Add table "Announcements"                                              */
/* ---------------------------------------------------------------------- */

CREATE TABLE [Announcements] (
	[Name] NVARCHAR(50) NOT NULL,
	[Culture] NVARCHAR(50) NOT NULL,
	[Message] NTEXT NOT NULL,
	[LastUpdate] DATETIME NOT NULL,
	CONSTRAINT [PK_Announcements] PRIMARY KEY ([Name], [Culture])
)
GO

/* ---------------------------------------------------------------------- */
/* Add table "AppAppearance"                                              */
/* ---------------------------------------------------------------------- */

CREATE TABLE [AppAppearance] (
	[Id] INTEGER IDENTITY(1,1) NOT NULL,
	[AppName] NVARCHAR(50) NOT NULL,
	[Logo] VARBINARY(max),
	[LastUpdate] DATETIME NOT NULL,
	[EnableStaticIPv4Service] BIT NOT NULL,
	[DefaultGridPageSize] INTEGER NOT NULL,
	[EnableFlexCloneProvisioning] BIT NOT NULL,
	[EnableComplexApprovals] BIT NOT NULL,
	[EnableSnapshotManagement] BIT CONSTRAINT [DF_AppAppearance_EnableSnapshotManagement] DEFAULT 1 NOT NULL,
	[EnableVirtualDataCenterSkill] BIT CONSTRAINT [DF_AppAppearance_EnableVirtualDataCenterSkill] DEFAULT 0 NOT NULL,
	CONSTRAINT [PK_AppAppearance] PRIMARY KEY ([Id])
)
GO

/* ---------------------------------------------------------------------- */
/* Add table "Categories"                                                 */
/* ---------------------------------------------------------------------- */

CREATE TABLE [Categories] (
	[CategoryID] INTEGER IDENTITY(1,1) NOT NULL,
	[CategoryName] NVARCHAR(64) NOT NULL,
	CONSTRAINT [PK_Categories] PRIMARY KEY ([CategoryID])
)
GO

/* ---------------------------------------------------------------------- */
/* Add table "CategoryLog"                                                */
/* ---------------------------------------------------------------------- */

CREATE TABLE [CategoryLog] (
	[CategoryLogID] INTEGER IDENTITY(1,1) NOT NULL,
	[LogID] INTEGER NOT NULL,
	[CategoryID] INTEGER,
	CONSTRAINT [PK_CategoryLog] PRIMARY KEY ([CategoryLogID])
)
GO

CREATE  INDEX [IDX_CategoryLog_1] ON [CategoryLog] ([LogID])
GO

CREATE  INDEX [IDX_CategoryLog_2] ON [CategoryLog] ([CategoryID])
GO

/* ---------------------------------------------------------------------- */
/* Add table "CompletedScope"                                             */
/* ---------------------------------------------------------------------- */

CREATE TABLE [CompletedScope] (
	[uidInstanceID] UNIQUEIDENTIFIER NOT NULL,
	[completedScopeID] UNIQUEIDENTIFIER NOT NULL,
	[state] IMAGE NOT NULL,
	[modified] DATETIME NOT NULL,
	CONSTRAINT [PK_CompletedScope] PRIMARY KEY ([uidInstanceID], [completedScopeID])
)
GO

CREATE NONCLUSTERED INDEX [IX_CompletedScope] ON [CompletedScope] ([completedScopeID] ASC)
GO

CREATE NONCLUSTERED INDEX [IX_CompletedScope_InstanceID] ON [CompletedScope] ([uidInstanceID] ASC)
GO

--
-- TABLE CompletedScope
--
IF EXISTS (SELECT * FROM [dbo].[sysobjects] WHERE id = object_id(N'[dbo].[CompletedScope]') AND OBJECTPROPERTY(id, N'IsUserTable') = 1)
DROP TABLE [dbo].[CompletedScope]
GO
CREATE TABLE [dbo].[CompletedScope] (
	[uidInstanceID] [uniqueidentifier] NOT NULL,
	[completedScopeID] [uniqueidentifier] NOT NULL,
	[state] [image] NOT NULL,
	[modified] [datetime] NOT NULL
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]
GO
CREATE  NONCLUSTERED  INDEX [IX_CompletedScope] ON [dbo].[CompletedScope]([completedScopeID]) ON [PRIMARY]
GO
CREATE  NONCLUSTERED  INDEX [IX_CompletedScope_InstanceID] ON [dbo].[CompletedScope]( [uidInstanceID] )
GO

/* ---------------------------------------------------------------------- */
/* Add table "ConfigData"                                                 */
/* ---------------------------------------------------------------------- */

CREATE TABLE [ConfigData] (
	[ConfigName] NVARCHAR(50) NOT NULL,
	[Description] NVARCHAR(500),
	[ConfigValue] NVARCHAR(2000) NOT NULL,
	[flags] INTEGER CONSTRAINT [DF_ConfigData_flags] DEFAULT 0 NOT NULL,
	CONSTRAINT [PK_ConfigData] PRIMARY KEY ([ConfigName])
)
GO

/* ---------------------------------------------------------------------- */
/* Add table "CostProfile"                                                */
/* ---------------------------------------------------------------------- */

CREATE TABLE [CostProfile] (
	[CostProfileID] UNIQUEIDENTIFIER NOT NULL,
	[CostProfileName] NVARCHAR(50) NOT NULL,
	[CostProfileDescription] NVARCHAR(1024),
	[MemoryCost] DECIMAL(10,4) NOT NULL,
	[DiskCost] DECIMAL(10,4) NOT NULL,
    [CpuCost] DECIMAL(10,4) NOT NULL,
	[Flags] BIGINT,
	[Text1] NVARCHAR(256),
	[Text2] NVARCHAR(max),
	CONSTRAINT [PK_CostProfile] PRIMARY KEY ([CostProfileID])
)
GO

CREATE UNIQUE NONCLUSTERED INDEX [IX_CostProfileName] ON [CostProfile] ([CostProfileName] ASC)
GO

EXECUTE sp_addextendedproperty N'MS_Description', N'Table to track Cost Data to be used in calculating ChargeBack amounts in the reports. The Cost has two components   1. For running a VM within host. This is done by applying MemoryCost  2. For using storage. This is done by applying DiskCost', 'SCHEMA', N'dbo', 'TABLE', N'CostProfile', NULL, NULL
GO

EXECUTE sp_addextendedproperty N'MS_Description', N'Primary Key', 'SCHEMA', N'dbo', 'TABLE', N'CostProfile', 'COLUMN', N'CostProfileID'
GO

EXECUTE sp_addextendedproperty N'MS_Description', N'Name for the cost profile', 'SCHEMA', N'dbo', 'TABLE', N'CostProfile', 'COLUMN', N'CostProfileName'
GO

EXECUTE sp_addextendedproperty N'MS_Description', N'Description for the cost profile', 'SCHEMA', N'dbo', 'TABLE', N'CostProfile', 'COLUMN', N'CostProfileDescription'
GO

EXECUTE sp_addextendedproperty N'MS_Description', N'Cost of the memory per GB of memory. This is a subsititue for fixed costs that can be associated with a VM', 'SCHEMA', N'dbo', 'TABLE', N'CostProfile', 'COLUMN', N'MemoryCost'
GO

EXECUTE sp_addextendedproperty N'MS_Description', N'Cost of disk per GB of storage. It is assumed that a host has same kind of storage attached', 'SCHEMA', N'dbo', 'TABLE', N'CostProfile', 'COLUMN', N'DiskCost'
GO

EXECUTE sp_addextendedproperty N'MS_Description', N'Integer attribute which can be used for applying flags to the entity', 'SCHEMA', N'dbo', 'TABLE', N'CostProfile', 'COLUMN', N'Flags'
GO

EXECUTE sp_addextendedproperty N'MS_Description', N'Generic text column with 256 bytes length', 'SCHEMA', N'dbo', 'TABLE', N'CostProfile', 'COLUMN', N'Text1'
GO

EXECUTE sp_addextendedproperty N'MS_Description', N'Generic text column with max length', 'SCHEMA', N'dbo', 'TABLE', N'CostProfile', 'COLUMN', N'Text2'
GO

/* ---------------------------------------------------------------------- */
/* Add table "EnterpriseAdminGroups"                                      */
/* ---------------------------------------------------------------------- */

CREATE TABLE [EnterpriseAdminGroups] (
	[EnterpriseAdminID] UNIQUEIDENTIFIER NOT NULL,
	[AdminName] NVARCHAR(50) NOT NULL,
	[AdminDescription] NVARCHAR(256),
	[Flags] BIGINT,
	[Text1] NVARCHAR(256),
	[Text2] NVARCHAR(max),
	CONSTRAINT [PK_EnterpriseAdminGroups] PRIMARY KEY ([EnterpriseAdminID])
)
GO

CREATE NONCLUSTERED INDEX [IDX_EnterpriseAdminGroups_1] ON [EnterpriseAdminGroups] ([AdminName] ASC)
GO

EXECUTE sp_addextendedproperty N'MS_Description', N'Enterprise admin groups are groups that can manage hosts. ', 'SCHEMA', N'dbo', 'TABLE', N'EnterpriseAdminGroups', NULL, NULL
GO

EXECUTE sp_addextendedproperty N'MS_Description', N'Primary key', 'SCHEMA', N'dbo', 'TABLE', N'EnterpriseAdminGroups', 'COLUMN', N'EnterpriseAdminID'
GO

EXECUTE sp_addextendedproperty N'MS_Description', N'name of the admin group', 'SCHEMA', N'dbo', 'TABLE', N'EnterpriseAdminGroups', 'COLUMN', N'AdminName'
GO

EXECUTE sp_addextendedproperty N'MS_Description', N'Description of the admin group', 'SCHEMA', N'dbo', 'TABLE', N'EnterpriseAdminGroups', 'COLUMN', N'AdminDescription'
GO

EXECUTE sp_addextendedproperty N'MS_Description', N'Integer attribute which can be used for applying flags to the entity', 'SCHEMA', N'dbo', 'TABLE', N'EnterpriseAdminGroups', 'COLUMN', N'Flags'
GO

EXECUTE sp_addextendedproperty N'MS_Description', N'Generic text column with 256 bytes length', 'SCHEMA', N'dbo', 'TABLE', N'EnterpriseAdminGroups', 'COLUMN', N'Text1'
GO

EXECUTE sp_addextendedproperty N'MS_Description', N'Generic text column with max length', 'SCHEMA', N'dbo', 'TABLE', N'EnterpriseAdminGroups', 'COLUMN', N'Text2'
GO

/* ---------------------------------------------------------------------- */
/* Add table "GlobalProfiles"                                             */
/* ---------------------------------------------------------------------- */

CREATE TABLE [GlobalProfiles] (
	[GlobalProfileID] UNIQUEIDENTIFIER NOT NULL,
	[ProfileName] NVARCHAR(256) NOT NULL,
	[Description] NVARCHAR(max),
	CONSTRAINT [PK_GlobalProfiles] PRIMARY KEY ([GlobalProfileID])
)
GO

EXECUTE sp_addextendedproperty N'MS_Description', N'Provides a way to track bunch of common properties that can be used by a set of Blueprints', 'SCHEMA', N'dbo', 'TABLE', N'GlobalProfiles', NULL, NULL
GO

EXECUTE sp_addextendedproperty N'MS_Description', N'Primary key', 'SCHEMA', N'dbo', 'TABLE', N'GlobalProfiles', 'COLUMN', N'GlobalProfileID'
GO

EXECUTE sp_addextendedproperty N'MS_Description', N'Name of the profile', 'SCHEMA', N'dbo', 'TABLE', N'GlobalProfiles', 'COLUMN', N'ProfileName'
GO

EXECUTE sp_addextendedproperty N'MS_Description', N'Description for the Global profile', 'SCHEMA', N'dbo', 'TABLE', N'GlobalProfiles', 'COLUMN', N'Description'
GO

/* ---------------------------------------------------------------------- */
/* Add table "ProvisioningGroup"                                          */
/* ---------------------------------------------------------------------- */

CREATE TABLE [ProvisioningGroup] (
	[GroupID] UNIQUEIDENTIFIER NOT NULL,
	[GroupName] NVARCHAR(256) NOT NULL,
	[GroupDescription] NVARCHAR(max),
	[HostnamePrefixID] UNIQUEIDENTIFIER,
	[AdContainer] NVARCHAR(2000),
	[AdministratorEmail] NVARCHAR(256),
	[IsTestGroup] BIT,
	[Flags] BIGINT,
	[Text1] NVARCHAR(256),
	[Text2] NVARCHAR(max),
	[GroupType] TINYINT,
	CONSTRAINT [PK_Group] PRIMARY KEY ([GroupID])
)
GO

CREATE UNIQUE NONCLUSTERED INDEX [IX_Group] ON [ProvisioningGroup] ([GroupName] ASC)
GO

EXECUTE sp_addextendedproperty N'MS_Description', N'Group of users that can do provision virtual machines. Group has access to certain resources through HostReservation to create VMs. It also has access to Virtual Machine Templates (Blueprints) from which it can create those machines  Renamed from Group(in 3.0.x schema)', 'SCHEMA', N'dbo', 'TABLE', N'ProvisioningGroup', NULL, NULL
GO

EXECUTE sp_addextendedproperty N'MS_Description', N'Primary key ', 'SCHEMA', N'dbo', 'TABLE', N'ProvisioningGroup', 'COLUMN', N'GroupID'
GO

EXECUTE sp_addextendedproperty N'MS_Description', N'Name for the provisioning group', 'SCHEMA', N'dbo', 'TABLE', N'ProvisioningGroup', 'COLUMN', N'GroupName'
GO

EXECUTE sp_addextendedproperty N'MS_Description', N'Description of the group', 'SCHEMA', N'dbo', 'TABLE', N'ProvisioningGroup', 'COLUMN', N'GroupDescription'
GO

EXECUTE sp_addextendedproperty N'MS_Description', N'Reference to HostnamePrefix which is used to control how VMs are named', 'SCHEMA', N'dbo', 'TABLE', N'ProvisioningGroup', 'COLUMN', N'HostnamePrefixID'
GO

EXECUTE sp_addextendedproperty N'MS_Description', N'Active directory container for the group. How it is used???', 'SCHEMA', N'dbo', 'TABLE', N'ProvisioningGroup', 'COLUMN', N'AdContainer'
GO

EXECUTE sp_addextendedproperty N'MS_Description', N'Email address of the group administrator. ', 'SCHEMA', N'dbo', 'TABLE', N'ProvisioningGroup', 'COLUMN', N'AdministratorEmail'
GO

EXECUTE sp_addextendedproperty N'MS_Description', N'Whether it is a test group.', 'SCHEMA', N'dbo', 'TABLE', N'ProvisioningGroup', 'COLUMN', N'IsTestGroup'
GO

EXECUTE sp_addextendedproperty N'MS_Description', N'Integer attribute which can be used for applying flags to the entity', 'SCHEMA', N'dbo', 'TABLE', N'ProvisioningGroup', 'COLUMN', N'Flags'
GO

EXECUTE sp_addextendedproperty N'MS_Description', N'Generic text column with 256 bytes length', 'SCHEMA', N'dbo', 'TABLE', N'ProvisioningGroup', 'COLUMN', N'Text1'
GO

EXECUTE sp_addextendedproperty N'MS_Description', N'Generic text column with max length', 'SCHEMA', N'dbo', 'TABLE', N'ProvisioningGroup', 'COLUMN', N'Text2'
GO

/* ---------------------------------------------------------------------- */
/* Add table "GroupSecurity"                                              */
/* ---------------------------------------------------------------------- */

CREATE TABLE [GroupSecurity] (
	[GroupID] UNIQUEIDENTIFIER NOT NULL,
	[GroupName] NVARCHAR(50) NOT NULL,
	[Members] NVARCHAR(max),
	CONSTRAINT [PK_GroupSecurity] PRIMARY KEY ([GroupID])
)
GO

EXECUTE sp_addextendedproperty N'MS_Description', N'Tracks permissions for a provisioning group', 'SCHEMA', N'dbo', 'TABLE', N'GroupSecurity', NULL, NULL
GO

EXECUTE sp_addextendedproperty N'MS_Description', N'Reference to Group', 'SCHEMA', N'dbo', 'TABLE', N'GroupSecurity', 'COLUMN', N'GroupID'
GO

EXECUTE sp_addextendedproperty N'MS_Description', N'Name of the Group', 'SCHEMA', N'dbo', 'TABLE', N'GroupSecurity', 'COLUMN', N'GroupName'
GO

EXECUTE sp_addextendedproperty N'MS_Description', N'Members that a group belong to. TODO Find correct description', 'SCHEMA', N'dbo', 'TABLE', N'GroupSecurity', 'COLUMN', N'Members'
GO

/* ---------------------------------------------------------------------- */
/* Add table "Host"                                                       */
/* ---------------------------------------------------------------------- */

CREATE TABLE [Host] (
	[HostID] UNIQUEIDENTIFIER NOT NULL,
	[ClusterHostID] UNIQUEIDENTIFIER,
	[PhysicalLocationID] UNIQUEIDENTIFIER,
	[CostProfileID] UNIQUEIDENTIFIER,
	[ManagementEndpointID] UNIQUEIDENTIFIER,
	[HostName] NVARCHAR(256) NOT NULL,
	[HostComments] NVARCHAR(2048),
	[HostOSType] NVARCHAR(256),
	[HostManufacturer] NVARCHAR(256),
	[HostModel] NVARCHAR(256),
	[HostUniqueID] NVARCHAR(256),
	[IsCluster] BIT,
	[HostProcessors] INTEGER,
	[HostProcessorSpeed] INTEGER,
	[HostProcessorType] NVARCHAR(256),
	[RecCreationTime] DATETIME,
	[RecDeleteTime] DATETIME,
	[RecUpdateTime] DATETIME,
	[Flags] BIGINT,
	[Text1] NVARCHAR(256),
	[Text2] NVARCHAR(max),
	[HostStateID] TINYINT,
	[HostTotalMemoryMB] BIGINT,
	[HostTotalStorageGB] BIGINT,
	[HostUsedMemoryMB] BIGINT,
	[HostUsedStorageGB] BIGINT,
	[ProvisioningAgentID] UNIQUEIDENTIFIER,
	[IsVRMManaged] BIT CONSTRAINT [DEF_Host_IsVRMManaged] DEFAULT 1,
	[HostDNSName] NVARCHAR(256),
	[MachineType] [tinyint] NOT NULL,
	[HostUuid] NVARCHAR(256),
	[AllocationType] [tinyint] NULL,
	[IsTpmEnabled] BIT,
	CONSTRAINT [PK_Host] PRIMARY KEY ([HostID])
)
GO

EXECUTE sp_addextendedproperty N'MS_Description', N'HostOrCluster tables is for storing hosts or clusters within virtual environments.  It has a parent to child relationship to itself via ClusterHostID. It will enable to track what hosts are making up the cluster.', 'SCHEMA', N'dbo', 'TABLE', N'Host', NULL, NULL
GO

EXECUTE sp_addextendedproperty N'MS_Description', N'Primary Key', 'SCHEMA', N'dbo', 'TABLE', N'Host', 'COLUMN', N'HostID'
GO

EXECUTE sp_addextendedproperty N'MS_Description', N'Parent Cluster ID. Set to HostID of cluster record', 'SCHEMA', N'dbo', 'TABLE', N'Host', 'COLUMN', N'ClusterHostID'
GO

EXECUTE sp_addextendedproperty N'MS_Description', N'Relationship to the physical location where host is located', 'SCHEMA', N'dbo', 'TABLE', N'Host', 'COLUMN', N'PhysicalLocationID'
GO

EXECUTE sp_addextendedproperty N'MS_Description', N'Reference to cost profile to be used for calculating chargeback', 'SCHEMA', N'dbo', 'TABLE', N'Host', 'COLUMN', N'CostProfileID'
GO

EXECUTE sp_addextendedproperty N'MS_Description', N'Reference to the management endpoint', 'SCHEMA', N'dbo', 'TABLE', N'Host', 'COLUMN', N'ManagementEndpointID'
GO

EXECUTE sp_addextendedproperty N'MS_Description', N'Name of the host', 'SCHEMA', N'dbo', 'TABLE', N'Host', 'COLUMN', N'HostName'
GO

EXECUTE sp_addextendedproperty N'MS_Description', N'Description/Notes about the host', 'SCHEMA', N'dbo', 'TABLE', N'Host', 'COLUMN', N'HostComments'
GO

EXECUTE sp_addextendedproperty N'MS_Description', N'Type of operating system running on host. This is just text description of OS', 'SCHEMA', N'dbo', 'TABLE', N'Host', 'COLUMN', N'HostOSType'
GO

EXECUTE sp_addextendedproperty N'MS_Description', N'Manufacturer of the host. Null if record is cluster', 'SCHEMA', N'dbo', 'TABLE', N'Host', 'COLUMN', N'HostManufacturer'
GO

EXECUTE sp_addextendedproperty N'MS_Description', N'Model of the manufacturer.', 'SCHEMA', N'dbo', 'TABLE', N'Host', 'COLUMN', N'HostModel'
GO

EXECUTE sp_addextendedproperty N'MS_Description', N'Unique identified of the host. This is unique id that can be found by many agents to consolidate information about a host. This will be provided by hypervisor ', 'SCHEMA', N'dbo', 'TABLE', N'Host', 'COLUMN', N'HostUniqueID'
GO

EXECUTE sp_addextendedproperty N'MS_Description', N'Indicates whether record is a cluster or a host', 'SCHEMA', N'dbo', 'TABLE', N'Host', 'COLUMN', N'IsCluster'
GO

EXECUTE sp_addextendedproperty N'MS_Description', N'Number of processors in the hosts. This is phyical CPUs and not cores. In case of cluster this is addition of all CPUs in the host making up cluster', 'SCHEMA', N'dbo', 'TABLE', N'Host', 'COLUMN', N'HostProcessors'
GO

EXECUTE sp_addextendedproperty N'MS_Description', N'Speed of the processor in GHz. Assumed that all CPUs have same speed', 'SCHEMA', N'dbo', 'TABLE', N'Host', 'COLUMN', N'HostProcessorSpeed'
GO

EXECUTE sp_addextendedproperty N'MS_Description', N'Type of CPU. Assumed that we have same type of CPU in the host', 'SCHEMA', N'dbo', 'TABLE', N'Host', 'COLUMN', N'HostProcessorType'
GO

EXECUTE sp_addextendedproperty N'MS_Description', N'Total memory in the host. In case of cluster it is addition of all the memory in hosts that are making up the cluster', 'SCHEMA', N'dbo', 'TABLE', N'Host', 'COLUMN', N'HostTotalMemoryMB'
GO

EXECUTE sp_addextendedproperty N'MS_Description', N'Total storage in a host. In case cluster this will be complicated and need to eliminate double counting', 'SCHEMA', N'dbo', 'TABLE', N'Host', 'COLUMN', N'HostTotalStorageGB'
GO

EXECUTE sp_addextendedproperty N'MS_Description', N'Host uuid', 'SCHEMA', N'dbo', 'TABLE', N'Host', 'COLUMN', N'HostUuid'
GO

EXECUTE sp_addextendedproperty N'MS_Description', N'Host AllocationType', 'SCHEMA', N'dbo', 'TABLE', N'Host', 'COLUMN', N'AllocationType'
GO

EXECUTE sp_addextendedproperty N'MS_Description', N'Indicates if the host (or every host in the cluster) has a TPM device installed', 'SCHEMA', N'dbo', 'TABLE', N'Host', 'COLUMN', N'IsTpmEnabled'
GO

/* ---------------------------------------------------------------------- */
/* Add table "HostCommand"                                                */
/* ---------------------------------------------------------------------- */

CREATE TABLE [HostCommand] (
	[HostCommandID] UNIQUEIDENTIFIER NOT NULL,
	[WorkflowType] NVARCHAR(2048) NOT NULL,
	[VirtualMachineID] UNIQUEIDENTIFIER NOT NULL,
	[HostCommandPriority] SMALLINT NOT NULL,
	[TimeStamp] SMALLDATETIME CONSTRAINT [DF_HostCommand_TimeStamp] DEFAULT getdate() NOT NULL,
	CONSTRAINT [PK_HostCommand] PRIMARY KEY ([HostCommandID])
)
GO

/* ---------------------------------------------------------------------- */
/* Add table "HostNamePrefix"                                             */
/* ---------------------------------------------------------------------- */

CREATE TABLE [HostNamePrefix] (
	[HostnamePrefixID] UNIQUEIDENTIFIER CONSTRAINT [DF_HostnamePrefix_HostnamePrefixID] DEFAULT newid() NOT NULL,
	[MachinePrefix] NVARCHAR(50) NOT NULL,
	[NextMachineNo] INTEGER NOT NULL,
	[MachineNumberLength] INTEGER NOT NULL,
	CONSTRAINT [PK_HostNamePrefix] PRIMARY KEY ([HostnamePrefixID])
)
GO

CREATE UNIQUE NONCLUSTERED INDEX [IX_MachinePrefix] ON [HostNamePrefix] ([MachinePrefix] ASC)
GO

EXECUTE sp_addextendedproperty N'MS_Description', N'Tracks information on how newly created virtual machines are named.', 'SCHEMA', N'dbo', 'TABLE', N'HostNamePrefix', NULL, NULL
GO

EXECUTE sp_addextendedproperty N'MS_Description', N'Primary key', 'SCHEMA', N'dbo', 'TABLE', N'HostNamePrefix', 'COLUMN', N'HostnamePrefixID'
GO

EXECUTE sp_addextendedproperty N'MS_Description', N'Prefix to use for while naming ', 'SCHEMA', N'dbo', 'TABLE', N'HostNamePrefix', 'COLUMN', N'MachinePrefix'
GO

EXECUTE sp_addextendedproperty N'MS_Description', N'Next machine number. Needs to be updated when a machine name if generated', 'SCHEMA', N'dbo', 'TABLE', N'HostNamePrefix', 'COLUMN', N'NextMachineNo'
GO

EXECUTE sp_addextendedproperty N'MS_Description', N'Length of number part of machine name. It is used for padding 0s to number in NextMachineNo', 'SCHEMA', N'dbo', 'TABLE', N'HostNamePrefix', 'COLUMN', N'MachineNumberLength'
GO

/* ---------------------------------------------------------------------- */
/* Add table "HostNic"                                                    */
/* ---------------------------------------------------------------------- */

CREATE TABLE [HostNic] (
	[HostNicID] UNIQUEIDENTIFIER NOT NULL,
	[HostNicUniqueID] NVARCHAR(80),
	[HostNicName] NVARCHAR(256) NOT NULL,
	[HostID] UNIQUEIDENTIFIER NOT NULL,
	[NetworkName] NVARCHAR(128),
	[MacID] NVARCHAR(64),
	CONSTRAINT [PK_HostState_1] PRIMARY KEY ([HostNicID])
)
GO

CREATE NONCLUSTERED INDEX [IDX_HostNic_1] ON [HostNic] ([HostID])
GO

EXECUTE sp_addextendedproperty N'MS_Description', N'Table to track NIC cards in a host. Assumed that a NIC is exporting one VM network (with NetworkName)', 'SCHEMA', N'dbo', 'TABLE', N'HostNic', NULL, NULL
GO

EXECUTE sp_addextendedproperty N'MS_Description', N'primary key', 'SCHEMA', N'dbo', 'TABLE', N'HostNic', 'COLUMN', N'HostNicID'
GO

EXECUTE sp_addextendedproperty N'MS_Description', N'Unique for the NIC provided by hypervisor', 'SCHEMA', N'dbo', 'TABLE', N'HostNic', 'COLUMN', N'HostNicUniqueID'
GO

EXECUTE sp_addextendedproperty N'MS_Description', N'Friendly name of the NIC', 'SCHEMA', N'dbo', 'TABLE', N'HostNic', 'COLUMN', N'HostNicName'
GO

EXECUTE sp_addextendedproperty N'MS_Description', N'Identifier of the Host', 'SCHEMA', N'dbo', 'TABLE', N'HostNic', 'COLUMN', N'HostID'
GO

EXECUTE sp_addextendedproperty N'MS_Description', N'Name of the VM network that NIC is providing', 'SCHEMA', N'dbo', 'TABLE', N'HostNic', 'COLUMN', N'NetworkName'
GO

EXECUTE sp_addextendedproperty N'MS_Description', N'MACID of the NIC', 'SCHEMA', N'dbo', 'TABLE', N'HostNic', 'COLUMN', N'MacID'
GO

/* ---------------------------------------------------------------------- */
/* Add table "HostReservation"                                            */
/* ---------------------------------------------------------------------- */

CREATE TABLE [HostReservation] (
	[HostReservationID] UNIQUEIDENTIFIER NOT NULL,
	[HostReservationName] NVARCHAR(256),
	[Enabled] BIT,
	[GroupID] UNIQUEIDENTIFIER NOT NULL,
	[ReservationMemorySizeMB] BIGINT DEFAULT 0,
	[ReservationStorageSizeGB] BIGINT DEFAULT 0,
	[MaxVMsPowerOn] INTEGER,
	[MaxVMsCreate] INTEGER,
	[ResourcePoolID] UNIQUEIDENTIFIER,
	[Flags] BIGINT,
	[Text1] NVARCHAR(256),
	[Text2] NVARCHAR(max),
	[HostID] UNIQUEIDENTIFIER NOT NULL,
	[ReservationPriority] INTEGER,
	[StorageAllocationPolicyID] TINYINT,
	[CurrentStorageAllocationIndex] INTEGER CONSTRAINT [DEF_HostReservation_CurrentStorageAllocationIndex] DEFAULT 0,
	[CurrentNetworkAllocationIndex] INTEGER CONSTRAINT [DEF_HostReservation_CurrentNetworkAllocationIndex] DEFAULT 0,
	[id] UNIQUEIDENTIFIER,
	[ReservationPolicyID] UNIQUEIDENTIFIER,
	[IsFileLevelCloningEnabled] BIT,
	[MachineType] [tinyint] NOT NULL,
	[AlertId] int,
	CONSTRAINT [PK_HostAllocation] PRIMARY KEY ([HostReservationID])
)
GO

CREATE NONCLUSTERED INDEX [IX_HostReservation_K3_K4_K9_K19] ON [HostReservation] 
(
	[Enabled] ASC,
	[GroupID] ASC,
	[HostID] ASC,
	[ReservationPolicyID] ASC
)
GO

EXECUTE sp_addextendedproperty N'MS_Description', N'Reservation of resources for a group from a particular host are tracked. There are substantial changes to storing reservations  from 3.0.x   1. Reservation have two quotas, one for maximum VMs can be created and other for maximum number of VMs can be powered on.   2. Reservation uses one or more network cards  3. Reservation uses one or more storage paths for creating disks. HostReservationToStorage table further has quotas for maximum VMs that can use a storage path and capacity that can be used  4. Reservation is associated with a Resource Pool', 'SCHEMA', N'dbo', 'TABLE', N'HostReservation', NULL, NULL
GO

EXECUTE sp_addextendedproperty N'MS_Description', N'Primary key', 'SCHEMA', N'dbo', 'TABLE', N'HostReservation', 'COLUMN', N'HostReservationID'
GO

EXECUTE sp_addextendedproperty N'MS_Description', N'Name for the reservation. This does not have to be unique', 'SCHEMA', N'dbo', 'TABLE', N'HostReservation', 'COLUMN', N'HostReservationName'
GO

EXECUTE sp_addextendedproperty N'MS_Description', N'Whether reservation should be used or not', 'SCHEMA', N'dbo', 'TABLE', N'HostReservation', 'COLUMN', N'Enabled'
GO

EXECUTE sp_addextendedproperty N'MS_Description', N'Reference to Group which this reservation belongs', 'SCHEMA', N'dbo', 'TABLE', N'HostReservation', 'COLUMN', N'GroupID'
GO

EXECUTE sp_addextendedproperty N'MS_Description', N'Maximum amount of memory that can be allocated for VMs that are created using this reservation', 'SCHEMA', N'dbo', 'TABLE', N'HostReservation', 'COLUMN', N'ReservationMemorySizeMB'
GO

EXECUTE sp_addextendedproperty N'MS_Description', N'Maxmimum number of machines that can be powered on which are created using this reservation', 'SCHEMA', N'dbo', 'TABLE', N'HostReservation', 'COLUMN', N'MaxVMsPowerOn'
GO

EXECUTE sp_addextendedproperty N'MS_Description', N'Maximum number of VMs that can be created from this reservation', 'SCHEMA', N'dbo', 'TABLE', N'HostReservation', 'COLUMN', N'MaxVMsCreate'
GO

EXECUTE sp_addextendedproperty N'MS_Description', N'Reference to Resource pool to which new virtual machines are associated ', 'SCHEMA', N'dbo', 'TABLE', N'HostReservation', 'COLUMN', N'ResourcePoolID'
GO

EXECUTE sp_addextendedproperty N'MS_Description', N'Integer attribute which can be used for applying flags to the entity', 'SCHEMA', N'dbo', 'TABLE', N'HostReservation', 'COLUMN', N'Flags'
GO

EXECUTE sp_addextendedproperty N'MS_Description', N'Generic text column with 256 bytes length', 'SCHEMA', N'dbo', 'TABLE', N'HostReservation', 'COLUMN', N'Text1'
GO

EXECUTE sp_addextendedproperty N'MS_Description', N'Generic text column with max length', 'SCHEMA', N'dbo', 'TABLE', N'HostReservation', 'COLUMN', N'Text2'
GO

/* ---------------------------------------------------------------------- */
/* Add table "HostState"                                                  */
/* ---------------------------------------------------------------------- */

CREATE TABLE [HostState] (
	[HostStateID] TINYINT NOT NULL,
	[HostStateName] NVARCHAR(255),
	[HostStateDesc] NVARCHAR(max) NOT NULL,
	CONSTRAINT [PK_HostState] PRIMARY KEY ([HostStateID])
)
GO

EXECUTE sp_addextendedproperty N'MS_Description', N'This table provide enumeration of host states. Possible values are   0 -- Online 1 -- Offline  Also more states can be added as requirements come in for suspending VM creation from particular host etc', 'SCHEMA', N'dbo', 'TABLE', N'HostState', NULL, NULL
GO

/* ---------------------------------------------------------------------- */
/* Add table "HostStorageReservationPolicy"                                          */
/* ---------------------------------------------------------------------- */
CREATE TABLE [HostStorageReservationPolicy] (
	[HostStorageReservationPolicyID] UNIQUEIDENTIFIER NOT NULL,
	[Name] NVARCHAR(256) NOT NULL,
	[Description] NVARCHAR(MAX),	
	CONSTRAINT [PK_HostStorageReservationPolicy] PRIMARY KEY ([HostStorageReservationPolicyID])
)
GO

EXECUTE sp_addextendedproperty N'MS_Description', N'This table is used to bind disk provision to storage that is tagged', 'SCHEMA', N'dbo', 'TABLE', N'HostStorageReservationPolicy', NULL, NULL
GO


/* ---------------------------------------------------------------------- */
/* Add table "InstanceState"                                              */
/* ---------------------------------------------------------------------- */

CREATE TABLE [InstanceState] (
	[uidInstanceID] UNIQUEIDENTIFIER NOT NULL,
	[state] IMAGE,
	[status] INTEGER,
	[unlocked] INTEGER,
	[blocked] INTEGER,
	[info] NTEXT,
	[modified] DATETIME NOT NULL,
	[ownerID] UNIQUEIDENTIFIER,
	CONSTRAINT [PK_InstanceState] PRIMARY KEY ([uidInstanceID])
)
GO

/* ---------------------------------------------------------------------- */
/* Add table "StatsTotals"                                                */
/* ---------------------------------------------------------------------- */

CREATE TABLE [StatsTotals] (
	[StatsKey] NCHAR(10) NOT NULL,
	[StatsDescription] NVARCHAR(50) NOT NULL,
	[StatsValue] BIGINT CONSTRAINT [DF_StatsTotals_StatsValue] DEFAULT 0 NOT NULL,
	[Flags] INTEGER CONSTRAINT [DF_Table_1_flags] DEFAULT 0 NOT NULL,
	[DBHostName] NVARCHAR(50) NOT NULL,
	[LastUpdate] DATETIME NOT NULL,
	CONSTRAINT [PK_StatsTotals] PRIMARY KEY ([StatsKey])
)
GO

/* ---------------------------------------------------------------------- */
/* Add table "Test"                                                       */
/* ---------------------------------------------------------------------- */

CREATE TABLE [Test] (
	[Result] NTEXT
)
GO

/* ---------------------------------------------------------------------- */
/* Add table "UserLog"                                                    */
/* ---------------------------------------------------------------------- */

CREATE TABLE [UserLog] (
	[UserLogId] INTEGER IDENTITY(1,1) NOT NULL,
	[UserName] NVARCHAR(256) NOT NULL,
	[Timestamp] DATETIME NOT NULL,
	[Type] TINYINT NOT NULL,
	[Message] NVARCHAR(2000) NOT NULL,
	[GroupID] UNIQUEIDENTIFIER,
	CONSTRAINT [PK_UserLog] PRIMARY KEY ([UserLogId])
)
GO

/* ---------------------------------------------------------------------- */
/* Add table "VirtualMachine"                                             */
/* ---------------------------------------------------------------------- */

CREATE TABLE [VirtualMachine] (
	[VirtualMachineID] UNIQUEIDENTIFIER NOT NULL,
	[IsManaged] BIT DEFAULT 0 NOT NULL,
	[HostID] UNIQUEIDENTIFIER,
	[VirtualMachineTemplateID] UNIQUEIDENTIFIER,
	[HostReservationID] UNIQUEIDENTIFIER,
	[ResourcePoolID] UNIQUEIDENTIFIER,
	[VirtualMachineName] NVARCHAR(256) NOT NULL,
	[Expires] DATETIME,
	[ExpireDays] INTEGER DEFAULT 0 NOT NULL,
	[BlueprintType] TINYINT DEFAULT 0 NOT NULL,
	[InitiatorType] NVARCHAR(256),
	[Notes] NVARCHAR(max),
	[GuestOS] NVARCHAR(256),
	[VMUniqueID] NVARCHAR(256),
	[PlatformDetails] NVARCHAR(50),
	[VMCreationDate] DATETIME,
	[VMDeleteDate] DATETIME,
	[LastLoggedDate] DATETIME,
	[LastLoggedUser] NVARCHAR(256),
	[LastPowerOffDate] DATETIME,
	[LastPowerOnDate] DATETIME,
	[OwnerExists] BIT DEFAULT 0 NOT NULL,
	[UsageIndex] INTEGER,
	[UsageIndexIgnoreBy] NVARCHAR(256),
	[IsDeleted] BIT DEFAULT 0 NOT NULL,
	[IsMissing] BIT DEFAULT 0 NOT NULL,
	[IsRogue] BIT DEFAULT 0 NOT NULL,
	[IsRunning] BIT DEFAULT 0 NOT NULL,
	[RecCreationTime] DATETIME,
	[RecDeleteTime] DATETIME,
	[RecUpdateTime] DATETIME,
	[Flags] BIGINT,
	[Text1] NVARCHAR(256),
	[Text2] NVARCHAR(max),
	[VMCPUs] INTEGER,
	[VMTotalMemoryMB] BIGINT,
	[VMTotalStorageGB] BIGINT,
	[Owner] INT,
	[Approver] INT,
	[GuestOSFamily] NVARCHAR(128),
	[VirtualMachineState] NVARCHAR(128),
	[CurrentTask] NVARCHAR(128),
	[HostStorageReservationID] UNIQUEIDENTIFIER,
	[StoragePath] NVARCHAR(256),
	[IsTemplate] BIT DEFAULT 0 NOT NULL,
	[ConnectToVdi] BIT DEFAULT 0 NOT NULL,
	[VMDNSName] NVARCHAR(256),
	[VMUsedStorageGB] DECIMAL(10,2),
	[FileLevelCloneImageName] NVARCHAR(128),
	[VMInitialUsedSpace] DECIMAL(10,2),
	[VMEstimatedUsedSpace] DECIMAL(10,2),
	[PhysicalMachineID] UNIQUEIDENTIFIER, -- FK to PhysicalMachine.PhysicalMachineID
	[MachineType] [tinyint] NOT NULL,
	[IsComponent] BIT DEFAULT 0 NOT NULL,
	[ParentMachineID] UNIQUEIDENTIFIER NULL,
	CONSTRAINT [PK_VirtualMachine] PRIMARY KEY ([VirtualMachineID])
)
GO

CREATE  INDEX [IDX_VirtualMachine_1] ON [VirtualMachine] ([VirtualMachineID],[VMDeleteDate])
GO

CREATE NONCLUSTERED INDEX [IDX_VirtualMachine_2] ON [VirtualMachine] ([VirtualMachineName] ASC)
GO

CREATE NONCLUSTERED INDEX [IDX_VirtualMachine_3] ON [VirtualMachine] ([HostID])
GO

CREATE NONCLUSTERED INDEX [IDX_VirtualMachine_4] ON [VirtualMachine] ([HostReservationID])
GO

CREATE NONCLUSTERED INDEX [IDX_VirtualMachine_5] ON [VirtualMachine] ([VirtualMachineTemplateID])
GO

CREATE NONCLUSTERED INDEX [IDX_VirtualMachine_6] ON [VirtualMachine] ([HostReservationID] ASC,[IsRunning] ASC) INCLUDE ( [VMTotalMemoryMB], [VMTotalStorageGB], [VMUsedStorageGB]) WITH (SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, DROP_EXISTING = OFF, ONLINE = OFF) ON [PRIMARY]
GO

EXECUTE sp_addextendedproperty N'MS_Description', N'Virtual Machine table tracks Virtual machines managed/identified by VRM. The records in this table are never deleted (as in 3.0.x)', 'SCHEMA', N'dbo', 'TABLE', N'VirtualMachine', NULL, NULL
GO

EXECUTE sp_addextendedproperty N'MS_Description', N'Primary Key', 'SCHEMA', N'dbo', 'TABLE', N'VirtualMachine', 'COLUMN', N'VirtualMachineID'
GO

EXECUTE sp_addextendedproperty N'MS_Description', N'Reference to Host', 'SCHEMA', N'dbo', 'TABLE', N'VirtualMachine', 'COLUMN', N'HostID'
GO

EXECUTE sp_addextendedproperty N'MS_Description', N'reference to Blueprint from which this VM was created', 'SCHEMA', N'dbo', 'TABLE', N'VirtualMachine', 'COLUMN', N'VirtualMachineTemplateID'
GO

EXECUTE sp_addextendedproperty N'MS_Description', N'Reference to reservation which was used to create this VM', 'SCHEMA', N'dbo', 'TABLE', N'VirtualMachine', 'COLUMN', N'HostReservationID'
GO

EXECUTE sp_addextendedproperty N'MS_Description', N'Reference to the ResourcePool to which this VM belong', 'SCHEMA', N'dbo', 'TABLE', N'VirtualMachine', 'COLUMN', N'ResourcePoolID'
GO

EXECUTE sp_addextendedproperty N'MS_Description', N'Name of the Virtual Machine', 'SCHEMA', N'dbo', 'TABLE', N'VirtualMachine', 'COLUMN', N'VirtualMachineName'
GO

EXECUTE sp_addextendedproperty N'MS_Description', N'Date when this VM Expires', 'SCHEMA', N'dbo', 'TABLE', N'VirtualMachine', 'COLUMN', N'Expires'
GO

EXECUTE sp_addextendedproperty N'MS_Description', N'Whether the VM is a server', 'SCHEMA', N'dbo', 'TABLE', N'VirtualMachine', 'COLUMN', N'BlueprintType'
GO

EXECUTE sp_addextendedproperty N'MS_Description', N'Not sure how this is used', 'SCHEMA', N'dbo', 'TABLE', N'VirtualMachine', 'COLUMN', N'InitiatorType'
GO

EXECUTE sp_addextendedproperty N'MS_Description', N'Note about the virtual machines', 'SCHEMA', N'dbo', 'TABLE', N'VirtualMachine', 'COLUMN', N'Notes'
GO

EXECUTE sp_addextendedproperty N'MS_Description', N'Operating system running in the quest', 'SCHEMA', N'dbo', 'TABLE', N'VirtualMachine', 'COLUMN', N'GuestOS'
GO

EXECUTE sp_addextendedproperty N'MS_Description', N'Unique identifer provided by Hypervisor for the VM', 'SCHEMA', N'dbo', 'TABLE', N'VirtualMachine', 'COLUMN', N'VMUniqueID'
GO

EXECUTE sp_addextendedproperty N'MS_Description', N'Not sure how this is usee', 'SCHEMA', N'dbo', 'TABLE', N'VirtualMachine', 'COLUMN', N'PlatformDetails'
GO

EXECUTE sp_addextendedproperty N'MS_Description', N'Date when this VM was created', 'SCHEMA', N'dbo', 'TABLE', N'VirtualMachine', 'COLUMN', N'VMCreationDate'
GO

EXECUTE sp_addextendedproperty N'MS_Description', N'Date when VM was deleted', 'SCHEMA', N'dbo', 'TABLE', N'VirtualMachine', 'COLUMN', N'VMDeleteDate'
GO

EXECUTE sp_addextendedproperty N'MS_Description', N'When was last time a user logged on to VM', 'SCHEMA', N'dbo', 'TABLE', N'VirtualMachine', 'COLUMN', N'LastLoggedDate'
GO

EXECUTE sp_addextendedproperty N'MS_Description', N'Who was the user last logged on to VM', 'SCHEMA', N'dbo', 'TABLE', N'VirtualMachine', 'COLUMN', N'LastLoggedUser'
GO

EXECUTE sp_addextendedproperty N'MS_Description', N'When was last time machine was powerdoff', 'SCHEMA', N'dbo', 'TABLE', N'VirtualMachine', 'COLUMN', N'LastPowerOffDate'
GO

EXECUTE sp_addextendedproperty N'MS_Description', N'when was last time machine was powered on', 'SCHEMA', N'dbo', 'TABLE', N'VirtualMachine', 'COLUMN', N'LastPowerOnDate'
GO

EXECUTE sp_addextendedproperty N'MS_Description', N'Whether owner of the machine exists in AD', 'SCHEMA', N'dbo', 'TABLE', N'VirtualMachine', 'COLUMN', N'OwnerExists'
GO

EXECUTE sp_addextendedproperty N'MS_Description', N'This is a placeholder for storing a integer value which will indicate over usage of the machine. This can be used to indicate over/under used virtual machines', 'SCHEMA', N'dbo', 'TABLE', N'VirtualMachine', 'COLUMN', N'UsageIndex'
GO

EXECUTE sp_addextendedproperty N'MS_Description', N'User marking to ignore the usage index', 'SCHEMA', N'dbo', 'TABLE', N'VirtualMachine', 'COLUMN', N'UsageIndexIgnoreBy'
GO

EXECUTE sp_addextendedproperty N'MS_Description', N'Whether a VM is deleted', 'SCHEMA', N'dbo', 'TABLE', N'VirtualMachine', 'COLUMN', N'IsDeleted'
GO

EXECUTE sp_addextendedproperty N'MS_Description', N'Whether VM is missing', 'SCHEMA', N'dbo', 'TABLE', N'VirtualMachine', 'COLUMN', N'IsMissing'
GO

EXECUTE sp_addextendedproperty N'MS_Description', N'Whether VM is rogue', 'SCHEMA', N'dbo', 'TABLE', N'VirtualMachine', 'COLUMN', N'IsRogue'
GO

EXECUTE sp_addextendedproperty N'MS_Description', N'Whether VM is running or turned off', 'SCHEMA', N'dbo', 'TABLE', N'VirtualMachine', 'COLUMN', N'IsRunning'
GO

EXECUTE sp_addextendedproperty N'MS_Description', N'Integer attribute which can be used for applying flags to the entity', 'SCHEMA', N'dbo', 'TABLE', N'VirtualMachine', 'COLUMN', N'Flags'
GO

EXECUTE sp_addextendedproperty N'MS_Description', N'Generic text column with 256 bytes length', 'SCHEMA', N'dbo', 'TABLE', N'VirtualMachine', 'COLUMN', N'Text1'
GO

EXECUTE sp_addextendedproperty N'MS_Description', N'Generic text column with max length', 'SCHEMA', N'dbo', 'TABLE', N'VirtualMachine', 'COLUMN', N'Text2'
GO

EXECUTE sp_addextendedproperty N'MS_Description', N'Number of CPUs', 'SCHEMA', N'dbo', 'TABLE', N'VirtualMachine', 'COLUMN', N'VMCPUs'
GO

EXECUTE sp_addextendedproperty N'MS_Description', N'Amount of memory allocated to VM. Stored in MB', 'SCHEMA', N'dbo', 'TABLE', N'VirtualMachine', 'COLUMN', N'VMTotalMemoryMB'
GO

EXECUTE sp_addextendedproperty N'MS_Description', N'Amount of disk space allocated to VM(add all the disks together). Stored in GB', 'SCHEMA', N'dbo', 'TABLE', N'VirtualMachine', 'COLUMN', N'VMTotalStorageGB'
GO

EXECUTE sp_addextendedproperty N'MS_Description', N'Whether VM is a component of an AppService', 'SCHEMA', N'dbo', 'TABLE', N'VirtualMachine', 'COLUMN', N'IsComponent'
GO

EXECUTE sp_addextendedproperty N'MS_Description', N'Parent virtual machine id', 'SCHEMA', N'dbo', 'TABLE', N'VirtualMachine', 'COLUMN', N'ParentMachineID'
GO

/* ---------------------------------------------------------------------- */
/* Add table "ManagementEndpoints                                         */
/* ---------------------------------------------------------------------- */

-- Creating table 'ManagementEndpoints'
CREATE TABLE [dbo].[ManagementEndpoints] (
    [ManagementEndpointID] uniqueidentifier  NOT NULL,
    [ManagementUri] nvarchar(128)  NOT NULL,
    [ManagementEndpointName] nvarchar(256)  NOT NULL,
    [ManagementEndpointDescription] nvarchar(max)  NULL,
	[InterfaceType] nvarchar(128) NOT NULL,
	[DataCollectionStatus] nvarchar(256) NULL,
    [Credential_CredentialID] uniqueidentifier  NOT NULL,
	[VirtualDataCentreSkillId] [int] NULL
);
GO

-- Creating table 'InterfaceTypes'
CREATE TABLE [dbo].[InterfaceTypes](
	[InterfaceTypeId] [nvarchar](128) NOT NULL,
	[EndpointType] [tinyint] NOT NULL,
	[DisplayName] [nvarchar](128) NOT NULL,
	[Description] [nvarchar](256) NULL,
	[Url] [nvarchar](256) NULL,
	[IntegratedSecurity] [bit] DEFAULT 1 NOT NULL,
	[HasEndpoints] [bit] DEFAULT 1 NOT NULL,
	[HasReservations] [bit] DEFAULT 1 NOT NULL,
	[HasBlueprints] [bit] DEFAULT 1 NOT NULL
);
GO

-- Creating table 'PhysicalControllers'
CREATE TABLE [dbo].[PhysicalControllers] (
    [PhysicalControllerID] uniqueidentifier  NOT NULL,
    [ServiceTag] nvarchar(128)  NULL,
    [Model] nvarchar(256)  NULL,
    [AssetTag] nvarchar(256)  NULL,
    [FirmwareVersion] nvarchar(128)  NULL,
    [DataCenter] nvarchar(128)  NULL,
    [Row] nvarchar(128)  NULL,
    [Rack] nvarchar(128)  NULL,
    [HardwareType] nvarchar(128)  NULL,
    [ManagementWebUri] nvarchar(256)  NULL,
	[InterfaceVersion] nvarchar(128)  NULL,
    [ManagementEndpoint_ManagementEndpointID] uniqueidentifier  NOT NULL
);
GO

-- Creating table 'PhysicalStorages'
CREATE TABLE [dbo].[PhysicalStorages] (
    [PhysicalStorageID] uniqueidentifier  NOT NULL,
    [Capacity] bigint  NOT NULL,
    [Type] nvarchar(128)  NULL,
    [Name] nvarchar(128)  NULL,
    [PhysicalMachine_PhysicalMachineID] uniqueidentifier  NOT NULL
);
GO

-- Creating table 'PhysicalNetworks'
CREATE TABLE [dbo].[PhysicalNetworks] (
    [PhysicalNetworkID] uniqueidentifier  NOT NULL,
    [MacAddress] nvarchar(128)  NOT NULL,
    [Name] nvarchar(128)  NOT NULL,
    [IpAddress] nvarchar(128)  NULL,
    [PhysicalMachine_PhysicalMachineID] uniqueidentifier  NOT NULL
);
GO

-- Creating table 'ManagementEndpointProperties'
CREATE TABLE [dbo].[ManagementEndpointProperties] (
	[Id] INTEGER NOT NULL identity(1,1),
	[Name] nvarchar(128) NOT NULL,
	[Value] nvarchar(256) NOT NULL,
	[IsHidden] bit NOT NULL DEFAULT 0,
	[IsRuntime] bit NOT NULL DEFAULT 0,
	[IsEncrypted] bit NOT NULL DEFAULT 0,
	[ManagementEndpointID] UNIQUEIDENTIFIER NOT NULL,
	[ManagementEndpointPropertyID] UNIQUEIDENTIFIER NOT NULL
);
GO

-- Creating primary key on [ManagementEndpointID] in table 'ManagementEndpoints'
ALTER TABLE [dbo].[ManagementEndpoints] WITH NOCHECK 
ADD CONSTRAINT [PK_ManagementEndpoints]
	PRIMARY KEY CLUSTERED ([ManagementEndpointID] ASC)
	ON [PRIMARY]
GO

-- Creating primary key on [InterfaceType] in table 'InterfaceType'
ALTER TABLE [dbo].[InterfaceTypes] WITH NOCHECK 
ADD CONSTRAINT [PK_InterfaceTypes]
	PRIMARY KEY CLUSTERED ([InterfaceTypeId] ASC)
	ON [PRIMARY]
GO

-- Creating primary key on [ManagementEndpointPropertyID] in table 'ManagementEndpointProperties'
ALTER TABLE [dbo].[ManagementEndpointProperties] WITH NOCHECK 
ADD CONSTRAINT [PK_ManagementEndpointProperties]
	PRIMARY KEY CLUSTERED ([ManagementEndpointPropertyID] ASC)
	ON [PRIMARY]
GO

-- Creating primary key on [PhysicalControllerID] in table 'PhysicalControllers'
ALTER TABLE [dbo].[PhysicalControllers] WITH NOCHECK
ADD CONSTRAINT [PK_PhysicalControllers]
    PRIMARY KEY CLUSTERED ([PhysicalControllerID] ASC)
	ON [PRIMARY]
GO

-- Creating primary key on [StorageID] in table 'PhysicalStorages'
ALTER TABLE [dbo].[PhysicalStorages] WITH NOCHECK
ADD CONSTRAINT [PK_PhysicalStorages]
    PRIMARY KEY CLUSTERED ([PhysicalStorageID] ASC)
	ON [PRIMARY]
GO

-- Creating primary key on [NetworkInterfaceID] in table 'PhysicalNetworks'
ALTER TABLE [dbo].[PhysicalNetworks] WITH NOCHECK
ADD CONSTRAINT [PK_PhysicalNetworks]
    PRIMARY KEY CLUSTERED ([PhysicalNetworkID] ASC)
	ON [PRIMARY]
GO

CREATE UNIQUE NONCLUSTERED INDEX [IX_MachineEndpointProperties_ManagementEndpointID_Name]
 ON [dbo].[ManagementEndpointProperties] 
(
	[ManagementEndpointID], [Name] ASC
) ON [PRIMARY]
GO

/* ---------------------------------------------------------------------- */
/* Add table "ChangeStateRequests"                                         */
/* ---------------------------------------------------------------------- */

-- Creating table 'ChangeStateRequests'
CREATE TABLE [dbo].[ChangeStateRequests] (
	[WorkflowID] UNIQUEIDENTIFIER NOT NULL,
	[NextState] nvarchar(128) NOT NULL,
	[IsEvent] bit NULL,
);
GO

-- Creating primary key on [WorkflowID] in table ChangeStateRequest'
ALTER TABLE [dbo].[ChangeStateRequests] WITH NOCHECK 
ADD CONSTRAINT [PK_ChangeStateRequests]
	PRIMARY KEY CLUSTERED ([WorkflowID] ASC)
	ON [PRIMARY]
GO

/* ---------------------------------------------------------------------- */
/* Add table "PhysicalMachine"                                            */
/* ---------------------------------------------------------------------- */

CREATE TABLE [dbo].[PhysicalMachines] (
    [PhysicalMachineID] uniqueidentifier  NOT NULL,
    [AssetTag] nvarchar(256)  NULL,
    [Vendor] nvarchar(128)  NULL,
    [ProcessorCount] int  NOT NULL,
    [MemoryInMB] int  NOT NULL,
    [DataCenter] nvarchar(128)  NULL,
    [Row] nvarchar(128)  NULL,
    [Rack] nvarchar(128)  NULL,
    [Slot] smallint  NOT NULL,
    [BiosVersion] nvarchar(128)  NULL,
    [Model] nvarchar(256)  NULL,
    [ServiceTag] nvarchar(128)  NULL,
    [CostProfileID] uniqueidentifier  NULL,
    [PhysicalController_PhysicalControllerID] uniqueidentifier  NOT NULL
);
GO

-- Creating table 'PhysicalMachineProperties'
CREATE TABLE [dbo].[PhysicalMachineProperties] (
	[Name] nvarchar(128) NOT NULL,
	[Value] nvarchar(256) NOT NULL,
	[PhysicalMachineID] UNIQUEIDENTIFIER  NOT NULL,
	[PhysicalMachinePropertyID] UNIQUEIDENTIFIER NOT NULL
);
GO

-- Creating primary key on [PhysicalMachineID] in table 'PhysicalMachines'
ALTER TABLE [dbo].[PhysicalMachines] WITH NOCHECK 
ADD CONSTRAINT [PK_PhysicalMachines]
	PRIMARY KEY CLUSTERED ([PhysicalMachineID] ASC)
	ON [PRIMARY]
GO

-- Creating primary key on [Name] in table 'PhysicalMachineProperties'
ALTER TABLE [dbo].[PhysicalMachineProperties] WITH NOCHECK 
ADD CONSTRAINT [PK_PhysicalMachineProperties]
	PRIMARY KEY CLUSTERED ([PhysicalMachinePropertyID] ASC)
	ON [PRIMARY]
GO

CREATE UNIQUE NONCLUSTERED INDEX [IX_PhysicalMachineProperties_PhysicalMachineID_Name]
 ON [dbo].[PhysicalMachineProperties] 
(
	[PhysicalMachineID], [Name] ASC
) ON [PRIMARY]
GO

/* ---------------------------------------------------------------------- */
/* Add table "VirtualMachineUsage"                                        */
/* ---------------------------------------------------------------------- */

CREATE TABLE [VirtualMachineUsage] (
	[VirtualMachineID] UNIQUEIDENTIFIER NOT NULL,
	[VMUsageTimestamp] DATETIME,
	[VMCPUs] BIGINT,
	[VMTotalStorageGB] BIGINT,
	[VMUsedStorageGB] BIGINT,
	[VMTotalMemoryMB] BIGINT,
	[VMUsedMemoryMB] BIGINT,
	[NumOfVMDisks] BIGINT,
	[VirtualMachineState] NVARCHAR(40),
	CONSTRAINT [PK_VirtualMachineAudit] PRIMARY KEY ([VirtualMachineID])
)
GO

EXECUTE sp_addextendedproperty N'MS_Description', N'Table to capture configuration parameters for the VM', 'SCHEMA', N'dbo', 'TABLE', N'VirtualMachineUsage', NULL, NULL
GO

EXECUTE sp_addextendedproperty N'MS_Description', N'Primary key', 'SCHEMA', N'dbo', 'TABLE', N'VirtualMachineUsage', 'COLUMN', N'VirtualMachineID'
GO

EXECUTE sp_addextendedproperty N'MS_Description', N'Number of CPUs', 'SCHEMA', N'dbo', 'TABLE', N'VirtualMachineUsage', 'COLUMN', N'VMCPUs'
GO

EXECUTE sp_addextendedproperty N'MS_Description', N'Amount of disk space allocated to VM(add all the disks together). Stored in GB', 'SCHEMA', N'dbo', 'TABLE', N'VirtualMachineUsage', 'COLUMN', N'VMTotalStorageGB'
GO

EXECUTE sp_addextendedproperty N'MS_Description', N'Amount of memory allocated to VM. Stored in MB', 'SCHEMA', N'dbo', 'TABLE', N'VirtualMachineUsage', 'COLUMN', N'VMTotalMemoryMB'
GO

EXECUTE sp_addextendedproperty N'MS_Description', N'Number of disks ', 'SCHEMA', N'dbo', 'TABLE', N'VirtualMachineUsage', 'COLUMN', N'NumOfVMDisks'
GO

/* ---------------------------------------------------------------------- */
/* Add table "WorkflowInfo"                                               */
/* ---------------------------------------------------------------------- */

CREATE TABLE [WorkflowInfo] (
	[WorkflowID] UNIQUEIDENTIFIER NOT NULL,
	[WorkflowName] NVARCHAR(128) NOT NULL,
	[AssemblyFQN] NVARCHAR(1024) NOT NULL,
	[WorkflowDescription] NVARCHAR(max),
	[WorkflowBuildTagType] NVARCHAR(128),
	CONSTRAINT [PK_Workflow] PRIMARY KEY ([WorkflowID])
)
GO

EXECUTE sp_addextendedproperty N'MS_Description', N'Tracks Workflow object. TODO put more description here', 'SCHEMA', N'dbo', 'TABLE', N'WorkflowInfo', NULL, NULL
GO

EXECUTE sp_addextendedproperty N'MS_Description', N'Primary Key', 'SCHEMA', N'dbo', 'TABLE', N'WorkflowInfo', 'COLUMN', N'WorkflowID'
GO

EXECUTE sp_addextendedproperty N'MS_Description', N'Name of the workflow', 'SCHEMA', N'dbo', 'TABLE', N'WorkflowInfo', 'COLUMN', N'WorkflowName'
GO

EXECUTE sp_addextendedproperty N'MS_Description', N'???', 'SCHEMA', N'dbo', 'TABLE', N'WorkflowInfo', 'COLUMN', N'AssemblyFQN'
GO

EXECUTE sp_addextendedproperty N'MS_Description', N'Description of the workflow', 'SCHEMA', N'dbo', 'TABLE', N'WorkflowInfo', 'COLUMN', N'WorkflowDescription'
GO

/* ---------------------------------------------------------------------- */
/* Add table "VirtualMachineTemplate"                                     */
/* ---------------------------------------------------------------------- */

CREATE TABLE [VirtualMachineTemplate] (
	[VirtualMachineTemplateID] UNIQUEIDENTIFIER NOT NULL,
	[VirtualMachineTemplateName] NVARCHAR(256) NOT NULL,
	[VirtualMachineTemplateDescription] NVARCHAR(1024),
	[ExpireDays] INTEGER NOT NULL,
	[LeaseDays] INTEGER NOT NULL,
	[Enabled] BIT NOT NULL,
	[BlueprintType] TINYINT DEFAULT 0 NOT NULL,
	[RequiresApproval] BIT NOT NULL,
	[Master] BIT DEFAULT 0 NOT NULL,
	[MemoryMB] BIGINT,
	[MemoryMaxMB] BIGINT,
	[DiskSize0GB] BIGINT,
	[DiskSizeMaxGB] BIGINT,
	[CPUCount] INTEGER,
	[CPUCountMax] INTEGER,
	[MachinePrefix] NVARCHAR(50),
	[Cost] DECIMAL(28,3),
	[InheritsFromVMTemplateID] UNIQUEIDENTIFIER,
	[Flags] BIGINT,
	[Text1] NVARCHAR(256),
	[Text2] NVARCHAR(max),
	[WorkflowID] UNIQUEIDENTIFIER,
	[MaxVMsPerUser] INTEGER,
	[IsGlobal] BIT DEFAULT 0 NOT NULL,
	[RecCreationTime] DATETIME,
	[RecDeleteTime] DATETIME,
	[RecUpdateTime] DATETIME,
	[ApprovalPolicyId] UNIQUEIDENTIFIER,
	[id] UNIQUEIDENTIFIER,
	[ReservationPolicyID] UNIQUEIDENTIFIER,
	[LeaseDaysMax] INTEGER,
	[MachineType] [tinyint] NOT NULL,
	[IsReconfigureAllowed] [bit] DEFAULT 1 NOT NULL,
	[ReconfigureMaxDisks] [int] NULL,
	[ReconfigureMaxNetworks] [int] NULL,
	[ReconfigureForceShutdown] [tinyint] NULL,
	[ReconfigureExecutionSelector] [tinyint] NULL,
	[EnableStoragePolicy] [bit] DEFAULT 0 NOT NULL,
	[DisplayIconId] UNIQUEIDENTIFIER,
	[InterfaceTypeId] nvarchar(128) NOT NULL,
	[IsComponentOnly] bit DEFAULT 0 NOT NULL,
	CONSTRAINT [PK_VirtualMachineTemplate] PRIMARY KEY ([VirtualMachineTemplateID]),
	CONSTRAINT [TUC_VirtualMachineTemplate_1] UNIQUE ([VirtualMachineTemplateName])
)
GO

CREATE NONCLUSTERED INDEX [IDX_VirtualMachineTemplate_1] ON [VirtualMachineTemplate] ([VirtualMachineTemplateName] ASC)
GO

EXECUTE sp_addextendedproperty N'MS_Description', N'Blueprint for creating/cloning virtual machines', 'SCHEMA', N'dbo', 'TABLE', N'VirtualMachineTemplate', NULL, NULL
GO

EXECUTE sp_addextendedproperty N'MS_Description', N'Primary key', 'SCHEMA', N'dbo', 'TABLE', N'VirtualMachineTemplate', 'COLUMN', N'VirtualMachineTemplateID'
GO

EXECUTE sp_addextendedproperty N'MS_Description', N'Name for the Blueprint', 'SCHEMA', N'dbo', 'TABLE', N'VirtualMachineTemplate', 'COLUMN', N'VirtualMachineTemplateName'
GO

EXECUTE sp_addextendedproperty N'MS_Description', N'Description of the Blueprint', 'SCHEMA', N'dbo', 'TABLE', N'VirtualMachineTemplate', 'COLUMN', N'VirtualMachineTemplateDescription'
GO

EXECUTE sp_addextendedproperty N'MS_Description', N'Number of days for which a VM is active for', 'SCHEMA', N'dbo', 'TABLE', N'VirtualMachineTemplate', 'COLUMN', N'ExpireDays'
GO

EXECUTE sp_addextendedproperty N'MS_Description', N'Number of days for which a virtual machine is leased for', 'SCHEMA', N'dbo', 'TABLE', N'VirtualMachineTemplate', 'COLUMN', N'LeaseDays'
GO

EXECUTE sp_addextendedproperty N'MS_Description', N'Whether Blueprint is enabled', 'SCHEMA', N'dbo', 'TABLE', N'VirtualMachineTemplate', 'COLUMN', N'Enabled'
GO

EXECUTE sp_addextendedproperty N'MS_Description', N'Whether Blueprint is for creating servers', 'SCHEMA', N'dbo', 'TABLE', N'VirtualMachineTemplate', 'COLUMN', N'BlueprintType'
GO

EXECUTE sp_addextendedproperty N'MS_Description', N'Whether requires approval before creating VM', 'SCHEMA', N'dbo', 'TABLE', N'VirtualMachineTemplate', 'COLUMN', N'RequiresApproval'
GO

EXECUTE sp_addextendedproperty N'MS_Description', N'Whether it is a master', 'SCHEMA', N'dbo', 'TABLE', N'VirtualMachineTemplate', 'COLUMN', N'Master'
GO

EXECUTE sp_addextendedproperty N'MS_Description', N'Amount of memory in MB to be allocated to virtual machine that is created from the Blueprint', 'SCHEMA', N'dbo', 'TABLE', N'VirtualMachineTemplate', 'COLUMN', N'MemoryMB'
GO

EXECUTE sp_addextendedproperty N'MS_Description', N'Size of first disk in GB created in virtual machine', 'SCHEMA', N'dbo', 'TABLE', N'VirtualMachineTemplate', 'COLUMN', N'DiskSize0GB'
GO

EXECUTE sp_addextendedproperty N'MS_Description', N'Number of CPUs to be allocated to virtual machine', 'SCHEMA', N'dbo', 'TABLE', N'VirtualMachineTemplate', 'COLUMN', N'CPUCount'
GO

EXECUTE sp_addextendedproperty N'MS_Description', N'Machine prefix for Blueprint. If not provided naming from group will be used', 'SCHEMA', N'dbo', 'TABLE', N'VirtualMachineTemplate', 'COLUMN', N'MachinePrefix'
GO

EXECUTE sp_addextendedproperty N'MS_Description', N'Cost to be associated with the Blueprint for charge back reports', 'SCHEMA', N'dbo', 'TABLE', N'VirtualMachineTemplate', 'COLUMN', N'Cost'
GO

EXECUTE sp_addextendedproperty N'MS_Description', N'This can be used to set inheritance among blueprint. A Blueprint could inherit properties of a anothe Blurprint and overriding some of the values ', 'SCHEMA', N'dbo', 'TABLE', N'VirtualMachineTemplate', 'COLUMN', N'InheritsFromVMTemplateID'
GO

EXECUTE sp_addextendedproperty N'MS_Description', N'Integer attribute which can be used for applying flags to the entity', 'SCHEMA', N'dbo', 'TABLE', N'VirtualMachineTemplate', 'COLUMN', N'Flags'
GO

EXECUTE sp_addextendedproperty N'MS_Description', N'Generic text column with 256 bytes length', 'SCHEMA', N'dbo', 'TABLE', N'VirtualMachineTemplate', 'COLUMN', N'Text1'
GO

EXECUTE sp_addextendedproperty N'MS_Description', N'Generic text column with max length', 'SCHEMA', N'dbo', 'TABLE', N'VirtualMachineTemplate', 'COLUMN', N'Text2'
GO

/* ---------------------------------------------------------------------- */
/* Add table "WorkflowMap"                                                */
/* ---------------------------------------------------------------------- */

CREATE TABLE [WorkflowMap] (
	[VirtualMachineID] UNIQUEIDENTIFIER NOT NULL,
	[ChildWorkflowID] UNIQUEIDENTIFIER,
	CONSTRAINT [PK_WorkflowMap] PRIMARY KEY ([VirtualMachineID])
)
GO

/* ---------------------------------------------------------------------- */
/* Add table "WorkItem"                                                   */
/* ---------------------------------------------------------------------- */

CREATE TABLE [WorkItem] (
	[WorkItemID] UNIQUEIDENTIFIER NOT NULL,
	[WorkflowID] UNIQUEIDENTIFIER,
	[Dispatched] BIT NOT NULL,
	[WorkItemContent] NVARCHAR(max) NOT NULL,
	[CreatedAt] DATETIME CONSTRAINT [DF__WorkItem__Create__108B795B] DEFAULT getdate(),
	[AgentName] NVARCHAR(256),
	[DataCollectionStatusID] UNIQUEIDENTIFIER,
	CONSTRAINT [PK_WorkItem] PRIMARY KEY ([WorkItemID])
)
GO

/* ---------------------------------------------------------------------- */
/* Add table "Request"                                                    */
/* ---------------------------------------------------------------------- */

CREATE TABLE [Request] (
	[RequestID] UNIQUEIDENTIFIER NOT NULL,
	[RequestUser] INT,
	[RequestDate] DATETIME,
	[RequestComments] NVARCHAR(max),
	[RequestFilter] NVARCHAR(max),
	[VirtualMachineID] UNIQUEIDENTIFIER,
	[HostID] UNIQUEIDENTIFIER,
	[VirtualMachineTemplateID] UNIQUEIDENTIFIER,
	[CompleteDate] DATETIME,
	[RequestTypeID] TINYINT NOT NULL,
	[ReasonFlags] BIGINT,
	[RequestDescription] NVARCHAR(max),
	[Flags] BIGINT,
	[Text1] NVARCHAR(256),
	[Text2] NVARCHAR(max),
	[RequestState] NVARCHAR(128),
	[WorkflowID] UNIQUEIDENTIFIER,
	[GroupID] UNIQUEIDENTIFIER,
	CONSTRAINT [PK_Request] PRIMARY KEY ([RequestID])
)
GO

CREATE NONCLUSTERED INDEX [IDX_Request_1] ON [Request] ([GroupID])
GO

CREATE NONCLUSTERED INDEX [IDX_Request_2] ON [Request] ([RequestUser] ASC)
GO

EXECUTE sp_addextendedproperty N'MS_Description', N'Request tracks user requirements to provision or unprovision something. Also this can track any requests such as power on/power off etc. ', 'SCHEMA', N'dbo', 'TABLE', N'Request', NULL, NULL
GO

EXECUTE sp_addextendedproperty N'MS_Description', N'Primary Key', 'SCHEMA', N'dbo', 'TABLE', N'Request', 'COLUMN', N'RequestID'
GO

EXECUTE sp_addextendedproperty N'MS_Description', N'Date when a requested', 'SCHEMA', N'dbo', 'TABLE', N'Request', 'COLUMN', N'RequestDate'
GO

EXECUTE sp_addextendedproperty N'MS_Description', N'Additional comments for the request', 'SCHEMA', N'dbo', 'TABLE', N'Request', 'COLUMN', N'RequestComments'
GO

EXECUTE sp_addextendedproperty N'MS_Description', N'Reference to the virtual machine if the request is associated with virtal machine', 'SCHEMA', N'dbo', 'TABLE', N'Request', 'COLUMN', N'VirtualMachineID'
GO

EXECUTE sp_addextendedproperty N'MS_Description', N'Blueprint for machine request. Filled only for Create/Clone request', 'SCHEMA', N'dbo', 'TABLE', N'Request', 'COLUMN', N'VirtualMachineTemplateID'
GO

EXECUTE sp_addextendedproperty N'MS_Description', N'Date when a request is completed', 'SCHEMA', N'dbo', 'TABLE', N'Request', 'COLUMN', N'CompleteDate'
GO

EXECUTE sp_addextendedproperty N'MS_Description', N'reference to type of request', 'SCHEMA', N'dbo', 'TABLE', N'Request', 'COLUMN', N'RequestTypeID'
GO

EXECUTE sp_addextendedproperty N'MS_Description', N'Integer attribute which can be used for applying flags to the entity', 'SCHEMA', N'dbo', 'TABLE', N'Request', 'COLUMN', N'Flags'
GO

EXECUTE sp_addextendedproperty N'MS_Description', N'Generic text column with 256 bytes length', 'SCHEMA', N'dbo', 'TABLE', N'Request', 'COLUMN', N'Text1'
GO

EXECUTE sp_addextendedproperty N'MS_Description', N'Generic text column with max length', 'SCHEMA', N'dbo', 'TABLE', N'Request', 'COLUMN', N'Text2'
GO

EXECUTE sp_addextendedproperty N'MS_Description', N'Primary Key', 'SCHEMA', N'dbo', 'TABLE', N'Request', 'COLUMN', N'WorkflowID'
GO

EXECUTE sp_addextendedproperty N'MS_Description', N'Primary key ', 'SCHEMA', N'dbo', 'TABLE', N'Request', 'COLUMN', N'GroupID'
GO

/* ---------------------------------------------------------------------- */
/* Add table "RequestType"                                                */
/* ---------------------------------------------------------------------- */

CREATE TABLE [RequestType] (
	[RequestTypeID] TINYINT NOT NULL,
	[RequestTypeName] NVARCHAR(256),
	[RequestTypeDescription] NVARCHAR(max),
	CONSTRAINT [PK_RequestType] PRIMARY KEY ([RequestTypeID])
)
GO

EXECUTE sp_addextendedproperty N'MS_Description', N'Provides enumeration for type of request. e.g.  0          Create Virtual Machine 1          Clone Virtual Machine 2          Power On Virtual Machine 3.         Clone Virtual Machine   etc ', 'SCHEMA', N'dbo', 'TABLE', N'RequestType', NULL, NULL
GO

/* ---------------------------------------------------------------------- */
/* Add table "VMEvents"                                                   */
/* ---------------------------------------------------------------------- */

CREATE TABLE [VMEvents] (
	[EventID] UNIQUEIDENTIFIER NOT NULL,
	[VirtualMachineID] UNIQUEIDENTIFIER NOT NULL,
	[EventTime] DATETIME,
	[EventTypeID] TINYINT NOT NULL,
	[EventStatusID] TINYINT NOT NULL,
	[EventStartTime] DATETIME,
	[EventCompleteTime] DATETIME,
	[EventTarget] NVARCHAR(40),
	[EventDescription] NVARCHAR(max),
	[Flags] BIGINT,
	[Text1] NVARCHAR(256),
	[Text2] NVARCHAR(max),
	CONSTRAINT [PK_VMEvents] PRIMARY KEY ([EventID]),
	CONSTRAINT [TUC_VMEvents_1] UNIQUE ([VirtualMachineID], [EventTime])
)
GO

EXECUTE sp_addextendedproperty N'MS_Description', N'Table tracks events that are happening in hypervisor for a virtual machine', 'SCHEMA', N'dbo', 'TABLE', N'VMEvents', NULL, NULL
GO

EXECUTE sp_addextendedproperty N'MS_Description', N'Primary Key', 'SCHEMA', N'dbo', 'TABLE', N'VMEvents', 'COLUMN', N'EventID'
GO

EXECUTE sp_addextendedproperty N'MS_Description', N'Reference to Virtual Machine', 'SCHEMA', N'dbo', 'TABLE', N'VMEvents', 'COLUMN', N'VirtualMachineID'
GO

EXECUTE sp_addextendedproperty N'MS_Description', N'Time when event occured', 'SCHEMA', N'dbo', 'TABLE', N'VMEvents', 'COLUMN', N'EventTime'
GO

EXECUTE sp_addextendedproperty N'MS_Description', N'Reference to type of Event', 'SCHEMA', N'dbo', 'TABLE', N'VMEvents', 'COLUMN', N'EventTypeID'
GO

EXECUTE sp_addextendedproperty N'MS_Description', N'Reference to Status of Event', 'SCHEMA', N'dbo', 'TABLE', N'VMEvents', 'COLUMN', N'EventStatusID'
GO

EXECUTE sp_addextendedproperty N'MS_Description', N'When was Event Started ', 'SCHEMA', N'dbo', 'TABLE', N'VMEvents', 'COLUMN', N'EventStartTime'
GO

EXECUTE sp_addextendedproperty N'MS_Description', N'When was Event completed', 'SCHEMA', N'dbo', 'TABLE', N'VMEvents', 'COLUMN', N'EventCompleteTime'
GO

EXECUTE sp_addextendedproperty N'MS_Description', N'Target of the Event a disk or network or memory etc', 'SCHEMA', N'dbo', 'TABLE', N'VMEvents', 'COLUMN', N'EventTarget'
GO

EXECUTE sp_addextendedproperty N'MS_Description', N'Description of the event', 'SCHEMA', N'dbo', 'TABLE', N'VMEvents', 'COLUMN', N'EventDescription'
GO

EXECUTE sp_addextendedproperty N'MS_Description', N'Integer attribute which can be used for applying flags to the entity', 'SCHEMA', N'dbo', 'TABLE', N'VMEvents', 'COLUMN', N'Flags'
GO

EXECUTE sp_addextendedproperty N'MS_Description', N'Generic text column with 256 bytes length', 'SCHEMA', N'dbo', 'TABLE', N'VMEvents', 'COLUMN', N'Text1'
GO

EXECUTE sp_addextendedproperty N'MS_Description', N'Generic text column with max length', 'SCHEMA', N'dbo', 'TABLE', N'VMEvents', 'COLUMN', N'Text2'
GO

/* ---------------------------------------------------------------------- */
/* Add table "VMEventType"                                                */
/* ---------------------------------------------------------------------- */

CREATE TABLE [VMEventType] (
	[EventTypeID] TINYINT NOT NULL,
	[EventTypeName] NVARCHAR(255),
	[EventTypeDesc] NVARCHAR(max),
	CONSTRAINT [PK_VMEventType] PRIMARY KEY ([EventTypeID])
)
GO

EXECUTE sp_addextendedproperty N'MS_Description', N'Enumeration for types of Events', 'SCHEMA', N'dbo', 'TABLE', N'VMEventType', NULL, NULL
GO

EXECUTE sp_addextendedproperty N'MS_Description', N'Primary key', 'SCHEMA', N'dbo', 'TABLE', N'VMEventType', 'COLUMN', N'EventTypeID'
GO

EXECUTE sp_addextendedproperty N'MS_Description', N'Name of the Event Type', 'SCHEMA', N'dbo', 'TABLE', N'VMEventType', 'COLUMN', N'EventTypeName'
GO

EXECUTE sp_addextendedproperty N'MS_Description', N'Description of the Event Type', 'SCHEMA', N'dbo', 'TABLE', N'VMEventType', 'COLUMN', N'EventTypeDesc'
GO

/* ---------------------------------------------------------------------- */
/* Add table "VMEventStatus"                                              */
/* ---------------------------------------------------------------------- */

CREATE TABLE [VMEventStatus] (
	[EventStatusID] TINYINT NOT NULL,
	[EventStatusName] NVARCHAR(256),
	[EventStatusDesc] NVARCHAR(max),
	CONSTRAINT [PK_VMEventStatus] PRIMARY KEY ([EventStatusID])
)
GO

EXECUTE sp_addextendedproperty N'MS_Description', N'Enumeration for Event Status', 'SCHEMA', N'dbo', 'TABLE', N'VMEventStatus', NULL, NULL
GO

EXECUTE sp_addextendedproperty N'MS_Description', N'Primary Key', 'SCHEMA', N'dbo', 'TABLE', N'VMEventStatus', 'COLUMN', N'EventStatusID'
GO

EXECUTE sp_addextendedproperty N'MS_Description', N'Name for the Event Status', 'SCHEMA', N'dbo', 'TABLE', N'VMEventStatus', 'COLUMN', N'EventStatusName'
GO

EXECUTE sp_addextendedproperty N'MS_Description', N'Description for the Event Status', 'SCHEMA', N'dbo', 'TABLE', N'VMEventStatus', 'COLUMN', N'EventStatusDesc'
GO

/* ---------------------------------------------------------------------- */
/* Add table "Cluster"                                                    */
/* ---------------------------------------------------------------------- */

CREATE TABLE [Cluster] (
	[ClusterID] UNIQUEIDENTIFIER NOT NULL,
	[ClusterName] NVARCHAR(256) NOT NULL,
	[ClusterIsDRS] BIT,
	[ClusterIsHA] BIT,
	[ClusterCPUResources] INTEGER,
	CONSTRAINT [PK_Cluster] PRIMARY KEY ([ClusterID])
)
GO

/* ---------------------------------------------------------------------- */
/* Add table "Storage"                                                    */
/* ---------------------------------------------------------------------- */

CREATE TABLE [Storage] (
	[StorageID] UNIQUEIDENTIFIER NOT NULL,
	[StorageUniqueID] NVARCHAR(256),
	[StorageDevice] NVARCHAR(1024),
	[StorageTotalCapacityGB] BIGINT,
	[StorageFreeCapacityGB] BIGINT,
	[StorageTypeID] TINYINT NOT NULL,
	[StorageName] NVARCHAR(256),
	[Flags] BIGINT,
	[Text1] NVARCHAR(256),
	[Text2] NVARCHAR(max),
	[ManagementEndpointID] UNIQUEIDENTIFIER,
	[IsFileLevelCloneInstalled] BIT,
	[VolumeSaving] DECIMAL(5,2),
	CONSTRAINT [PK_Storage] PRIMARY KEY ([StorageID])
)
GO

EXECUTE sp_addextendedproperty N'MS_Description', N'Tracks storage paths in a host available for provisiong virtual machines', 'SCHEMA', N'dbo', 'TABLE', N'Storage', NULL, NULL
GO

EXECUTE sp_addextendedproperty N'MS_Description', N'Database primary key for storage path', 'SCHEMA', N'dbo', 'TABLE', N'Storage', 'COLUMN', N'StorageID'
GO

EXECUTE sp_addextendedproperty N'MS_Description', N'Unique ID provided by hyeprvsior for storage path', 'SCHEMA', N'dbo', 'TABLE', N'Storage', 'COLUMN', N'StorageUniqueID'
GO

EXECUTE sp_addextendedproperty N'MS_Description', N'List of devices/LUNs that make up storage path. Not collected at this time', 'SCHEMA', N'dbo', 'TABLE', N'Storage', 'COLUMN', N'StorageDevice'
GO

EXECUTE sp_addextendedproperty N'MS_Description', N'Total capacity in the storage path in GB', 'SCHEMA', N'dbo', 'TABLE', N'Storage', 'COLUMN', N'StorageTotalCapacityGB'
GO

EXECUTE sp_addextendedproperty N'MS_Description', N'Free capacity in the storage path in GB', 'SCHEMA', N'dbo', 'TABLE', N'Storage', 'COLUMN', N'StorageFreeCapacityGB'
GO

EXECUTE sp_addextendedproperty N'MS_Description', N'Reference to storage type', 'SCHEMA', N'dbo', 'TABLE', N'Storage', 'COLUMN', N'StorageTypeID'
GO

EXECUTE sp_addextendedproperty N'MS_Description', N'Name of the storage path', 'SCHEMA', N'dbo', 'TABLE', N'Storage', 'COLUMN', N'StorageName'
GO

EXECUTE sp_addextendedproperty N'MS_Description', N'Integer attribute which can be used for applying flags to the entity', 'SCHEMA', N'dbo', 'TABLE', N'Storage', 'COLUMN', N'Flags'
GO

EXECUTE sp_addextendedproperty N'MS_Description', N'Generic text column with 256 bytes length', 'SCHEMA', N'dbo', 'TABLE', N'Storage', 'COLUMN', N'Text1'
GO

EXECUTE sp_addextendedproperty N'MS_Description', N'Generic text column with max length', 'SCHEMA', N'dbo', 'TABLE', N'Storage', 'COLUMN', N'Text2'
GO

/* ---------------------------------------------------------------------- */
/* Add table "HostStorageType"                                            */
/* ---------------------------------------------------------------------- */

CREATE TABLE [HostStorageType] (
	[StorageTypeID] TINYINT NOT NULL,
	[StorageTypeName] NVARCHAR(256) NOT NULL,
	[StorageTypeDesc] NVARCHAR(max),
	CONSTRAINT [PK_HostStorageType] PRIMARY KEY ([StorageTypeID])
)
GO

EXECUTE sp_addextendedproperty N'MS_Description', N'Table to store enumeration for storage type. need to figure out what storage types can be collected ', 'SCHEMA', N'dbo', 'TABLE', N'HostStorageType', NULL, NULL
GO

EXECUTE sp_addextendedproperty N'MS_Description', N'Primary key for storage type', 'SCHEMA', N'dbo', 'TABLE', N'HostStorageType', 'COLUMN', N'StorageTypeID'
GO

EXECUTE sp_addextendedproperty N'MS_Description', N'Name for storage type', 'SCHEMA', N'dbo', 'TABLE', N'HostStorageType', 'COLUMN', N'StorageTypeName'
GO

EXECUTE sp_addextendedproperty N'MS_Description', N'Description of the storage type', 'SCHEMA', N'dbo', 'TABLE', N'HostStorageType', 'COLUMN', N'StorageTypeDesc'
GO

/* ---------------------------------------------------------------------- */
/* Add table "Performance"                                                */
/* ---------------------------------------------------------------------- */

CREATE TABLE [Performance] (
	[PerformanceID] UNIQUEIDENTIFIER NOT NULL,
	[PerfTimestamp] DATETIME,
	[MetricTypeID] TINYINT NOT NULL,
	[MetricValue] DECIMAL(28,3),
	[EntityID] UNIQUEIDENTIFIER,
	[EntityTypeID] TINYINT,
	[LastCollectedTime] DATETIME,
	[MetricPartitionKey] INTEGER,
	CONSTRAINT [PK_Performance] PRIMARY KEY ([PerformanceID])
)
GO

EXECUTE sp_addextendedproperty N'MS_Description', N'Table to store performance or trend data for various entities in VRM', 'SCHEMA', N'dbo', 'TABLE', N'Performance', NULL, NULL
GO

EXECUTE sp_addextendedproperty N'MS_Description', N'Primary key', 'SCHEMA', N'dbo', 'TABLE', N'Performance', 'COLUMN', N'PerformanceID'
GO

EXECUTE sp_addextendedproperty N'MS_Description', N'Time when metric value was collected', 'SCHEMA', N'dbo', 'TABLE', N'Performance', 'COLUMN', N'PerfTimestamp'
GO

EXECUTE sp_addextendedproperty N'MS_Description', N'Reference to type of Metric', 'SCHEMA', N'dbo', 'TABLE', N'Performance', 'COLUMN', N'MetricTypeID'
GO

EXECUTE sp_addextendedproperty N'MS_Description', N'Value for the Metric stored as numeric', 'SCHEMA', N'dbo', 'TABLE', N'Performance', 'COLUMN', N'MetricValue'
GO

EXECUTE sp_addextendedproperty N'MS_Description', N'Reference to entity for which metric is stored', 'SCHEMA', N'dbo', 'TABLE', N'Performance', 'COLUMN', N'EntityID'
GO

EXECUTE sp_addextendedproperty N'MS_Description', N'Type of Entity for which metric is stored', 'SCHEMA', N'dbo', 'TABLE', N'Performance', 'COLUMN', N'EntityTypeID'
GO

EXECUTE sp_addextendedproperty N'MS_Description', N'Key for partitioning Performance table', 'SCHEMA', N'dbo', 'TABLE', N'Performance', 'COLUMN', N'MetricPartitionKey'
GO

/* ---------------------------------------------------------------------- */
/* Add table "VMAlarm"                                                    */
/* ---------------------------------------------------------------------- */

CREATE TABLE [VMAlarm] (
	[VMAlarmID] UNIQUEIDENTIFIER NOT NULL,
	[VirtualMachineID] UNIQUEIDENTIFIER NOT NULL,
	[VMAlarmName] NVARCHAR(256),
	[VMAlarmAck] BIT,
	[VMAlarmAckUser] NVARCHAR(256),
	[VMAlarmTime] DATETIME,
	[VMAlarmDescription] NVARCHAR(max),
	[VMAlarmTypeID] UNIQUEIDENTIFIER,
	CONSTRAINT [PK_VMAlarm] PRIMARY KEY ([VMAlarmID])
)
GO

/* ---------------------------------------------------------------------- */
/* Add table "VMAlaramType"                                               */
/* ---------------------------------------------------------------------- */

CREATE TABLE [VMAlaramType] (
	[VMAlarmTypeID] UNIQUEIDENTIFIER NOT NULL,
	[VMAlarmTypeName] NVARCHAR(256) NOT NULL,
	[VMAlarmTypeDescription] NVARCHAR(max),
	CONSTRAINT [PK_VMAlaramType] PRIMARY KEY ([VMAlarmTypeID])
)
GO

/* ---------------------------------------------------------------------- */
/* Add table "PhysicalLocation"                                           */
/* ---------------------------------------------------------------------- */

CREATE TABLE [PhysicalLocation] (
	[PhysicalLocationID] UNIQUEIDENTIFIER NOT NULL,
	[PhysicalLocationName] NVARCHAR(128),
	[PhysicalLocationDescription] NVARCHAR(max),
	CONSTRAINT [PK_PhysicalLocation] PRIMARY KEY ([PhysicalLocationID])
)
GO

EXECUTE sp_addextendedproperty N'MS_Description', N'Table to track where a host is located. A host is installed in a DataCenter and assumed that is in only one location.  e.g. a Host is in London data center or Zurich Data Center etc. This is used to logically organize hosts in a group for reporting purposes. The reports such as how many VMs are there in a data center etc can be created', 'SCHEMA', N'dbo', 'TABLE', N'PhysicalLocation', NULL, NULL
GO

EXECUTE sp_addextendedproperty N'MS_Description', N'Primary key', 'SCHEMA', N'dbo', 'TABLE', N'PhysicalLocation', 'COLUMN', N'PhysicalLocationID'
GO

EXECUTE sp_addextendedproperty N'MS_Description', N'Name given for the location', 'SCHEMA', N'dbo', 'TABLE', N'PhysicalLocation', 'COLUMN', N'PhysicalLocationName'
GO

EXECUTE sp_addextendedproperty N'MS_Description', N'Description of the location ', 'SCHEMA', N'dbo', 'TABLE', N'PhysicalLocation', 'COLUMN', N'PhysicalLocationDescription'
GO

/* ---------------------------------------------------------------------- */
/* Add table "VRM_ID"                                                     */
/* ---------------------------------------------------------------------- */

CREATE TABLE [VRM_ID] (
	[VRMID] UNIQUEIDENTIFIER NOT NULL,
	[VRMName] NVARCHAR(128),
	[VRMDescription] NVARCHAR(max),
	[VRMVersion] NVARCHAR(128),
	[VRMDBVersion] NVARCHAR(128),
	[LicensedSockets] BIGINT,
	[LicenseKey] NVARCHAR(256),
	[Flags] BIGINT,
	[Text1] NVARCHAR(256),
	[Text2] NVARCHAR(max),
	CONSTRAINT [PK_VRM_ID] PRIMARY KEY ([VRMID])
)
GO

EXECUTE sp_addextendedproperty N'MS_Description', N'Table tracks information about VRM that is using this database', 'SCHEMA', N'dbo', 'TABLE', N'VRM_ID', NULL, NULL
GO

EXECUTE sp_addextendedproperty N'MS_Description', N'Primary key', 'SCHEMA', N'dbo', 'TABLE', N'VRM_ID', 'COLUMN', N'VRMID'
GO

EXECUTE sp_addextendedproperty N'MS_Description', N'Name of the VRM assuming a friendly name can be provided', 'SCHEMA', N'dbo', 'TABLE', N'VRM_ID', 'COLUMN', N'VRMName'
GO

EXECUTE sp_addextendedproperty N'MS_Description', N'Description/Notes about the VRM', 'SCHEMA', N'dbo', 'TABLE', N'VRM_ID', 'COLUMN', N'VRMDescription'
GO

EXECUTE sp_addextendedproperty N'MS_Description', N'Version of VRM (Manager Service)', 'SCHEMA', N'dbo', 'TABLE', N'VRM_ID', 'COLUMN', N'VRMVersion'
GO

EXECUTE sp_addextendedproperty N'MS_Description', N'Version of the database schema', 'SCHEMA', N'dbo', 'TABLE', N'VRM_ID', 'COLUMN', N'VRMDBVersion'
GO

EXECUTE sp_addextendedproperty N'MS_Description', N'Integer attribute which can be used for applying flags to the entity', 'SCHEMA', N'dbo', 'TABLE', N'VRM_ID', 'COLUMN', N'Flags'
GO

EXECUTE sp_addextendedproperty N'MS_Description', N'Generic text column with 256 bytes length', 'SCHEMA', N'dbo', 'TABLE', N'VRM_ID', 'COLUMN', N'Text1'
GO

EXECUTE sp_addextendedproperty N'MS_Description', N'Generic text column with max length', 'SCHEMA', N'dbo', 'TABLE', N'VRM_ID', 'COLUMN', N'Text2'
GO

/* ---------------------------------------------------------------------- */
/* Add table "MetricType"                                                 */
/* ---------------------------------------------------------------------- */

CREATE TABLE [MetricType] (
	[MetricTypeID] TINYINT NOT NULL,
	[MetricTypeName] NVARCHAR(256),
	[MetricTypeDesc] NVARCHAR(max),
	[MetricPartitionKey] INTEGER,
	CONSTRAINT [PK_MetricType] PRIMARY KEY ([MetricTypeID])
)
GO

EXECUTE sp_addextendedproperty N'MS_Description', N'Enumeration for type Metric that is stored in VRM e.g.  0     Capacity Free for Host 1     CPU Usage for Host 2     Memory Usage for VM  etc', 'SCHEMA', N'dbo', 'TABLE', N'MetricType', NULL, NULL
GO

EXECUTE sp_addextendedproperty N'MS_Description', N'primary key', 'SCHEMA', N'dbo', 'TABLE', N'MetricType', 'COLUMN', N'MetricTypeID'
GO

EXECUTE sp_addextendedproperty N'MS_Description', N'Name for the Metric', 'SCHEMA', N'dbo', 'TABLE', N'MetricType', 'COLUMN', N'MetricTypeName'
GO

EXECUTE sp_addextendedproperty N'MS_Description', N'Description for the Metric', 'SCHEMA', N'dbo', 'TABLE', N'MetricType', 'COLUMN', N'MetricTypeDesc'
GO

EXECUTE sp_addextendedproperty N'MS_Description', N'Key for partitioning Performance table', 'SCHEMA', N'dbo', 'TABLE', N'MetricType', 'COLUMN', N'MetricPartitionKey'
GO

/* ---------------------------------------------------------------------- */
/* Add table "ResourcePool"                                               */
/* ---------------------------------------------------------------------- */

CREATE TABLE [ResourcePool] (
	[ResourcePoolID] UNIQUEIDENTIFIER NOT NULL,
	[ResourcePoolUniqueID] NVARCHAR(256),
	[HostID] UNIQUEIDENTIFIER NOT NULL,
	[ResourcePoolName] NVARCHAR(256) NOT NULL,
	[ResourcePoolDesc] NVARCHAR(max),
	[ResourcePoolMemoryMB] INTEGER,
	[ResourcePoolCPU] INTEGER,
	[Flags] BIGINT,
	[Text1] NVARCHAR(256),
	[Text2] NVARCHAR(max),
	CONSTRAINT [PK_ResourcePool] PRIMARY KEY ([ResourcePoolID])
)
GO

EXECUTE sp_addextendedproperty N'MS_Description', N'Tracks resource pools within a host or cluster', 'SCHEMA', N'dbo', 'TABLE', N'ResourcePool', NULL, NULL
GO

EXECUTE sp_addextendedproperty N'MS_Description', N'Primary key', 'SCHEMA', N'dbo', 'TABLE', N'ResourcePool', 'COLUMN', N'ResourcePoolID'
GO

EXECUTE sp_addextendedproperty N'MS_Description', N'Hyeprvisor provided unique key for resource pool', 'SCHEMA', N'dbo', 'TABLE', N'ResourcePool', 'COLUMN', N'ResourcePoolUniqueID'
GO

EXECUTE sp_addextendedproperty N'MS_Description', N'Reference to host or cluster', 'SCHEMA', N'dbo', 'TABLE', N'ResourcePool', 'COLUMN', N'HostID'
GO

EXECUTE sp_addextendedproperty N'MS_Description', N'Name of the resource pool', 'SCHEMA', N'dbo', 'TABLE', N'ResourcePool', 'COLUMN', N'ResourcePoolName'
GO

EXECUTE sp_addextendedproperty N'MS_Description', N'Description of the resource pool', 'SCHEMA', N'dbo', 'TABLE', N'ResourcePool', 'COLUMN', N'ResourcePoolDesc'
GO

EXECUTE sp_addextendedproperty N'MS_Description', N'Amount memory allocated to ResourcePool in Mega bytes', 'SCHEMA', N'dbo', 'TABLE', N'ResourcePool', 'COLUMN', N'ResourcePoolMemoryMB'
GO

EXECUTE sp_addextendedproperty N'MS_Description', N'Number of CPUs associated with the resource pool', 'SCHEMA', N'dbo', 'TABLE', N'ResourcePool', 'COLUMN', N'ResourcePoolCPU'
GO

EXECUTE sp_addextendedproperty N'MS_Description', N'Integer attribute which can be used for applying flags to the entity', 'SCHEMA', N'dbo', 'TABLE', N'ResourcePool', 'COLUMN', N'Flags'
GO

EXECUTE sp_addextendedproperty N'MS_Description', N'Generic text column with 256 bytes length', 'SCHEMA', N'dbo', 'TABLE', N'ResourcePool', 'COLUMN', N'Text1'
GO

EXECUTE sp_addextendedproperty N'MS_Description', N'Generic text column with max length', 'SCHEMA', N'dbo', 'TABLE', N'ResourcePool', 'COLUMN', N'Text2'
GO

/* ---------------------------------------------------------------------- */
/* Add table "CollectionSchedule"                                         */
/* ---------------------------------------------------------------------- */

CREATE TABLE [CollectionSchedule] (
	[ScheduleID] UNIQUEIDENTIFIER NOT NULL,
	[ScheduleName] NVARCHAR(256),
	[ScheduleDesc] NVARCHAR(max),
	[ScheduleExpression] NVARCHAR(64),
	[Flags] BIGINT,
	[Text1] NVARCHAR(256),
	[Text2] NVARCHAR(max),
	[FrequencyInMinutes] INTEGER,
	CONSTRAINT [PK_CollectionSchedule] PRIMARY KEY ([ScheduleID])
)
GO

EXECUTE sp_addextendedproperty N'MS_Description', N'Table to track the different Schedules required for collecting data from Hyeprvisors and Virtual Machines', 'SCHEMA', N'dbo', 'TABLE', N'CollectionSchedule', NULL, NULL
GO

EXECUTE sp_addextendedproperty N'MS_Description', N'Primary Key', 'SCHEMA', N'dbo', 'TABLE', N'CollectionSchedule', 'COLUMN', N'ScheduleID'
GO

EXECUTE sp_addextendedproperty N'MS_Description', N'Name of the Schedule', 'SCHEMA', N'dbo', 'TABLE', N'CollectionSchedule', 'COLUMN', N'ScheduleName'
GO

EXECUTE sp_addextendedproperty N'MS_Description', N'Description for the Schedule', 'SCHEMA', N'dbo', 'TABLE', N'CollectionSchedule', 'COLUMN', N'ScheduleDesc'
GO

EXECUTE sp_addextendedproperty N'MS_Description', N'CRON Expression for the schedule', 'SCHEMA', N'dbo', 'TABLE', N'CollectionSchedule', 'COLUMN', N'ScheduleExpression'
GO

EXECUTE sp_addextendedproperty N'MS_Description', N'Integer attribute which can be used for applying flags to the entity', 'SCHEMA', N'dbo', 'TABLE', N'CollectionSchedule', 'COLUMN', N'Flags'
GO

EXECUTE sp_addextendedproperty N'MS_Description', N'Generic text column with 256 bytes length', 'SCHEMA', N'dbo', 'TABLE', N'CollectionSchedule', 'COLUMN', N'Text1'
GO

EXECUTE sp_addextendedproperty N'MS_Description', N'Generic text column with max length', 'SCHEMA', N'dbo', 'TABLE', N'CollectionSchedule', 'COLUMN', N'Text2'
GO

/* ---------------------------------------------------------------------- */
/* Add table "EntityType"                                                 */
/* ---------------------------------------------------------------------- */

CREATE TABLE [EntityType] (
	[EntityTypeID] TINYINT NOT NULL,
	[EntityTypeName] NVARCHAR(128),
	[EntityTypeDesc] NVARCHAR(max),
	CONSTRAINT [PK_EntityType] PRIMARY KEY ([EntityTypeID])
)
GO

EXECUTE sp_addextendedproperty N'MS_Description', N'Enumerations for types of Entities that are stored in database schema e.g.  0   VM 1   Host 2   Cluster 3   StoragePath   etc ', 'SCHEMA', N'dbo', 'TABLE', N'EntityType', NULL, NULL
GO

EXECUTE sp_addextendedproperty N'MS_Description', N'Primary key', 'SCHEMA', N'dbo', 'TABLE', N'EntityType', 'COLUMN', N'EntityTypeID'
GO

EXECUTE sp_addextendedproperty N'MS_Description', N'Name for the Entity', 'SCHEMA', N'dbo', 'TABLE', N'EntityType', 'COLUMN', N'EntityTypeName'
GO

EXECUTE sp_addextendedproperty N'MS_Description', N'Description of the Entity', 'SCHEMA', N'dbo', 'TABLE', N'EntityType', 'COLUMN', N'EntityTypeDesc'
GO

/* ---------------------------------------------------------------------- */
/* Add table "RecAuditTimes"                                              */
/* ---------------------------------------------------------------------- */

CREATE TABLE [RecAuditTimes] (
	[RecCreationTime] DATETIME NOT NULL,
	[RecUpdateTime] DATETIME NOT NULL,
	[RecDeleteTime] DATETIME NOT NULL,
	CONSTRAINT [PK_RecAuditTimes] PRIMARY KEY ([RecCreationTime], [RecUpdateTime], [RecDeleteTime])
)
GO

/* ---------------------------------------------------------------------- */
/* Add table "HostToNetwork"                                              */
/* ---------------------------------------------------------------------- */

CREATE TABLE [HostToNetwork] (
	[NetworkID] UNIQUEIDENTIFIER NOT NULL,
	[HostID] UNIQUEIDENTIFIER NOT NULL,
	[EntityID] UNIQUEIDENTIFIER NOT NULL,
	CONSTRAINT [PK_HostToNetwork] PRIMARY KEY ([NetworkID], [HostID], [EntityID])
)
GO

/* ---------------------------------------------------------------------- */
/* Add table "HostToStorage"                                              */
/* ---------------------------------------------------------------------- */

CREATE TABLE [HostToStorage] (
	[HostToStorageID] UNIQUEIDENTIFIER NOT NULL,
	[HostID] UNIQUEIDENTIFIER NOT NULL,
	[StorageID] UNIQUEIDENTIFIER NOT NULL,
	[StorageCostProfileId] UNIQUEIDENTIFIER  NULL,
	[HostStorageReservationPolicyID] UNIQUEIDENTIFIER NULL,
	[StoragePath] NVARCHAR(256) NOT NULL,
	[Flags] BIGINT,
	CONSTRAINT [PK_HostToStorage] PRIMARY KEY ([HostToStorageID])
)
GO

CREATE NONCLUSTERED INDEX [IDX_HostToStorage_1] ON [HostToStorage] ([HostID])
GO

EXECUTE sp_addextendedproperty N'MS_Description', N'Association between host and storage paths', 'SCHEMA', N'dbo', 'TABLE', N'HostToStorage', NULL, NULL
GO

EXECUTE sp_addextendedproperty N'MS_Description', N'Primary key for the table', 'SCHEMA', N'dbo', 'TABLE', N'HostToStorage', 'COLUMN', N'HostToStorageID'
GO

EXECUTE sp_addextendedproperty N'MS_Description', N'Reference to host', 'SCHEMA', N'dbo', 'TABLE', N'HostToStorage', 'COLUMN', N'HostID'
GO

EXECUTE sp_addextendedproperty N'MS_Description', N'Reference to storage', 'SCHEMA', N'dbo', 'TABLE', N'HostToStorage', 'COLUMN', N'StorageID'
GO

EXECUTE sp_addextendedproperty N'MS_Description', N'Reference to reservation storage policy', 'SCHEMA', N'dbo', 'TABLE', N'HostStorageReservationPolicy', 'COLUMN', N'HostStorageReservationPolicyID'
GO

EXECUTE sp_addextendedproperty N'MS_Description', N'Name for the storage path if any', 'SCHEMA', N'dbo', 'TABLE', N'HostToStorage', 'COLUMN', N'StoragePath'
GO

/* ---------------------------------------------------------------------- */
/* Add table "PropertyDataType"                                           */
/* ---------------------------------------------------------------------- */

CREATE TABLE [PropertyDataType] (
	[PropertyDataTypeID] TINYINT NOT NULL,
	[PropertyDataTypeName] NVARCHAR(256),
	[PropertyDataTypeDesc] NVARCHAR(max),
	CONSTRAINT [PK_PropertyDataType] PRIMARY KEY ([PropertyDataTypeID])
)
GO

/* ---------------------------------------------------------------------- */
/* Add table "AdminGroupToHost"                                           */
/* ---------------------------------------------------------------------- */

CREATE TABLE [AdminGroupToHost] (
	[HostID] UNIQUEIDENTIFIER NOT NULL,
	[EnterpriseAdminID] UNIQUEIDENTIFIER NOT NULL,
	CONSTRAINT [PK_AdminGroupToHost] PRIMARY KEY ([HostID], [EnterpriseAdminID])
)
GO

EXECUTE sp_addextendedproperty N'MS_Description', N'Association of Enterprise Admin Group to Host or Cluster', 'SCHEMA', N'dbo', 'TABLE', N'AdminGroupToHost', NULL, NULL
GO

EXECUTE sp_addextendedproperty N'MS_Description', N'Reference to Host', 'SCHEMA', N'dbo', 'TABLE', N'AdminGroupToHost', 'COLUMN', N'HostID'
GO

EXECUTE sp_addextendedproperty N'MS_Description', N'Reference to Enterprise Admin Group', 'SCHEMA', N'dbo', 'TABLE', N'AdminGroupToHost', 'COLUMN', N'EnterpriseAdminID'
GO

/* ---------------------------------------------------------------------- */
/* Add table "AdminGroupMembers"                                          */
/* ---------------------------------------------------------------------- */

CREATE TABLE [AdminGroupMembers] (
	[EnterpriseAdminID] UNIQUEIDENTIFIER NOT NULL,
	[UserName] INT NOT NULL,
	CONSTRAINT [PK_AdminGroupMembers] PRIMARY KEY ([EnterpriseAdminID], [UserName])
)
GO

EXECUTE sp_addextendedproperty N'MS_Description', N'Tracks users in a enterprise admin group', 'SCHEMA', N'dbo', 'TABLE', N'AdminGroupMembers', NULL, NULL
GO

EXECUTE sp_addextendedproperty N'MS_Description', N'Reference to enterprise admin group', 'SCHEMA', N'dbo', 'TABLE', N'AdminGroupMembers', 'COLUMN', N'EnterpriseAdminID'
GO

/* ---------------------------------------------------------------------- */
/* Add table "HostUsage"                                                  */
/* ---------------------------------------------------------------------- */

CREATE TABLE [HostUsage] (
	[HostID] UNIQUEIDENTIFIER NOT NULL,
	[HostStateID] TINYINT NOT NULL,
	[HostTotalMemoryMB] BIGINT,
	[HostTotalStorageGB] BIGINT,
	[HostTimestamp] DATETIME NOT NULL,
	[HostUsedMemoryMB] BIGINT,
	[HostUsedStorageGB] BIGINT,
	CONSTRAINT [PK_HostUsage] PRIMARY KEY ([HostID], [HostTimestamp])
)
GO

EXECUTE sp_addextendedproperty N'MS_Description', N'This table tracks relatively more changing information about a host or cluster', 'SCHEMA', N'dbo', 'TABLE', N'HostUsage', NULL, NULL
GO

EXECUTE sp_addextendedproperty N'MS_Description', N'Reference to the host state', 'SCHEMA', N'dbo', 'TABLE', N'HostUsage', 'COLUMN', N'HostStateID'
GO

EXECUTE sp_addextendedproperty N'MS_Description', N'Total memory in the host. In case of cluster it is addition of all the memory in hosts that are making up the cluster', 'SCHEMA', N'dbo', 'TABLE', N'HostUsage', 'COLUMN', N'HostTotalMemoryMB'
GO

EXECUTE sp_addextendedproperty N'MS_Description', N'Total storage in a host. In case cluster this will be complicated and need to eliminate double counting', 'SCHEMA', N'dbo', 'TABLE', N'HostUsage', 'COLUMN', N'HostTotalStorageGB'
GO

/* ---------------------------------------------------------------------- */
/* Add table "HostToProxyAgent"                                           */
/* ---------------------------------------------------------------------- */

CREATE TABLE [HostToProxyAgent] (
	[HostID] UNIQUEIDENTIFIER NOT NULL,
	[ProxyAgentID] UNIQUEIDENTIFIER NOT NULL,
	[EntityID] UNIQUEIDENTIFIER NOT NULL,
	CONSTRAINT [PK_HostToProxyAgent] PRIMARY KEY ([HostID], [ProxyAgentID], [EntityID])
)
GO

/* ---------------------------------------------------------------------- */
/* Add table "Users"                                                      */
/* ---------------------------------------------------------------------- */

CREATE TABLE [Users] (
	[UserID] int IDENTITY(1,1) NOT NULL,
	[UserName] NVARCHAR(128) UNIQUE NOT NULL,
	[UserNameDescription] NVARCHAR(max),
	[GroupID] UNIQUEIDENTIFIER,
	CONSTRAINT [PK_Users] PRIMARY KEY ([UserID])
)
GO

EXECUTE sp_addextendedproperty N'MS_Description', N'Table to track users interacting with VRM. This is used in associating owners, members of the admin groups and provisioning groups etc', 'SCHEMA', N'dbo', 'TABLE', N'Users', NULL, NULL
GO

EXECUTE sp_addextendedproperty N'MS_Description', N'Name of the user includes domain of the user (e.g dynamicops\zmagdum)', 'SCHEMA', N'dbo', 'TABLE', N'Users', 'COLUMN', N'UserName'
GO

EXECUTE sp_addextendedproperty N'MS_Description', N'Description of the users', 'SCHEMA', N'dbo', 'TABLE', N'Users', 'COLUMN', N'UserNameDescription'
GO

EXECUTE sp_addextendedproperty N'MS_Description', N'Reference to the provisiong group to which user belong', 'SCHEMA', N'dbo', 'TABLE', N'Users', 'COLUMN', N'GroupID'
GO

/* ---------------------------------------------------------------------- */
/* Add table "Credential"                                                 */
/* ---------------------------------------------------------------------- */

CREATE TABLE [Credential] (
	[CredentialID] UNIQUEIDENTIFIER NOT NULL,
	[UserName] NVARCHAR(128) NOT NULL,
	[Domain] NVARCHAR(128),
	[Password] NVARCHAR(128),
	[Certificate] NVARCHAR(max),
	[CredentialName] NVARCHAR(128),
	[CredentialDescription] NVARCHAR(max),
	CONSTRAINT [PK_Credential] PRIMARY KEY ([CredentialID])
)
GO

EXECUTE sp_addextendedproperty N'MS_Description', N'Table to track the credentials required to communicate with Hypervisor Management Endpoints', 'SCHEMA', N'dbo', 'TABLE', N'Credential', NULL, NULL
GO

EXECUTE sp_addextendedproperty N'MS_Description', N'Primary Key', 'SCHEMA', N'dbo', 'TABLE', N'Credential', 'COLUMN', N'CredentialID'
GO

EXECUTE sp_addextendedproperty N'MS_Description', N'Name of the User', 'SCHEMA', N'dbo', 'TABLE', N'Credential', 'COLUMN', N'UserName'
GO

EXECUTE sp_addextendedproperty N'MS_Description', N'Domain of the User', 'SCHEMA', N'dbo', 'TABLE', N'Credential', 'COLUMN', N'Domain'
GO

EXECUTE sp_addextendedproperty N'MS_Description', N'Password for the account', 'SCHEMA', N'dbo', 'TABLE', N'Credential', 'COLUMN', N'Password'
GO

EXECUTE sp_addextendedproperty N'MS_Description', N'If Certificates are used to login then store it here', 'SCHEMA', N'dbo', 'TABLE', N'Credential', 'COLUMN', N'Certificate'
GO

/* ---------------------------------------------------------------------- */
/* Add table "DataSource"                                                 */
/* ---------------------------------------------------------------------- */

CREATE TABLE [DataSource] (
	[DataSourceID] UNIQUEIDENTIFIER NOT NULL,
	[DataSourceName] NVARCHAR(128),
	[DataSourceDescription] NVARCHAR(max),
	[DataSourceURI] NVARCHAR(256) NOT NULL,
	[CredentialID] UNIQUEIDENTIFIER,
	[DataSourceProperties] XML,
	CONSTRAINT [PK_DataSource] PRIMARY KEY ([DataSourceID])
)
GO

/* ---------------------------------------------------------------------- */
/* Add table "CollectionType"                                             */
/* ---------------------------------------------------------------------- */

CREATE TABLE [CollectionType] (
	[CollectionTypeID] UNIQUEIDENTIFIER NOT NULL,
	[CollectionTypeName] NVARCHAR(128),
	[CollectionTypeDesc] NVARCHAR(max),
	CONSTRAINT [PK_CollectionType] PRIMARY KEY ([CollectionTypeID])
)
GO

/* ---------------------------------------------------------------------- */
/* Add table "FilterSpec"                                                 */
/* ---------------------------------------------------------------------- */

CREATE TABLE [FilterSpec] (
	[FilterSpecID] UNIQUEIDENTIFIER NOT NULL,
	[FilterSpecName] NVARCHAR(255),
	[FilterSpecDesc] NVARCHAR(max),
	[FilterSpecNamespace] NVARCHAR(255),
	[FilterSpecPath] NVARCHAR(255),
	[FilterSpecQuery] NVARCHAR(max),
	[FilterSpecScript] NVARCHAR(max),
	[FilterSpecGroupID] UNIQUEIDENTIFIER NOT NULL,
	[AgentCapabilityName] NVARCHAR(128),
	CONSTRAINT [PK_FilterSpec] PRIMARY KEY ([FilterSpecID])
)
GO

EXECUTE sp_addextendedproperty N'MS_Description', N'Table tracks various paths/queries/scripts that need to run to collect data from virtual envoriments. There are mainly two providers of data (3.2) Running WMI queries against a VM and running SSH commands against a VM or Host  Agent will use this data to actual work of running queries and collecting data based on this path  Table will filled in with default set of data collection items but user can add more queries if necessary', 'SCHEMA', N'dbo', 'TABLE', N'FilterSpec', NULL, NULL
GO

EXECUTE sp_addextendedproperty N'MS_Description', N'Primary Key', 'SCHEMA', N'dbo', 'TABLE', N'FilterSpec', 'COLUMN', N'FilterSpecID'
GO

EXECUTE sp_addextendedproperty N'MS_Description', N'Name for the FIlter Spec', 'SCHEMA', N'dbo', 'TABLE', N'FilterSpec', 'COLUMN', N'FilterSpecName'
GO

EXECUTE sp_addextendedproperty N'MS_Description', N'Description for the filter Spec', 'SCHEMA', N'dbo', 'TABLE', N'FilterSpec', 'COLUMN', N'FilterSpecDesc'
GO

EXECUTE sp_addextendedproperty N'MS_Description', N'Namespace for WMI ', 'SCHEMA', N'dbo', 'TABLE', N'FilterSpec', 'COLUMN', N'FilterSpecNamespace'
GO

EXECUTE sp_addextendedproperty N'MS_Description', N'Object path for WMI queries', 'SCHEMA', N'dbo', 'TABLE', N'FilterSpec', 'COLUMN', N'FilterSpecPath'
GO

EXECUTE sp_addextendedproperty N'MS_Description', N'Queries to be used ', 'SCHEMA', N'dbo', 'TABLE', N'FilterSpec', 'COLUMN', N'FilterSpecQuery'
GO

EXECUTE sp_addextendedproperty N'MS_Description', N'Scripts to be used ', 'SCHEMA', N'dbo', 'TABLE', N'FilterSpec', 'COLUMN', N'FilterSpecScript'
GO

/* ---------------------------------------------------------------------- */
/* Add table "AgentWorkItem"                                              */
/* ---------------------------------------------------------------------- */

CREATE TABLE [AgentWorkItem] (
	[WorkItemID] UNIQUEIDENTIFIER NOT NULL,
	[WorkItemCreatedTime] TIMESTAMP,
	[FilterSpecGroupID] UNIQUEIDENTIFIER,
	[VirtualMachineID] UNIQUEIDENTIFIER,
	[WorkItemPickedByAgentID] UNIQUEIDENTIFIER,
	[WorkItemContent] NVARCHAR(max),
	[HostID] UNIQUEIDENTIFIER,
	[AgentCapabilityName] NVARCHAR(128),
	[Flags] BIGINT,
	[Text1] NVARCHAR(256),
	[Text2] NVARCHAR(max),
	[HypervisorManagementID] UNIQUEIDENTIFIER,
	CONSTRAINT [PK_AgentWorkItem] PRIMARY KEY ([WorkItemID])
)
GO

EXECUTE sp_addextendedproperty N'MS_Description', N'Table to track work to be done by agents. Manager Service will create different work items for different types of provisioning tasks. WorkItem will described and WorkItemContent which will also have configuration needed to run the work item.   Manager service will provide the workitem to appropriate agent based on what HostID or VirtualMachineID is associated, agent capability name(tag). Once a workitem is given to an agent its ID will be recorded in WorkItemPickedByAgentID column. WorkItem record will be deleted when agent responds with a response that it is done with command and posts results', 'SCHEMA', N'dbo', 'TABLE', N'AgentWorkItem', NULL, NULL
GO

EXECUTE sp_addextendedproperty N'MS_Description', N'Primary Key', 'SCHEMA', N'dbo', 'TABLE', N'AgentWorkItem', 'COLUMN', N'WorkItemID'
GO

EXECUTE sp_addextendedproperty N'MS_Description', N'Time when work item was created', 'SCHEMA', N'dbo', 'TABLE', N'AgentWorkItem', 'COLUMN', N'WorkItemCreatedTime'
GO

EXECUTE sp_addextendedproperty N'MS_Description', N'Reference to filter spec group', 'SCHEMA', N'dbo', 'TABLE', N'AgentWorkItem', 'COLUMN', N'FilterSpecGroupID'
GO

EXECUTE sp_addextendedproperty N'MS_Description', N'Reference to Virtual Machine', 'SCHEMA', N'dbo', 'TABLE', N'AgentWorkItem', 'COLUMN', N'VirtualMachineID'
GO

EXECUTE sp_addextendedproperty N'MS_Description', N'Which agent is performing tasks', 'SCHEMA', N'dbo', 'TABLE', N'AgentWorkItem', 'COLUMN', N'WorkItemPickedByAgentID'
GO

EXECUTE sp_addextendedproperty N'MS_Description', N'Content of the work item. This is XML definition of the work to be done by agent. This will also include configuration required by the agent', 'SCHEMA', N'dbo', 'TABLE', N'AgentWorkItem', 'COLUMN', N'WorkItemContent'
GO

EXECUTE sp_addextendedproperty N'MS_Description', N'Reference to the Host', 'SCHEMA', N'dbo', 'TABLE', N'AgentWorkItem', 'COLUMN', N'HostID'
GO

EXECUTE sp_addextendedproperty N'MS_Description', N'Name of the agent capability required to execute the commands specified in work item content', 'SCHEMA', N'dbo', 'TABLE', N'AgentWorkItem', 'COLUMN', N'AgentCapabilityName'
GO

EXECUTE sp_addextendedproperty N'MS_Description', N'Integer attribute which can be used for applying flags to the entity', 'SCHEMA', N'dbo', 'TABLE', N'AgentWorkItem', 'COLUMN', N'Flags'
GO

EXECUTE sp_addextendedproperty N'MS_Description', N'Generic text column with 256 bytes length', 'SCHEMA', N'dbo', 'TABLE', N'AgentWorkItem', 'COLUMN', N'Text1'
GO

EXECUTE sp_addextendedproperty N'MS_Description', N'Generic text column with max length', 'SCHEMA', N'dbo', 'TABLE', N'AgentWorkItem', 'COLUMN', N'Text2'
GO

/* ---------------------------------------------------------------------- */
/* Add table "FilterSchedule"                                             */
/* ---------------------------------------------------------------------- */

CREATE TABLE [FilterSchedule] (
	[FilterSpecGroupID] UNIQUEIDENTIFIER NOT NULL,
	[ScheduleID] UNIQUEIDENTIFIER NOT NULL,
	CONSTRAINT [PK_FilterSchedule] PRIMARY KEY ([FilterSpecGroupID], [ScheduleID])
)
GO

EXECUTE sp_addextendedproperty N'MS_Description', N'Table to track schedules for different filter spec groups to be run by the agents', 'SCHEMA', N'dbo', 'TABLE', N'FilterSchedule', NULL, NULL
GO

EXECUTE sp_addextendedproperty N'MS_Description', N'Reference to FilterSpecGroup', 'SCHEMA', N'dbo', 'TABLE', N'FilterSchedule', 'COLUMN', N'FilterSpecGroupID'
GO

EXECUTE sp_addextendedproperty N'MS_Description', N'Reference to schedule', 'SCHEMA', N'dbo', 'TABLE', N'FilterSchedule', 'COLUMN', N'ScheduleID'
GO

/* ---------------------------------------------------------------------- */
/* Add table "FilterSpecGroup"                                            */
/* ---------------------------------------------------------------------- */

CREATE TABLE [FilterSpecGroup] (
	[FilterSpecGroupID] UNIQUEIDENTIFIER NOT NULL,
	[FilterSpecGroupName] NVARCHAR(128),
	[FilterSpecGroupDesc] NVARCHAR(max),
	[ScheduleID] UNIQUEIDENTIFIER,
	[DependsOnFilterSpecGroupID] UNIQUEIDENTIFIER,
	CONSTRAINT [PK_FilterSpecGroup] PRIMARY KEY ([FilterSpecGroupID])
)
GO

EXECUTE sp_addextendedproperty N'MS_Description', N'Table to Group different specs so that Schedule can be applied to the Group', 'SCHEMA', N'dbo', 'TABLE', N'FilterSpecGroup', NULL, NULL
GO

EXECUTE sp_addextendedproperty N'MS_Description', N'Primary Key', 'SCHEMA', N'dbo', 'TABLE', N'FilterSpecGroup', 'COLUMN', N'FilterSpecGroupID'
GO

EXECUTE sp_addextendedproperty N'MS_Description', N'Name for the filterspec group', 'SCHEMA', N'dbo', 'TABLE', N'FilterSpecGroup', 'COLUMN', N'FilterSpecGroupName'
GO

EXECUTE sp_addextendedproperty N'MS_Description', N'Description for the filter spec', 'SCHEMA', N'dbo', 'TABLE', N'FilterSpecGroup', 'COLUMN', N'FilterSpecGroupDesc'
GO

/* ---------------------------------------------------------------------- */
/* Add table "CredentialAssoc"                                            */
/* ---------------------------------------------------------------------- */

CREATE TABLE [CredentialAssoc] (
	[CredentialAssocID] UNIQUEIDENTIFIER NOT NULL,
	[CredentialID] UNIQUEIDENTIFIER,
	[GroupID] UNIQUEIDENTIFIER,
	[VirtualMachineTemplateID] UNIQUEIDENTIFIER,
	[CredentialAssocName] NVARCHAR(128),
	[AgentID] UNIQUEIDENTIFIER,
	CONSTRAINT [PK_CredentialAssoc] PRIMARY KEY ([CredentialAssocID])
)
GO

EXECUTE sp_addextendedproperty N'MS_Description', N'Table to associate credentials to groups or Blueprints. The credentials are used to log on to VM by agents(WMI or SSH). Can store one Global credentials or per group or per Blueprint. if there is credential stored for template then it will be used first, if there is one stored for the group then it will be used next or global credential will be used', 'SCHEMA', N'dbo', 'TABLE', N'CredentialAssoc', NULL, NULL
GO

EXECUTE sp_addextendedproperty N'MS_Description', N'Reference to Credential', 'SCHEMA', N'dbo', 'TABLE', N'CredentialAssoc', 'COLUMN', N'CredentialID'
GO

EXECUTE sp_addextendedproperty N'MS_Description', N'Reference to the Group', 'SCHEMA', N'dbo', 'TABLE', N'CredentialAssoc', 'COLUMN', N'GroupID'
GO

EXECUTE sp_addextendedproperty N'MS_Description', N'Reference to Blueprint', 'SCHEMA', N'dbo', 'TABLE', N'CredentialAssoc', 'COLUMN', N'VirtualMachineTemplateID'
GO

EXECUTE sp_addextendedproperty N'MS_Description', N'Name for the credentials association if any.', 'SCHEMA', N'dbo', 'TABLE', N'CredentialAssoc', 'COLUMN', N'CredentialAssocName'
GO

/* ---------------------------------------------------------------------- */
/* Add table "HypervisorManagementEndpoint"                               */
/* ---------------------------------------------------------------------- */

CREATE TABLE [HypervisorManagementEndpoint] (
	[HypervisorManagementID] UNIQUEIDENTIFIER NOT NULL,
	[HypervisorManagementURL] NVARCHAR(256),
	[HypervisorManagementDescription] NVARCHAR(max),
	[CredentialID] UNIQUEIDENTIFIER,
	[HypervisorAgentID] UNIQUEIDENTIFIER,
	[MonitoringAgentID] UNIQUEIDENTIFIER,
	[HypervisorTypeID] TINYINT,
	[ProvisioningEnabled] BIT,
	[DataCenterName] NVARCHAR(128),
	[Flags] BIGINT,
	[Text1] NVARCHAR(256),
	[Text2] NVARCHAR(max),
	[HypervisorName] NVARCHAR(256),
	CONSTRAINT [PK_HypervisorManagementEndpoint] PRIMARY KEY ([HypervisorManagementID])
)
GO

EXECUTE sp_addextendedproperty N'MS_Description', N'Table captures defintion required to communicate with hypervisor management server. For VMWARE this is VirtualCenter and  for Xen and Hyper-V this is server on which virtualization is running.  VRM use will create these entries(through UI) to register different management endpoints.  As soon as a record is created in this table we need to create a workitem for agent to collect of virtualization environment objects and report that to VRM', 'SCHEMA', N'dbo', 'TABLE', N'HypervisorManagementEndpoint', NULL, NULL
GO

EXECUTE sp_addextendedproperty N'MS_Description', N'Primary Key', 'SCHEMA', N'dbo', 'TABLE', N'HypervisorManagementEndpoint', 'COLUMN', N'HypervisorManagementID'
GO

EXECUTE sp_addextendedproperty N'MS_Description', N'URL to connect to hypervisor management endpoint', 'SCHEMA', N'dbo', 'TABLE', N'HypervisorManagementEndpoint', 'COLUMN', N'HypervisorManagementURL'
GO

EXECUTE sp_addextendedproperty N'MS_Description', N'Description for the management endpoint', 'SCHEMA', N'dbo', 'TABLE', N'HypervisorManagementEndpoint', 'COLUMN', N'HypervisorManagementDescription'
GO

EXECUTE sp_addextendedproperty N'MS_Description', N'Reference to the Credential to be used by agent to communicate with hypervisor', 'SCHEMA', N'dbo', 'TABLE', N'HypervisorManagementEndpoint', 'COLUMN', N'CredentialID'
GO

EXECUTE sp_addextendedproperty N'MS_Description', N'Hypervisor agent to be used for running provisiong commands on the hypervisor(s) provided by management endpoint.', 'SCHEMA', N'dbo', 'TABLE', N'HypervisorManagementEndpoint', 'COLUMN', N'HypervisorAgentID'
GO

EXECUTE sp_addextendedproperty N'MS_Description', N'Monitoring agent to be used for the monitoring management endpoint and all inventory objects that are discovered by talking to management endpoint. This could be null and agent pointed by HpervisorAgentID will also be used for monitoring', 'SCHEMA', N'dbo', 'TABLE', N'HypervisorManagementEndpoint', 'COLUMN', N'MonitoringAgentID'
GO

EXECUTE sp_addextendedproperty N'MS_Description', N'Reference to type of hyeprvisor', 'SCHEMA', N'dbo', 'TABLE', N'HypervisorManagementEndpoint', 'COLUMN', N'HypervisorTypeID'
GO

EXECUTE sp_addextendedproperty N'MS_Description', N'Whether provisioning is enabled for all the objects provisioned by management endpoint. This bit could be used if provisioning against particular virtual center needs to be disabled for time being', 'SCHEMA', N'dbo', 'TABLE', N'HypervisorManagementEndpoint', 'COLUMN', N'ProvisioningEnabled'
GO

EXECUTE sp_addextendedproperty N'MS_Description', N'Name of the data center for the the Virtual Center. This is specific to VMWare. There are many  Data Centers withing a VirtualCenter and we need to be able to use credentials for particular data center ', 'SCHEMA', N'dbo', 'TABLE', N'HypervisorManagementEndpoint', 'COLUMN', N'DataCenterName'
GO

EXECUTE sp_addextendedproperty N'MS_Description', N'Integer attribute which can be used for applying flags to the entity', 'SCHEMA', N'dbo', 'TABLE', N'HypervisorManagementEndpoint', 'COLUMN', N'Flags'
GO

EXECUTE sp_addextendedproperty N'MS_Description', N'Generic text column with 256 bytes length', 'SCHEMA', N'dbo', 'TABLE', N'HypervisorManagementEndpoint', 'COLUMN', N'Text1'
GO

EXECUTE sp_addextendedproperty N'MS_Description', N'Generic text column with max length', 'SCHEMA', N'dbo', 'TABLE', N'HypervisorManagementEndpoint', 'COLUMN', N'Text2'
GO

/* ---------------------------------------------------------------------- */
/* Add table "Agent"                                                      */
/* ---------------------------------------------------------------------- */

CREATE TABLE [Agent] (
	[AgentID] UNIQUEIDENTIFIER NOT NULL,
	[AgentHostName] NVARCHAR(128) NOT NULL,
	[AgentDescription] NVARCHAR(max),
	[AgentVersion] NVARCHAR(64),
	[AgentName] NVARCHAR(128) NOT NULL,
	[AgentGeneratedID] UNIQUEIDENTIFIER,
	[AgentAlive] BIT,
	[WorkItemsProcessed] BIGINT,
	[ManagesAll] BIT,
	[LastAccessed] DATETIME,
	[Flags] BIGINT,
	[Text1] NVARCHAR(256),
	[Text2] NVARCHAR(max),
	CONSTRAINT [PK_Agent] PRIMARY KEY ([AgentID])
)
GO

EXECUTE sp_addextendedproperty N'MS_Description', N'Table for listing all the agents. Agents are run for doing different tasks. Each VRM agent when it starts should send it''s ID and some other information to VRM so that it can register in VRM environment. Once registered VRM can assign different work items for it to run. Agent also report what it is capable of and this information is used while running an activity within workflow for choosing and agent to do work', 'SCHEMA', N'dbo', 'TABLE', N'Agent', NULL, NULL
GO

EXECUTE sp_addextendedproperty N'MS_Description', N'Primary Key', 'SCHEMA', N'dbo', 'TABLE', N'Agent', 'COLUMN', N'AgentID'
GO

EXECUTE sp_addextendedproperty N'MS_Description', N'Host where agent is running', 'SCHEMA', N'dbo', 'TABLE', N'Agent', 'COLUMN', N'AgentHostName'
GO

EXECUTE sp_addextendedproperty N'MS_Description', N'Version of the agent code', 'SCHEMA', N'dbo', 'TABLE', N'Agent', 'COLUMN', N'AgentVersion'
GO

EXECUTE sp_addextendedproperty N'MS_Description', N'Name of the Agent', 'SCHEMA', N'dbo', 'TABLE', N'Agent', 'COLUMN', N'AgentName'
GO

EXECUTE sp_addextendedproperty N'MS_Description', N'Unique identifier provided by the agent for itself', 'SCHEMA', N'dbo', 'TABLE', N'Agent', 'COLUMN', N'AgentGeneratedID'
GO

EXECUTE sp_addextendedproperty N'MS_Description', N'Whether agent is alive', 'SCHEMA', N'dbo', 'TABLE', N'Agent', 'COLUMN', N'AgentAlive'
GO

EXECUTE sp_addextendedproperty N'MS_Description', N'Number of work items processed by agent', 'SCHEMA', N'dbo', 'TABLE', N'Agent', 'COLUMN', N'WorkItemsProcessed'
GO

EXECUTE sp_addextendedproperty N'MS_Description', N'Bit indicating whether agent manages all the entities by default.', 'SCHEMA', N'dbo', 'TABLE', N'Agent', 'COLUMN', N'ManagesAll'
GO

EXECUTE sp_addextendedproperty N'MS_Description', N'Integer attribute which can be used for applying flags to the entity', 'SCHEMA', N'dbo', 'TABLE', N'Agent', 'COLUMN', N'Flags'
GO

EXECUTE sp_addextendedproperty N'MS_Description', N'Generic text column with 256 bytes length', 'SCHEMA', N'dbo', 'TABLE', N'Agent', 'COLUMN', N'Text1'
GO

EXECUTE sp_addextendedproperty N'MS_Description', N'Generic text column with max length', 'SCHEMA', N'dbo', 'TABLE', N'Agent', 'COLUMN', N'Text2'
GO

/* ---------------------------------------------------------------------- */
/* Add table "HostToAgent"                                                */
/* ---------------------------------------------------------------------- */

CREATE TABLE [HostToAgent] (
	[AgentID] UNIQUEIDENTIFIER NOT NULL,
	[HostID] UNIQUEIDENTIFIER NOT NULL,
	CONSTRAINT [PK_HostToAgent] PRIMARY KEY ([AgentID], [HostID])
)
GO

EXECUTE sp_addextendedproperty N'MS_Description', N'Table for associating Agent and Host. If different provisioning tasks on Hosts or on VMs that are on the Host need to be done by specific host then this associated must be created', 'SCHEMA', N'dbo', 'TABLE', N'HostToAgent', NULL, NULL
GO

/* ---------------------------------------------------------------------- */
/* Add table "HostsInHypervisor"                                          */
/* ---------------------------------------------------------------------- */

CREATE TABLE [HostsInHypervisor] (
	[HypervisorManagementID] UNIQUEIDENTIFIER NOT NULL,
	[HostID] UNIQUEIDENTIFIER NOT NULL,
	CONSTRAINT [PK_HostsInHypervisor] PRIMARY KEY ([HypervisorManagementID], [HostID])
)
GO

EXECUTE sp_addextendedproperty N'MS_Description', N'Associates Host and HypervisorManagementEndpoint', 'SCHEMA', N'dbo', 'TABLE', N'HostsInHypervisor', NULL, NULL
GO

EXECUTE sp_addextendedproperty N'MS_Description', N'Reference to HypervisorManagementEndpoint', 'SCHEMA', N'dbo', 'TABLE', N'HostsInHypervisor', 'COLUMN', N'HypervisorManagementID'
GO

EXECUTE sp_addextendedproperty N'MS_Description', N'Reference to Host', 'SCHEMA', N'dbo', 'TABLE', N'HostsInHypervisor', 'COLUMN', N'HostID'
GO

/* ---------------------------------------------------------------------- */
/* Add table "HypervisorType"                                             */
/* ---------------------------------------------------------------------- */

CREATE TABLE [HypervisorType] (
	[HypervisorTypeID] TINYINT NOT NULL,
	[HypervisorTypeName] NVARCHAR(128),
	[HypervisorTypeDec] NVARCHAR(max),
	CONSTRAINT [PK_HypervisorType] PRIMARY KEY ([HypervisorTypeID])
)
GO

EXECUTE sp_addextendedproperty N'MS_Description', N'Enumeration  for different hypervisor types e.g.  0   VMWARE 1   XEN 2   HYPER-V', 'SCHEMA', N'dbo', 'TABLE', N'HypervisorType', NULL, NULL
GO

/* ---------------------------------------------------------------------- */
/* Add table "HostNicToReservation"                                       */
/* ---------------------------------------------------------------------- */

CREATE TABLE [HostNicToReservation] (
	[HostReservationID] UNIQUEIDENTIFIER NOT NULL,
	[HostNicID] UNIQUEIDENTIFIER NOT NULL,
        [StaticIPv4NetworkProfileID] UNIQUEIDENTIFIER, 
	CONSTRAINT [PK_HostNicToReservation] PRIMARY KEY ([HostReservationID], [HostNicID])
)
GO

EXECUTE sp_addextendedproperty N'MS_Description', N'Association table to store relationship between HostNic and HostReservation Records', 'SCHEMA', N'dbo', 'TABLE', N'HostNicToReservation', NULL, NULL
GO

EXECUTE sp_addextendedproperty N'MS_Description', N'Reference to reservation record', 'SCHEMA', N'dbo', 'TABLE', N'HostNicToReservation', 'COLUMN', N'HostReservationID'
GO

EXECUTE sp_addextendedproperty N'MS_Description', N'Reference to HostNic record', 'SCHEMA', N'dbo', 'TABLE', N'HostNicToReservation', 'COLUMN', N'HostNicID'
GO

/* ---------------------------------------------------------------------- */
/* Add table "HostReservationToStorage"                                   */
/* ---------------------------------------------------------------------- */

CREATE TABLE [HostReservationToStorage] (
	[HostReservationToStorageID] UNIQUEIDENTIFIER NOT NULL,
	[HostReservationID] UNIQUEIDENTIFIER NOT NULL,
	[MaxVMsAttachedStorage] INTEGER,
	[ReservationPriority] INTEGER,
	[Enabled] BIT,
	[MaxCapacity] BIGINT,
	[Flags] BIGINT,
	[HostToStorageID] UNIQUEIDENTIFIER,
	[IsFileLevelCloneEnabled] BIT,
	[HostStorageReservationPolicyID] UNIQUEIDENTIFIER NULL,
	CONSTRAINT [PK_HostReservationToStorage] PRIMARY KEY ([HostReservationToStorageID])
)
GO


/* ---------------------------------------------------------------------- */
/* Add table "Tag"                                                        */
/* ---------------------------------------------------------------------- */

CREATE TABLE [Tag] (
	[TagID] UNIQUEIDENTIFIER NOT NULL,
	[TagName] NVARCHAR(128),
	[TagDesc] NVARCHAR(max),
	CONSTRAINT [PK_Tag] PRIMARY KEY ([TagID])
)
GO

EXECUTE sp_addextendedproperty N'MS_Description', N'Table to collect tags that can be associated with different entities within VRM', 'SCHEMA', N'dbo', 'TABLE', N'Tag', NULL, NULL
GO

EXECUTE sp_addextendedproperty N'MS_Description', N'Primary Key', 'SCHEMA', N'dbo', 'TABLE', N'Tag', 'COLUMN', N'TagID'
GO

EXECUTE sp_addextendedproperty N'MS_Description', N'Name of the tag', 'SCHEMA', N'dbo', 'TABLE', N'Tag', 'COLUMN', N'TagName'
GO

EXECUTE sp_addextendedproperty N'MS_Description', N'Comments for the tag', 'SCHEMA', N'dbo', 'TABLE', N'Tag', 'COLUMN', N'TagDesc'
GO

/* ---------------------------------------------------------------------- */
/* Add table "TagToEntity"                                                */
/* ---------------------------------------------------------------------- */

CREATE TABLE [TagToEntity] (
	[TagID] UNIQUEIDENTIFIER NOT NULL,
	[EntityID] UNIQUEIDENTIFIER NOT NULL,
	CONSTRAINT [PK_TagToEntity] PRIMARY KEY ([TagID], [EntityID])
)
GO

EXECUTE sp_addextendedproperty N'MS_Description', N'Association of various tags to the entities in VRM', 'SCHEMA', N'dbo', 'TABLE', N'TagToEntity', NULL, NULL
GO

EXECUTE sp_addextendedproperty N'MS_Description', N'Reference to tag', 'SCHEMA', N'dbo', 'TABLE', N'TagToEntity', 'COLUMN', N'TagID'
GO

EXECUTE sp_addextendedproperty N'MS_Description', N'Reference to entity', 'SCHEMA', N'dbo', 'TABLE', N'TagToEntity', 'COLUMN', N'EntityID'
GO

/* ---------------------------------------------------------------------- */
/* Add table "AgentCapabilities"                                          */
/* ---------------------------------------------------------------------- */

CREATE TABLE [AgentCapabilities] (
	[AgentID] UNIQUEIDENTIFIER NOT NULL,
	[AgentCapabilityName] NVARCHAR(128) NOT NULL,
	[AgentCapDesc] NVARCHAR(max),
	CONSTRAINT [PK_AgentCapabilities] PRIMARY KEY ([AgentID], [AgentCapabilityName])
)
GO

EXECUTE sp_addextendedproperty N'MS_Description', N'Table lists capabilities of an agent', 'SCHEMA', N'dbo', 'TABLE', N'AgentCapabilities', NULL, NULL
GO

EXECUTE sp_addextendedproperty N'MS_Description', N'Primary key', 'SCHEMA', N'dbo', 'TABLE', N'AgentCapabilities', 'COLUMN', N'AgentID'
GO

EXECUTE sp_addextendedproperty N'MS_Description', N'Name of the Capability', 'SCHEMA', N'dbo', 'TABLE', N'AgentCapabilities', 'COLUMN', N'AgentCapabilityName'
GO

EXECUTE sp_addextendedproperty N'MS_Description', N'Description of the Capability', 'SCHEMA', N'dbo', 'TABLE', N'AgentCapabilities', 'COLUMN', N'AgentCapDesc'
GO

/* ---------------------------------------------------------------------- */
/* Add table "AgentCapabilityType"                                        */
/* ---------------------------------------------------------------------- */

CREATE TABLE [AgentCapabilityType] (
	[AgentCapabilityName] NVARCHAR(128) NOT NULL,
	CONSTRAINT [PK_AgentCapabilityType] PRIMARY KEY ([AgentCapabilityName])
)
GO

EXECUTE sp_addextendedproperty N'MS_Description', N'Table providing tagging of different things that agent can do. This is at a higher level. e.g  ESX  XEN  HYPERV LDAP  etc', 'SCHEMA', N'dbo', 'TABLE', N'AgentCapabilityType', NULL, NULL
GO

/* ---------------------------------------------------------------------- */
/* Add table "VMToNetwork"                                                */
/* ---------------------------------------------------------------------- */

CREATE TABLE [VMToNetwork] (
	[VirtualMachineID] UNIQUEIDENTIFIER CONSTRAINT [DEF_VMToNetwork_VirtualMachineID] DEFAULT '0' NOT NULL,
	[HostNicID] UNIQUEIDENTIFIER NOT NULL,
	[NetworkOrder] INTEGER,
	[VMToNetworkID] UNIQUEIDENTIFIER NOT NULL,
	[MacAddress] NVARCHAR(256) NULL,
	CONSTRAINT [PK_VMToNetwork] PRIMARY KEY ([VMToNetworkID])
)
GO

EXECUTE sp_addextendedproperty N'MS_Description', N'Association table to associated networks to virtual machines. This is many to many relationship', 'SCHEMA', N'dbo', 'TABLE', N'VMToNetwork', NULL, NULL
GO

EXECUTE sp_addextendedproperty N'MS_Description', N'Reference to VirtualMachine', 'SCHEMA', N'dbo', 'TABLE', N'VMToNetwork', 'COLUMN', N'VirtualMachineID'
GO

EXECUTE sp_addextendedproperty N'MS_Description', N'Reference to HostNic which has network name', 'SCHEMA', N'dbo', 'TABLE', N'VMToNetwork', 'COLUMN', N'HostNicID'
GO

EXECUTE sp_addextendedproperty N'MS_Description', N'Mac Address of network card', 'SCHEMA', N'dbo', 'TABLE', N'VMToNetwork', 'COLUMN', N'MacAddress'
GO

/* ---------------------------------------------------------------------- */
/* Add table "VMDiskHardware"                                             */
/* ---------------------------------------------------------------------- */

CREATE TABLE [VMDiskHardware] (
	[VMToStorageID] UNIQUEIDENTIFIER NOT NULL,
	[VirtualMachineID] UNIQUEIDENTIFIER,
	[Capacity] BIGINT,
	[DiskName] NVARCHAR(256),
	[Text1] NVARCHAR(256),
	[Text2] NVARCHAR(max),
	[HostToStorageID] UNIQUEIDENTIFIER,
    [UsedCapacity] BIGINT,
	[ExternalDiskID] NVARCHAR(256),
	[DeviceID] NVARCHAR(256),
	[IsFixed] bit DEFAULT 0 NOT NULL
CONSTRAINT [PK_VMDiskHardware] PRIMARY KEY ([VMToStorageID])
)
GO

CREATE NONCLUSTERED INDEX [IDX_VMDiskHardware_1] ON [VMDiskHardware] ([VirtualMachineID])
GO

EXECUTE sp_addextendedproperty N'MS_Description', N'Generic text column with 256 bytes length', 'SCHEMA', N'dbo', 'TABLE', N'VMDiskHardware', 'COLUMN', N'Text1'
GO

EXECUTE sp_addextendedproperty N'MS_Description', N'Generic text column with max length', 'SCHEMA', N'dbo', 'TABLE', N'VMDiskHardware', 'COLUMN', N'Text2'
GO

/* ---------------------------------------------------------------------- */
/* Add table "VMDiskHardwareHistory"                                             */
/* ---------------------------------------------------------------------- */

CREATE TABLE [VMDiskHardwareHistory] (	
	[VMToStorageID] UNIQUEIDENTIFIER NOT NULL,	
	[VirtualMachineID] UNIQUEIDENTIFIER,	
	[Capacity] BIGINT,	[DiskName] NVARCHAR(256),	
	[Text1] NVARCHAR(256),	
	[Text2] NVARCHAR(max),	
	[HostToStorageID] UNIQUEIDENTIFIER,	
    [UsedCapacity] BIGINT,
	[ExternalDiskID] NVARCHAR(256),
	[DeviceID] NVARCHAR(256),
	[IsFixed] bit DEFAULT 0 NOT NULL
CONSTRAINT [PK_VMDiskHardwareHistory] PRIMARY KEY ([VMToStorageID]))
GO

CREATE NONCLUSTERED INDEX [IDX_VMDiskHardware_1] ON [VMDiskHardwareHistory] ([VirtualMachineID])
GO

EXECUTE sp_addextendedproperty N'MS_Description', N'Generic text column with 256 bytes length', 'SCHEMA', N'dbo', 'TABLE', N'VMDiskHardwareHistory', 'COLUMN', N'Text1'
GO

EXECUTE sp_addextendedproperty N'MS_Description', N'Generic text column with max length', 'SCHEMA', N'dbo', 'TABLE', N'VMDiskHardwareHistory', 'COLUMN', N'Text2'
GO

/* ---------------------------------------------------------------------- */
/* Add table "VMLogicalDisk"                                              */
/* ---------------------------------------------------------------------- */
CREATE TABLE [VMLogicalDisk] (
	[VMLogicalDiskID] UNIQUEIDENTIFIER NOT NULL,
	[VMLogicalDiskName] NVARCHAR(128),
	[VMLogicalTotalCapacityGB] BIGINT,
	[VMLogicalUsedCapacityGB] BIGINT,
	[VirtualMachineID] UNIQUEIDENTIFIER,
	[VMLogicalDiskUniqueID] NVARCHAR(128),
	CONSTRAINT [PK_VMLogicalDisk] PRIMARY KEY ([VMLogicalDiskID])
)
GO

CREATE NONCLUSTERED INDEX [IDX_VMLogicalDisk_1] ON [VMLogicalDisk] ([VirtualMachineID])
GO

EXECUTE sp_addextendedproperty N'MS_Description', N'Tracks logical drives ( or file systems ) within a VM. ', 'SCHEMA', N'dbo', 'TABLE', N'VMLogicalDisk', NULL, NULL
GO

EXECUTE sp_addextendedproperty N'MS_Description', N'primary key', 'SCHEMA', N'dbo', 'TABLE', N'VMLogicalDisk', 'COLUMN', N'VMLogicalDiskID'
GO

EXECUTE sp_addextendedproperty N'MS_Description', N'Name of the logical disk e.g. c:, d: etc ', 'SCHEMA', N'dbo', 'TABLE', N'VMLogicalDisk', 'COLUMN', N'VMLogicalDiskName'
GO

EXECUTE sp_addextendedproperty N'MS_Description', N'Size of the logical disk in GB', 'SCHEMA', N'dbo', 'TABLE', N'VMLogicalDisk', 'COLUMN', N'VMLogicalTotalCapacityGB'
GO

EXECUTE sp_addextendedproperty N'MS_Description', N'Free capacity of the logical disk in GB', 'SCHEMA', N'dbo', 'TABLE', N'VMLogicalDisk', 'COLUMN', N'VMLogicalUsedCapacityGB'
GO

EXECUTE sp_addextendedproperty N'MS_Description', N'Reference to VM', 'SCHEMA', N'dbo', 'TABLE', N'VMLogicalDisk', 'COLUMN', N'VirtualMachineID'
GO

EXECUTE sp_addextendedproperty N'MS_Description', N'Unique ID of the Logical disk. This could be just name', 'SCHEMA', N'dbo', 'TABLE', N'VMLogicalDisk', 'COLUMN', N'VMLogicalDiskUniqueID'
GO

/* ---------------------------------------------------------------------- */
/* Add table "PropertyListItem"                                           */
/* ---------------------------------------------------------------------- */

CREATE TABLE [PropertyListItem] (
	[AttrListItemID] TINYINT NOT NULL,
	[AttrListItemValue] NVARCHAR(256),
	[AttrListItemDesc] NVARCHAR(max),
	[AttrValueListID] TINYINT NOT NULL,
	CONSTRAINT [PK_PropertyListItem] PRIMARY KEY ([AttrListItemID], [AttrValueListID])
)
GO

EXECUTE sp_addextendedproperty N'MS_Description', N'Table to capture all the enumerations required to constraint data for an attribute', 'SCHEMA', N'dbo', 'TABLE', N'PropertyListItem', NULL, NULL
GO

EXECUTE sp_addextendedproperty N'MS_Description', N'Primary key for enumeration', 'SCHEMA', N'dbo', 'TABLE', N'PropertyListItem', 'COLUMN', N'AttrListItemID'
GO

EXECUTE sp_addextendedproperty N'MS_Description', N'String(Display) value of the enumeration', 'SCHEMA', N'dbo', 'TABLE', N'PropertyListItem', 'COLUMN', N'AttrListItemValue'
GO

EXECUTE sp_addextendedproperty N'MS_Description', N'Description for the enumerated value', 'SCHEMA', N'dbo', 'TABLE', N'PropertyListItem', 'COLUMN', N'AttrListItemDesc'
GO

EXECUTE sp_addextendedproperty N'MS_Description', N'Reference to list which this item belongs', 'SCHEMA', N'dbo', 'TABLE', N'PropertyListItem', 'COLUMN', N'AttrValueListID'
GO

/* ---------------------------------------------------------------------- */
/* Add table "PropertyValueList"                                          */
/* ---------------------------------------------------------------------- */

CREATE TABLE [PropertyValueList] (
	[AttrValueListID] TINYINT NOT NULL,
	[AttrValueListName] NVARCHAR(128),
	[AttrValueListDesc] NVARCHAR(max),
	CONSTRAINT [PK_PropertyValueList] PRIMARY KEY ([AttrValueListID])
)
GO

EXECUTE sp_addextendedproperty N'MS_Description', N'Table to capture all the lists required to constraint data for an attribute', 'SCHEMA', N'dbo', 'TABLE', N'PropertyValueList', NULL, NULL
GO

EXECUTE sp_addextendedproperty N'MS_Description', N'Primary Key', 'SCHEMA', N'dbo', 'TABLE', N'PropertyValueList', 'COLUMN', N'AttrValueListID'
GO

EXECUTE sp_addextendedproperty N'MS_Description', N'Name for the List', 'SCHEMA', N'dbo', 'TABLE', N'PropertyValueList', 'COLUMN', N'AttrValueListName'
GO

EXECUTE sp_addextendedproperty N'MS_Description', N'Description of the List', 'SCHEMA', N'dbo', 'TABLE', N'PropertyValueList', 'COLUMN', N'AttrValueListDesc'
GO

/* ---------------------------------------------------------------------- */
/* Add table "PropertyCatalog"                                            */
/* ---------------------------------------------------------------------- */

CREATE TABLE [PropertyCatalog] (
	[PropertyID] TINYINT NOT NULL,
	[PropertyName] NVARCHAR(128),
	[PropertyDesc] NVARCHAR(max),
	[AttrValueListID] TINYINT,
	[AttrPartitionKey] INTEGER NOT NULL,
	[PropertyDataTypeID] TINYINT,
	[PropertyGroupID] TINYINT,
	CONSTRAINT [PK_PropertyCatalog] PRIMARY KEY ([PropertyID], [AttrPartitionKey])
)
GO

EXECUTE sp_addextendedproperty N'MS_Description', N'Defintion of an attribute(column) for an entity', 'SCHEMA', N'dbo', 'TABLE', N'PropertyCatalog', NULL, NULL
GO

EXECUTE sp_addextendedproperty N'MS_Description', N'Primary Key', 'SCHEMA', N'dbo', 'TABLE', N'PropertyCatalog', 'COLUMN', N'PropertyID'
GO

EXECUTE sp_addextendedproperty N'MS_Description', N'Name for the attribute', 'SCHEMA', N'dbo', 'TABLE', N'PropertyCatalog', 'COLUMN', N'PropertyName'
GO

EXECUTE sp_addextendedproperty N'MS_Description', N'Description of the attribute', 'SCHEMA', N'dbo', 'TABLE', N'PropertyCatalog', 'COLUMN', N'PropertyDesc'
GO

EXECUTE sp_addextendedproperty N'MS_Description', N'Reference to the list if values are enumerations', 'SCHEMA', N'dbo', 'TABLE', N'PropertyCatalog', 'COLUMN', N'AttrValueListID'
GO

EXECUTE sp_addextendedproperty N'MS_Description', N'Key on which partition of table can depend on', 'SCHEMA', N'dbo', 'TABLE', N'PropertyCatalog', 'COLUMN', N'AttrPartitionKey'
GO

/* ---------------------------------------------------------------------- */
/* Add table "PropertyValue"                                              */
/* ---------------------------------------------------------------------- */

CREATE TABLE [PropertyValue] (
	[EntityID] UNIQUEIDENTIFIER NOT NULL,
	[PropertyName] NVARCHAR(256) NOT NULL,
	[PropertyValueString] NVARCHAR(max),
	CONSTRAINT [PK_PropertyValue] PRIMARY KEY ([EntityID], [PropertyName])
)
GO

EXECUTE sp_addextendedproperty N'MS_Description', N'Table stores values for attributes of an Entity. Values can be Integer (which can store numbers, flags, item from a list etc), Double which can store currencies, Date, String or a Binary data. only one of these will be filled in and other columns will be null. Keeping them seperate allows to use database sorting as well as other functions to select attributes values and entities', 'SCHEMA', N'dbo', 'TABLE', N'PropertyValue', NULL, NULL
GO

EXECUTE sp_addextendedproperty N'MS_Description', N'Reference to Entity for which this attribute value is being stored', 'SCHEMA', N'dbo', 'TABLE', N'PropertyValue', 'COLUMN', N'EntityID'
GO

EXECUTE sp_addextendedproperty N'MS_Description', N'String/Text value for the attribute', 'SCHEMA', N'dbo', 'TABLE', N'PropertyValue', 'COLUMN', N'PropertyValueString'
GO

/* ---------------------------------------------------------------------- */
/* Add table "RelationshipType"                                           */
/* ---------------------------------------------------------------------- */

CREATE TABLE [RelationshipType] (
	[RelTypeID] TINYINT NOT NULL,
	[RelTypeName] NVARCHAR(128),
	[RelTypeDesc] NVARCHAR(max),
	[RelPartitionKey] INTEGER NOT NULL,
	CONSTRAINT [PK_RelationshipType] PRIMARY KEY ([RelTypeID], [RelPartitionKey])
)
GO

EXECUTE sp_addextendedproperty N'MS_Description', N'Enumeration for types of relationships between entities e.g.  0   Containment 1   Association 2   Managed by   etc', 'SCHEMA', N'dbo', 'TABLE', N'RelationshipType', NULL, NULL
GO

/* ---------------------------------------------------------------------- */
/* Add table "Entity"                                                     */
/* ---------------------------------------------------------------------- */

CREATE TABLE [Entity] (
	[EntityID] UNIQUEIDENTIFIER NOT NULL,
	[EntityUniqueID] NVARCHAR(512),
	[EntityName] NVARCHAR(256),
	[EntityDesc] NVARCHAR(max),
	[EntityTypeID] TINYINT NOT NULL,
	[Flags] BIGINT,
	[Text1] NVARCHAR(256),
	[Text2] NVARCHAR(max),
	CONSTRAINT [PK_Entity] PRIMARY KEY ([EntityID])
)
GO

EXECUTE sp_addextendedproperty N'MS_Description', N'Tables stores all the entities created/discovered/managed by VRM.', 'SCHEMA', N'dbo', 'TABLE', N'Entity', NULL, NULL
GO

EXECUTE sp_addextendedproperty N'MS_Description', N'Primary Key', 'SCHEMA', N'dbo', 'TABLE', N'Entity', 'COLUMN', N'EntityID'
GO

EXECUTE sp_addextendedproperty N'MS_Description', N'Unique Identifier for the entity that can be recognized accross platforms (in Hypervisor or hosts etc) ', 'SCHEMA', N'dbo', 'TABLE', N'Entity', 'COLUMN', N'EntityUniqueID'
GO

EXECUTE sp_addextendedproperty N'MS_Description', N'Name for the entity', 'SCHEMA', N'dbo', 'TABLE', N'Entity', 'COLUMN', N'EntityName'
GO

EXECUTE sp_addextendedproperty N'MS_Description', N'Description for the entity', 'SCHEMA', N'dbo', 'TABLE', N'Entity', 'COLUMN', N'EntityDesc'
GO

EXECUTE sp_addextendedproperty N'MS_Description', N'Reference to type of Entity', 'SCHEMA', N'dbo', 'TABLE', N'Entity', 'COLUMN', N'EntityTypeID'
GO

EXECUTE sp_addextendedproperty N'MS_Description', N'Integer attribute which can be used for applying flags to the entity', 'SCHEMA', N'dbo', 'TABLE', N'Entity', 'COLUMN', N'Flags'
GO

EXECUTE sp_addextendedproperty N'MS_Description', N'Generic text column with 256 bytes length', 'SCHEMA', N'dbo', 'TABLE', N'Entity', 'COLUMN', N'Text1'
GO

EXECUTE sp_addextendedproperty N'MS_Description', N'Generic text column with max length', 'SCHEMA', N'dbo', 'TABLE', N'Entity', 'COLUMN', N'Text2'
GO

/* ---------------------------------------------------------------------- */
/* Add table "EntityRelationship"                                         */
/* ---------------------------------------------------------------------- */

CREATE TABLE [EntityRelationship] (
	[EntityRelID] UNIQUEIDENTIFIER NOT NULL,
	[ParentEntityID] UNIQUEIDENTIFIER,
	[ChildEntityID] UNIQUEIDENTIFIER,
	[RelTypeID] TINYINT,
	[RecCreationTime] DATETIME,
	[RecUpdateTime] DATETIME,
	[RecDeleteTime] DATETIME,
	[RelPartitionKey] INTEGER,
	CONSTRAINT [PK_EntityRelationship] PRIMARY KEY ([EntityRelID])
)
GO

EXECUTE sp_addextendedproperty N'MS_Description', N'Table to store relationships between two entities', 'SCHEMA', N'dbo', 'TABLE', N'EntityRelationship', NULL, NULL
GO

EXECUTE sp_addextendedproperty N'MS_Description', N'Primary Key', 'SCHEMA', N'dbo', 'TABLE', N'EntityRelationship', 'COLUMN', N'EntityRelID'
GO

EXECUTE sp_addextendedproperty N'MS_Description', N'Reference to parent Entity', 'SCHEMA', N'dbo', 'TABLE', N'EntityRelationship', 'COLUMN', N'ParentEntityID'
GO

EXECUTE sp_addextendedproperty N'MS_Description', N'Reference to Child Entity', 'SCHEMA', N'dbo', 'TABLE', N'EntityRelationship', 'COLUMN', N'ChildEntityID'
GO

EXECUTE sp_addextendedproperty N'MS_Description', N'Type of Relationship', 'SCHEMA', N'dbo', 'TABLE', N'EntityRelationship', 'COLUMN', N'RelTypeID'
GO

EXECUTE sp_addextendedproperty N'MS_Description', N'Time when the record was created', 'SCHEMA', N'dbo', 'TABLE', N'EntityRelationship', 'COLUMN', N'RecCreationTime'
GO

EXECUTE sp_addextendedproperty N'MS_Description', N'Time when Record was updated', 'SCHEMA', N'dbo', 'TABLE', N'EntityRelationship', 'COLUMN', N'RecUpdateTime'
GO

EXECUTE sp_addextendedproperty N'MS_Description', N'Time when record was marked for deletion', 'SCHEMA', N'dbo', 'TABLE', N'EntityRelationship', 'COLUMN', N'RecDeleteTime'
GO

EXECUTE sp_addextendedproperty N'MS_Description', N'Key to partition this table on', 'SCHEMA', N'dbo', 'TABLE', N'EntityRelationship', 'COLUMN', N'RelPartitionKey'
GO

/* ---------------------------------------------------------------------- */
/* Add table "EntityStatus"                                               */
/* ---------------------------------------------------------------------- */

CREATE TABLE [EntityStatus] (
	[EntityStatusID] TINYINT NOT NULL,
	[EntityStatusName] NVARCHAR(128),
	[EntityStatusDesc] NVARCHAR(max),
	CONSTRAINT [PK_EntityStatus] PRIMARY KEY ([EntityStatusID])
)
GO

EXECUTE sp_addextendedproperty N'MS_Description', N'Enumeration of simple status for Entity. This is generic e.g.  0   Good 1   Offline 2   Has errors   etc', 'SCHEMA', N'dbo', 'TABLE', N'EntityStatus', NULL, NULL
GO

EXECUTE sp_addextendedproperty N'MS_Description', N'Primary key', 'SCHEMA', N'dbo', 'TABLE', N'EntityStatus', 'COLUMN', N'EntityStatusID'
GO

EXECUTE sp_addextendedproperty N'MS_Description', N'Name or String to be displayed for Status', 'SCHEMA', N'dbo', 'TABLE', N'EntityStatus', 'COLUMN', N'EntityStatusName'
GO

EXECUTE sp_addextendedproperty N'MS_Description', N'Description for the status', 'SCHEMA', N'dbo', 'TABLE', N'EntityStatus', 'COLUMN', N'EntityStatusDesc'
GO

/* ---------------------------------------------------------------------- */
/* Add table "GroupToTemplate"                                            */
/* ---------------------------------------------------------------------- */

CREATE TABLE [GroupToTemplate] (
	[GroupID] UNIQUEIDENTIFIER NOT NULL,
	[VirtualMachineTemplateID] UNIQUEIDENTIFIER NOT NULL,
	CONSTRAINT [PK_GroupToTemplate] PRIMARY KEY ([GroupID], [VirtualMachineTemplateID])
)
GO

EXECUTE sp_addextendedproperty N'MS_Description', N'Association of a ProvisioningGroup to a BluePrint. We can associate a Blueprint to many groups with this', 'SCHEMA', N'dbo', 'TABLE', N'GroupToTemplate', NULL, NULL
GO

EXECUTE sp_addextendedproperty N'MS_Description', N'Reference to group', 'SCHEMA', N'dbo', 'TABLE', N'GroupToTemplate', 'COLUMN', N'GroupID'
GO

EXECUTE sp_addextendedproperty N'MS_Description', N'Reference to Blueprint', 'SCHEMA', N'dbo', 'TABLE', N'GroupToTemplate', 'COLUMN', N'VirtualMachineTemplateID'
GO

/* ---------------------------------------------------------------------- */
/* Add table "EntityProperty"                                             */
/* ---------------------------------------------------------------------- */

CREATE TABLE [EntityProperty] (
	[AttrValueID] UNIQUEIDENTIFIER NOT NULL,
	[AttrValueInt] BIGINT,
	[AttrValueDouble] DECIMAL(28, 3),
	[AttrValueDate] DATETIME,
	[AttrValueString] NVARCHAR(1024),
	[AttrValueBinary] VARBINARY(max),
	[AttrID] UNIQUEIDENTIFIER NOT NULL,
	[EntityID] UNIQUEIDENTIFIER NOT NULL,
	[EntityTypeID] UNIQUEIDENTIFIER NOT NULL,
	[AttrPartitionKey] INTEGER NOT NULL,
	CONSTRAINT [PK_EntityProperty] PRIMARY KEY ([AttrValueID], [AttrID], [EntityID], [EntityTypeID], [AttrPartitionKey])
)
GO

EXECUTE sp_addextendedproperty N'MS_Description', N'This is a duplicate table of AttrValue. This table holds only those propeties that are important for provisioning. This will speed up collecting properties while provisioning and reporting can use AttrValue table for addition properties.   See generic schema (diagram 2/3) for more description', 'SCHEMA', N'dbo', 'TABLE', N'EntityProperty', NULL, NULL
GO

EXECUTE sp_addextendedproperty N'MS_Description', N'Primary key for an attribute value', 'SCHEMA', N'dbo', 'TABLE', N'EntityProperty', 'COLUMN', N'AttrValueID'
GO

EXECUTE sp_addextendedproperty N'MS_Description', N'Value stored as integer ', 'SCHEMA', N'dbo', 'TABLE', N'EntityProperty', 'COLUMN', N'AttrValueInt'
GO

EXECUTE sp_addextendedproperty N'MS_Description', N'value stored as double', 'SCHEMA', N'dbo', 'TABLE', N'EntityProperty', 'COLUMN', N'AttrValueDouble'
GO

EXECUTE sp_addextendedproperty N'MS_Description', N'value stored as date', 'SCHEMA', N'dbo', 'TABLE', N'EntityProperty', 'COLUMN', N'AttrValueDate'
GO

EXECUTE sp_addextendedproperty N'MS_Description', N'value stored as string', 'SCHEMA', N'dbo', 'TABLE', N'EntityProperty', 'COLUMN', N'AttrValueString'
GO

EXECUTE sp_addextendedproperty N'MS_Description', N'Value stored as binary', 'SCHEMA', N'dbo', 'TABLE', N'EntityProperty', 'COLUMN', N'AttrValueBinary'
GO

EXECUTE sp_addextendedproperty N'MS_Description', N'Reference to attribute for which value is stored', 'SCHEMA', N'dbo', 'TABLE', N'EntityProperty', 'COLUMN', N'AttrID'
GO

EXECUTE sp_addextendedproperty N'MS_Description', N'Reference to Entity to which this attribute belong', 'SCHEMA', N'dbo', 'TABLE', N'EntityProperty', 'COLUMN', N'EntityID'
GO

EXECUTE sp_addextendedproperty N'MS_Description', N'Reference to type of Entity', 'SCHEMA', N'dbo', 'TABLE', N'EntityProperty', 'COLUMN', N'EntityTypeID'
GO

EXECUTE sp_addextendedproperty N'MS_Description', N'Key on which to partition the data in this table', 'SCHEMA', N'dbo', 'TABLE', N'EntityProperty', 'COLUMN', N'AttrPartitionKey'
GO

/* ---------------------------------------------------------------------- */
/* Add table "AgentWorkItemResponse"                                      */
/* ---------------------------------------------------------------------- */

CREATE TABLE [AgentWorkItemResponse] (
	[WorkItemID] UNIQUEIDENTIFIER NOT NULL,
	[WorkItemResponse] NVARCHAR(max),
	[ResponseReceivedTime] DATETIME,
	[AgentID] UNIQUEIDENTIFIER,
	CONSTRAINT [PK_AgentWorkItemResponse] PRIMARY KEY ([WorkItemID])
)
GO

/* ---------------------------------------------------------------------- */
/* Add table "TemplateToGlobalProfiles"                                   */
/* ---------------------------------------------------------------------- */

CREATE TABLE [TemplateToGlobalProfiles] (
	[VirtualMachineTemplateID] UNIQUEIDENTIFIER NOT NULL,
	[GlobalProfileID] UNIQUEIDENTIFIER NOT NULL,
	CONSTRAINT [PK_TemplateToGlobalProfiles] PRIMARY KEY ([VirtualMachineTemplateID], [GlobalProfileID])
)
GO

/* ---------------------------------------------------------------------- */
/* Add table "PropertyGroup"                                              */
/* ---------------------------------------------------------------------- */

CREATE TABLE [PropertyGroup] (
	[PropertyGroupID] TINYINT NOT NULL,
	[PropertyGroupName] NVARCHAR(256),
	[PropertyGroupDesc] NVARCHAR(max),
	[ParentPropertyGroupID] TINYINT,
	CONSTRAINT [PK_PropertyGroup] PRIMARY KEY ([PropertyGroupID])
)
GO

/* ---------------------------------------------------------------------- */
/* Add table "DataCollectionStatus"                                       */
/* ---------------------------------------------------------------------- */

CREATE TABLE [DataCollectionStatus] (
	[AgentID] UNIQUEIDENTIFIER,
	[LastCollectedTime] DATETIME,
	[LastCollectedStatus] BIT,
	[EntityID] UNIQUEIDENTIFIER,
	[CollectionStartTime] DATETIME,
	[DataCollectionStatusID] UNIQUEIDENTIFIER NOT NULL,
	[FilterSpecID] UNIQUEIDENTIFIER,
	[ErrorCode] BIGINT,
	[ErrorMessage] NVARCHAR(max),
	[EntityName] NVARCHAR(256),
	[Frequency] INTEGER,
	[IsDisabled] BIT DEFAULT 0 NOT NULL,
	CONSTRAINT [PK_DataCollectionStatus] PRIMARY KEY ([DataCollectionStatusID])
)
GO

/* ---------------------------------------------------------------------- */
/* Add table "RequestAudit"                                               */
/* ---------------------------------------------------------------------- */

CREATE TABLE [RequestAudit] (
	[RequestAuditID] UNIQUEIDENTIFIER NOT NULL,
	[RequestAuditDescription] NVARCHAR(max),
	[RequestAuditDate] DATETIME,
	[RequestAuditUser] NVARCHAR(128),
	[RequestID] UNIQUEIDENTIFIER,
	[Flags] BIGINT,
	[Text1] NVARCHAR(256),
	[Text2] NVARCHAR(max),
	[RequestAuditTypeID] TINYINT,
	[RequestAuditState] NVARCHAR(128),
	[RequestAuditCounter] BIGINT IDENTITY(0,1),
	CONSTRAINT [PK_RequestAudit] PRIMARY KEY ([RequestAuditID])
)
GO

EXECUTE sp_addextendedproperty N'MS_Description', N'Integer attribute which can be used for applying flags to the entity', 'SCHEMA', N'dbo', 'TABLE', N'RequestAudit', 'COLUMN', N'Flags'
GO

EXECUTE sp_addextendedproperty N'MS_Description', N'Generic text column with 256 bytes length', 'SCHEMA', N'dbo', 'TABLE', N'RequestAudit', 'COLUMN', N'Text1'
GO

EXECUTE sp_addextendedproperty N'MS_Description', N'Generic text column with max length', 'SCHEMA', N'dbo', 'TABLE', N'RequestAudit', 'COLUMN', N'Text2'
GO

/* ---------------------------------------------------------------------- */
/* Add table "RequestAuditType"                                           */
/* ---------------------------------------------------------------------- */

CREATE TABLE [RequestAuditType] (
	[RequestAuditTypeID] TINYINT NOT NULL,
	[RequestAuditTypeName] NVARCHAR(128),
	[RequestAuditTypeDescription] NVARCHAR(max),
	CONSTRAINT [PK_RequestAuditType] PRIMARY KEY ([RequestAuditTypeID])
)
GO

/* ---------------------------------------------------------------------- */
/* Add table "RequestApprover"                                            */
/* ---------------------------------------------------------------------- */

CREATE TABLE [RequestApprover] (
	[RequestID] UNIQUEIDENTIFIER NOT NULL,
	[UserName] INT NOT NULL,
	[RequestApproverPriority] INTEGER,
	[RequestApproverFlags] BIGINT,
	[RequestApproverStateID] TINYINT,
	CONSTRAINT [PK_RequestApprover] PRIMARY KEY ([RequestID], [UserName])
)
GO

EXECUTE sp_addextendedproperty N'MS_Description', N'Order in which apprvals will be obtained in ascending order. Approvars with the same priority will be notified at the same time', 'SCHEMA', N'dbo', 'TABLE', N'RequestApprover', 'COLUMN', N'RequestApproverPriority'
GO

/* ---------------------------------------------------------------------- */
/* Add table "UserFilter"                                                 */
/* ---------------------------------------------------------------------- */

CREATE TABLE [UserFilter] (
	[UserFilterID] UNIQUEIDENTIFIER NOT NULL,
	[DataSourceName] NVARCHAR(128) NOT NULL,
	[FilterName] NVARCHAR(128) NOT NULL,
	[UserName] NVARCHAR(128),
	[ColumnLayout] NVARCHAR(max),
	[FilterExpression] NVARCHAR(max),
	[CreatedTime] DATETIME CONSTRAINT [DEF_UserFilter_CreatedTime] DEFAULT getdate() NOT NULL,
	[ModifiedTime] DATETIME CONSTRAINT [DEF_UserFilter_ModifiedTime] DEFAULT getdate() NOT NULL,
	[AutoAdjustDateValues] BIT CONSTRAINT [DEF_UserFilter_AutoAdjustDateValues] DEFAULT 0 NOT NULL,
	CONSTRAINT [PK_UserFilter] PRIMARY KEY ([UserFilterID])
)
GO

CREATE UNIQUE  INDEX [IDX_UserFilter_1] ON [UserFilter] ([DataSourceName],[FilterName],[UserName])
GO

/* ---------------------------------------------------------------------- */
/* Add table "VMLoginUser"                                                */
/* ---------------------------------------------------------------------- */

CREATE TABLE [VMLoginUser] (
	[LoginUserName] NVARCHAR(256) NOT NULL,
	[LastLoginDate] DATETIME,
	[LastLogoffDate] DATETIME,
	[NumLogins] BIGINT,
	[LastUpdated] DATETIME,
	[VirtualMachineID] UNIQUEIDENTIFIER NOT NULL,
	[ErrorCode] BIGINT,
	[ErrorMessage] NVARCHAR(max),
	[AgentID] UNIQUEIDENTIFIER,
	CONSTRAINT [PK_VMLoginUser] PRIMARY KEY ([LoginUserName], [VirtualMachineID])
)
GO

/* ---------------------------------------------------------------------- */
/* Add table "LastLoginIgnoreUser"                                        */
/* ---------------------------------------------------------------------- */

CREATE TABLE [LastLoginIgnoreUser] (
	[LastLoginIgnoreUserID] UNIQUEIDENTIFIER NOT NULL,
	[VirtualMachineID] UNIQUEIDENTIFIER,
	[LoginUserName] NVARCHAR(256),
	CONSTRAINT [PK_LastLoginIgnoreUser] PRIMARY KEY ([LastLoginIgnoreUserID])
)
GO

/* ---------------------------------------------------------------------- */
/* Add table "StorageAllocationPolicy"                                    */
/* ---------------------------------------------------------------------- */

CREATE TABLE [StorageAllocationPolicy] (
	[StorageAllocationPolicyID] TINYINT NOT NULL,
	[StorageAllocationPolicyName] NVARCHAR(128),
	[StorageAllocationPolicyDescription] NVARCHAR(max),
	CONSTRAINT [PK_StorageAllocationPolicy] PRIMARY KEY ([StorageAllocationPolicyID])
)
GO

/* ---------------------------------------------------------------------- */
/* Add table "PropertySetXml"                                             */
/* ---------------------------------------------------------------------- */

CREATE TABLE [PropertySetXml] (
	[PropertySetID] UNIQUEIDENTIFIER NOT NULL,
	[SetName] NVARCHAR(40) NOT NULL,
	[Description] NVARCHAR(max),
	[Xml] XML NOT NULL,
	[IsEnabled] BIT,
	[IsDefault] BIT,
	CONSTRAINT [PK_PropertySetXml] PRIMARY KEY ([SetName])
)
GO

/* ---------------------------------------------------------------------- */
/* Add table "StaticIPv4NetworkProfile"                                   */
/* ---------------------------------------------------------------------- */

CREATE TABLE [StaticIPv4NetworkProfile] (
	[ID] UNIQUEIDENTIFIER NOT NULL,
	[StaticIPv4NetworkProfileName] NVARCHAR(255),
	[ProfileDescription] NVARCHAR(2048),
	[SubnetMaskIPv4] NVARCHAR(255) NOT NULL,
	[GatewayIPv4Address] NVARCHAR(255),
	[PrimaryDNSIPv4Address] NVARCHAR(255),
	[SecondaryDNSIPv4Address] NVARCHAR(255),
	[DnsSuffix] NVARCHAR(255),
	[DnsSearchSuffix] NVARCHAR(255),
	[PrimaryWinsIPv4Address] NVARCHAR(255),
	[SecondaryWinsIPv4Address] NVARCHAR(255),
	[CreatedDate] DATETIME NOT NULL,
	[LastModifiedDate] DATETIME NOT NULL,
	CONSTRAINT [PK_StaticIPv4NetworkProfile] PRIMARY KEY ([ID])
)
GO

/* ---------------------------------------------------------------------- */
/* Add table "StaticIPv4Range"                                            */
/* ---------------------------------------------------------------------- */

CREATE TABLE [StaticIPv4Range] (
	[ID] UNIQUEIDENTIFIER NOT NULL,
	[StaticIPv4RangeName] NVARCHAR(255),
	[IPv4RangeDescription] NVARCHAR(2048),
	[StaticIPv4NetworkProfileID] UNIQUEIDENTIFIER NOT NULL,
	[BeginIPv4Address] NVARCHAR(255),
	[EndIPv4Address] NVARCHAR(255),
	[CreatedDate] DATETIME NOT NULL,
	[LastModifiedDate] DATETIME NOT NULL,
	CONSTRAINT [PK_StaticIPv4Range] PRIMARY KEY ([ID])
)
GO

/* ---------------------------------------------------------------------- */
/* Add table "StaticIPv4Address"                                          */
/* ---------------------------------------------------------------------- */

CREATE TABLE [StaticIPv4Address] (
	[ID] UNIQUEIDENTIFIER NOT NULL,
	[StaticIPv4NetworkProfileID] UNIQUEIDENTIFIER NOT NULL,
	[StaticIPv4RangeID] UNIQUEIDENTIFIER,
	[VirtualMachineID] UNIQUEIDENTIFIER,
	[Hostname] NVARCHAR(255),
	[IPv4Address] NVARCHAR(40) NOT NULL,
	[IPSortValue] BIGINT,
	[StaticIPv4AddressState] INTEGER NOT NULL,
	[NetworkInterfaceCardOffset] INTEGER,
	[CreatedDate] DATETIME NOT NULL,
	[LastModifiedDate] DATETIME NOT NULL,
	CONSTRAINT [PK_StaticIPv4Address] PRIMARY KEY ([ID])
)
GO

/* ---------------------------------------------------------------------- */
/* Add table "UserFilterExclusion"                                        */
/* ---------------------------------------------------------------------- */

CREATE TABLE [UserFilterExclusion] (
	[UserFilterID] UNIQUEIDENTIFIER NOT NULL,
	[ExclusionKey] NVARCHAR(255) NOT NULL,
	[CreatedTime] DATETIME CONSTRAINT [DEF_UserFilterExclusion_CreatedTime] DEFAULT GETDATE() NOT NULL,
	[ExpirationTime] DATETIME,
	CONSTRAINT [PK_UserFilterExclusion] PRIMARY KEY ([UserFilterID], [ExclusionKey])
)
GO

/* ---------------------------------------------------------------------- */
/* Add table "VMPerformance"                                              */
/* ---------------------------------------------------------------------- */

CREATE TABLE [VMPerformance] (
	[CpuUsageAverage] DECIMAL(28,3),
	[MemUsageAverage] DECIMAL(28,3),
	[NetUsageAverage] DECIMAL(28,3),
	[DiskUsageAverage] DECIMAL(28,3),
	[LastCollectedTime] DATETIME,
	[VirtualMachineID] UNIQUEIDENTIFIER NOT NULL,
	[PerfTimeStamp] DATETIME,
	CONSTRAINT [PK_VMPerformance] PRIMARY KEY ([VirtualMachineID])
)
GO

/* ---------------------------------------------------------------------- */
/* Add table "VMSnapshots"                                              */
/* ---------------------------------------------------------------------- */

CREATE TABLE [dbo].[VMSnapshots] (
    [Id] INTEGER IDENTITY(1,1)  NOT NULL,
    [ExternalSnapshotId] int  NOT NULL,
    [Name] nvarchar(127)  NOT NULL,
    [Description] nvarchar(255)  NULL,
    [CreatedDatetime] datetime  NOT NULL,
    [IsCurrentSnapshot] bit NULL,
    [IsMemorySnapshot] bit NULL,
    [VirtualMachineID] uniqueidentifier  NOT NULL,
    [ParentId] INTEGER  NULL
);
GO

ALTER TABLE [dbo].[VMSnapshots]
ADD CONSTRAINT [PK_VMSnapshot]
    PRIMARY KEY CLUSTERED ([Id] ASC);
GO

/* ---------------------------------------------------------------------- */
/* Add table "Audit"                                                      */
/* ---------------------------------------------------------------------- */

CREATE TABLE [Audit] (
	[LogID] INTEGER IDENTITY(1,1) NOT NULL,
	[EventID] INTEGER,
	[Priority] INTEGER,
	[Severity] NVARCHAR(64),
	[Title] NVARCHAR(256),
	[Timestamp] DATETIME NOT NULL,
	[MachineName] NVARCHAR(64),
	[AppDomainName] NVARCHAR(512),
	[ProcessID] NVARCHAR(256),
	[ProcessName] NVARCHAR(512),
	[ThreadName] NVARCHAR(512),
	[Win32ThreadID] NVARCHAR(128),
	[Message] NTEXT NOT NULL,
	[FormattedMessage] NTEXT,
	CONSTRAINT [PK_Audit] PRIMARY KEY ([LogID])
)
GO

/* ---------------------------------------------------------------------- */
/* Add table "ApprovalPolicy"                                             */
/* ---------------------------------------------------------------------- */

CREATE TABLE [ApprovalPolicy] (
	[PolicyId] UNIQUEIDENTIFIER NOT NULL,
	[PolicyName] NVARCHAR(128),
	[PolicyDescription] NVARCHAR(2000),
	[GroupAdminApproval] BIT,
	[XmlConfiguration] NVARCHAR(max),
	[EmailOwner] BIT,
	[EmailApprover] BIT,
	CONSTRAINT [PK_ApprovalPolicy] PRIMARY KEY ([PolicyId])
)
GO

/* ---------------------------------------------------------------------- */
/* Add table "GroupType"                                                  */
/* ---------------------------------------------------------------------- */

CREATE TABLE [GroupType] (
	[GroupType] TINYINT NOT NULL,
	[GroupTypeName] NVARCHAR(128) NOT NULL,
	[GroupTypeDescription] NVARCHAR(max),
	CONSTRAINT [PK_GroupType] PRIMARY KEY ([GroupType])
)
GO

/* ---------------------------------------------------------------------- */
/* Add table "VirtualMachineHistory"                                      */
/* ---------------------------------------------------------------------- */

CREATE TABLE [VirtualMachineHistory] (
	[VirtualMachineID] UNIQUEIDENTIFIER NOT NULL,
	[IsManaged] BIT DEFAULT 0 NOT NULL,
	[HostID] UNIQUEIDENTIFIER,
	[VirtualMachineTemplateID] UNIQUEIDENTIFIER,
	[HostReservationID] UNIQUEIDENTIFIER,
	[ResourcePoolID] UNIQUEIDENTIFIER,
	[VirtualMachineName] NVARCHAR(256) NOT NULL,
	[Expires] DATETIME,
	[ExpireDays] INTEGER DEFAULT 0 NOT NULL,
	[BlueprintType] TINYINT DEFAULT 0 NOT NULL,
	[InitiatorType] NVARCHAR(256),
	[Notes] NVARCHAR(max),
	[GuestOS] NVARCHAR(256),
	[VMUniqueID] NVARCHAR(256),
	[PlatformDetails] NVARCHAR(50),
	[VMCreationDate] DATETIME,
	[VMDeleteDate] DATETIME,
	[LastLoggedDate] DATETIME,
	[LastLoggedUser] NVARCHAR(256),
	[LastPowerOffDate] DATETIME,
	[LastPowerOnDate] DATETIME,
	[OwnerExists] BIT DEFAULT 0 NOT NULL,
	[UsageIndex] INTEGER,
	[UsageIndexIgnoreBy] NVARCHAR(256),
	[IsDeleted] BIT DEFAULT 0 NOT NULL,
	[IsMissing] BIT DEFAULT 0 NOT NULL,
	[IsRogue] BIT DEFAULT 0 NOT NULL,
	[IsRunning] BIT DEFAULT 0 NOT NULL,
	[RecCreationTime] DATETIME,
	[RecDeleteTime] DATETIME,
	[RecUpdateTime] DATETIME,
	[Flags] BIGINT,
	[Text1] NVARCHAR(256),
	[Text2] NVARCHAR(max),
	[VMCPUs] INTEGER,
	[VMTotalMemoryMB] BIGINT,
	[VMTotalStorageGB] BIGINT,
	[Owner] INT,
	[Approver] INT,
	[GuestOSFamily] NVARCHAR(128),
	[VirtualMachineState] NVARCHAR(128),
    [CurrentTask] NVARCHAR(128),
	[HostStorageReservationID] UNIQUEIDENTIFIER,
	[StoragePath] NVARCHAR(256),
	[IsTemplate] BIT DEFAULT 0 NOT NULL,
	[ConnectToVdi] BIT DEFAULT 0 NOT NULL,
	[VMDNSName] NVARCHAR(256),
	[VMUsedStorageGB] DECIMAL(10,2),
	[FileLevelCloneImageName] NVARCHAR(128),
	[VMInitialUsedSpace] DECIMAL(10,2),
	[VMEstimatedUsedSpace] DECIMAL(10,2),
	[PhysicalMachineID] UNIQUEIDENTIFIER, -- FK to PhysicalMachine.PhysicalMachineID
	[MachineType] [tinyint] NOT NULL,
	[IsComponent] BIT DEFAULT 0 NOT NULL,
	[ParentMachineID] UNIQUEIDENTIFIER NULL,
	CONSTRAINT [PK_VirtualMachine_History] PRIMARY KEY ([VirtualMachineID])
)
GO

CREATE  INDEX [IDX_VirtualMachineHistory_1] ON [VirtualMachineHistory] ([VirtualMachineID],[VMDeleteDate])
GO

CREATE NONCLUSTERED INDEX [IDX_VirtualMachineHistory_2] ON [VirtualMachineHistory] ([VirtualMachineName] ASC)
GO

CREATE NONCLUSTERED INDEX [IDX_VirtualMachineHistory_3] ON [VirtualMachineHistory] ([HostID])
GO

CREATE NONCLUSTERED INDEX [IDX_VirtualMachineHistory_4] ON [VirtualMachineHistory] ([HostReservationID])
GO

CREATE NONCLUSTERED INDEX [IDX_VirtualMachineHistory_5] ON [VirtualMachineHistory] ([VirtualMachineTemplateID])
GO

EXECUTE sp_addextendedproperty N'MS_Description', N'Virtual Machine table tracks Virtual machines managed/identified by VRM. The records in this table are never deleted (as in 3.0.x)', 'SCHEMA', N'dbo', 'TABLE', N'VirtualMachineHistory', NULL, NULL
GO

EXECUTE sp_addextendedproperty N'MS_Description', N'Primary Key', 'SCHEMA', N'dbo', 'TABLE', N'VirtualMachineHistory', 'COLUMN', N'VirtualMachineID'
GO

EXECUTE sp_addextendedproperty N'MS_Description', N'Reference to Host', 'SCHEMA', N'dbo', 'TABLE', N'VirtualMachineHistory', 'COLUMN', N'HostID'
GO

EXECUTE sp_addextendedproperty N'MS_Description', N'reference to Blueprint from which this VM was created', 'SCHEMA', N'dbo', 'TABLE', N'VirtualMachineHistory', 'COLUMN', N'VirtualMachineTemplateID'
GO

EXECUTE sp_addextendedproperty N'MS_Description', N'Reference to reservation which was used to create this VM', 'SCHEMA', N'dbo', 'TABLE', N'VirtualMachineHistory', 'COLUMN', N'HostReservationID'
GO

EXECUTE sp_addextendedproperty N'MS_Description', N'Reference to the ResourcePool to which this VM belong', 'SCHEMA', N'dbo', 'TABLE', N'VirtualMachineHistory', 'COLUMN', N'ResourcePoolID'
GO

EXECUTE sp_addextendedproperty N'MS_Description', N'Name of the Virtual Machine', 'SCHEMA', N'dbo', 'TABLE', N'VirtualMachineHistory', 'COLUMN', N'VirtualMachineName'
GO

EXECUTE sp_addextendedproperty N'MS_Description', N'Date when this VM Expires', 'SCHEMA', N'dbo', 'TABLE', N'VirtualMachineHistory', 'COLUMN', N'Expires'
GO

EXECUTE sp_addextendedproperty N'MS_Description', N'Whether the VM is a server', 'SCHEMA', N'dbo', 'TABLE', N'VirtualMachineHistory', 'COLUMN', N'BlueprintType'
GO

EXECUTE sp_addextendedproperty N'MS_Description', N'Not sure how this is used', 'SCHEMA', N'dbo', 'TABLE', N'VirtualMachineHistory', 'COLUMN', N'InitiatorType'
GO

EXECUTE sp_addextendedproperty N'MS_Description', N'Note about the virtual machines', 'SCHEMA', N'dbo', 'TABLE', N'VirtualMachineHistory', 'COLUMN', N'Notes'
GO

EXECUTE sp_addextendedproperty N'MS_Description', N'Operating system running in the quest', 'SCHEMA', N'dbo', 'TABLE', N'VirtualMachineHistory', 'COLUMN', N'GuestOS'
GO

EXECUTE sp_addextendedproperty N'MS_Description', N'Unique identifer provided by Hypervisor for the VM', 'SCHEMA', N'dbo', 'TABLE', N'VirtualMachineHistory', 'COLUMN', N'VMUniqueID'
GO

EXECUTE sp_addextendedproperty N'MS_Description', N'Not sure how this is usee', 'SCHEMA', N'dbo', 'TABLE', N'VirtualMachineHistory', 'COLUMN', N'PlatformDetails'
GO

EXECUTE sp_addextendedproperty N'MS_Description', N'Date when this VM was created', 'SCHEMA', N'dbo', 'TABLE', N'VirtualMachineHistory', 'COLUMN', N'VMCreationDate'
GO

EXECUTE sp_addextendedproperty N'MS_Description', N'Date when VM was deleted', 'SCHEMA', N'dbo', 'TABLE', N'VirtualMachineHistory', 'COLUMN', N'VMDeleteDate'
GO

EXECUTE sp_addextendedproperty N'MS_Description', N'When was last time a user logged on to VM', 'SCHEMA', N'dbo', 'TABLE', N'VirtualMachineHistory', 'COLUMN', N'LastLoggedDate'
GO

EXECUTE sp_addextendedproperty N'MS_Description', N'Who was the user last logged on to VM', 'SCHEMA', N'dbo', 'TABLE', N'VirtualMachineHistory', 'COLUMN', N'LastLoggedUser'
GO

EXECUTE sp_addextendedproperty N'MS_Description', N'When was last time machine was powerdoff', 'SCHEMA', N'dbo', 'TABLE', N'VirtualMachineHistory', 'COLUMN', N'LastPowerOffDate'
GO

EXECUTE sp_addextendedproperty N'MS_Description', N'when was last time machine was powered on', 'SCHEMA', N'dbo', 'TABLE', N'VirtualMachineHistory', 'COLUMN', N'LastPowerOnDate'
GO

EXECUTE sp_addextendedproperty N'MS_Description', N'Whether owner of the machine exists in AD', 'SCHEMA', N'dbo', 'TABLE', N'VirtualMachineHistory', 'COLUMN', N'OwnerExists'
GO

EXECUTE sp_addextendedproperty N'MS_Description', N'This is a placeholder for storing a integer value which will indicate over usage of the machine. This can be used to indicate over/under used virtual machines', 'SCHEMA', N'dbo', 'TABLE', N'VirtualMachineHistory', 'COLUMN', N'UsageIndex'
GO

EXECUTE sp_addextendedproperty N'MS_Description', N'User marking to ignore the usage index', 'SCHEMA', N'dbo', 'TABLE', N'VirtualMachineHistory', 'COLUMN', N'UsageIndexIgnoreBy'
GO

EXECUTE sp_addextendedproperty N'MS_Description', N'Whether a VM is deleted', 'SCHEMA', N'dbo', 'TABLE', N'VirtualMachineHistory', 'COLUMN', N'IsDeleted'
GO

EXECUTE sp_addextendedproperty N'MS_Description', N'Whether VM is missing', 'SCHEMA', N'dbo', 'TABLE', N'VirtualMachineHistory', 'COLUMN', N'IsMissing'
GO

EXECUTE sp_addextendedproperty N'MS_Description', N'Whether VM is rogue', 'SCHEMA', N'dbo', 'TABLE', N'VirtualMachineHistory', 'COLUMN', N'IsRogue'
GO

EXECUTE sp_addextendedproperty N'MS_Description', N'Whether VM is running or turned off', 'SCHEMA', N'dbo', 'TABLE', N'VirtualMachineHistory', 'COLUMN', N'IsRunning'
GO

EXECUTE sp_addextendedproperty N'MS_Description', N'Integer attribute which can be used for applying flags to the entity', 'SCHEMA', N'dbo', 'TABLE', N'VirtualMachineHistory', 'COLUMN', N'Flags'
GO

EXECUTE sp_addextendedproperty N'MS_Description', N'Generic text column with 256 bytes length', 'SCHEMA', N'dbo', 'TABLE', N'VirtualMachineHistory', 'COLUMN', N'Text1'
GO

EXECUTE sp_addextendedproperty N'MS_Description', N'Generic text column with max length', 'SCHEMA', N'dbo', 'TABLE', N'VirtualMachineHistory', 'COLUMN', N'Text2'
GO

EXECUTE sp_addextendedproperty N'MS_Description', N'Number of CPUs', 'SCHEMA', N'dbo', 'TABLE', N'VirtualMachineHistory', 'COLUMN', N'VMCPUs'
GO

EXECUTE sp_addextendedproperty N'MS_Description', N'Amount of memory allocated to VM. Stored in MB', 'SCHEMA', N'dbo', 'TABLE', N'VirtualMachineHistory', 'COLUMN', N'VMTotalMemoryMB'
GO

EXECUTE sp_addextendedproperty N'MS_Description', N'Amount of disk space allocated to VM(add all the disks together). Stored in GB', 'SCHEMA', N'dbo', 'TABLE', N'VirtualMachineHistory', 'COLUMN', N'VMTotalStorageGB'
GO

EXECUTE sp_addextendedproperty N'MS_Description', N'Whether VM is a component of an AppService', 'SCHEMA', N'dbo', 'TABLE', N'VirtualMachineHistory', 'COLUMN', N'IsComponent'
GO

EXECUTE sp_addextendedproperty N'MS_Description', N'Parent virtual machine id', 'SCHEMA', N'dbo', 'TABLE', N'VirtualMachineHistory', 'COLUMN', N'ParentMachineID'
GO

/* ---------------------------------------------------------------------- */
/* Add table "UICustomization"                                            */
/* ---------------------------------------------------------------------- */

CREATE TABLE [UICustomization] (
	[id] UNIQUEIDENTIFIER NOT NULL,
	[lastmodified] DATETIME,
	[showdashboard] BIT,
	[showvmgrid] BIT,
	[showvmgridfilters] BIT,
	[showvmgridmultiselect] BIT,
	[showvmgridexport] BIT,
	[vmgriddefaultcolumns] NTEXT,
	[showpendinggrid] BIT,
	[showpendinggridexport] BIT,
	[showreclaimgrid] BIT,
	[showreclaimgridexport] BIT,
	[showexpiregrid] BIT,
	[showexpiregridexport] BIT,
	[showrecentgrid] BIT,
	[showrecentgridexport] BIT,
	[requestvmshownfields] NTEXT,
	[defaultinitialpage] INTEGER,
	[showvmgridextracolumns] BIT,
	[showreclaimcolumns] BIT,
	CONSTRAINT [PK_UICustomization] PRIMARY KEY ([id])
)
GO

/* ---------------------------------------------------------------------- */
/* Add table "HostReservationPolicy"                                      */
/* ---------------------------------------------------------------------- */

CREATE TABLE [HostReservationPolicy] (
	[id] UNIQUEIDENTIFIER NOT NULL,
	[lastmodified] DATETIME NOT NULL,
	[name] NVARCHAR(256) NOT NULL,
	[description] NVARCHAR(max),
	CONSTRAINT [PK_HostReservationPolicy] PRIMARY KEY ([id])
)
GO

/* ---------------------------------------------------------------------- */
/* Add table "StorageArray"                                               */
/* ---------------------------------------------------------------------- */

CREATE TABLE [StorageArray] (
	[StorageArrayID] UNIQUEIDENTIFIER NOT NULL,
	[StorageArrayName] NVARCHAR(128),
	[StorageArrayManagementEndpoint] NVARCHAR(256),
	[StorageArrayDesc] NVARCHAR(max),
	[IsFileCloneSoftwareInstalled] BIT,
	[CredentialID] UNIQUEIDENTIFIER,
	CONSTRAINT [PK_StorageArray] PRIMARY KEY ([StorageArrayID])
)
GO

/* ---------------------------------------------------------------------- */
/* Add table "ExternalWorkflowMap"                                        */
/* ---------------------------------------------------------------------- */

CREATE TABLE [ExternalWorkflowMap] (
	[PrimaryWorkflowId] UNIQUEIDENTIFIER NOT NULL,
	[ExternalWorkflowId] UNIQUEIDENTIFIER NOT NULL,
	CONSTRAINT [PK_ExternalWorkflowMap] PRIMARY KEY ([PrimaryWorkflowId], [ExternalWorkflowId])
)
GO

/* ---------------------------------------------------------------------- */
/* Add table "EmailProfile"                                               */
/* ---------------------------------------------------------------------- */

CREATE TABLE [EmailProfile] (
	[EmailProfileId] UNIQUEIDENTIFIER NOT NULL,
	[EmailProfileName] NVARCHAR(128) NOT NULL,
	[EmailProfileDescription] NVARCHAR(max),
	[EmailServerAddress] NVARCHAR(128) NOT NULL,
	[EmailServerPort] INTEGER,
	[SubjectProductName] NVARCHAR(128),
	[DefaultFromAddress] NVARCHAR(128),
	[EnableSSL] BIT CONSTRAINT [DEF_EmailProfile_EnableSSL] DEFAULT 0,
	[UseServiceCredentials] BIT CONSTRAINT [DEF_EmailProfile_UseServiceCredentials] DEFAULT 0,
	[CredentialID] UNIQUEIDENTIFIER,
	CONSTRAINT [PK_EmailProfile] PRIMARY KEY ([EmailProfileId])
)
GO

/* ---------------------------------------------------------------------- */
/* Add table "WorkflowEventMap"                                           */
/* ---------------------------------------------------------------------- */

CREATE TABLE [WorkflowStateEvent] (
	[WorkflowStateEventId] UNIQUEIDENTIFIER NOT NULL,
	[WorkflowInfoId] UNIQUEIDENTIFIER NOT NULL,
	[StateName] NVARCHAR(128) NOT NULL,
	[EventName] NVARCHAR(128) NOT NULL,
	[UserEvent] BIT NOT NULL DEFAULT 0,
	CONSTRAINT [PK_WorkflowStateEvent] PRIMARY KEY ([WorkflowStateEventId])
)
GO


/* ---------------------------------------------------------------------- */
/* Add table "VirtualMachineTemplateProperties"                           */
/* ---------------------------------------------------------------------- */

CREATE TABLE [VirtualMachineTemplateProperties](
	[Id] INTEGER IDENTITY(1,1) NOT NULL,
	[EntityID] UNIQUEIDENTIFIER NOT NULL,
	[PropertyName] NVARCHAR(128) NOT NULL,
	[PropertyValue] NVARCHAR(MAX),
	[IsHidden] BIT NOT NULL DEFAULT 0,
	[IsRuntime] BIT NOT NULL DEFAULT 0,
	[IsEncrypted] BIT NOT NULL DEFAULT 0,
	CONSTRAINT [PK_VirtualMachineTemplateProperties]  PRIMARY KEY NONCLUSTERED ([Id])
) 
GO

CREATE CLUSTERED INDEX [IX_VirtualMachineTemplateProperties] ON [VirtualMachineTemplateProperties] ([EntityID], [PropertyName] ASC)
GO

ALTER TABLE [VirtualMachineTemplateProperties] ADD CONSTRAINT [FK_VirtualMachineTemplateProperties_VirtualMachineTemplate] 
	FOREIGN KEY ([EntityID]) REFERENCES [VirtualMachineTemplate] ([VirtualMachineTemplateID]) ON DELETE CASCADE
GO

/* ---------------------------------------------------------------------- */
/* Add table "VirtualMachineProperties"                                   */
/* ---------------------------------------------------------------------- */

CREATE TABLE [VirtualMachineProperties](
	[Id] INTEGER IDENTITY(1,1) NOT NULL,
	[EntityID] UNIQUEIDENTIFIER NOT NULL,
	[PropertyName] NVARCHAR(128) NOT NULL,
	[PropertyValue] NVARCHAR(MAX),
	[IsHidden] BIT NOT NULL DEFAULT 0,
	[IsRuntime] BIT NOT NULL DEFAULT 0,
	[IsEncrypted] BIT NOT NULL DEFAULT 0,
	CONSTRAINT [PK_VirtualMachineProperties] PRIMARY KEY NONCLUSTERED ([Id])
) 
GO

CREATE CLUSTERED INDEX [IX_VirtualMachineProperties] ON [VirtualMachineProperties] ([EntityID], [PropertyName] ASC)
GO

ALTER TABLE [dbo].[VirtualMachineProperties] WITH NOCHECK ADD CONSTRAINT [FK_VirtualMachineProperties_VirtualMachine] FOREIGN KEY ([EntityID]) REFERENCES [dbo].[VirtualMachine] ([VirtualMachineID])
GO

ALTER TABLE [dbo].[VirtualMachineProperties] NOCHECK CONSTRAINT [FK_VirtualMachineProperties_VirtualMachine]
GO

/* ------------------------------- */
/* Add table "HostProperties"      */
/* ------------------------------- */

CREATE TABLE [HostProperties](
	[Id] INTEGER IDENTITY(1,1) NOT NULL,
	[EntityID] UNIQUEIDENTIFIER NOT NULL,
	[PropertyName] NVARCHAR(128) NOT NULL,
	[PropertyValue] NVARCHAR(MAX),
	[IsHidden] BIT NOT NULL DEFAULT 0,
	[IsRuntime] BIT NOT NULL DEFAULT 0,
	[IsEncrypted] BIT NOT NULL DEFAULT 0,
	CONSTRAINT [PK_HostProperties] PRIMARY KEY NONCLUSTERED ([Id])
) 
GO

CREATE CLUSTERED INDEX [IX_HostProperties] ON [HostProperties] ([EntityID], [PropertyName] ASC)
GO

ALTER TABLE [HostProperties] ADD CONSTRAINT [FK_HostProperties_Host] 
	FOREIGN KEY ([EntityID]) REFERENCES [Host] ([HostID]) ON DELETE CASCADE
GO

/* ------------------------------------------------------------- */
/* Add table "GlobalProfileProperties"                           */
/* ------------------------------------------------------------- */

CREATE TABLE [GlobalProfileProperties](
	[Id] INTEGER IDENTITY(1,1) NOT NULL,
	[EntityID] UNIQUEIDENTIFIER NOT NULL,
	[PropertyName] NVARCHAR(128) NOT NULL,
	[PropertyValue] NVARCHAR(MAX),
	[IsHidden] BIT NOT NULL DEFAULT 0,
	[IsRuntime] BIT NOT NULL DEFAULT 0,
	[IsEncrypted] BIT NOT NULL DEFAULT 0,
	CONSTRAINT [PK_GlobalProfileProperties] PRIMARY KEY NONCLUSTERED ([Id])
) 
GO

CREATE CLUSTERED INDEX [IX_GlobalProfileProperties] ON [GlobalProfileProperties] ([EntityID], [PropertyName] ASC)
GO

ALTER TABLE [GlobalProfileProperties] ADD CONSTRAINT [FK_GlobalProfileProperties_GlobalProfile] 
	FOREIGN KEY ([EntityID]) REFERENCES [GlobalProfiles] ([GlobalProfileID]) ON DELETE CASCADE
GO

-- Creating table 'Files'
CREATE TABLE [dbo].[Files] (
    [Id] int IDENTITY(1,1) NOT NULL,
    [FileName] nvarchar(512)  NOT NULL,
    [Content] varbinary(max)  NOT NULL,
    [Version] nvarchar(50)  NOT NULL,
    [Description] nvarchar(1024)  NOT NULL,
    [Revision] int  NOT NULL,
	[CreatedAt] DATETIME NOT NULL
);
GO

-- Creating primary key on [Id] in table 'Files'
ALTER TABLE [dbo].[Files]
ADD CONSTRAINT [PK_Files]
    PRIMARY KEY CLUSTERED ([Id] ASC);
GO

/* --------------------------------------------------------------- */
/* Add table "HostReservationProperties"                           */
/* --------------------------------------------------------------- */

CREATE TABLE [HostReservationProperties](
	[Id] INTEGER IDENTITY(1,1) NOT NULL,
	[EntityID] UNIQUEIDENTIFIER NOT NULL,
	[PropertyName] NVARCHAR(128) NOT NULL,
	[PropertyValue] NVARCHAR(MAX),
	[IsHidden] BIT NOT NULL DEFAULT 0,
	[IsRuntime] BIT NOT NULL DEFAULT 0,
	[IsEncrypted] BIT NOT NULL DEFAULT 0,
	CONSTRAINT [PK_HostReservationProperties] PRIMARY KEY NONCLUSTERED ([Id])
) 
GO

CREATE CLUSTERED INDEX [IX_HostReservationProperties] ON [HostReservationProperties] ([EntityID], [PropertyName] ASC)
GO

ALTER TABLE [HostReservationProperties] ADD CONSTRAINT [FK_HostReservationProperties_HostReservation] 
	FOREIGN KEY ([EntityID]) REFERENCES [HostReservation] ([HostReservationID]) ON DELETE CASCADE
GO

/* ----------------------------------------------------------------- */
/* Add table "ProvisioningGroupProperties"                           */
/* ----------------------------------------------------------------- */

CREATE TABLE [ProvisioningGroupProperties](
	[Id] INTEGER IDENTITY(1,1) NOT NULL,
	[EntityID] UNIQUEIDENTIFIER NOT NULL,
	[PropertyName] NVARCHAR(128) NOT NULL,
	[PropertyValue] NVARCHAR(MAX),
	[IsHidden] BIT NOT NULL DEFAULT 0,
	[IsRuntime] BIT NOT NULL DEFAULT 0,
	[IsEncrypted] BIT NOT NULL DEFAULT 0,
	CONSTRAINT [PK_ProvisioningGroupProperties] PRIMARY KEY NONCLUSTERED ([Id])
) 
GO

CREATE CLUSTERED INDEX [IX_ProvisioningGroupProperties] ON [ProvisioningGroupProperties] ([EntityID], [PropertyName] ASC)
GO

ALTER TABLE [ProvisioningGroupProperties] ADD CONSTRAINT [FK_ProvisioningGroupProperties_ProvisioningGroup] 
	FOREIGN KEY ([EntityID]) REFERENCES [ProvisioningGroup] ([GroupID]) ON DELETE CASCADE
GO

/* ------------------------------------------------------- */
/* Add table "RequestProperties"                           */
/* ------------------------------------------------------- */

CREATE TABLE [RequestProperties](
	[Id] INTEGER IDENTITY(1,1) NOT NULL,
	[EntityID] UNIQUEIDENTIFIER NOT NULL,
	[PropertyName] NVARCHAR(128) NOT NULL,
	[PropertyValue] NVARCHAR(MAX),
	[IsHidden] BIT NOT NULL DEFAULT 0,
	[IsRuntime] BIT NOT NULL DEFAULT 0,
	[IsEncrypted] BIT NOT NULL DEFAULT 0,
	CONSTRAINT [PK_RequestProperties] PRIMARY KEY NONCLUSTERED ([Id])
) 
GO

CREATE CLUSTERED INDEX [IX_RequestProperties] ON [RequestProperties] ([EntityID], [PropertyName] ASC)
GO

ALTER TABLE [RequestProperties] ADD CONSTRAINT [FK_RequestProperties_Request] 
	FOREIGN KEY ([EntityID]) REFERENCES [Request] ([RequestID]) ON DELETE CASCADE
GO

/* ------------------------------------------------------- */
/* Add table "VirtualMachineHistoryProperties"             */
/* ------------------------------------------------------- */

CREATE TABLE [VirtualMachineHistoryProperties](
	[Id] INTEGER IDENTITY(1,1) NOT NULL,
	[EntityID] UNIQUEIDENTIFIER NOT NULL,
	[PropertyName] NVARCHAR(128) NOT NULL,
	[PropertyValue] NVARCHAR(MAX),
	[IsHidden] BIT NOT NULL DEFAULT 0,
	[IsRuntime] BIT NOT NULL DEFAULT 0,
	[IsEncrypted] BIT NOT NULL DEFAULT 0,
	CONSTRAINT [PK_VirtualMachineHistoryProperties] PRIMARY KEY NONCLUSTERED ([Id])
) 
GO

CREATE CLUSTERED INDEX [IX_VirtualMachineHistoryProperties] ON [VirtualMachineHistoryProperties] ([EntityID], [PropertyName] ASC)
GO

ALTER TABLE [VirtualMachineHistoryProperties] ADD CONSTRAINT [FK_VirtualMachineHistoryProperties_VirtualMachineHistory] 
	FOREIGN KEY ([EntityID]) REFERENCES [VirtualMachineHistory] ([VirtualMachineID]) ON DELETE CASCADE
GO

/* ------------------------------------------------------- */
/* Add table "EndpointUsageHistory"			               */
/* ------------------------------------------------------- */

CREATE TABLE [dbo].[EndpointUsageHistory](
	[Id] UNIQUEIDENTIFIER NOT NULL,
	[DateTaken] DATETIME NOT NULL,
	[EndpointName] NVARCHAR(256) NOT NULL,
	[EndpointId] UNIQUEIDENTIFIER NOT NULL,
	[NumberOfServer] INT,
	[NumberOfDesktop] INT,
	CONSTRAINT [PK_EndpointUsageHistory] PRIMARY KEY ([Id])
 ) 
GO

/* ------------------------------------------------------- */
/* Add table "MachineUsageHistory"						   */
/* ------------------------------------------------------- */

CREATE TABLE [dbo].[MachineUsageHistory](
	[Id] [uniqueidentifier] NOT NULL,
	[DateTaken] [datetime] NOT NULL,
	[MachineType] [tinyint] NOT NULL,
	[BlueprintType] [tinyint] NOT NULL,
	[TotalMachineCount] [int] NOT NULL,
	[DayTaken] [datetime]  NOT NULL,
    [BatchId] [uniqueidentifier]  NOT NULL,
 CONSTRAINT [PK_MachineUsageHistory] PRIMARY KEY CLUSTERED 
(
	[Id] ASC
)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON) ON [PRIMARY]
) ON [PRIMARY]

GO

/* ------------------------------------------------------- */
/* Add table "MachineStateHistory"						   */
/* ------------------------------------------------------- */

CREATE TABLE [dbo].[MachineStateHistory](
	[Id] [uniqueidentifier] NOT NULL,
	[MachineUsageHistoryId] [uniqueidentifier] NOT NULL,
	[MachineState] [nvarchar](128) NOT NULL,
	[MachineCount] [int] NOT NULL,
 CONSTRAINT [PK_MachineStatusHistory] PRIMARY KEY CLUSTERED 
(
	[Id] ASC
)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON) ON [PRIMARY]
) ON [PRIMARY]

GO

/* ---------------------------------------------------------------------- */
/* Foreign key constraints                                                */
/* ---------------------------------------------------------------------- */

ALTER TABLE [dbo].[MachineStateHistory]  WITH CHECK ADD  CONSTRAINT [FK_MachineStateHistory_MachineUsageHistory] FOREIGN KEY([MachineUsageHistoryId])
REFERENCES [dbo].[MachineUsageHistory] ([Id])
GO

ALTER TABLE [dbo].[MachineStateHistory] CHECK CONSTRAINT [FK_MachineStateHistory_MachineUsageHistory]
GO

ALTER TABLE [CategoryLog] ADD CONSTRAINT [Categories_CategoryLog] 
	FOREIGN KEY ([CategoryID]) REFERENCES [Categories] ([CategoryID])
GO

ALTER TABLE [CategoryLog] ADD CONSTRAINT [Audit_CategoryLog] 
	FOREIGN KEY ([LogID]) REFERENCES [Audit] ([LogID])
GO

ALTER TABLE [ProvisioningGroup] ADD CONSTRAINT [FK_Group_HostNamePrefix] 
	FOREIGN KEY ([HostnamePrefixID]) REFERENCES [HostNamePrefix] ([HostnamePrefixID])
GO

ALTER TABLE [ProvisioningGroup] ADD CONSTRAINT [GroupType_ProvisioningGroup] 
	FOREIGN KEY ([GroupType]) REFERENCES [GroupType] ([GroupType])
GO

ALTER TABLE [GroupSecurity] ADD CONSTRAINT [ProvisioningGroup_GroupSecurity] 
	FOREIGN KEY ([GroupID]) REFERENCES [ProvisioningGroup] ([GroupID])
GO

ALTER TABLE [Host] ADD CONSTRAINT [FK_CostProfile_Host] 
	FOREIGN KEY ([CostProfileID]) REFERENCES [CostProfile] ([CostProfileID])
GO

ALTER TABLE [Host] ADD CONSTRAINT [FK_ManagementEndpoint_Host] 
	FOREIGN KEY ([ManagementEndpointID]) REFERENCES [ManagementEndpoints] ([ManagementEndpointID])
GO

ALTER TABLE [Host] ADD CONSTRAINT [PhysicalLocation_Host] 
	FOREIGN KEY ([PhysicalLocationID]) REFERENCES [PhysicalLocation] ([PhysicalLocationID])
GO

ALTER TABLE [Host] ADD CONSTRAINT [Host_Host] 
	FOREIGN KEY ([ClusterHostID]) REFERENCES [Host] ([HostID])
GO

ALTER TABLE [Host] ADD CONSTRAINT [HostState_Host] 
	FOREIGN KEY ([HostStateID]) REFERENCES [HostState] ([HostStateID])
GO

ALTER TABLE [Host] ADD CONSTRAINT [Agent_Host] 
	FOREIGN KEY ([ProvisioningAgentID]) REFERENCES [Agent] ([AgentID]) ON DELETE SET NULL
GO

ALTER TABLE [HostNic] ADD CONSTRAINT [Host_HostNic] 
	FOREIGN KEY ([HostID]) REFERENCES [Host] ([HostID])
GO

ALTER TABLE [HostReservation] ADD CONSTRAINT [FK_HostReservation_Group] 
	FOREIGN KEY ([GroupID]) REFERENCES [ProvisioningGroup] ([GroupID]) ON DELETE CASCADE
GO

ALTER TABLE [HostReservation] ADD CONSTRAINT [ResourcePool_HostReservation] 
	FOREIGN KEY ([ResourcePoolID]) REFERENCES [ResourcePool] ([ResourcePoolID])
GO

ALTER TABLE [HostReservation] ADD CONSTRAINT [Host_HostReservation] 
	FOREIGN KEY ([HostID]) REFERENCES [Host] ([HostID])
GO

ALTER TABLE [HostReservation] ADD CONSTRAINT [StorageAllocationPolicy_HostReservation] 
	FOREIGN KEY ([StorageAllocationPolicyID]) REFERENCES [StorageAllocationPolicy] ([StorageAllocationPolicyID])
GO

ALTER TABLE [HostReservation] ADD CONSTRAINT [HostReservationPolicy_HostReservation] 
	FOREIGN KEY ([ReservationPolicyID]) REFERENCES [HostReservationPolicy] ([id])
GO

ALTER TABLE [VirtualMachine] ADD CONSTRAINT [FK_VirtualMachine_HostReservation] 
	FOREIGN KEY ([HostReservationID]) REFERENCES [HostReservation] ([HostReservationID]) ON DELETE CASCADE
GO

ALTER TABLE [VirtualMachine] ADD CONSTRAINT [FK_VirtualMachine_VirtualMachineTemplate] 
	FOREIGN KEY ([VirtualMachineTemplateID]) REFERENCES [VirtualMachineTemplate] ([VirtualMachineTemplateID])
GO

ALTER TABLE [VirtualMachine] ADD CONSTRAINT [ResourcePool_VirtualMachine] 
	FOREIGN KEY ([ResourcePoolID]) REFERENCES [ResourcePool] ([ResourcePoolID])
GO

ALTER TABLE [VirtualMachine] ADD CONSTRAINT [Host_VirtualMachine] 
	FOREIGN KEY ([HostID]) REFERENCES [Host] ([HostID])
GO

ALTER TABLE [VirtualMachine] ADD CONSTRAINT [Users_VirtualMachine_Owner] 
	FOREIGN KEY ([Owner]) REFERENCES [Users] ([UserID])
GO

ALTER TABLE [VirtualMachine] ADD CONSTRAINT [Users_VirtualMachine_Approver] 
	FOREIGN KEY ([Approver]) REFERENCES [Users] ([UserID])
GO

ALTER TABLE [VirtualMachine] ADD CONSTRAINT [HostReservationToStorage_VirtualMachine] 
	FOREIGN KEY ([HostStorageReservationID]) REFERENCES [HostReservationToStorage] ([HostReservationToStorageID])
GO

ALTER TABLE [VirtualMachine] ADD CONSTRAINT [VirtualMachine_VirtualMachine] 
	FOREIGN KEY ([ParentMachineID]) REFERENCES [VirtualMachine] ([VirtualMachineID])
GO

ALTER TABLE [VirtualMachineUsage] ADD CONSTRAINT [VirtualMachine_VirtualMachineUsage] 
	FOREIGN KEY ([VirtualMachineID]) REFERENCES [VirtualMachine] ([VirtualMachineID]) ON DELETE CASCADE
GO

ALTER TABLE [VirtualMachineTemplate] ADD CONSTRAINT [VirtualMachineTemplate_VirtualMachineTemplate] 
	FOREIGN KEY ([InheritsFromVMTemplateID]) REFERENCES [VirtualMachineTemplate] ([VirtualMachineTemplateID])
GO

ALTER TABLE [VirtualMachineTemplate] ADD CONSTRAINT [WorkflowInfo_VirtualMachineTemplate] 
	FOREIGN KEY ([WorkflowID]) REFERENCES [WorkflowInfo] ([WorkflowID])
GO

ALTER TABLE [VirtualMachineTemplate] ADD CONSTRAINT [ApprovalPolicy_VirtualMachineTemplate] 
	FOREIGN KEY ([ApprovalPolicyId]) REFERENCES [ApprovalPolicy] ([PolicyId])
GO

ALTER TABLE [VirtualMachineTemplate] ADD CONSTRAINT [HostReservationPolicy_VirtualMachineTemplate] 
	FOREIGN KEY ([ReservationPolicyID]) REFERENCES [HostReservationPolicy] ([id])
GO

ALTER TABLE [VirtualMachineTemplate] ADD CONSTRAINT [VirtualMachineTemplate_InterfaceType]
    FOREIGN KEY ([InterfaceTypeId]) REFERENCES [dbo].[InterfaceTypes] ([InterfaceTypeId])
GO

ALTER TABLE [WorkItem] ADD CONSTRAINT [DataCollectionStatus_WorkItem] 
	FOREIGN KEY ([DataCollectionStatusID]) REFERENCES [DataCollectionStatus] ([DataCollectionStatusID]) ON DELETE CASCADE
GO

ALTER TABLE [Request] ADD CONSTRAINT [VirtualMachine_Request] 
	FOREIGN KEY ([VirtualMachineID]) REFERENCES [VirtualMachine] ([VirtualMachineID]) ON DELETE CASCADE
GO

ALTER TABLE [Request] ADD CONSTRAINT [VirtualMachineTemplate_Request] 
	FOREIGN KEY ([VirtualMachineTemplateID]) REFERENCES [VirtualMachineTemplate] ([VirtualMachineTemplateID])
GO

ALTER TABLE [Request] ADD CONSTRAINT [RequestType_Request] 
	FOREIGN KEY ([RequestTypeID]) REFERENCES [RequestType] ([RequestTypeID])
GO

ALTER TABLE [Request] ADD CONSTRAINT [Users_Request] 
	FOREIGN KEY ([RequestUser]) REFERENCES [Users] ([UserID])
GO

ALTER TABLE [Request] ADD CONSTRAINT [Host_Request] 
	FOREIGN KEY ([HostID]) REFERENCES [Host] ([HostID]) ON DELETE SET NULL
GO

ALTER TABLE [Request] ADD CONSTRAINT [ProvisioningGroup_Request] 
	FOREIGN KEY ([GroupID]) REFERENCES [ProvisioningGroup] ([GroupID])
GO

ALTER TABLE [VMEvents] ADD CONSTRAINT [VirtualMachine_VMEvents] 
	FOREIGN KEY ([VirtualMachineID]) REFERENCES [VirtualMachine] ([VirtualMachineID]) ON DELETE CASCADE
GO

ALTER TABLE [VMEvents] ADD CONSTRAINT [VMEventType_VMEvents] 
	FOREIGN KEY ([EventTypeID]) REFERENCES [VMEventType] ([EventTypeID])
GO

ALTER TABLE [VMEvents] ADD CONSTRAINT [VMEventStatus_VMEvents] 
	FOREIGN KEY ([EventStatusID]) REFERENCES [VMEventStatus] ([EventStatusID])
GO

ALTER TABLE [Storage] ADD CONSTRAINT [HostStorageType_Storage] 
	FOREIGN KEY ([StorageTypeID]) REFERENCES [HostStorageType] ([StorageTypeID])
GO

ALTER TABLE [Storage] ADD CONSTRAINT [ManagementEndpoint_Storage] 
	FOREIGN KEY ([ManagementEndpointID]) REFERENCES [ManagementEndpoints] ([ManagementEndpointID])
GO

ALTER TABLE [Performance] ADD CONSTRAINT [MetricType_Performance] 
	FOREIGN KEY ([MetricTypeID]) REFERENCES [MetricType] ([MetricTypeID])
GO

ALTER TABLE [Performance] ADD CONSTRAINT [Entity_Performance] 
	FOREIGN KEY ([EntityID]) REFERENCES [Entity] ([EntityID])
GO

ALTER TABLE [Performance] ADD CONSTRAINT [EntityType_Performance] 
	FOREIGN KEY ([EntityTypeID]) REFERENCES [EntityType] ([EntityTypeID])
GO

ALTER TABLE [VMAlarm] ADD CONSTRAINT [VirtualMachine_VMAlarm] 
	FOREIGN KEY ([VirtualMachineID]) REFERENCES [VirtualMachine] ([VirtualMachineID]) ON DELETE CASCADE
GO

ALTER TABLE [VMAlarm] ADD CONSTRAINT [VMAlaramType_VMAlarm] 
	FOREIGN KEY ([VMAlarmTypeID]) REFERENCES [VMAlaramType] ([VMAlarmTypeID])
GO

ALTER TABLE [ResourcePool] ADD CONSTRAINT [Host_ResourcePool] 
	FOREIGN KEY ([HostID]) REFERENCES [Host] ([HostID])
GO

ALTER TABLE [HostToNetwork] ADD CONSTRAINT [Host_HostToNetwork] 
	FOREIGN KEY ([HostID]) REFERENCES [Host] ([HostID])
GO

ALTER TABLE [HostToStorage] ADD CONSTRAINT [Host_HostToStorage] 
	FOREIGN KEY ([HostID]) REFERENCES [Host] ([HostID])
GO

ALTER TABLE [HostToStorage] ADD CONSTRAINT [Storage_HostToStorage] 
	FOREIGN KEY ([StorageID]) REFERENCES [Storage] ([StorageID])
GO

ALTER TABLE [HostToStorage] ADD CONSTRAINT [HostStorageReservationPolicy_HostToStorage] 
	FOREIGN KEY ([HostStorageReservationPolicyID]) REFERENCES [HostStorageReservationPolicy] ([HostStorageReservationPolicyID])
GO

ALTER TABLE [AdminGroupToHost] ADD CONSTRAINT [Host_AdminGroupToHost] 
	FOREIGN KEY ([HostID]) REFERENCES [Host] ([HostID])
GO

ALTER TABLE [AdminGroupToHost] ADD CONSTRAINT [EnterpriseAdminGroups_AdminGroupToHost] 
	FOREIGN KEY ([EnterpriseAdminID]) REFERENCES [EnterpriseAdminGroups] ([EnterpriseAdminID]) ON DELETE CASCADE
GO

ALTER TABLE [AdminGroupMembers] ADD CONSTRAINT [EnterpriseAdminGroups_AdminGroupMembers] 
	FOREIGN KEY ([EnterpriseAdminID]) REFERENCES [EnterpriseAdminGroups] ([EnterpriseAdminID])
GO

ALTER TABLE [AdminGroupMembers] ADD CONSTRAINT [Users_AdminGroupMembers] 
	FOREIGN KEY ([UserName]) REFERENCES [Users] ([UserID])
GO

ALTER TABLE [HostUsage] ADD CONSTRAINT [HostState_HostUsage] 
	FOREIGN KEY ([HostStateID]) REFERENCES [HostState] ([HostStateID])
GO

ALTER TABLE [HostUsage] ADD CONSTRAINT [Host_HostUsage] 
	FOREIGN KEY ([HostID]) REFERENCES [Host] ([HostID])
GO

ALTER TABLE [HostToProxyAgent] ADD CONSTRAINT [Host_HostToProxyAgent] 
	FOREIGN KEY ([HostID]) REFERENCES [Host] ([HostID])
GO

ALTER TABLE [Users] ADD CONSTRAINT [ProvisioningGroup_Users] 
	FOREIGN KEY ([GroupID]) REFERENCES [ProvisioningGroup] ([GroupID]) ON DELETE SET NULL
GO

ALTER TABLE [DataSource] ADD CONSTRAINT [Credential_DataSource] 
	FOREIGN KEY ([CredentialID]) REFERENCES [Credential] ([CredentialID])
GO

ALTER TABLE [FilterSpec] ADD CONSTRAINT [FilterSpecGroup_FilterSpec] 
	FOREIGN KEY ([FilterSpecGroupID]) REFERENCES [FilterSpecGroup] ([FilterSpecGroupID]) ON DELETE CASCADE
GO

ALTER TABLE [FilterSpec] ADD CONSTRAINT [AgentCapabilityType_FilterSpec] 
	FOREIGN KEY ([AgentCapabilityName]) REFERENCES [AgentCapabilityType] ([AgentCapabilityName])
GO

ALTER TABLE [AgentWorkItem] ADD CONSTRAINT [FilterSpecGroup_AgentWorkItem] 
	FOREIGN KEY ([FilterSpecGroupID]) REFERENCES [FilterSpecGroup] ([FilterSpecGroupID])
GO

ALTER TABLE [AgentWorkItem] ADD CONSTRAINT [VirtualMachine_AgentWorkItem] 
	FOREIGN KEY ([VirtualMachineID]) REFERENCES [VirtualMachine] ([VirtualMachineID])
GO

ALTER TABLE [AgentWorkItem] ADD CONSTRAINT [Host_AgentWorkItem] 
	FOREIGN KEY ([HostID]) REFERENCES [Host] ([HostID])
GO

ALTER TABLE [AgentWorkItem] ADD CONSTRAINT [AgentCapabilityType_AgentWorkItem] 
	FOREIGN KEY ([AgentCapabilityName]) REFERENCES [AgentCapabilityType] ([AgentCapabilityName])
GO

ALTER TABLE [AgentWorkItem] ADD CONSTRAINT [HypervisorManagementEndpoint_AgentWorkItem] 
	FOREIGN KEY ([HypervisorManagementID]) REFERENCES [HypervisorManagementEndpoint] ([HypervisorManagementID])
GO

ALTER TABLE [FilterSchedule] ADD CONSTRAINT [FilterSpecGroup_FilterSchedule] 
	FOREIGN KEY ([FilterSpecGroupID]) REFERENCES [FilterSpecGroup] ([FilterSpecGroupID])
GO

ALTER TABLE [FilterSchedule] ADD CONSTRAINT [CollectionSchedule_FilterSchedule] 
	FOREIGN KEY ([ScheduleID]) REFERENCES [CollectionSchedule] ([ScheduleID])
GO

ALTER TABLE [FilterSpecGroup] ADD CONSTRAINT [CollectionSchedule_FilterSpecGroup] 
	FOREIGN KEY ([ScheduleID]) REFERENCES [CollectionSchedule] ([ScheduleID])
GO

ALTER TABLE [FilterSpecGroup] ADD CONSTRAINT [FilterSpecGroup_FilterSpecGroup] 
	FOREIGN KEY ([DependsOnFilterSpecGroupID]) REFERENCES [FilterSpecGroup] ([FilterSpecGroupID])
GO

ALTER TABLE [CredentialAssoc] ADD CONSTRAINT [Credential_CredentialAssoc] 
	FOREIGN KEY ([CredentialID]) REFERENCES [Credential] ([CredentialID])
GO

ALTER TABLE [CredentialAssoc] ADD CONSTRAINT [ProvisioningGroup_CredentialAssoc] 
	FOREIGN KEY ([GroupID]) REFERENCES [ProvisioningGroup] ([GroupID])
GO

ALTER TABLE [CredentialAssoc] ADD CONSTRAINT [VirtualMachineTemplate_CredentialAssoc] 
	FOREIGN KEY ([VirtualMachineTemplateID]) REFERENCES [VirtualMachineTemplate] ([VirtualMachineTemplateID])
GO

ALTER TABLE [CredentialAssoc] ADD CONSTRAINT [Agent_CredentialAssoc] 
	FOREIGN KEY ([AgentID]) REFERENCES [Agent] ([AgentID])
GO

ALTER TABLE [HypervisorManagementEndpoint] ADD CONSTRAINT [Credential_HypervisorManagementEndpoint] 
	FOREIGN KEY ([CredentialID]) REFERENCES [Credential] ([CredentialID])
GO

ALTER TABLE [HypervisorManagementEndpoint] ADD CONSTRAINT [Agent_HypervisorManagementEndpoint_1] 
	FOREIGN KEY ([HypervisorAgentID]) REFERENCES [Agent] ([AgentID])
GO

ALTER TABLE [HypervisorManagementEndpoint] ADD CONSTRAINT [Agent_HypervisorManagementEndpoint] 
	FOREIGN KEY ([MonitoringAgentID]) REFERENCES [Agent] ([AgentID])
GO

ALTER TABLE [HypervisorManagementEndpoint] ADD CONSTRAINT [HypervisorType_HypervisorManagementEndpoint] 
	FOREIGN KEY ([HypervisorTypeID]) REFERENCES [HypervisorType] ([HypervisorTypeID])
GO

ALTER TABLE [HostToAgent] ADD CONSTRAINT [Agent_HostToAgent] 
	FOREIGN KEY ([AgentID]) REFERENCES [Agent] ([AgentID]) ON DELETE CASCADE
GO

ALTER TABLE [HostToAgent] ADD CONSTRAINT [Host_HostToAgent] 
	FOREIGN KEY ([HostID]) REFERENCES [Host] ([HostID])
GO

ALTER TABLE [HostsInHypervisor] ADD CONSTRAINT [HypervisorManagementEndpoint_HostsInHypervisor] 
	FOREIGN KEY ([HypervisorManagementID]) REFERENCES [HypervisorManagementEndpoint] ([HypervisorManagementID])
GO

ALTER TABLE [HostsInHypervisor] ADD CONSTRAINT [Host_HostsInHypervisor] 
	FOREIGN KEY ([HostID]) REFERENCES [Host] ([HostID])
GO

ALTER TABLE [HostNicToReservation] ADD CONSTRAINT [HostReservation_HostNicToReservation] 
	FOREIGN KEY ([HostReservationID]) REFERENCES [HostReservation] ([HostReservationID]) ON DELETE CASCADE
GO

ALTER TABLE [HostNicToReservation] ADD CONSTRAINT [HostNic_HostNicToReservation] 
	FOREIGN KEY ([HostNicID]) REFERENCES [HostNic] ([HostNicID])
GO

ALTER TABLE [HostReservationToStorage] ADD CONSTRAINT [HostReservation_HostReservationToStorage] 
	FOREIGN KEY ([HostReservationID]) REFERENCES [HostReservation] ([HostReservationID]) ON DELETE CASCADE
GO

ALTER TABLE [HostReservationToStorage] ADD CONSTRAINT [HostToStorage_HostReservationToStorage] 
	FOREIGN KEY ([HostToStorageID]) REFERENCES [HostToStorage] ([HostToStorageID])
GO

ALTER TABLE [HostReservationToStorage] ADD CONSTRAINT [HostStorageReservationPolicy_HostReservationToStorage] 
	FOREIGN KEY ([HostStorageReservationPolicyID]) REFERENCES [HostStorageReservationPolicy] ([HostStorageReservationPolicyID])
GO

ALTER TABLE [TagToEntity] ADD CONSTRAINT [Tag_TagToEntity] 
	FOREIGN KEY ([TagID]) REFERENCES [Tag] ([TagID])
GO

ALTER TABLE [AgentCapabilities] ADD CONSTRAINT [Agent_AgentCapabilities] 
	FOREIGN KEY ([AgentID]) REFERENCES [Agent] ([AgentID]) ON DELETE CASCADE
GO

ALTER TABLE [AgentCapabilities] ADD CONSTRAINT [AgentCapabilityType_AgentCapabilities] 
	FOREIGN KEY ([AgentCapabilityName]) REFERENCES [AgentCapabilityType] ([AgentCapabilityName])
GO

ALTER TABLE [VMToNetwork] ADD CONSTRAINT [VirtualMachine_VMToNetwork] 
	FOREIGN KEY ([VirtualMachineID]) REFERENCES [VirtualMachine] ([VirtualMachineID]) ON DELETE CASCADE
GO

ALTER TABLE [VMToNetwork] ADD CONSTRAINT [HostNic_VMToNetwork] 
	FOREIGN KEY ([HostNicID]) REFERENCES [HostNic] ([HostNicID])
GO

ALTER TABLE [dbo].[VMDiskHardware] WITH NOCHECK ADD CONSTRAINT [VirtualMachine_VMDiskHardware] 
	FOREIGN KEY ([VirtualMachineID]) REFERENCES [VirtualMachine] ([VirtualMachineID])
GO

ALTER TABLE [dbo].[VMDiskHardware] NOCHECK CONSTRAINT [VirtualMachine_VMDiskHardware]
GO

ALTER TABLE [VMDiskHardware] ADD CONSTRAINT [HostToStorage_VMDiskHardware] 
	FOREIGN KEY ([HostToStorageID]) REFERENCES [HostToStorage] ([HostToStorageID]) ON DELETE SET NULL
GO

ALTER TABLE [VMDiskHardwareHistory] ADD CONSTRAINT [VirtualMachineHistory_VMDiskHardwareHistory] 	
	FOREIGN KEY ([VirtualMachineID]) REFERENCES [VirtualMachineHistory] ([VirtualMachineID]) ON DELETE CASCADE
GO

ALTER TABLE [VMDiskHardwareHistory] ADD CONSTRAINT [HostToStorage_VMDiskHardwareHistory] 
	FOREIGN KEY ([HostToStorageID]) REFERENCES [HostToStorage] ([HostToStorageID]) ON DELETE SET NULL
GO

ALTER TABLE [VMLogicalDisk] ADD CONSTRAINT [VirtualMachine_VMLogicalDisk] 
	FOREIGN KEY ([VirtualMachineID]) REFERENCES [VirtualMachine] ([VirtualMachineID]) ON DELETE CASCADE
GO

ALTER TABLE [PropertyListItem] ADD CONSTRAINT [PropertyValueList_PropertyListItem] 
	FOREIGN KEY ([AttrValueListID]) REFERENCES [PropertyValueList] ([AttrValueListID])
GO

ALTER TABLE [PropertyCatalog] ADD CONSTRAINT [PropertyValueList_PropertyCatalog] 
	FOREIGN KEY ([AttrValueListID]) REFERENCES [PropertyValueList] ([AttrValueListID])
GO

ALTER TABLE [PropertyCatalog] ADD CONSTRAINT [PropertyDataType_PropertyCatalog] 
	FOREIGN KEY ([PropertyDataTypeID]) REFERENCES [PropertyDataType] ([PropertyDataTypeID])
GO

ALTER TABLE [PropertyCatalog] ADD CONSTRAINT [PropertyGroup_PropertyCatalog] 
	FOREIGN KEY ([PropertyGroupID]) REFERENCES [PropertyGroup] ([PropertyGroupID])
GO

ALTER TABLE [PropertyValue] ADD CONSTRAINT [Entity_PropertyValue] 
	FOREIGN KEY ([EntityID]) REFERENCES [Entity] ([EntityID])
GO

ALTER TABLE [Entity] ADD CONSTRAINT [EntityType_Entity] 
	FOREIGN KEY ([EntityTypeID]) REFERENCES [EntityType] ([EntityTypeID])
GO

ALTER TABLE [EntityRelationship] ADD CONSTRAINT [Entity_EntityRelationship] 
	FOREIGN KEY ([ChildEntityID]) REFERENCES [Entity] ([EntityID])
GO

ALTER TABLE [EntityRelationship] ADD CONSTRAINT [RelationshipType_EntityRelationship] 
	FOREIGN KEY ([RelTypeID], [RelPartitionKey]) REFERENCES [RelationshipType] ([RelTypeID],[RelPartitionKey])
GO

ALTER TABLE [EntityRelationship] ADD CONSTRAINT [RecAuditTimes_EntityRelationship] 
	FOREIGN KEY ([RecCreationTime], [RecUpdateTime], [RecDeleteTime]) REFERENCES [RecAuditTimes] ([RecCreationTime],[RecUpdateTime],[RecDeleteTime])
GO

ALTER TABLE [EntityRelationship] ADD CONSTRAINT [Entity_EntityRelationship_Parent] 
	FOREIGN KEY ([ParentEntityID]) REFERENCES [Entity] ([EntityID])
GO

ALTER TABLE [GroupToTemplate] ADD CONSTRAINT [ProvisioningGroup_GroupToTemplate] 
	FOREIGN KEY ([GroupID]) REFERENCES [ProvisioningGroup] ([GroupID]) ON DELETE CASCADE
GO

ALTER TABLE [GroupToTemplate] ADD CONSTRAINT [VirtualMachineTemplate_GroupToTemplate] 
	FOREIGN KEY ([VirtualMachineTemplateID]) REFERENCES [VirtualMachineTemplate] ([VirtualMachineTemplateID])
GO

ALTER TABLE [AgentWorkItemResponse] ADD CONSTRAINT [AgentWorkItem_AgentWorkItemResponse] 
	FOREIGN KEY ([WorkItemID]) REFERENCES [AgentWorkItem] ([WorkItemID])
GO

ALTER TABLE [AgentWorkItemResponse] ADD CONSTRAINT [Agent_AgentWorkItemResponse] 
	FOREIGN KEY ([AgentID]) REFERENCES [Agent] ([AgentID])
GO

ALTER TABLE [TemplateToGlobalProfiles] ADD CONSTRAINT [VirtualMachineTemplate_TemplateToGlobalProfiles] 
	FOREIGN KEY ([VirtualMachineTemplateID]) REFERENCES [VirtualMachineTemplate] ([VirtualMachineTemplateID])
GO

ALTER TABLE [TemplateToGlobalProfiles] ADD CONSTRAINT [GlobalProfiles_TemplateToGlobalProfiles] 
	FOREIGN KEY ([GlobalProfileID]) REFERENCES [GlobalProfiles] ([GlobalProfileID])
GO

ALTER TABLE [PropertyGroup] ADD CONSTRAINT [PropertyGroup_PropertyGroup] 
	FOREIGN KEY ([ParentPropertyGroupID]) REFERENCES [PropertyGroup] ([PropertyGroupID])
GO

ALTER TABLE [DataCollectionStatus] ADD CONSTRAINT [Agent_DataCollectionStatus] 
	FOREIGN KEY ([AgentID]) REFERENCES [Agent] ([AgentID]) ON DELETE CASCADE
GO

ALTER TABLE [DataCollectionStatus] ADD CONSTRAINT [FilterSpec_DataCollectionStatus] 
	FOREIGN KEY ([FilterSpecID]) REFERENCES [FilterSpec] ([FilterSpecID])
GO

ALTER TABLE [RequestAudit] ADD CONSTRAINT [RequestAuditType_RequestAudit] 
	FOREIGN KEY ([RequestAuditTypeID]) REFERENCES [RequestAuditType] ([RequestAuditTypeID])
GO

ALTER TABLE [RequestAudit] ADD CONSTRAINT [Request_RequestAudit] 
	FOREIGN KEY ([RequestID]) REFERENCES [Request] ([RequestID]) ON DELETE CASCADE
GO

ALTER TABLE [RequestApprover] ADD CONSTRAINT [Request_RequestApprover] 
	FOREIGN KEY ([RequestID]) REFERENCES [Request] ([RequestID]) ON DELETE CASCADE
GO

ALTER TABLE [RequestApprover] ADD CONSTRAINT [Users_RequestApprover] 
	FOREIGN KEY ([UserName]) REFERENCES [Users] ([UserID])
GO

ALTER TABLE [RequestApprover] ADD CONSTRAINT [RequestAuditType_RequestApprover] 
	FOREIGN KEY ([RequestApproverStateID]) REFERENCES [RequestAuditType] ([RequestAuditTypeID])
GO

ALTER TABLE [VMLoginUser] ADD CONSTRAINT [VirtualMachine_VMLoginUser] 
	FOREIGN KEY ([VirtualMachineID]) REFERENCES [VirtualMachine] ([VirtualMachineID]) ON DELETE CASCADE
GO

ALTER TABLE [VMLoginUser] ADD CONSTRAINT [Agent_VMLoginUser] 
	FOREIGN KEY ([AgentID]) REFERENCES [Agent] ([AgentID])
GO

ALTER TABLE [LastLoginIgnoreUser] ADD CONSTRAINT [VirtualMachine_LastLoginIgnoreUser] 
	FOREIGN KEY ([VirtualMachineID]) REFERENCES [VirtualMachine] ([VirtualMachineID]) ON DELETE CASCADE
GO

ALTER TABLE [StaticIPv4Range] ADD CONSTRAINT [StaticIPv4NetworkProfile_StaticIPv4Range] 
	FOREIGN KEY ([StaticIPv4NetworkProfileID]) REFERENCES [StaticIPv4NetworkProfile] ([ID]) ON DELETE CASCADE
GO

ALTER TABLE [StaticIPv4Address] ADD CONSTRAINT [StaticIPv4NetworkProfile_StaticIPv4Address] 
	FOREIGN KEY ([StaticIPv4NetworkProfileID]) REFERENCES [StaticIPv4NetworkProfile] ([ID]) ON DELETE CASCADE
GO

ALTER TABLE [StaticIPv4Address] ADD CONSTRAINT [StaticIPv4Range_StaticIPv4Address] 
	FOREIGN KEY ([StaticIPv4RangeID]) REFERENCES [StaticIPv4Range] ([ID])
GO

ALTER TABLE [StaticIPv4Address] ADD CONSTRAINT [VirtualMachine_StaticIPv4Address] 
	FOREIGN KEY ([VirtualMachineID]) REFERENCES [VirtualMachine] ([VirtualMachineID]) ON DELETE SET NULL
GO

ALTER TABLE [UserFilterExclusion] ADD CONSTRAINT [UserFilter_UserFilterExclusion] 
	FOREIGN KEY ([UserFilterID]) REFERENCES [UserFilter] ([UserFilterID]) ON DELETE CASCADE
GO

ALTER TABLE [VMPerformance] ADD CONSTRAINT [VirtualMachine_VMPerformance] 
	FOREIGN KEY ([VirtualMachineID]) REFERENCES [VirtualMachine] ([VirtualMachineID]) ON DELETE CASCADE
GO

ALTER TABLE [EmailProfile] ADD CONSTRAINT [Credential_EmailProfile] 
	FOREIGN KEY ([CredentialID]) REFERENCES [Credential] ([CredentialID])
GO

ALTER TABLE [WorkflowStateEvent] ADD CONSTRAINT [WorkflowInfo_WorkflowStateEvent]
	FOREIGN KEY ([WorkflowInfoId]) REFERENCES [WorkflowInfo] ([WorkflowID])
GO

ALTER TABLE [UserLog] ADD CONSTRAINT [FK_UserLog_Group] 
	FOREIGN KEY ([GroupID]) REFERENCES [ProvisioningGroup] ([GroupID]) ON DELETE SET NULL
GO

CREATE INDEX [IX_UserLog_UserName]
 ON [dbo].[UserLog] 
	([UserName]);
GO

-- Creating table 'WorkflowOperations'
CREATE TABLE [dbo].[WorkflowOperations] (
    [Id] int IDENTITY(1,1) NOT NULL,
    [OperationName] nvarchar(max)  NOT NULL
);
GO

-- Creating table 'WorkflowOperationArguments'
CREATE TABLE [dbo].[WorkflowOperationArguments] (
    [Id] int IDENTITY(1,1) NOT NULL,
    [Name] nvarchar(max)  NOT NULL,
    [Value] nvarchar(max)  NULL,
    [WorkflowOperation_Id] int  NOT NULL
);
GO

-- Creating primary key on [Id] in table 'WorkflowOperations'
ALTER TABLE [dbo].[WorkflowOperations]
ADD CONSTRAINT [PK_WorkflowOperations]
    PRIMARY KEY CLUSTERED ([Id] ASC);
GO

-- Creating primary key on [Id] in table 'WorkflowOperationArguments'
ALTER TABLE [dbo].[WorkflowOperationArguments]
ADD CONSTRAINT [PK_WorkflowOperationArguments]
    PRIMARY KEY CLUSTERED ([Id] ASC);
GO

-- Creating foreign key on [Alert_AlertId] in table 'AlertItems'
ALTER TABLE [dbo].[AlertItems] 
ADD CONSTRAINT [FK_Alerts_AlertItems_AlertId] 
	FOREIGN KEY ([AlertId]) 
	REFERENCES [dbo].[Alerts] ([Id]) 
	ON DELETE CASCADE;
GO

-- Creating non-clustered index for FOREIGN KEY 'FK_Alerts_AlertItems_AlertId'
CREATE INDEX [IX_FK_Alerts_AlertItems_AlertId]
ON [dbo].[AlertItems]
    ([AlertId]);
GO

-- Creating foreign key on [Alert_AlertId] in table 'HostReservation'
ALTER TABLE [dbo].[HostReservation] 
ADD CONSTRAINT [FK_Alerts_HostReservation_AlertId]
    FOREIGN KEY ([AlertId]) 
	REFERENCES [dbo].[Alerts] ([Id]) 
	ON DELETE CASCADE;
GO

-- Creating non-clustered index for FOREIGN KEY 'FK_Alerts_HostReservation_AlertId'
CREATE INDEX [IX_FK_Alerts_HostReservation_AlertId]
ON [dbo].[HostReservation]
    ([AlertId]);
GO

-- Creating foreign key on [Alert_AlertId] in table 'AlertEmailAddresses'
ALTER TABLE [dbo].[AlertEmailAddresses] 
ADD CONSTRAINT [FK_Alerts_AlertEmailAddresses_AlertId]
    FOREIGN KEY ([AlertId]) 
	REFERENCES [dbo].[Alerts] ([Id]) 
	ON DELETE CASCADE;
GO

-- Creating non-clustered index for FOREIGN KEY 'FK_Alerts_AlertEmailAddresses_AlertId'
CREATE INDEX [IX_FK_Alerts_AlertEmailAddresses_AlertId]
ON [dbo].[AlertEmailAddresses]
    ([AlertId]);
GO

-- Foreign keys related to the PhysicalMachine table

-- Creating foreign key on [PhysicalMachineID] in table 'PhysicalMachineProperties'
ALTER TABLE [dbo].[PhysicalMachineProperties] WITH NOCHECK 
ADD CONSTRAINT [FK_PhysicalMachinePhysicalMachineProperties]
	FOREIGN KEY ([PhysicalMachineID])
	REFERENCES [dbo].[PhysicalMachines]
		([PhysicalMachineID])
	ON DELETE CASCADE ON UPDATE NO ACTION
GO

-- Creating foreign key on [CostProfile_CostProfileID] in table 'PhysicalMachines'
ALTER TABLE [dbo].[PhysicalMachines]
ADD CONSTRAINT [FK_CostProfilePhysicalMachine]
    FOREIGN KEY ([CostProfileID])
    REFERENCES [dbo].[CostProfile]
        ([CostProfileID])
    ON DELETE NO ACTION ON UPDATE NO ACTION;

-- Creating non-clustered index for FOREIGN KEY 'FK_CostProfilePhysicalMachine'
CREATE INDEX [IX_FK_CostProfilePhysicalMachine]
ON [dbo].[PhysicalMachines]
    ([CostProfileID]);
GO

-- Creating foreign key on [PhysicalMachineID] in table 'VirtualMachine'
ALTER TABLE [dbo].[VirtualMachine] WITH NOCHECK
ADD CONSTRAINT [FK_VirtualMachinePhysicalMachine]
	FOREIGN KEY ([PhysicalMachineID])
	REFERENCES [dbo].[PhysicalMachines]
		([PhysicalMachineID])
	ON DELETE NO ACTION ON UPDATE NO ACTION
GO
-- Creating foreign key on [ManagementEndpointID] in table 'ManagementEndpointProperties'
ALTER TABLE [dbo].[ManagementEndpointProperties] WITH NOCHECK 
ADD CONSTRAINT [FK_ManagementEndpointManagementEndpointProperty]
	FOREIGN KEY ([ManagementEndpointID])
	REFERENCES [dbo].[ManagementEndpoints]
		([ManagementEndpointID])
	ON DELETE CASCADE ON UPDATE NO ACTION
GO

-- Creating foreign key on [InterfaceType] in table 'ManagementEndpoints'
ALTER TABLE [dbo].[ManagementEndpoints]
ADD CONSTRAINT [FK_ManagementEndpoint_InterfaceType]
    FOREIGN KEY ([InterfaceType])
    REFERENCES [dbo].[InterfaceTypes]
        ([InterfaceTypeId])
    ON DELETE NO ACTION ON UPDATE NO ACTION;

-- Creating foreign key on [Credential_CredentialID] in table 'ManagementEndpoints'
ALTER TABLE [dbo].[ManagementEndpoints]
ADD CONSTRAINT [FK_ManagementEndpointCredential]
    FOREIGN KEY ([Credential_CredentialID])
    REFERENCES [dbo].[Credential]
        ([CredentialID])
    ON DELETE NO ACTION ON UPDATE NO ACTION;

-- Creating non-clustered index for FOREIGN KEY 'FK_ManagementEndpointCredential'
CREATE INDEX [IX_FK_ManagementEndpointCredential]
ON [dbo].[ManagementEndpoints]
    ([Credential_CredentialID]);
GO

-- Creating foreign key on [ManagementEndpoint_ManagementEndpointID] in table 'PhysicalControllers'
ALTER TABLE [dbo].[PhysicalControllers]
ADD CONSTRAINT [FK_ManagementEndpointPhysicalController]
    FOREIGN KEY ([ManagementEndpoint_ManagementEndpointID])
    REFERENCES [dbo].[ManagementEndpoints]
        ([ManagementEndpointID])
    ON DELETE NO ACTION ON UPDATE NO ACTION;

-- Creating non-clustered index for FOREIGN KEY 'FK_ManagementEndpointPhysicalController'
CREATE INDEX [IX_FK_ManagementEndpointPhysicalController]
ON [dbo].[PhysicalControllers]
    ([ManagementEndpoint_ManagementEndpointID]);
GO

-- Creating foreign key on [PhysicalController_PhysicalControllerID] in table 'PhysicalMachines'
ALTER TABLE [dbo].[PhysicalMachines]
ADD CONSTRAINT [FK_PhysicalControllerPhysicalMachine]
    FOREIGN KEY ([PhysicalController_PhysicalControllerID])
    REFERENCES [dbo].[PhysicalControllers]
        ([PhysicalControllerID])
    ON DELETE CASCADE ON UPDATE NO ACTION;

-- Creating non-clustered index for FOREIGN KEY 'FK_PhysicalControllerPhysicalMachine'
CREATE INDEX [IX_FK_PhysicalControllerPhysicalMachine]
ON [dbo].[PhysicalMachines]
    ([PhysicalController_PhysicalControllerID]);
GO

-- Creating foreign key on [PhysicalMachine_PhysicalMachineID] in table 'PhysicalNetworks'
ALTER TABLE [dbo].[PhysicalNetworks]
ADD CONSTRAINT [FK_PhysicalMachinePhysicalNetwork]
    FOREIGN KEY ([PhysicalMachine_PhysicalMachineID])
    REFERENCES [dbo].[PhysicalMachines]
        ([PhysicalMachineID])
    ON DELETE CASCADE ON UPDATE NO ACTION;

-- Creating non-clustered index for FOREIGN KEY 'FK_PhysicalMachinePhysicalNetwork'
CREATE INDEX [IX_FK_PhysicalMachinePhysicalNetwork]
ON [dbo].[PhysicalNetworks]
    ([PhysicalMachine_PhysicalMachineID]);
GO

-- Creating foreign key on [PhysicalMachine_PhysicalMachineID] in table 'PhysicalStorages'
ALTER TABLE [dbo].[PhysicalStorages]
ADD CONSTRAINT [FK_PhysicalMachinePhysicalStorage]
    FOREIGN KEY ([PhysicalMachine_PhysicalMachineID])
    REFERENCES [dbo].[PhysicalMachines]
        ([PhysicalMachineID])
    ON DELETE CASCADE ON UPDATE NO ACTION;

-- Creating non-clustered index for FOREIGN KEY 'FK_PhysicalMachinePhysicalStorage'
CREATE INDEX [IX_FK_PhysicalMachinePhysicalStorage]
ON [dbo].[PhysicalStorages]
    ([PhysicalMachine_PhysicalMachineID]);
GO

-- Creating foreign key on [WorkflowOperation_Id] in table 'WorkflowOperationArguments'
ALTER TABLE [dbo].[WorkflowOperationArguments]
ADD CONSTRAINT [FK_WorkflowOperationArgumentWorkflowOperation]
    FOREIGN KEY ([WorkflowOperation_Id])
    REFERENCES [dbo].[WorkflowOperations]
        ([Id])
    ON DELETE CASCADE ON UPDATE NO ACTION;

-- Creating non-clustered index for FOREIGN KEY 'FK_WorkflowOperationArgumentWorkflowOperation'
CREATE INDEX [IX_FK_WorkflowOperationArgumentWorkflowOperation]
ON [dbo].[WorkflowOperationArguments]
    ([WorkflowOperation_Id]);
GO

--
-- Machine Operations
--

-- Creating table 'MachineOperations'
CREATE TABLE [dbo].[MachineOperations] (
    [Id] uniqueidentifier  NOT NULL,
    [Name] nvarchar(max)  NOT NULL,
    [DefaultDisplayName] nvarchar(max)  NOT NULL,
    [IconUri] nvarchar(max)  NOT NULL,
    [TaskName] nvarchar(max)  NOT NULL,
    [MenuOrder] int  NOT NULL,
    [UriTemplate] nvarchar(max) NOT NULL,
    [DisplayStates] nvarchar(max)  NOT NULL
);
GO

-- Creating table 'MachineOperationVirtualMachineTemplate'
CREATE TABLE [dbo].[MachineOperationVirtualMachineTemplate] (
    [MachineOperations_Id] uniqueidentifier  NOT NULL,
    [VirtualMachineTemplates_VirtualMachineTemplateID] uniqueidentifier  NOT NULL
);
GO

-- Creating primary key on [Id] in table 'MachineOperations'
ALTER TABLE [dbo].[MachineOperations]
ADD CONSTRAINT [PK_MachineOperations]
    PRIMARY KEY CLUSTERED ([Id] ASC);
GO

-- Creating primary key on [MachineOperations_Id], [VirtualMachineTemplates_VirtualMachineTemplateID] in table 'MachineOperationVirtualMachineTemplate'
ALTER TABLE [dbo].[MachineOperationVirtualMachineTemplate]
ADD CONSTRAINT [PK_MachineOperationVirtualMachineTemplate]
    PRIMARY KEY NONCLUSTERED ([MachineOperations_Id], [VirtualMachineTemplates_VirtualMachineTemplateID] ASC);
GO

-- Creating foreign key on [MachineOperations_Id] in table 'MachineOperationVirtualMachineTemplate'
ALTER TABLE [dbo].[MachineOperationVirtualMachineTemplate]
ADD CONSTRAINT [FK_MachineOperationVirtualMachineTemplate_MachineOperation]
    FOREIGN KEY ([MachineOperations_Id])
    REFERENCES [dbo].[MachineOperations]
        ([Id])
    ON DELETE CASCADE ON UPDATE NO ACTION;
GO

-- Creating foreign key on [VirtualMachineTemplates_VirtualMachineTemplateID] in table 'MachineOperationVirtualMachineTemplate'
ALTER TABLE [dbo].[MachineOperationVirtualMachineTemplate]
ADD CONSTRAINT [FK_MachineOperationVirtualMachineTemplate_VirtualMachineTemplate]
    FOREIGN KEY ([VirtualMachineTemplates_VirtualMachineTemplateID])
    REFERENCES [dbo].[VirtualMachineTemplate]
        ([VirtualMachineTemplateID])
    ON DELETE CASCADE ON UPDATE NO ACTION;

-- Creating non-clustered index for FOREIGN KEY 'FK_MachineOperationVirtualMachineTemplate_VirtualMachineTemplate'
CREATE INDEX [IX_FK_MachineOperationVirtualMachineTemplate_VirtualMachineTemplate]
ON [dbo].[MachineOperationVirtualMachineTemplate]
    ([VirtualMachineTemplates_VirtualMachineTemplateID]);
GO

-- Creating table 'StorageCostProfiles'
CREATE TABLE [dbo].[StorageCostProfiles] (
    [Id] uniqueidentifier  NOT NULL,
    [Name] nvarchar(50)  NOT NULL,
    [Description] nvarchar(1024),
    [DiskCost] decimal(10,4)  NOT NULL
);
GO

-- Creating primary key on [Id] in table 'StorageCostProfiles'
ALTER TABLE [dbo].[StorageCostProfiles]
ADD CONSTRAINT [PK_StorageCostProfiles]
    PRIMARY KEY CLUSTERED ([Id] ASC);
GO

-- Creating foreign key on [StorageCostProfileId] in table 'HostToStorage'
ALTER TABLE [dbo].[HostToStorage]
ADD CONSTRAINT [FK_StorageCostProfileHostToStorage]
    FOREIGN KEY ([StorageCostProfileId])
    REFERENCES [dbo].[StorageCostProfiles]
        ([Id])
    ON DELETE NO ACTION ON UPDATE NO ACTION;

	-- Creating non-clustered index for FOREIGN KEY 'FK_StorageCostProfileHostToStorage'
CREATE INDEX [IX_FK_StorageCostProfileHostToStorage]
ON [dbo].[HostToStorage]
    ([StorageCostProfileId]);
GO

-- Creating foreign key on [VirtualMachineID] in table 'VMSnapshots'
ALTER TABLE [dbo].[VMSnapshots]
ADD CONSTRAINT [FK_VMSnapshots_VirtualMachine_VirtualMachineID]
    FOREIGN KEY ([VirtualMachineID])
    REFERENCES [dbo].[VirtualMachine]
        ([VirtualMachineID])
    ON DELETE CASCADE ON UPDATE NO ACTION;

-- Creating non-clustered index for FOREIGN KEY 'FK_VMSnapshots_VirtualMachine_VirtualMachineID'
CREATE INDEX [IX_FK_VMSnapshots_VirtualMachine_VirtualMachineID]
ON [dbo].[VMSnapshots]
    ([VirtualMachineID]);
GO

-- Creating foreign key on [ParentId] in table 'VMSnapshots'
ALTER TABLE [dbo].[VMSnapshots]
ADD CONSTRAINT [FK_VMSnapshots_VMSnapshots_ParentId]
    FOREIGN KEY ([ParentId])
    REFERENCES [dbo].[VMSnapshots]
        ([Id])
    ON DELETE NO ACTION ON UPDATE NO ACTION;

-- Creating non-clustered index for FOREIGN KEY 'FK_VMSnapshotParent'
CREATE INDEX [IX_FK_VMSnapshots_VMSnapshots_ParentId]
ON [dbo].[VMSnapshots]
    ([ParentId]);
    
-- Creating non-clustered index in table VMSnapshots for 'ExternalSnapshotId'
CREATE INDEX [IX_VMSnapshots_ExternalSnapshotId]
ON [dbo].[VMSnapshots]
    ([ExternalSnapshotId]);
    
GO

-- --------------------------------------------------
-- PropertyDictionary - Creating all tables
-- --------------------------------------------------

-- Creating table 'PropertyDefinitions'
CREATE TABLE [PropertyDefinitions] (
    [Id] int IDENTITY(1,1) NOT NULL,
    [PropertyName] nvarchar(max)  NOT NULL,
    [PropertyValue] nvarchar(max)  NOT NULL,
    [DisplayName] nvarchar(max)  NOT NULL,
    [FullDescription] nvarchar(max)  NOT NULL,
    [IsDefault] bit  NOT NULL,
    [IsRequired] bit  NOT NULL,
    [IsHidden] bit  NOT NULL,
    [IsRuntime] bit  NOT NULL,
    [IsEncrypted] bit  NOT NULL,
    [PropertyDefinitionSetId] int  NULL,
    [ControlTypeName] nvarchar(100)  NULL
);
GO

-- Creating table 'ControlTypes'
CREATE TABLE [ControlTypes] (
    [Name] nvarchar(100)  NOT NULL,
    [FullDescription] nvarchar(max)  NOT NULL,
    [UserControlFileName] nvarchar(max)  NULL,
    [AssemblyFQN] nvarchar(max)  NULL,
    [PropertyDefinitionId] int  NULL
);
GO

-- Creating table 'PropertyAttributes'
CREATE TABLE [PropertyAttributes] (
    [Id] int IDENTITY(1,1) NOT NULL,
    [PropertyDefinitionId] int  NOT NULL,
    [AttributeName] nvarchar(max)  NOT NULL,
    [AttributeValue] nvarchar(max)  NOT NULL,
    [PropertyAttributeTypeName] nvarchar(100)  NOT NULL
);
GO

-- Creating table 'PropertyAttributeTypes'
CREATE TABLE [PropertyAttributeTypes] (
    [Name] nvarchar(100)  NOT NULL,
    [FullDescription] nvarchar(max)  NOT NULL,
    [IsRule] bit  NOT NULL
);
GO

-- Creating table 'ControlLayouts'
CREATE TABLE [ControlLayouts] (
    [Id] int IDENTITY(1,1) NOT NULL,
    [LayoutName] nvarchar(max)  NOT NULL,
    [LabelWidth] nvarchar(max)  NOT NULL,
    [ControlWidth] nvarchar(max)  NOT NULL,
    [FullDescription] nvarchar(max)  NOT NULL,
    [WorkflowOperationName] nvarchar(max)  NULL,
    [Title] nvarchar(max)  NULL,
    [Label] nvarchar(max)  NULL,
    [ShowConfirmation] bit  NOT NULL
);
GO

-- Creating table 'ControlInstances'
CREATE TABLE [ControlInstances] (
    [Id] int IDENTITY(1,1) NOT NULL,
    [ControlLayoutId] int  NOT NULL,
    [OrderIndex] nvarchar(max)  NOT NULL,
    [PropertyDefinitionId] int  NOT NULL
);
GO

-- Creating table 'PropertyDefinitionSets'
CREATE TABLE [PropertyDefinitionSets] (
    [Id] int IDENTITY(1,1) NOT NULL,
    [SetName] nvarchar(max)  NOT NULL,
    [FullDescription] nvarchar(max)  NOT NULL,
    [IsReadOnly] bit  NOT NULL,
    [IsEnabled] bit  NOT NULL,
    [IsDefault] bit  NOT NULL
);
GO

-- Creating table 'PropertyValues'
CREATE TABLE [PropertyValues] (
    [Id] int IDENTITY(1,1) NOT NULL,
    [Value] nvarchar(max)  NOT NULL,
    [FilterName] nvarchar(max)  NULL,
    [FilterValue] nvarchar(max)  NULL,
    [PropertyDefinitionPropertyDefinitionId] int  NOT NULL
);
GO

-- Creating table 'ControlTypePropertyAttributeType'
CREATE TABLE [ControlTypePropertyAttributeType] (
    [ControlTypes_Name] nvarchar(100)  NOT NULL,
    [PropertyAttributeTypes_Name] nvarchar(100)  NOT NULL
);
GO

-- --------------------------------------------------
-- PropertyDictionary - Creating all PRIMARY KEY constraints
-- --------------------------------------------------

-- Creating primary key on [Id] in table 'PropertyDefinitions'
ALTER TABLE [PropertyDefinitions]
ADD CONSTRAINT [PK_PropertyDefinitions]
    PRIMARY KEY CLUSTERED ([Id] ASC);
GO

-- Creating primary key on [Name] in table 'ControlTypes'
ALTER TABLE [ControlTypes]
ADD CONSTRAINT [PK_ControlTypes]
    PRIMARY KEY CLUSTERED ([Name] ASC);
GO

-- Creating primary key on [Id] in table 'PropertyAttributes'
ALTER TABLE [PropertyAttributes]
ADD CONSTRAINT [PK_PropertyAttributes]
    PRIMARY KEY CLUSTERED ([Id] ASC);
GO

-- Creating primary key on [Name] in table 'PropertyAttributeTypes'
ALTER TABLE [PropertyAttributeTypes]
ADD CONSTRAINT [PK_PropertyAttributeTypes]
    PRIMARY KEY CLUSTERED ([Name] ASC);
GO

-- Creating primary key on [Id] in table 'ControlLayouts'
ALTER TABLE [ControlLayouts]
ADD CONSTRAINT [PK_ControlLayouts]
    PRIMARY KEY CLUSTERED ([Id] ASC);
GO

-- Creating primary key on [Id] in table 'ControlInstances'
ALTER TABLE [ControlInstances]
ADD CONSTRAINT [PK_ControlInstances]
    PRIMARY KEY CLUSTERED ([Id] ASC);
GO

-- Creating primary key on [Id] in table 'PropertyDefinitionSets'
ALTER TABLE [PropertyDefinitionSets]
ADD CONSTRAINT [PK_PropertyDefinitionSets]
    PRIMARY KEY CLUSTERED ([Id] ASC);
GO

-- Creating primary key on [Id] in table 'PropertyValues'
ALTER TABLE [PropertyValues]
ADD CONSTRAINT [PK_PropertyValues]
    PRIMARY KEY CLUSTERED ([Id] ASC);
GO

-- Creating primary key on [ControlTypes_Name], [PropertyAttributeTypes_Name] in table 'ControlTypePropertyAttributeType'
ALTER TABLE [ControlTypePropertyAttributeType]
ADD CONSTRAINT [PK_ControlTypePropertyAttributeType]
    PRIMARY KEY NONCLUSTERED ([ControlTypes_Name], [PropertyAttributeTypes_Name] ASC);
GO

-- --------------------------------------------------
-- PropertyDictionary - Creating all FOREIGN KEY constraints
-- --------------------------------------------------

-- Creating foreign key on [PropertyDefinitionId] in table 'PropertyAttributes'
ALTER TABLE [PropertyAttributes]
ADD CONSTRAINT [FK_PropertyDefinitionPropertyAttribute]
    FOREIGN KEY ([PropertyDefinitionId])
    REFERENCES [PropertyDefinitions]
        ([Id])
    ON DELETE NO ACTION ON UPDATE NO ACTION;

-- Creating non-clustered index for FOREIGN KEY 'FK_PropertyDefinitionPropertyAttribute'
CREATE INDEX [IX_FK_PropertyDefinitionPropertyAttribute]
ON [PropertyAttributes]
    ([PropertyDefinitionId]);
GO

-- Creating foreign key on [ControlLayoutId] in table 'ControlInstances'
ALTER TABLE [ControlInstances]
ADD CONSTRAINT [FK_ControlInstanceControlLayout]
    FOREIGN KEY ([ControlLayoutId])
    REFERENCES [ControlLayouts]
        ([Id])
    ON DELETE NO ACTION ON UPDATE NO ACTION;

-- Creating non-clustered index for FOREIGN KEY 'FK_ControlInstanceControlLayout'
CREATE INDEX [IX_FK_ControlInstanceControlLayout]
ON [ControlInstances]
    ([ControlLayoutId]);
GO

-- Creating foreign key on [PropertyDefinitionId] in table 'ControlInstances'
ALTER TABLE [ControlInstances]
ADD CONSTRAINT [FK_PropertyDefinitionControlInstance]
    FOREIGN KEY ([PropertyDefinitionId])
    REFERENCES [PropertyDefinitions]
        ([Id])
    ON DELETE NO ACTION ON UPDATE NO ACTION;

-- Creating non-clustered index for FOREIGN KEY 'FK_PropertyDefinitionControlInstance'
CREATE INDEX [IX_FK_PropertyDefinitionControlInstance]
ON [ControlInstances]
    ([PropertyDefinitionId]);
GO

-- Creating foreign key on [PropertyDefinitionPropertyDefinitionId] in table 'PropertyValues'
ALTER TABLE [PropertyValues]
ADD CONSTRAINT [FK_PropertyValuePropertyDefinition]
    FOREIGN KEY ([PropertyDefinitionPropertyDefinitionId])
    REFERENCES [PropertyDefinitions]
        ([Id])
    ON DELETE NO ACTION ON UPDATE NO ACTION;

-- Creating non-clustered index for FOREIGN KEY 'FK_PropertyValuePropertyDefinition'
CREATE INDEX [IX_FK_PropertyValuePropertyDefinition]
ON [PropertyValues]
    ([PropertyDefinitionPropertyDefinitionId]);
GO

-- Creating foreign key on [PropertyAttributeTypeName] in table 'PropertyAttributes'
ALTER TABLE [PropertyAttributes]
ADD CONSTRAINT [FK_PropertyAttributePropertyAttributeType]
    FOREIGN KEY ([PropertyAttributeTypeName])
    REFERENCES [PropertyAttributeTypes]
        ([Name])
    ON DELETE NO ACTION ON UPDATE NO ACTION;

-- Creating non-clustered index for FOREIGN KEY 'FK_PropertyAttributePropertyAttributeType'
CREATE INDEX [IX_FK_PropertyAttributePropertyAttributeType]
ON [PropertyAttributes]
    ([PropertyAttributeTypeName]);
GO

-- Creating foreign key on [ControlTypes_Name] in table 'ControlTypePropertyAttributeType'
ALTER TABLE [ControlTypePropertyAttributeType]
ADD CONSTRAINT [FK_ControlTypePropertyAttributeType_ControlType]
    FOREIGN KEY ([ControlTypes_Name])
    REFERENCES [ControlTypes]
        ([Name])
    ON DELETE NO ACTION ON UPDATE NO ACTION;
GO

-- Creating foreign key on [PropertyAttributeTypes_Name] in table 'ControlTypePropertyAttributeType'
ALTER TABLE [ControlTypePropertyAttributeType]
ADD CONSTRAINT [FK_ControlTypePropertyAttributeType_PropertyAttributeType]
    FOREIGN KEY ([PropertyAttributeTypes_Name])
    REFERENCES [PropertyAttributeTypes]
        ([Name])
    ON DELETE NO ACTION ON UPDATE NO ACTION;

-- Creating non-clustered index for FOREIGN KEY 'FK_ControlTypePropertyAttributeType_PropertyAttributeType'
CREATE INDEX [IX_FK_ControlTypePropertyAttributeType_PropertyAttributeType]
ON [ControlTypePropertyAttributeType]
    ([PropertyAttributeTypes_Name]);
GO

-- Creating foreign key on [PropertyDefinitionSetId] in table 'PropertyDefinitions'
ALTER TABLE [PropertyDefinitions]
ADD CONSTRAINT [FK_PropertyDefinitionPropertyDefinitionSet]
    FOREIGN KEY ([PropertyDefinitionSetId])
    REFERENCES [PropertyDefinitionSets]
        ([Id])
    ON DELETE NO ACTION ON UPDATE NO ACTION;

-- Creating non-clustered index for FOREIGN KEY 'FK_PropertyDefinitionPropertyDefinitionSet'
CREATE INDEX [IX_FK_PropertyDefinitionPropertyDefinitionSet]
ON [PropertyDefinitions]
    ([PropertyDefinitionSetId]);
GO

-- Creating foreign key on [ControlTypeName] in table 'PropertyDefinitions'
ALTER TABLE [PropertyDefinitions]
ADD CONSTRAINT [FK_PropertyDefinitionControlType]
    FOREIGN KEY ([ControlTypeName])
    REFERENCES [ControlTypes]
        ([Name])
    ON DELETE NO ACTION ON UPDATE NO ACTION;

-- Creating non-clustered index for FOREIGN KEY 'FK_PropertyDefinitionControlType'
CREATE INDEX [IX_FK_PropertyDefinitionControlType]
ON [PropertyDefinitions]
    ([ControlTypeName]);
GO

-- --------------------------------------------------
-- App Services
-- --------------------------------------------------
CREATE TABLE [dbo].[AppServiceTemplates] (
    [Id] INTEGER IDENTITY(1,1) NOT NULL,
    [VirtualMachineTemplateId] uniqueidentifier  NOT NULL,
    [PreProvisioningScript] NVARCHAR(50) NULL,
    [PostProvisioningScript] NVARCHAR(50) NULL,
    [PreStartupScript] NVARCHAR(50) NULL,
    [PostStartupScript] NVARCHAR(50) NULL,
    [PreShutdownScript] NVARCHAR(50) NULL,
    [PostShutdownScript] NVARCHAR(50) NULL,
	CONSTRAINT [PK_AppServiceTemplates] PRIMARY KEY ([Id] ASC)
);
GO

CREATE TABLE [dbo].[AppServiceComponentTemplates] (
    [Id] INTEGER IDENTITY(1,1) NOT NULL,
    [Name] nvarchar(255)  NULL,
    [VirtualMachineTemplateId] uniqueidentifier  NOT NULL,
    [VirtualMachineId] [uniqueidentifier] NULL,		
    [AppServiceTemplateId] INTEGER  NOT NULL,
    [MinimumInstances] int NOT NULL,
    [MaximumInstances] int  NULL,
    [StartupOrder] int NOT NULL,
    [ShutdownOrder] int NOT NULL,
	CONSTRAINT [PK_AppServiceComponentTemplates] PRIMARY KEY ([Id] ASC),
);
GO

CREATE TABLE [dbo].[AppServiceComponents] (
    [Id] INTEGER IDENTITY(1,1) NOT NULL,
    [VirtualMachineId] uniqueidentifier  NOT NULL,
    [AppServiceComponentTemplateId] INTEGER NOT NULL,
    [AppServiceId] uniqueidentifier  NOT NULL,
    CONSTRAINT [PK_AppServiceComponents] PRIMARY KEY ([Id] ASC),
);
GO

CREATE UNIQUE NONCLUSTERED INDEX [IX_AppServiceComponentsVirtualMachine] ON [AppServiceComponents] ([VirtualMachineId] ASC)
GO

CREATE UNIQUE NONCLUSTERED INDEX [IX_AppServiceTemplatesVirtualMachineTemplate] ON [AppServiceTemplates] ([VirtualMachineTemplateId] ASC)
GO

-- Creating FOREIGN KEYs for AppServices

ALTER TABLE [dbo].[AppServiceTemplates]
WITH CHECK ADD CONSTRAINT [FK_AppServiceTemplates_VirtualMachineTemplates_AppServiceTemplateId]
    FOREIGN KEY ([VirtualMachineTemplateId])
    REFERENCES [dbo].[VirtualMachineTemplate]
        ([VirtualMachineTemplateID])
    ON DELETE CASCADE ON UPDATE NO ACTION;

CREATE INDEX [IX_FK_VirtualMachineTemplates_AppServiceTemplates_VirtualMachineTemplateId]
ON [dbo].[AppServiceTemplates]
    ([VirtualMachineTemplateId]);
GO

ALTER TABLE [dbo].[AppServiceComponentTemplates]
WITH CHECK ADD CONSTRAINT [FK_VirtualMachineTemplates_AppServiceComponentTemplates_VirtualMachineTemplateId]
    FOREIGN KEY ([VirtualMachineTemplateId])
    REFERENCES [dbo].[VirtualMachineTemplate]
        ([VirtualMachineTemplateID])
    ON DELETE CASCADE ON UPDATE NO ACTION;

CREATE INDEX [IX_FK_VirtualMachineTemplates_AppServiceComponentTemplates_VirtualMachineTemplateId]
ON [dbo].[AppServiceComponentTemplates]
    ([VirtualMachineTemplateId]);
GO

ALTER TABLE [dbo].[AppServiceComponentTemplates]
WITH CHECK ADD CONSTRAINT [FK_AppServiceTemplates_AppServiceComponentTemplates_AppServiceTemplateId]
    FOREIGN KEY ([AppServiceTemplateId])
    REFERENCES [dbo].[AppServiceTemplates]
        ([Id])
    ON DELETE NO ACTION ON UPDATE NO ACTION;

CREATE INDEX [IX_FK_AppServiceTemplates_AppServiceComponentTemplates_AppServiceTemplateId]
ON [dbo].[AppServiceComponentTemplates]
    ([AppServiceTemplateId]);
GO

ALTER TABLE [dbo].[AppServiceComponents]
WITH CHECK ADD CONSTRAINT [FK_AppServiceComponents_VirtualMachineVirtualMachines_AppServiceComponentId]
    FOREIGN KEY ([VirtualMachineId])
    REFERENCES [dbo].[VirtualMachine]
        ([VirtualMachineID])
    ON DELETE CASCADE ON UPDATE NO ACTION;

ALTER TABLE [dbo].[AppServiceComponents]
WITH CHECK ADD CONSTRAINT [FK_VirtualMachine_AppServiceComponents_AppServiceId]
    FOREIGN KEY ([AppServiceId])
    REFERENCES [dbo].[VirtualMachine]
        ([VirtualMachineId])
    ON DELETE NO ACTION ON UPDATE NO ACTION;

CREATE INDEX [IX_FK_VirtualMachine_AppServiceComponents_AppServiceId]
ON [dbo].[AppServiceComponents]
    ([AppServiceId]);
GO

ALTER TABLE [dbo].[AppServiceComponents]
WITH CHECK ADD CONSTRAINT [FK_AppServiceComponentTemplates_AppServiceComponents_AppServiceComponentTemplateId]
    FOREIGN KEY ([AppServiceComponentTemplateId])
    REFERENCES [dbo].[AppServiceComponentTemplates]
        ([Id])
    ON DELETE NO ACTION ON UPDATE NO ACTION;

CREATE INDEX [IX_FK_AppServiceComponentTemplates_AppServiceComponents_AppServiceComponentTemplateId]
ON [dbo].[AppServiceComponents]
    ([AppServiceComponentTemplateId]);
GO

-- --------------------------------------------------
-- State Operations and Approvals tables
-- --------------------------------------------------
CREATE TABLE [dbo].[StateOperationExecutionStates](
	[Id] [int] IDENTITY(1,1) NOT NULL,
	[Name] [nvarchar](75) NULL,
 CONSTRAINT [PK_StateOperationExecutionState] PRIMARY KEY CLUSTERED 
(
	[Id] ASC
)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON) ON [PRIMARY]
) ON [PRIMARY]
GO

CREATE UNIQUE NONCLUSTERED INDEX [IX_StateOperationExecutionState_Name] ON [dbo].[StateOperationExecutionStates] 
(
	[Name] ASC
)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON) ON [PRIMARY]
GO

CREATE TABLE [dbo].[StateOperationDefinitions](
	[Id] [int] IDENTITY(1,1) NOT NULL,
	[Name] [nvarchar](50) NULL,
	[Description] [nvarchar](250) NULL,
	[IsUniquePerEntity] [bit] NULL,
	[CreatedDatetime] [datetime] NULL,
 CONSTRAINT [PK_StateOperationDefinitions] PRIMARY KEY CLUSTERED 
(
	[Id] ASC
)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON) ON [PRIMARY]
) ON [PRIMARY]
GO

CREATE UNIQUE NONCLUSTERED INDEX [IX_StateOperationDefinitions_Name] ON [dbo].[StateOperationDefinitions] 
(
	[Name] ASC
)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON) ON [PRIMARY]
GO

CREATE TABLE [dbo].[ApprovalDefinitions](
	[Id] [tinyint] IDENTITY(1,1) NOT NULL,
	[Name] [nvarchar](127) NOT NULL,
	[Description] [nvarchar](256) NULL,
	[AprovalRequestEmailUniqueCode] [nvarchar](127) NULL,
	[ApprovedEmailUniqueCode] [nvarchar](127) NULL,
	[RejectedEmailUniqueCode] [nvarchar](127) NULL,
 CONSTRAINT [PK_ApprovalDefinitions] PRIMARY KEY CLUSTERED 
(
	[Id] ASC
)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON) ON [PRIMARY]
) ON [PRIMARY]
GO

CREATE UNIQUE NONCLUSTERED INDEX [IX_ApprovalDefinitions_Name] ON [dbo].[ApprovalDefinitions] 
(
	[Name] ASC
)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON) ON [PRIMARY]
GO

CREATE TABLE [dbo].[StateOperationDefinitionProperties](
	[Id] [int] IDENTITY(1,1) NOT NULL,
	[StateOperationDefinitionId] [int] NOT NULL,
	[PropertyName] [nvarchar](127) NOT NULL,
	[PropertyValue] [nvarchar](max) NULL,
	[IsHidden] [bit] NOT NULL,
	[IsRuntime] [bit] NOT NULL,
	[IsEncrypted] [bit] NOT NULL,
 CONSTRAINT [PK_StateOperationDefinitionProperties] PRIMARY KEY CLUSTERED 
(
	[Id] ASC
)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON) ON [PRIMARY]
) ON [PRIMARY]
GO

CREATE UNIQUE NONCLUSTERED INDEX [IX_StateOperationDefinitionProperties_StateOperationDefinitionId_PropertyName] ON [dbo].[StateOperationDefinitionProperties] 
(
	[StateOperationDefinitionId] ASC,
	[PropertyName] ASC
)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON) ON [PRIMARY]
GO

CREATE TABLE [dbo].[ApprovalInstances](
	[Id] [int] IDENTITY(1,1) NOT NULL,
	[ApprovalDefinitionId] [tinyint] NOT NULL,
	[SummaryText] [nvarchar](1000) NULL,
	[TriggeringUserId] [int] NOT NULL,
	[CompletedDatetime] [datetime] NULL,
	[ApprovalResult] [tinyint] NOT NULL,
 CONSTRAINT [PK_ApprovalInstances] PRIMARY KEY CLUSTERED 
(
	[Id] ASC
)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON) ON [PRIMARY]
) ON [PRIMARY]
GO

CREATE TABLE [dbo].[StateOperations](
	[Id] [int] IDENTITY(1,1) NOT NULL,
	[UniqueId] [uniqueidentifier] NULL,
	[StateOperationDefinitionId] [int] NOT NULL,
	[EntityId] [uniqueidentifier] NULL,
	[EntityTypeName] [nvarchar](50) NULL,
	[SummaryText] [nvarchar](1000) NULL,
	[CompletionText] [nvarchar](1000) NULL,
	[ExecutionStateId] [int] NOT NULL,
	[ScheduleDatetime] [datetime] NULL,
	[IsBlocking] [bit] NOT NULL,
	[TriggeringUserId] [int] NULL,
	[CreatedDatetime] [datetime] NULL,
 CONSTRAINT [PK_StateOperations] PRIMARY KEY CLUSTERED 
(
	[Id] ASC
)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON) ON [PRIMARY]
) ON [PRIMARY]
GO

CREATE TABLE [dbo].[StateOperationVirtualMachines](
	[StateOperationId] [int] NOT NULL,
	[VirtualMachineId] [uniqueidentifier] NOT NULL,
 CONSTRAINT [PK_StateOperationVirtualMachines_1] PRIMARY KEY CLUSTERED 
(
	[StateOperationId] ASC
)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON) ON [PRIMARY]
) ON [PRIMARY]
GO

CREATE TABLE [dbo].[StateOperationProperties](
	[Id] [int] IDENTITY(1,1) NOT NULL,
	[StateOperationId] [int] NOT NULL,
	[PropertyName] [nvarchar](127) NOT NULL,
	[PropertyValue] [nvarchar](max) NULL,
	[IsHidden] [bit] NOT NULL,
	[IsRuntime] [bit] NOT NULL,
	[IsEncrypted] [bit] NOT NULL,
 CONSTRAINT [PK_StateOperationProperties] PRIMARY KEY CLUSTERED 
(
	[Id] ASC
)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON) ON [PRIMARY]
) ON [PRIMARY]
GO

CREATE UNIQUE NONCLUSTERED INDEX [IX_StateOperationProperties_StateOperationId_PropertyName] ON [dbo].[StateOperationProperties] 
(
	[StateOperationId] ASC,
	[PropertyName] ASC
)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON) ON [PRIMARY]
GO

CREATE TABLE [dbo].[StateOperationApprovals](
	[ApprovalInstanceId] [int] NOT NULL,
	[StateOperationId] [int] NOT NULL,
 CONSTRAINT [PK_StateOperationApprovals] PRIMARY KEY CLUSTERED 
(
	[ApprovalInstanceId] ASC
)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON) ON [PRIMARY]
) ON [PRIMARY]
GO

CREATE TABLE [dbo].[ApprovalInstanceItems](
	[Id] [int] IDENTITY(1,1) NOT NULL,
	[ApprovalInstanceId] [int] NOT NULL,
	[ProvisioningGroupId] [uniqueidentifier] NULL,
	[Priority] [tinyint] NOT NULL,
	[ApprovalState] [tinyint] NOT NULL,
	[ResponseComments] [nvarchar](255) NULL,
	[RespondedBy] [nvarchar](127) NULL,
	[RespondedDatetime] [datetime] NULL,
 CONSTRAINT [PK_ApprovalInstanceItems] PRIMARY KEY CLUSTERED 
(
	[Id] ASC
)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON) ON [PRIMARY]
) ON [PRIMARY]
GO

ALTER TABLE [dbo].[ApprovalInstanceItems] ADD  CONSTRAINT [DF_ApprovalItems_ApprovalState]  DEFAULT ((0)) FOR [ApprovalState]
GO

ALTER TABLE [dbo].[StateOperationDefinitionProperties] ADD  CONSTRAINT [DF_StateOperationDefinitionProperties_IsEncrypted]  DEFAULT ((0)) FOR [IsEncrypted]
GO

ALTER TABLE [dbo].[StateOperationProperties] ADD  CONSTRAINT [DF_StateOperationInstanceProperties_IsEncrypted]  DEFAULT ((0)) FOR [IsEncrypted]
GO

ALTER TABLE [dbo].[ApprovalInstanceItems]  WITH CHECK ADD  CONSTRAINT [FK_ApprovalInstanceItems_ApprovalInstanceItems] FOREIGN KEY([ProvisioningGroupId])
REFERENCES [dbo].[ProvisioningGroup] ([GroupID])
GO

ALTER TABLE [dbo].[ApprovalInstanceItems] CHECK CONSTRAINT [FK_ApprovalInstanceItems_ApprovalInstanceItems]
GO

ALTER TABLE [dbo].[ApprovalInstanceItems]  WITH CHECK ADD  CONSTRAINT [FK_ApprovalInstanceItems_Approvals_ApprovalInstanceId] FOREIGN KEY([ApprovalInstanceId])
REFERENCES [dbo].[ApprovalInstances] ([Id]) ON DELETE CASCADE
GO

ALTER TABLE [dbo].[ApprovalInstanceItems] CHECK CONSTRAINT [FK_ApprovalInstanceItems_Approvals_ApprovalInstanceId]
GO

ALTER TABLE [dbo].[ApprovalInstances]  WITH CHECK ADD  CONSTRAINT [FK_ApprovalInstances_Users_TriggeringUserId] FOREIGN KEY([TriggeringUserId])
REFERENCES [dbo].[Users] ([UserID])
GO

ALTER TABLE [dbo].[ApprovalInstances] CHECK CONSTRAINT [FK_ApprovalInstances_Users_TriggeringUserId]
GO

ALTER TABLE [dbo].[ApprovalInstances]  WITH CHECK ADD  CONSTRAINT [FK_Approvals_ApprovalTypes_ApprovalTypeId] FOREIGN KEY([ApprovalDefinitionId])
REFERENCES [dbo].[ApprovalDefinitions] ([Id])
GO

ALTER TABLE [dbo].[ApprovalInstances] CHECK CONSTRAINT [FK_Approvals_ApprovalTypes_ApprovalTypeId]
GO

ALTER TABLE [dbo].[StateOperationApprovals]  WITH CHECK ADD  CONSTRAINT [FK_StateOperationApprovals_ApprovalInstances_ApprovalInstanceId] FOREIGN KEY([ApprovalInstanceId])
REFERENCES [dbo].[ApprovalInstances] ([Id])
GO

ALTER TABLE [dbo].[StateOperationApprovals] CHECK CONSTRAINT [FK_StateOperationApprovals_ApprovalInstances_ApprovalInstanceId]
GO

ALTER TABLE [dbo].[StateOperationApprovals]  WITH CHECK ADD  CONSTRAINT [FK_StateOperationApprovals_StateOperations_StateOperationId] FOREIGN KEY([StateOperationId])
REFERENCES [dbo].[StateOperations] ([Id])
GO

ALTER TABLE [dbo].[StateOperationApprovals] CHECK CONSTRAINT [FK_StateOperationApprovals_StateOperations_StateOperationId]
GO

ALTER TABLE [dbo].[StateOperationDefinitionProperties]  WITH CHECK ADD  CONSTRAINT [FK_StateOperationDefinitionProperties_StateOperationDefinitions_StateOperationDefinitionId] FOREIGN KEY([StateOperationDefinitionId])
REFERENCES [dbo].[StateOperationDefinitions] ([Id]) ON DELETE CASCADE
GO

ALTER TABLE [dbo].[StateOperationDefinitionProperties] CHECK CONSTRAINT [FK_StateOperationDefinitionProperties_StateOperationDefinitions_StateOperationDefinitionId]
GO

ALTER TABLE [dbo].[StateOperationProperties]  WITH CHECK ADD  CONSTRAINT [FK_StateOperationInstanceProperties_StateOperations_StateOperationId] FOREIGN KEY([StateOperationId])
REFERENCES [dbo].[StateOperations] ([Id]) ON DELETE CASCADE
GO

ALTER TABLE [dbo].[StateOperationProperties] CHECK CONSTRAINT [FK_StateOperationInstanceProperties_StateOperations_StateOperationId]
GO

ALTER TABLE [dbo].[StateOperations]  WITH CHECK ADD  CONSTRAINT [FK_StateOperations_StateOperationDefinitions_StateOperationDefinitionId] FOREIGN KEY([StateOperationDefinitionId])
REFERENCES [dbo].[StateOperationDefinitions] ([Id])
GO

ALTER TABLE [dbo].[StateOperations] CHECK CONSTRAINT [FK_StateOperations_StateOperationDefinitions_StateOperationDefinitionId]
GO

ALTER TABLE [dbo].[StateOperations]  WITH CHECK ADD  CONSTRAINT [FK_StateOperations_StateOperationExecutionState_ExecutionStateId] FOREIGN KEY([ExecutionStateId])
REFERENCES [dbo].[StateOperationExecutionStates] ([Id])
GO

ALTER TABLE [dbo].[StateOperations] CHECK CONSTRAINT [FK_StateOperations_StateOperationExecutionState_ExecutionStateId]
GO

ALTER TABLE [dbo].[StateOperations]  WITH CHECK ADD  CONSTRAINT [FK_StateOperations_Users_TriggeringUserId] FOREIGN KEY([TriggeringUserId])
REFERENCES [dbo].[Users] ([UserID])
GO

ALTER TABLE [dbo].[StateOperations] CHECK CONSTRAINT [FK_StateOperations_Users_TriggeringUserId]
GO

ALTER TABLE [dbo].[StateOperationVirtualMachines]  WITH CHECK ADD  CONSTRAINT [FK_StateOperationVirtualMachines_StateOperationInstances_StateOperationInstanceId] FOREIGN KEY([StateOperationId])
REFERENCES [dbo].[StateOperations] ([Id])
ON DELETE CASCADE
GO

ALTER TABLE [dbo].[StateOperationVirtualMachines] CHECK CONSTRAINT [FK_StateOperationVirtualMachines_StateOperationInstances_StateOperationInstanceId]
GO

ALTER TABLE [dbo].[StateOperationVirtualMachines]  WITH CHECK ADD  CONSTRAINT [FK_StateOperationVirtualMachines_VirtualMachine_VirtualMachineId] FOREIGN KEY([VirtualMachineId])
REFERENCES [dbo].[VirtualMachine] ([VirtualMachineID])
GO

ALTER TABLE [dbo].[StateOperationVirtualMachines] CHECK CONSTRAINT [FK_StateOperationVirtualMachines_VirtualMachine_VirtualMachineId]
GO


CREATE TABLE [DisplayIcon] (
[DisplayIconId] UNIQUEIDENTIFIER,
[Content] varbinary(max)  NOT NULL,
[Hash] varbinary(max)  NOT NULL,
CONSTRAINT [PK_DisplayIconId] PRIMARY KEY ([DisplayIconId]),
)
GO

CREATE TABLE [dbo].[Iso]
(
	[IsoID] INT IDENTITY(1,1) NOT NULL PRIMARY KEY, 
    [Name] NVARCHAR(256) NOT NULL, 
    [Description] NVARCHAR(1000) NULL, 
    [Size] INT NULL, 
	[HypervisorType] NVARCHAR(15) NOT NULL, 
    [UniqueID] NVARCHAR(256) NOT NULL
)
GO

CREATE TABLE [dbo].[HostToIso]
(
	[HostToIsoID] INT IDENTITY(1,1) NOT NULL PRIMARY KEY, 
    [HostID] UNIQUEIDENTIFIER NOT NULL, 
    [IsoID] INT NOT NULL, 
    CONSTRAINT [FK_HostToIso_ToHost] FOREIGN KEY ([HostID]) REFERENCES [dbo].[Host]([HostID]) ON DELETE CASCADE, 
    CONSTRAINT [FK_HostToIso_ToIso] FOREIGN KEY ([IsoID]) REFERENCES [dbo].[Iso]([IsoID]) ON DELETE CASCADE
)
GO
