/*
	Upgrade Samarra DB (5.1.2) to Burma DB (5.2.3)
*/

----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
-- Cleaning
---

-- Temporary stored proc to drop our constraints on a table
IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[DropConstraintFromTable]') AND type in (N'P', N'PC'))
	DROP PROCEDURE [dbo].[DropConstraintFromTable]
GO
CREATE PROC DropConstraintFromTable 
	@table NVARCHAR(256),
	-- Generated constraints name have this format 'DF__DataColle__IsDis__03BB8E22', To escape undescore in a like query, we have to use [_]
	@constraintsFilterName NVARCHAR(256) = '%[_][_]%[_][_]%[_][_]%'
AS BEGIN
		
	DECLARE @sql nvarchar(255)

	WHILE EXISTS(select * from SysObjects s1 join SysObjects s2 on s2.parent_obj = s1.id where s1.name=@table and s2.name like @constraintsFilterName) BEGIN
		SELECT @sql = 'ALTER TABLE ' + s1.name + ' DROP CONSTRAINT ' + s2.name
			FROM SysObjects s1 join SysObjects s2 on s2.parent_obj = s1.id
				WHERE s1.name=@table and s2.name like @constraintsFilterName
		print(@sql)
		EXEC sp_executesql @sql
	END
END
GO

IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[DropUniqueConstraintFromTable]') AND type in (N'P', N'PC'))
	Drop Procedure DropUniqueConstraintFromTable
GO

CREATE PROC DropUniqueConstraintFromTable 
	@table NVARCHAR(256)
AS BEGIN
Declare @Cons_Name NVARCHAR(100)
Declare @Str NVARCHAR(500)

	SELECT @Cons_Name=name
	FROM sys.objects
	WHERE type='UQ' AND OBJECT_NAME(parent_object_id) = @table;

	---- Delete the unique constraint.
	SET @Str='ALTER TABLE ' + @table + ' DROP CONSTRAINT ' + @Cons_Name;
	print(@Str)
	EXEC sp_executesql @Str

END

GO

PRINT N'Dropping foreign keys from [dbo].[AppServiceTemplates]'
GO
ALTER TABLE [dbo].[AppServiceTemplates] DROP
CONSTRAINT [FK_AppServiceTemplates_VirtualMachineTemplates_AppServiceTemplateId]
GO

PRINT N'Dropping foreign keys from [dbo].[MachineOperationVirtualMachineTemplate]'
GO
ALTER TABLE [dbo].[MachineOperationVirtualMachineTemplate] DROP
CONSTRAINT [FK_MachineOperationVirtualMachineTemplate_VirtualMachineTemplate]
GO

PRINT N'Dropping foreign keys from [dbo].[VirtualMachine]'
GO
ALTER TABLE [dbo].[VirtualMachine] DROP
CONSTRAINT [FK_VirtualMachine_VirtualMachineTemplate]
GO

PRINT N'Dropping foreign keys from [dbo].[VirtualMachineTemplateProperties]'
GO
IF EXISTS (SELECT name FROM sys.foreign_keys WHERE object_id = OBJECT_ID('FK_VirtualMachineTemplateProperties_VirtualMachineTemplate'))
BEGIN
	ALTER TABLE [dbo].[VirtualMachineTemplateProperties] DROP
	CONSTRAINT [FK_VirtualMachineTemplateProperties_VirtualMachineTemplate]
END
GO

PRINT N'Dropping foreign keys from [dbo].[AppServiceComponentTemplates]'
GO
ALTER TABLE [dbo].[AppServiceComponentTemplates] DROP
CONSTRAINT [FK_VirtualMachineTemplates_AppServiceComponentTemplates_VirtualMachineTemplateId]
GO

PRINT N'Dropping foreign keys from [dbo].[CredentialAssoc]'
GO
ALTER TABLE [dbo].[CredentialAssoc] DROP
CONSTRAINT [VirtualMachineTemplate_CredentialAssoc]
GO

PRINT N'Dropping foreign keys from [dbo].[GroupToTemplate]'
GO
ALTER TABLE [dbo].[GroupToTemplate] DROP
CONSTRAINT [VirtualMachineTemplate_GroupToTemplate]
GO

PRINT N'Dropping foreign keys from [dbo].[Request]'
GO
ALTER TABLE [dbo].[Request] DROP
CONSTRAINT [VirtualMachineTemplate_Request]
GO

PRINT N'Dropping foreign keys from [dbo].[TemplateToGlobalProfiles]'
GO
ALTER TABLE [dbo].[TemplateToGlobalProfiles] DROP
CONSTRAINT [VirtualMachineTemplate_TemplateToGlobalProfiles]
GO

PRINT N'Dropping foreign keys from [dbo].[VirtualMachineTemplate]'
GO
ALTER TABLE [dbo].[VirtualMachineTemplate] DROP CONSTRAINT [VirtualMachineTemplate_VirtualMachineTemplate]
GO
ALTER TABLE [dbo].[VirtualMachineTemplate] DROP CONSTRAINT [WorkflowInfo_VirtualMachineTemplate]
GO
ALTER TABLE [dbo].[VirtualMachineTemplate] DROP CONSTRAINT [ApprovalPolicy_VirtualMachineTemplate]
GO
ALTER TABLE [dbo].[VirtualMachineTemplate] DROP CONSTRAINT [HostReservationPolicy_VirtualMachineTemplate]
GO
ALTER TABLE [dbo].[VirtualMachineTemplate] DROP CONSTRAINT [FK_VirtualMachineTemplateServiceProfileTemplate]
GO

PRINT N'Dropping constraints from [dbo].[UICustomization]'
GO
ALTER TABLE [dbo].[UICustomization] DROP CONSTRAINT [PK_UICustomization]
GO

PRINT N'Dropping constraints from [dbo].[Users]'
GO
EXEC DropUniqueConstraintFromTable N'Users'
GO

PRINT N'Dropping constraints from [dbo].[VirtualMachineTemplate]'
GO
ALTER TABLE [dbo].[VirtualMachineTemplate] DROP CONSTRAINT [PK_VirtualMachineTemplate]
GO

PRINT N'Dropping constraints from [dbo].[VirtualMachineTemplate]'
GO
ALTER TABLE [dbo].[VirtualMachineTemplate] DROP CONSTRAINT [TUC_VirtualMachineTemplate_1]
GO

PRINT N'Dropping constraints from [dbo].[VirtualMachineTemplate]'
GO
Exec DropConstraintFromTable N'VirtualMachineTemplate'
GO

PRINT N'Dropping constraints from [dbo].[VirtualMachineTemplate]'
GO
IF EXISTS (SELECT * FROM dbo.sysobjects WHERE [name] = (N'DF_VirtualMachineTemplate_IsReconfigureAllowed') AND type = 'D')
BEGIN
	ALTER TABLE [dbo].[VirtualMachineTemplate] DROP CONSTRAINT [DF_VirtualMachineTemplate_IsReconfigureAllowed]
END
GO

PRINT N'Dropping index [IDX_VirtualMachineTemplate_1] from [dbo].[VirtualMachineTemplate]'
GO
IF INDEXPROPERTY(OBJECT_ID('[dbo].[VirtualMachineTemplate]'), N'IDX_VirtualMachineTemplate_1', N'IndexID') IS NOT NULL
	DROP INDEX [IDX_VirtualMachineTemplate_1] ON [dbo].[VirtualMachineTemplate]
GO

PRINT N'Dropping index [IX_FK_VirtualMachineTemplateServiceProfileTemplate] from [dbo].[VirtualMachineTemplate]'
GO
IF INDEXPROPERTY(OBJECT_ID('[dbo].[VirtualMachineTemplate]'), N'IX_FK_VirtualMachineTemplateServiceProfileTemplate', N'IndexID') IS NOT NULL
	DROP INDEX [IX_FK_VirtualMachineTemplateServiceProfileTemplate] ON [dbo].[VirtualMachineTemplate]
GO

PRINT N'Altering [dbo].[HostNic]'
GO
ALTER TABLE [dbo].[HostNic] ALTER COLUMN [HostNicUniqueID] [nvarchar] (80) COLLATE SQL_Latin1_General_CP1_CI_AS NULL
GO

PRINT N'Altering [dbo].[GetNetworkNamesForReservation]'
GO
ALTER FUNCTION [dbo].[GetNetworkNamesForReservation] (@HostReservationID uniqueidentifier)
RETURNS nvarchar(4000) AS
BEGIN
	DECLARE @Concat nvarchar(4000), @Delimiter nvarchar(1);
	SET @Concat = N'';
	SET @Delimiter = N';'
	SELECT @Concat = @Concat + @Delimiter + LTRIM(NetworkName)
		 FROM (SELECT DISTINCT n.NetworkName FROM dbo.HostNic n 
			   INNER JOIN HostNicToReservation nr ON nr.HostNicID = n.HostNicID
			   WHERE nr.HostReservationID = @HostReservationID) derived
	RETURN SUBSTRING(@Concat, 2, LEN(@Concat));
END
GO

PRINT N'Refreshing [dbo].[RequestLastAction]'
GO
EXEC sp_refreshview N'[dbo].[RequestLastAction]'
GO

PRINT N'Rebuilding [dbo].[UICustomization]'
GO
CREATE TABLE [dbo].[tmp_rg_xx_UICustomization]
(
[id] [uniqueidentifier] NOT NULL,
[lastmodified] [datetime] NULL,
[showdashboard] [bit] NULL,
[showvmgrid] [bit] NULL,
[showvmgridfilters] [bit] NULL,
[showvmgridmultiselect] [bit] NULL,
[showvmgridexport] [bit] NULL,
[vmgriddefaultcolumns] [ntext] COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[showpendinggrid] [bit] NULL,
[showpendinggridexport] [bit] NULL,
[showreclaimgrid] [bit] NULL,
[showreclaimgridexport] [bit] NULL,
[showexpiregrid] [bit] NULL,
[showexpiregridexport] [bit] NULL,
[showrecentgrid] [bit] NULL,
[showrecentgridexport] [bit] NULL,
[requestvmshownfields] [ntext] COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[defaultinitialpage] [int] NULL,
[showvmgridextracolumns] [bit] NULL,
[showreclaimcolumns] [bit] NULL
)
GO

INSERT INTO [dbo].[tmp_rg_xx_UICustomization]([id], [lastmodified], [showdashboard], [showvmgrid], [showvmgridfilters], [showvmgridmultiselect], [showvmgridexport], [vmgriddefaultcolumns], [showpendinggrid], [showpendinggridexport], [showreclaimgrid], [showreclaimgridexport], [showexpiregrid], [showexpiregridexport], [showrecentgrid], [showrecentgridexport], [requestvmshownfields], [defaultinitialpage], [showvmgridextracolumns], [showreclaimcolumns]) SELECT [id], [lastmodified], [showdashboard], [showvmgrid], [showvmgridfilters], [showvmgridmultiselect], [showvmgridexport], CAST([vmgriddefaultcolumns] AS [ntext]), [showpendinggrid], [showpendinggridexport], [showreclaimgrid], [showreclaimgridexport], [showexpiregrid], [showexpiregridexport], [showrecentgrid], [showrecentgridexport], CAST([requestvmshownfields] AS [ntext]), [defaultinitialpage], [showvmgridextracolumns], [showreclaimcolumns] FROM [dbo].[UICustomization]
GO

DROP TABLE [dbo].[UICustomization]
GO

EXEC sp_rename N'[dbo].[tmp_rg_xx_UICustomization]', N'UICustomization'
GO

PRINT N'Creating primary key [PK_UICustomization] on [dbo].[UICustomization]'
GO
ALTER TABLE [dbo].[UICustomization] ADD CONSTRAINT [PK_UICustomization] PRIMARY KEY CLUSTERED  ([id])
GO

PRINT N'Altering [dbo].[Audit]'
GO
ALTER TABLE [dbo].[Audit] ALTER COLUMN [Severity] [nvarchar] (64) COLLATE SQL_Latin1_General_CP1_CI_AS NULL
ALTER TABLE [dbo].[Audit] ALTER COLUMN [AppDomainName] [nvarchar] (512) COLLATE SQL_Latin1_General_CP1_CI_AS NULL
ALTER TABLE [dbo].[Audit] ALTER COLUMN [ProcessID] [nvarchar] (256) COLLATE SQL_Latin1_General_CP1_CI_AS NULL
ALTER TABLE [dbo].[Audit] ALTER COLUMN [ProcessName] [nvarchar] (512) COLLATE SQL_Latin1_General_CP1_CI_AS NULL
ALTER TABLE [dbo].[Audit] ALTER COLUMN [ThreadName] [nvarchar] (512) COLLATE SQL_Latin1_General_CP1_CI_AS NULL
ALTER TABLE [dbo].[Audit] ALTER COLUMN [Win32ThreadID] [nvarchar] (128) COLLATE SQL_Latin1_General_CP1_CI_AS NULL
GO

PRINT N'Altering [dbo].[GetCategoriesForAuditMessage]'
GO
ALTER FUNCTION [dbo].[GetCategoriesForAuditMessage] (@LogID int)
RETURNS nvarchar(4000) AS
BEGIN
	DECLARE @Concat nvarchar(4000), @Delimiter nvarchar(1);
	SET @Concat = N'';
	SET @Delimiter = N','
	SELECT @Concat = @Concat + @Delimiter + LTRIM(CategoryName)
		 FROM (SELECT  cn.CategoryName from CategoryLog cl LEFT OUTER JOIN 
		 Categories cn on cn.CategoryID = cl.CategoryID 
		 WHERE LogID=@LogID
		 ) derived
	RETURN SUBSTRING(@Concat, 2, LEN(@Concat));
END
GO

PRINT N'Altering [dbo].[vrm_tasks_RequestHandlerResources]'
GO
ALTER TABLE [dbo].[vrm_tasks_RequestHandlerResources] ALTER COLUMN [ResourceName] [nvarchar] (200) COLLATE SQL_Latin1_General_CP1_CI_AS NOT NULL
ALTER TABLE [dbo].[vrm_tasks_RequestHandlerResources] ALTER COLUMN [ResourceValue] [nvarchar] (200) COLLATE SQL_Latin1_General_CP1_CI_AS NULL
GO

PRINT N'Altering [dbo].[vrm_tasks_RequestResources]'
GO
ALTER TABLE [dbo].[vrm_tasks_RequestResources] ALTER COLUMN [ResourceName] [nvarchar] (200) COLLATE SQL_Latin1_General_CP1_CI_AS NOT NULL
ALTER TABLE [dbo].[vrm_tasks_RequestResources] ALTER COLUMN [ResourceValue] [nvarchar] (200) COLLATE SQL_Latin1_General_CP1_CI_AS NOT NULL
GO

PRINT N'Altering [dbo].[StaticIPv4NetworkProfile]'
GO
ALTER TABLE [dbo].[StaticIPv4NetworkProfile] ALTER COLUMN [SubnetMaskIPv4] [nvarchar] (255) COLLATE SQL_Latin1_General_CP1_CI_AS NOT NULL
ALTER TABLE [dbo].[StaticIPv4NetworkProfile] ALTER COLUMN [GatewayIPv4Address] [nvarchar] (255) COLLATE SQL_Latin1_General_CP1_CI_AS NULL
ALTER TABLE [dbo].[StaticIPv4NetworkProfile] ALTER COLUMN [PrimaryDNSIPv4Address] [nvarchar] (255) COLLATE SQL_Latin1_General_CP1_CI_AS NULL
ALTER TABLE [dbo].[StaticIPv4NetworkProfile] ALTER COLUMN [SecondaryDNSIPv4Address] [nvarchar] (255) COLLATE SQL_Latin1_General_CP1_CI_AS NULL
ALTER TABLE [dbo].[StaticIPv4NetworkProfile] ALTER COLUMN [DnsSuffix] [nvarchar] (255) COLLATE SQL_Latin1_General_CP1_CI_AS NULL
ALTER TABLE [dbo].[StaticIPv4NetworkProfile] ALTER COLUMN [DnsSearchSuffix] [nvarchar] (255) COLLATE SQL_Latin1_General_CP1_CI_AS NULL
ALTER TABLE [dbo].[StaticIPv4NetworkProfile] ALTER COLUMN [PrimaryWinsIPv4Address] [nvarchar] (255) COLLATE SQL_Latin1_General_CP1_CI_AS NULL
ALTER TABLE [dbo].[StaticIPv4NetworkProfile] ALTER COLUMN [SecondaryWinsIPv4Address] [nvarchar] (255) COLLATE SQL_Latin1_General_CP1_CI_AS NULL
GO

PRINT N'Altering [dbo].[ChangeStateRequests]'
GO
ALTER TABLE [dbo].[ChangeStateRequests] ADD
[IsEvent] [bit] NULL
GO

PRINT N'Altering [dbo].[AppServiceComponentTemplates]'
GO
ALTER TABLE [dbo].[AppServiceComponentTemplates] ADD
[VirtualMachineId] [uniqueidentifier] NULL
GO

PRINT N'Altering [dbo].[GetMachineType]'
GO
ALTER FUNCTION [dbo].[GetMachineType] (@machineType tinyint)
RETURNS nvarchar(10) AS
BEGIN
   return case when @machineType = 1 then N'Physical' when @machineType = 2 then N'Cloud' else N'Virtual' end  
END
GO

PRINT N'Altering [dbo].[GetGroupNamesForTemplate]'
GO
ALTER FUNCTION [dbo].[GetGroupNamesForTemplate] (@VirtualMachineTemplateID uniqueidentifier)
RETURNS nvarchar(4000) AS
BEGIN
	DECLARE @Concat nvarchar(4000), @Delimiter nvarchar(2);
	SET @Concat = N'';
	SET @Delimiter = N', '
	SELECT @Concat = @Concat + @Delimiter + LTRIM(GroupName)
		 FROM (SELECT DISTINCT g.GroupName FROM ProvisioningGroup g 
			   INNER JOIN GroupToTemplate gt ON gt.GroupID = g.GroupID
			   WHERE gt.VirtualMachineTemplateID = @VirtualMachineTemplateID) derived
	RETURN SUBSTRING(@Concat, 3, LEN(@Concat));
END
GO

PRINT N'Altering [dbo].[StaticIPv4Range]'
GO
ALTER TABLE [dbo].[StaticIPv4Range] ALTER COLUMN [BeginIPv4Address] [nvarchar] (255) COLLATE SQL_Latin1_General_CP1_CI_AS NULL
ALTER TABLE [dbo].[StaticIPv4Range] ALTER COLUMN [EndIPv4Address] [nvarchar] (255) COLLATE SQL_Latin1_General_CP1_CI_AS NULL
GO

PRINT N'Altering [dbo].[StaticIPv4Address]'
GO
ALTER TABLE [dbo].[StaticIPv4Address] ALTER COLUMN [IPv4Address] [nvarchar] (40) COLLATE SQL_Latin1_General_CP1_CI_AS NOT NULL
GO

PRINT N'Altering [dbo].[UserLogViewInterim]'
GO
ALTER VIEW [dbo].[UserLogViewInterim]
AS
SELECT     
	UserLogId, [UserName], [Timestamp], [Type], [Message], GroupID,
	substring([Message], charIndex(N'Machine ', [Message])+8, lEN([Message])) STRAFTERVM, 
	charIndex(N':', [Message])- charIndex(N'Machine ', [Message])-8 COLONID,
	Status = CASE [Type] WHEN 0 THEN N'Info'
						 WHEN 1 THEN N'Warning'
						 WHEN 2 THEN N'Error'
						 ELSE N'Unknown'
	END
FROM UserLog
GO

PRINT N'Refreshing [dbo].[UserLogView]'
GO
EXEC sp_refreshview N'[dbo].[UserLogView]'
GO

PRINT N'Altering [dbo].[GetEnterpriseAdminNamesForHost]'
GO
ALTER FUNCTION [dbo].[GetEnterpriseAdminNamesForHost] (@HostID uniqueidentifier)
RETURNS nvarchar(4000) AS
BEGIN
	DECLARE @Concat nvarchar(4000), @Delimiter nvarchar(1);
	SET @Concat = N'';
	SET @Delimiter = N';'
	SELECT @Concat = @Concat + @Delimiter + LTRIM(AdminName)
		 FROM (SELECT DISTINCT AdminName FROM dbo.AdminGroupToHost a 
			   INNER JOIN EnterpriseAdminGroups e ON a.EnterpriseAdminID = e.EnterpriseAdminID
			   WHERE a.HostID = @HostID) derived
	RETURN SUBSTRING(@Concat, 2, LEN(@Concat));
END
GO

PRINT N'Altering [dbo].[ApprovalDefinitions]'
GO
ALTER TABLE [dbo].[ApprovalDefinitions] ALTER COLUMN [AprovalRequestEmailUniqueCode] [nvarchar] (127) COLLATE SQL_Latin1_General_CP1_CI_AS NULL
ALTER TABLE [dbo].[ApprovalDefinitions] ALTER COLUMN [ApprovedEmailUniqueCode] [nvarchar] (127) COLLATE SQL_Latin1_General_CP1_CI_AS NULL
ALTER TABLE [dbo].[ApprovalDefinitions] ALTER COLUMN [RejectedEmailUniqueCode] [nvarchar] (127) COLLATE SQL_Latin1_General_CP1_CI_AS NULL
GO


PRINT N'Altering [DynamicOps.VMWare].[ReconfigureRequestNetworks]'
GO
ALTER TABLE [DynamicOps.VMWare].[ReconfigureRequestNetworks] ALTER COLUMN [StaticIPv4Address] [nvarchar] (40) COLLATE SQL_Latin1_General_CP1_CI_AS NULL
GO

PRINT N'Altering [dbo].[RequestType]'
GO
ALTER TABLE [dbo].[RequestType] ALTER COLUMN [RequestTypeName] [nvarchar] (256) COLLATE SQL_Latin1_General_CP1_CI_AS NULL
ALTER TABLE [dbo].[RequestType] ALTER COLUMN [RequestTypeDescription] [nvarchar] (max) COLLATE SQL_Latin1_General_CP1_CI_AS NULL
GO

PRINT N'Altering [dbo].[VMAlarm]'
GO
ALTER TABLE [dbo].[VMAlarm] ALTER COLUMN [VMAlarmName] [nvarchar] (256) COLLATE SQL_Latin1_General_CP1_CI_AS NULL
GO

PRINT N'Altering [dbo].[VirtualMachine]'
GO
ALTER TABLE [dbo].[VirtualMachine] ADD
[ParentMachineID] [uniqueidentifier] NULL
GO

ALTER TABLE [dbo].[VirtualMachine] ALTER COLUMN [GuestOS] [nvarchar] (256) COLLATE SQL_Latin1_General_CP1_CI_AS NULL
ALTER TABLE [dbo].[VirtualMachine] ALTER COLUMN [VMUniqueID] [nvarchar] (256) COLLATE SQL_Latin1_General_CP1_CI_AS NULL
GO

PRINT N'Altering [dbo].[Host]'
GO
ALTER TABLE [dbo].[Host] ADD
[AllocationType] [tinyint] NULL
GO

ALTER TABLE [dbo].[Host] ALTER COLUMN [HostOSType] [nvarchar] (256) COLLATE SQL_Latin1_General_CP1_CI_AS NULL
ALTER TABLE [dbo].[Host] ALTER COLUMN [HostManufacturer] [nvarchar] (256) COLLATE SQL_Latin1_General_CP1_CI_AS NULL
ALTER TABLE [dbo].[Host] ALTER COLUMN [HostModel] [nvarchar] (256) COLLATE SQL_Latin1_General_CP1_CI_AS NULL
GO

PRINT N'Rebuilding [dbo].[VirtualMachineTemplate]'
GO
CREATE TABLE [dbo].[tmp_rg_xx_VirtualMachineTemplate]
(
[VirtualMachineTemplateID] [uniqueidentifier] NOT NULL,
[VirtualMachineTemplateName] [nvarchar] (256) COLLATE SQL_Latin1_General_CP1_CI_AS NOT NULL,
[VirtualMachineTemplateDescription] [nvarchar] (1024) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[ExpireDays] [int] NOT NULL,
[LeaseDays] [int] NOT NULL,
[Enabled] [bit] NOT NULL,
[BlueprintType] [tinyint] NOT NULL DEFAULT ((0)),
[RequiresApproval] [bit] NOT NULL,
[Master] [bit] NOT NULL DEFAULT ((0)),
[MemoryMB] [bigint] NULL,
[MemoryMaxMB] [bigint] NULL,
[DiskSize0GB] [bigint] NULL,
[DiskSizeMaxGB] [bigint] NULL,
[CPUCount] [int] NULL,
[CPUCountMax] [int] NULL,
[MachinePrefix] [nvarchar] (50) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[Cost] [decimal] (28, 3) NULL,
[InheritsFromVMTemplateID] [uniqueidentifier] NULL,
[Flags] [bigint] NULL,
[Text1] [nvarchar] (256) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[Text2] [nvarchar] (max) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[WorkflowID] [uniqueidentifier] NULL,
[MaxVMsPerUser] [int] NULL,
[IsGlobal] [bit] NOT NULL DEFAULT ((0)),
[RecCreationTime] [datetime] NULL,
[RecDeleteTime] [datetime] NULL,
[RecUpdateTime] [datetime] NULL,
[ApprovalPolicyId] [uniqueidentifier] NULL,
[id] [uniqueidentifier] NULL,
[ReservationPolicyID] [uniqueidentifier] NULL,
[LeaseDaysMax] [int] NULL,
[MachineType] [tinyint] NOT NULL,
[IsReconfigureAllowed] [bit] NOT NULL DEFAULT ((1)),
[ReconfigureMaxDisks] [int] NULL,
[ReconfigureMaxNetworks] [int] NULL,
[ReconfigureForceShutdown] [tinyint] NULL,
[ReconfigureExecutionSelector] [tinyint] NULL,
[EnableStoragePolicy] [bit] NOT NULL DEFAULT ((0)),
[DisplayIconId] [uniqueidentifier] NULL,
[InterfaceTypeId] [nvarchar] (128) COLLATE SQL_Latin1_General_CP1_CI_AS NOT NULL,
[IsComponentOnly] [bit] NOT NULL DEFAULT ((0)),
[ServiceProfileTemplate_Id] [int] NULL
)
GO

INSERT INTO [dbo].[tmp_rg_xx_VirtualMachineTemplate]([VirtualMachineTemplateID], [VirtualMachineTemplateName], [VirtualMachineTemplateDescription], 
[ExpireDays], [LeaseDays], [Enabled], [BlueprintType], [RequiresApproval], [Master], [MemoryMB], [MemoryMaxMB], [DiskSize0GB], [DiskSizeMaxGB], 
[CPUCount], [CPUCountMax], [MachinePrefix], [Cost], [InheritsFromVMTemplateID], [Flags], [Text1], [Text2], [WorkflowID], [MaxVMsPerUser], [IsGlobal], 
[RecCreationTime], [RecDeleteTime], [RecUpdateTime], [ApprovalPolicyId], [id], [ReservationPolicyID], [LeaseDaysMax], [MachineType], [IsReconfigureAllowed], 
[ReconfigureMaxDisks], [ReconfigureMaxNetworks], [ReconfigureForceShutdown], [ReconfigureExecutionSelector], [EnableStoragePolicy], [DisplayIconId], 
 [ServiceProfileTemplate_Id], [InterfaceTypeId]) 
SELECT [VirtualMachineTemplateID], [VirtualMachineTemplateName], [VirtualMachineTemplateDescription], [ExpireDays], [LeaseDays], [Enabled], [BlueprintType], [RequiresApproval], [Master], [MemoryMB], [MemoryMaxMB], [DiskSize0GB], [DiskSizeMaxGB], [CPUCount], [CPUCountMax], [MachinePrefix], [Cost], [InheritsFromVMTemplateID], [Flags], [Text1], [Text2], [WorkflowID], [MaxVMsPerUser], [IsGlobal], [RecCreationTime], [RecDeleteTime], [RecUpdateTime], [ApprovalPolicyId], [id], [ReservationPolicyID], [LeaseDaysMax], [MachineType], [IsReconfigureAllowed], [ReconfigureMaxDisks], [ReconfigureMaxNetworks], [ReconfigureForceShutdown], [ReconfigureExecutionSelector], [EnableStoragePolicy], [DisplayIconId], [ServiceProfileTemplate_Id], 
       [InterfaceTypeId] = CASE WHEN vmt.MachineType = 2 THEN N'AmazonEC2'
						        WHEN vmt.MachineType = 3 THEN N'MultiMachine'
						        ELSE T.PropertyValue END FROM [dbo].[VirtualMachineTemplate] vmt LEFT JOIN  
(SELECT vmtp.EntityID, vmtp.PropertyValue FROM VirtualMachineTemplateProperties vmtp INNER JOIN VirtualMachineTemplate vmt2 ON vmtp.EntityID = vmt2.VirtualMachineTemplateID WHERE vmtp.PropertyName = N'__template_hardwareType') as T ON vmt.VirtualMachineTemplateID = T.EntityID
GO

DROP TABLE [dbo].[VirtualMachineTemplate]
GO

EXEC sp_rename N'[dbo].[tmp_rg_xx_VirtualMachineTemplate]', N'VirtualMachineTemplate'
GO

PRINT N'Creating primary key [PK_VirtualMachineTemplate] on [dbo].[VirtualMachineTemplate]'
GO
ALTER TABLE [dbo].[VirtualMachineTemplate] ADD CONSTRAINT [PK_VirtualMachineTemplate] PRIMARY KEY CLUSTERED  ([VirtualMachineTemplateID])
GO

PRINT N'Creating index [IDX_VirtualMachineTemplate_1] on [dbo].[VirtualMachineTemplate]'
GO
CREATE NONCLUSTERED INDEX [IDX_VirtualMachineTemplate_1] ON [dbo].[VirtualMachineTemplate] ([VirtualMachineTemplateName])
GO

PRINT N'Creating index [IX_FK_VirtualMachineTemplateServiceProfileTemplate] on [dbo].[VirtualMachineTemplate]'
GO
CREATE NONCLUSTERED INDEX [IX_FK_VirtualMachineTemplateServiceProfileTemplate] ON [dbo].[VirtualMachineTemplate] ([ServiceProfileTemplate_Id])
GO

PRINT N'Refreshing [dbo].[VMTemplateView]'
GO
EXEC sp_refreshview N'[dbo].[VMTemplateView]'
GO

PRINT N'Refreshing [dbo].[ReservationView]'
GO
EXEC sp_refreshview N'[dbo].[ReservationView]'
GO

PRINT N'Refreshing [dbo].[ReservationInfoView]'
GO
EXEC sp_refreshview N'[dbo].[ReservationInfoView]'
GO

PRINT N'Refreshing [dbo].[ReservationInfoExView]'
GO
EXEC sp_refreshview N'[dbo].[ReservationInfoExView]'
GO

PRINT N'Altering [dbo].[VMDiskHardware]'
GO
ALTER TABLE [dbo].[VMDiskHardware] ADD
[IsFixed] [bit] NOT NULL CONSTRAINT [DF__VMDiskHar__IsFix__70A8B9AE] DEFAULT ((0))
GO

PRINT N'Refreshing [dbo].[RequestView]'
GO
EXEC sp_refreshview N'[dbo].[RequestView]'
GO

PRINT N'Altering [dbo].[LastLogonUserView]'
GO
ALTER VIEW [dbo].[LastLogonUserView]
AS
	select lu.VirtualMachineID, lu.LoginUserName, MAX(lu.LastLoginDate) LastLoginDate 
	from VMLoginUser lu 
	where lu.LoginUserName not in (select iu.LoginUserName from LastLoginIgnoreUser iu where iu.VirtualMachineID = lu.VirtualMachineID) and 
	lu.LoginUserName <> N'error'
	and lu.LastLoginDate is not null
	GROUP BY lu.LoginUserName, lu.VirtualMachineID
GO

PRINT N'Altering [dbo].[uv_VirtualMachineView]'
GO
ALTER VIEW [dbo].[uv_VirtualMachineView]
AS
SELECT     v.VirtualMachineID, v.HostID, v.VirtualMachineTemplateID, v.IsManaged, v.HostReservationID, v.ResourcePoolID, v.VirtualMachineName, v.Expires, v.ExpireDays, v.BlueprintType, v.InitiatorType, 
					  v.Notes, v.GuestOS, v.VMUniqueID, v.PlatformDetails, v.VMCreationDate, v.VMDeleteDate, v.LastLoggedDate, v.LastLoggedUser, v.LastPowerOffDate, 
					  v.LastPowerOnDate, v.OwnerExists, v.UsageIndex, v.UsageIndexIgnoreBy, v.IsDeleted, v.IsMissing, v.IsRogue, v.IsRunning, v.RecCreationTime, v.RecDeleteTime, 
					  v.RecUpdateTime, v.Flags, v.Text1, v.Text2, v.VMCPUs, v.VMTotalMemoryMB, v.VMTotalStorageGB, v.GuestOSFamily, v.VirtualMachineState, v.IsComponent, v.ParentMachineID,
					  v.HostStorageReservationID, v.StoragePath, v.IsTemplate, v.ConnectToVdi, v.VMDNSName, v.VMUsedStorageGB, v.FileLevelCloneImageName, v.VMInitialUsedSpace, v.VMEstimatedUsedSpace, 
					  v.PhysicalMachineID, v.MachineType, h.HostName, hr.HostReservationName, r.ResourcePoolName, t.VirtualMachineTemplateName, g.GroupID, g.GroupName, uApprover.UserName as Approver, uOwner.UserName as Owner,
					  v.CurrentTask
FROM         dbo.VirtualMachine AS v LEFT OUTER JOIN
					  dbo.HostReservation AS hr ON hr.HostReservationID = v.HostReservationID LEFT OUTER JOIN
					  dbo.Host AS h ON h.HostID = v.HostID LEFT OUTER JOIN
					  dbo.VirtualMachineTemplate AS t ON t.VirtualMachineTemplateID = v.VirtualMachineTemplateID LEFT OUTER JOIN
					  dbo.ProvisioningGroup AS g ON g.GroupID = hr.GroupID LEFT OUTER JOIN
					  dbo.ResourcePool AS r ON r.ResourcePoolID = v.ResourcePoolID LEFT OUTER JOIN
					  dbo.Users AS uOwner ON v.Owner = uOwner.UserID LEFT OUTER JOIN
					  dbo.Users AS uApprover ON v.Approver = uApprover.UserID
GO

PRINT N'Refreshing [dbo].[VirtualMachineInfoView]'
GO
EXEC sp_refreshview N'[dbo].[VirtualMachineInfoView]'
GO

PRINT N'Altering [dbo].[VirtualMachineHistory]'
GO
ALTER TABLE [dbo].[VirtualMachineHistory] ADD
[ParentMachineID] [uniqueidentifier] NULL
GO

ALTER TABLE [dbo].[VirtualMachineHistory] ALTER COLUMN [GuestOS] [nvarchar] (256) COLLATE SQL_Latin1_General_CP1_CI_AS NULL
ALTER TABLE [dbo].[VirtualMachineHistory] ALTER COLUMN [VMUniqueID] [nvarchar] (256) COLLATE SQL_Latin1_General_CP1_CI_AS NULL
GO

PRINT N'Refreshing [dbo].[ProvisioningGroupCostSavingsView]'
GO
EXEC sp_refreshview N'[dbo].[ProvisioningGroupCostSavingsView]'

PRINT N'Altering [dbo].[GetVirtualMachineUsedStoragePathsSummary]'
GO
ALTER FUNCTION [dbo].[GetVirtualMachineUsedStoragePathsSummary] (@VirtualMachineID UNIQUEIDENTIFIER)
RETURNS NVARCHAR(MAX) AS
BEGIN
	DECLARE @T TABLE(
		[StoragePath] [nvarchar](256) NOT NULL,
		[TotalCapacity] [bigint] NULL
	)
	INSERT INTO @T (StoragePath, TotalCapacity)
		SELECT hs.StoragePath, Sum(d.Capacity) TotalCapacity
		FROM VirtualMachine vm
			JOIN VMDiskHardware d on d.VirtualMachineID = vm.VirtualMachineID
			JOIN HostToStorage hs on d.HostToStorageID = hs.HostToStorageID
		WHERE vm.VirtualMachineID = @VirtualMachineID
		GROUP BY hs.StoragePath
		ORDER BY TotalCapacity DESC
	DECLARE @Info NVARCHAR(MAX)
	SELECT @Info = COALESCE(@Info + N', ', N'') + StoragePath + N'[' + Cast(TotalCapacity as NVarChar(max))+ N' GB]' FROM @T
	RETURN @Info
END
GO

PRINT N'Altering [dbo].[VirtualMachineExt]'
GO
ALTER VIEW [dbo].[VirtualMachineExt] AS
    SELECT
        v.VirtualMachineID
        ,dbo.GetVirtualMachineUsedStoragePathsSummary(v.VirtualMachineID) StoragePathsSummary
        ,MachineName = NULLIF(v.VirtualMachineName, N'')
        ,[Status]  = 
        CASE
            WHEN v.IsMissing = 1 THEN N'Missing'
            WHEN v.IsManaged = 0 and v.HostReservationID IS NULL THEN N'Unmanaged'
            WHEN v.IsManaged = 0 and v.HostReservationID IS NOT NULL THEN N'Reserved'
            WHEN v.VirtualMachineState = N'InstallTools' OR v.VirtualMachineState = N'Install Tools' THEN N'Installing Tools'
            WHEN v.VirtualMachineState = N'VdiRegister' OR v.VirtualMachineState = N'VdiRegisterUser' THEN N'Registering virtual desktop'
            WHEN v.VirtualMachineState = N'VdiUnregister' OR v.VirtualMachineState = N'VdiUnregisterUser' THEN N'Unregistering virtual desktop and user'
            WHEN v.CurrentTask IS NOT NULL THEN v.VirtualMachineState + N' (' + v.CurrentTask + N')'
            ELSE v.VirtualMachineState
        END
        ,MachineType = 
        CASE
            WHEN v.MachineType = 1 THEN N'Physical' 
            WHEN v.MachineType = 2 THEN N'Cloud' 
            WHEN v.MachineType = 3 THEN N'Multi-Machine'
            ELSE N'Virtual'
        END
        ,BlueprintName = t.VirtualMachineTemplateName
        ,UserName = u.UserName
        ,HostName = 
        CASE
            WHEN v.MachineType IN (1,3) THEN NULL
            ELSE h.HostName
        END
        ,GroupName = pg.GroupName
        ,ReservationName = 
        CASE
            WHEN v.MachineType IN (1,3) THEN NULL
            ELSE hr.HostReservationName
        END
        ,EndpointName = 
        CASE
            WHEN v.MachineType = 1 THEN epc.ManagementEndpointName
            ELSE eh.ManagementEndpointName
        END
        ,EndpointInterfaceType = 
        CASE
            WHEN v.MachineType = 1 THEN epc.InterfaceType
            ELSE eh.InterfaceType
        END
        ,CostProfileName = cp.CostProfileName
        ,DestructionDate = DATEADD(day, ISNULL(v.ExpireDays, 0), v.Expires)
        ,VMCPUs=
        CASE
            WHEN v.MachineType = 1 THEN pm.ProcessorCount
            WHEN v.MachineType = 3 THEN NULL
            ELSE v.VMCPUs
        END
        ,VMTotalMemoryGB = 
        CASE
            WHEN v.MachineType = 1 THEN CAST(ROUND(CAST(pm.MemoryInMB AS FLOAT)/ 1024, 1) AS REAL)
            WHEN v.MachineType = 3 THEN NULL
            ELSE CAST(ROUND(CAST(ISNULL(v.VMTotalMemoryMB, 0) AS FLOAT)/ 1024, 1) AS REAL)
        END
        ,VMTotalStorageGB = 
        CASE
            WHEN v.MachineType IN (1,3) THEN NULL
            ELSE v.VMTotalStorageGB
        END
        ,OwnerExistsString = 
        CASE
            WHEN v.OwnerExists = 1 THEN N'Yes' ELSE N'No'
        END
        ,IsMissingString = 
        CASE
            WHEN v.IsMissing = 1 THEN N'Yes' ELSE N'No'
        END
    FROM [dbo].VirtualMachine v LEFT OUTER JOIN
         [dbo].VirtualMachineTemplate t ON v.VirtualMachineTemplateID = t.VirtualMachineTemplateID LEFT OUTER JOIN
         [dbo].Users u ON v.[Owner] = u.UserID LEFT OUTER JOIN
         [dbo].Host h ON v.HostID = h.HostID LEFT OUTER JOIN
         [dbo].HostReservation hr ON v.HostReservationID = hr.HostReservationID LEFT OUTER JOIN
         [dbo].ProvisioningGroup pg ON hr.GroupID = pg.GroupID LEFT OUTER JOIN
         [dbo].PhysicalMachines pm ON v.PhysicalMachineID = pm.PhysicalMachineID LEFT OUTER JOIN
         [dbo].PhysicalControllers pc ON pm.PhysicalController_PhysicalControllerID = pc.PhysicalControllerID LEFT OUTER JOIN
         [dbo].ManagementEndpoints epc ON pc.ManagementEndpoint_ManagementEndpointID = epc.ManagementEndpointID LEFT OUTER JOIN
         [dbo].ManagementEndpoints eh ON h.ManagementEndpointID = eh.ManagementEndpointID LEFT OUTER JOIN
         [dbo].CostProfile cp ON pm.CostProfileID = cp.CostProfileID 	 
GO

PRINT N'Altering [dbo].[MachineUsageByState]'
GO
ALTER VIEW [dbo].[MachineUsageByState]
AS
	SELECT 
	COUNT(vm.VirtualMachineId) as MachineCount, 
	vm.VirtualMachineState as MachineState,
	vm.MachineType as MachineType,
	vm.BlueprintType as BlueprintType
	FROM VirtualMachine vm
	WHERE vm.IsManaged = 1 AND vm.VirtualMachineState IS NOT NULL
	GROUP BY vm.VirtualMachineState, vm.MachineType, vm.BlueprintType
	UNION
	SELECT 
	COUNT(vmh.VirtualMachineId) as MachineCount, 
	N'Disposed' as MachineState,
	vmh.MachineType as MachineType,
	vmh.BlueprintType as BlueprintType
	FROM VirtualMachineHistory vmh
	WHERE vmh.VMDeleteDate > DATEADD(DAY, -1, GETDATE()) AND vmh.VMDeleteDate < DATEADD(DAY, 1, GETDATE())
	GROUP BY vmh.MachineType, vmh.BlueprintType
GO

PRINT N'Altering [dbo].[VMDiskHardwareHistory]'
GO
ALTER TABLE [dbo].[VMDiskHardwareHistory] ADD
[IsFixed] [bit] NOT NULL CONSTRAINT [DF__VMDiskHar__IsFix__73852659] DEFAULT ((0))
GO

PRINT N'Refreshing [dbo].[MachineCostView]'
GO
EXEC sp_refreshview N'[dbo].[MachineCostView]'
GO

PRINT N'Altering [dbo].[InterfaceTypes]'
GO
ALTER TABLE [dbo].[InterfaceTypes] ADD
[IntegratedSecurity] [bit] NOT NULL CONSTRAINT [DF__Interface__Integ__6B24EA82] DEFAULT ((1)),
[HasEndpoints] [bit] NOT NULL CONSTRAINT [DF__Interface__HasEn__6C190EBB] DEFAULT ((1)),
[HasReservations] [bit] NOT NULL CONSTRAINT [DF__Interface__HasRe__6D0D32F4] DEFAULT ((1)),
[HasBlueprints] [bit] NOT NULL CONSTRAINT [DF__Interface__HasBl__6E01572D] DEFAULT ((1))
GO

-- Update rows in [dbo].[InterfaceTypes]
PRINT N'Updating [dbo].[InterfaceTypes]'
GO
UPDATE [dbo].[InterfaceTypes] SET [EndpointType]=2, [IntegratedSecurity]=0 WHERE [InterfaceTypeId]=N'AmazonEC2'
GO
UPDATE [dbo].[InterfaceTypes] SET [EndpointType]=1, [IntegratedSecurity]=0, [HasReservations]=0 WHERE [InterfaceTypeId]=N'CiscoUcs'
GO
UPDATE [dbo].[InterfaceTypes] SET [EndpointType]=0, [IntegratedSecurity]=0, [HasEndpoints]=0 WHERE [InterfaceTypeId]=N'CitrixXen'
GO
UPDATE [dbo].[InterfaceTypes] SET [EndpointType]=1, [IntegratedSecurity]=0, [HasReservations]=0 WHERE [InterfaceTypeId]=N'DellIdrac'
GO
UPDATE [dbo].[InterfaceTypes] SET [EndpointType]=1, [IntegratedSecurity]=0, [HasReservations]=0 WHERE [InterfaceTypeId]=N'HpIlo'
GO
UPDATE [dbo].[InterfaceTypes] SET [EndpointType]=0, [IntegratedSecurity]=0, [HasEndpoints]=0 WHERE [InterfaceTypeId]=N'HyperV'
GO
UPDATE [dbo].[InterfaceTypes] SET [EndpointType]=3, [IntegratedSecurity]=0, [HasReservations]=0, [HasBlueprints]=0 WHERE [InterfaceTypeId]=N'NetAppOnTapp'
GO
UPDATE [dbo].[InterfaceTypes] SET [EndpointType]=0 WHERE [InterfaceTypeId]=N'Scvmm'
GO
UPDATE [dbo].[InterfaceTypes] SET [DisplayName]=N'vApp (vCloud Director)', [IntegratedSecurity]=0 WHERE [InterfaceTypeId]=N'vCloud'
GO
UPDATE [dbo].[InterfaceTypes] SET [IntegratedSecurity]=0, [HasReservations]=0, [HasBlueprints]=0 WHERE [InterfaceTypeId]=N'vCO'
GO
UPDATE [dbo].[InterfaceTypes] SET [EndpointType]=0 WHERE [InterfaceTypeId]=N'vSphere'
GO
UPDATE [dbo].[InterfaceTypes] SET [DisplayName]=N'Generic' WHERE [InterfaceTypeId]=N'Generic'
GO
UPDATE [dbo].[InterfaceTypes] SET [DisplayName]=N'Physical' WHERE [InterfaceTypeId]=N'GenericPhysical'
GO
UPDATE [dbo].[InterfaceTypes] SET [DisplayName]=N'vApp Component (vCloud Director)' WHERE [InterfaceTypeId]=N'vCloudComponent'
GO

PRINT N'Adding [dbo].[InterfaceTypes]'
GO
INSERT INTO [dbo].[InterfaceTypes] ([InterfaceTypeId], [EndpointType], [DisplayName], [Description], [Url], [IntegratedSecurity], [HasEndpoints], [HasReservations], [HasBlueprints]) VALUES (N'Generic', 0, N'Generic Virtual', NULL, NULL, 0, 0, 0, 1)
GO
INSERT INTO [dbo].[InterfaceTypes] ([InterfaceTypeId], [EndpointType], [DisplayName], [Description], [Url], [IntegratedSecurity], [HasEndpoints], [HasReservations], [HasBlueprints]) VALUES (N'GenericPhysical', 1, N'Generic Physical', NULL, NULL, 0, 0, 1, 0)
GO
INSERT INTO [dbo].[InterfaceTypes] ([InterfaceTypeId], [EndpointType], [DisplayName], [Description], [Url], [IntegratedSecurity], [HasEndpoints], [HasReservations], [HasBlueprints]) VALUES (N'MultiMachine', 4, N'Multi-Machine', NULL, NULL, 0, 0, 0, 1)
GO
INSERT INTO [dbo].[InterfaceTypes] ([InterfaceTypeId], [EndpointType], [DisplayName], [Description], [Url], [IntegratedSecurity], [HasEndpoints], [HasReservations], [HasBlueprints]) VALUES (N'vCloudComponent', 2, N'vApp (vCloud Director) Component', NULL, NULL, 0, 0, 0, 1)
GO
INSERT INTO [dbo].[InterfaceTypes] ([InterfaceTypeId], [EndpointType], [DisplayName], [Description], [Url], [IntegratedSecurity], [HasEndpoints], [HasReservations], [HasBlueprints]) VALUES (N'Test', 0, N'Test', null, null, 0, 0, 0, 0)
GO
INSERT INTO [dbo].[InterfaceTypes] ([InterfaceTypeId], [EndpointType], [DisplayName], [Description], [Url], [IntegratedSecurity], [HasEndpoints], [HasReservations], [HasBlueprints]) VALUES (N'Kvm', 0, N'KVM (RHEV)', NULL, NULL, 0, 1, 1, 1)
GO

PRINT N'Refreshing [dbo].[TempHostReservationInfo]'
GO
EXEC sp_refreshview N'[dbo].[TempHostReservationInfo]'
GO

PRINT N'Altering [dbo].[VMToNetwork]'
GO
ALTER TABLE [dbo].[VMToNetwork] ADD
[MacAddress] [nvarchar] (256) COLLATE SQL_Latin1_General_CP1_CI_AS NULL
GO

PRINT N'Refreshing [dbo].[PhysicalMachineView]'
GO
EXEC sp_refreshview N'[dbo].[PhysicalMachineView]'
GO

PRINT N'Refreshing [dbo].[CloudMachineView]'
GO
EXEC sp_refreshview N'[dbo].[CloudMachineView]'
GO

PRINT N'Altering [dbo].[TemplatesView]'
GO
ALTER VIEW [dbo].[TemplatesView]
AS
SELECT     
	VMT.*
	,CASE WHEN MemoryMaxMB is not null and  MemoryMaxMB > 0 THEN convert(nvarchar(5), MemoryMB) + '-' + convert(nvarchar(5), MemoryMaxMB) ELSE convert(nvarchar(5), MemoryMB) END TemplateMemory
	,CASE WHEN DiskSizeMaxGB is not null and  DiskSizeMaxGB > 0 THEN convert(nvarchar(5), DiskSize0GB) + '-' + convert(nvarchar(5), DiskSizeMaxGB) ELSE convert(nvarchar(5), DiskSize0GB) END TemplateStorage
	,(SELECT dbo.GetGroupNamesForTemplate(VMT.VirtualMachineTemplateID)) GroupNames
FROM VMTemplateView AS VMT 
GO

PRINT N'Refreshing [dbo].[VirtualMachineRequestView]'
GO
EXEC sp_refreshview N'[dbo].[VirtualMachineRequestView]'
GO

PRINT N'Refreshing [dbo].[HostReservationsView]'
GO
EXEC sp_refreshview N'[dbo].[HostReservationsView]'
GO

PRINT N'Refreshing [dbo].[HostReservationCostView]'
GO
EXEC sp_refreshview N'[dbo].[HostReservationCostView]'
GO

PRINT N'Refreshing [dbo].[HostReservationAvailabilityZonesView]'
GO
EXEC sp_refreshview N'[dbo].[HostReservationAvailabilityZonesView]'
GO

PRINT N'Altering [dbo].[GetHostNamesForEnterpriseAdmin]'
GO
ALTER FUNCTION [dbo].[GetHostNamesForEnterpriseAdmin] (@EnterpriseAdminGroupID uniqueidentifier)
RETURNS nvarchar(4000) AS
BEGIN
	DECLARE @Concat nvarchar(4000), @Delimiter nvarchar(1);
	SET @Concat = N'';
	SET @Delimiter = N';'
	SELECT @Concat = @Concat + @Delimiter + LTRIM(HostName)
		 FROM (SELECT DISTINCT h.HostName FROM dbo.AdminGroupToHost a 
			   INNER JOIN Host h ON a.HostID = h.HostID
			   WHERE a.EnterpriseAdminID = @EnterpriseAdminGroupID) derived
	RETURN SUBSTRING(@Concat, 2, LEN(@Concat));
END
GO

PRINT N'Altering [dbo].[HostBasicView]'
GO
ALTER VIEW [dbo].[HostBasicView]
AS
	SELECT 
		Host.HostID
		,ClusterHostID
		,Host.PhysicalLocationID
		,Host.CostProfileID
		,Host.ManagementEndpointID
		,HostName
		,HostComments
		,HostOSType
		,HostManufacturer
		,HostModel
		,HostUniqueID
		,IsCluster
		,HostProcessors
		,HostProcessorSpeed
		,HostProcessorType
		,RecCreationTime
		,RecDeleteTime
		,RecUpdateTime
		,HostStateID
		,HostTotalMemoryMB
		,v1.HostUsedMemoryMB
		,v1.HostUsedStorageGB 
		,HostUsedFlCloneStorageGB  
		,HostTotalStorageGB
		,ProvisioningAgentID
		,(SELECT TOP 1 EnterpriseAdminID FROM AdminGroupToHost a WHERE a.HostID = Host.HostID) EnterpriseAdminGroupID         
		,dbo.GetEnterpriseAdminNamesForHost(Host.HostID) EnterpriseAdminGroups
		,CostProfileName
		,AgentName
		,AgentAlive
		,PhysicalLocationName        
		,NumOfVMsCreated  
		,NumOfVMsNonMissing
		,NumOfVMsManagedMissing
		,NumOfVMsCreatedHasReservation  
		,NumOfVMsUnregistered
		,(SELECT COUNT(r.HostReservationID) From HostReservation r WHERE r.HostID = Host.HostID) NumOfHostReservations
		,IsVRMManaged
		,HostDNSName
		,HostUuid
		,AllocationType 
	FROM [Host] LEFT OUTER JOIN 
		Agent ON Agent.AgentID = Host.ProvisioningAgentID LEFT OUTER JOIN
		CostProfile ON CostProfile.CostProfileID = Host.CostProfileID LEFT OUTER JOIN
		PhysicalLocation ON PhysicalLocation.PhysicalLocationID = Host.PhysicalLocationID
	LEFT OUTER JOIN
	(
		SELECT
				v.HostID
			,	SUM(CASE WHEN v.IsRunning = 1 THEN v.VMTotalMemoryMB END) AS HostUsedMemoryMB
			,	SUM(v.VMTotalStorageGB) AS HostUsedStorageGB
			,	SUM(v.VMUsedStorageGB) AS HostUsedFlCloneStorageGB
			,	SUM(CASE WHEN 
					v.IsTemplate = 0 and (v.IsMissing = 0 or v.VirtualMachineTemplateID is not null) 
					THEN 1 ELSE 0 END) AS NumOfVMsCreated
			,	SUM(CASE WHEN 
					v.IsTemplate = 0 and v.IsMissing = 0
					THEN 1 ELSE 0 END) AS NumOfVMsNonMissing
			,	SUM(CASE WHEN 
					v.IsTemplate = 0 and v.IsMissing = 1 and v.VirtualMachineTemplateID is not null
					THEN 1 ELSE 0 END) AS NumOfVMsManagedMissing
			,	SUM(CASE WHEN 
					v.HostReservationID is not null AND v.IsTemplate = 0
					THEN 1 ELSE 0 END) AS NumOfVMsCreatedHasReservation
			,	SUM(CASE WHEN 
					v.VirtualMachineTemplateID is null AND v.IsTemplate = 0 and v.IsMissing = 0
					THEN 1 ELSE 0 END) AS NumOfVMsUnregistered
		FROM VirtualMachine v
		GROUP BY v.HostID
	) v1 ON  v1.HostID = Host.HostID
GO

PRINT N'Altering [dbo].[VirtualMachineView]'
GO
ALTER VIEW [dbo].[VirtualMachineView]
AS
SELECT     
	VM.*, 
	ISNULL(CONVERT(NVARCHAR(20), VM.Expires, 106), N'Never') ExpireDate
FROM uv_VirtualMachineView AS VM where IsTemplate = 0 and MachineType = 0
GO

PRINT N'Refreshing [dbo].[EntityProperties]'
GO
EXEC sp_refreshview N'[dbo].[EntityProperties]'
GO

PRINT N'Refreshing [dbo].[HostReservationInfo]'
GO
EXEC sp_refreshview N'[dbo].[HostReservationInfo]'
GO

PRINT N'Altering [dbo].[AvailabilityZoneOrSubnetToReservations]'
GO
ALTER FUNCTION [dbo].[AvailabilityZoneOrSubnetToReservations] (@VirtualMachineId uniqueidentifier, @AvailabilityZone nvarchar(256))
RETURNS @ReservationList TABLE (HostReservationId uniqueidentifier)
AS
	BEGIN
		DECLARE @SubnetId int
		DECLARE @AdvancedCapabilitiesMode bit
	
		SET @SubnetId = dbo.GetVirtualMachinePropertyValue(@VirtualMachineId, N'__amazon.subnetId')
		SET @AdvancedCapabilitiesMode = dbo.GetVirtualMachinePropertyValue(@VirtualMachineId, N'__amazon_advancedCapabilitiesMode')
		
		IF (@AdvancedCapabilitiesMode != 1)
		BEGIN
			IF (@AvailabilityZone IS NOT NULL AND @AvailabilityZone != '')
			BEGIN
				-- Return all reservations containing the requested location
				INSERT INTO @ReservationList 
				SELECT hr.HostReservationId 
					FROM HostReservation hr
						JOIN HostReservationAvailabilityZonesView HRAZ ON hr.HostReservationId = HRAZ.HostReservationId
					WHERE @AvailabilityZone = HRAZ.AvailabilityZone
				
				RETURN
			END			
		END
		ELSE
		BEGIN		
			-- It is assumed either a subnet OR availability zone will be specified.  If a subnet is specified it will take precedence
			IF (@SubnetId IS NOT NULL)
			BEGIN
				-- Return all hostreservations where the subnet exists
				INSERT INTO @ReservationList
				SELECT hr.HostReservationId
					FROM dbo.HostReservation hr 
						JOIN [DynamicOps.AmazonWSModel].[AmazonHostReservations] ahr ON hr.HostReservationID = ahr.HostReservationId
						JOIN [DynamicOps.AmazonWSModel].[CloudReservationSubnet] crs ON ahr.Id = crs.CloudReservations_Id
						JOIN [DynamicOps.AmazonWSModel].[Subnets] s ON crs.Subnets_Id = @SubnetId
				RETURN				
			END
			ELSE
			BEGIN
				IF (@AvailabilityZone IS NOT NULL AND @AvailabilityZone != '')							
				BEGIN
					-- Return all non-VPC hostreservations where the availability zone exists
					INSERT INTO @ReservationList
					SELECT hr.HostReservationId 
					FROM HostReservation hr
						JOIN HostReservationAvailabilityZonesView HRAZ ON hr.HostReservationId = HRAZ.HostReservationId
					WHERE @AvailabilityZone = HRAZ.AvailabilityZone	
						AND IsVPC = 0
						
					RETURN
				END				
				ELSE
				BEGIN
					-- Return all non-VPC hostreservations
					INSERT INTO @ReservationList
					SELECT HRAZ.HostReservationId 
					FROM HostReservationAvailabilityZonesView HRAZ
					WHERE IsVPC = 0
						
					RETURN
				END				
			END	
			RETURN
		END
		
		-- If no cases match, return all reservations
		INSERT INTO @ReservationList 
		SELECT hr.HostReservationId 
			FROM HostReservation hr
	
		RETURN 
	END
GO

PRINT N'Refreshing [dbo].[ProvisioningGroupCapacityViewInt]'
GO
EXEC sp_refreshview N'[dbo].[ProvisioningGroupCapacityViewInt]'
GO

PRINT N'Refreshing [dbo].[ProvisioningGroupCapacityViewInt1]'
GO
EXEC sp_refreshview N'[dbo].[ProvisioningGroupCapacityViewInt1]'
GO

PRINT N'Refreshing [dbo].[ProvisioningGroupCapacityView]'
GO
EXEC sp_refreshview N'[dbo].[ProvisioningGroupCapacityView]'
GO

PRINT N'Altering [dbo].[ReclaimedVirtualMachineView]'
GO
ALTER VIEW [dbo].[ReclaimedVirtualMachineView]
AS
SELECT     
	v.VirtualMachineID, 
	v.VirtualMachineTemplateID, 
	v.HostID, 
	v.HostReservationID, 
	v.ResourcePoolID, 
	v.VirtualMachineName, 
	v.Expires, 
	v.BlueprintType, 
	v.InitiatorType, 
	v.Notes, 
	v.GuestOS, 
	v.VMUniqueID, 
	v.PlatformDetails, 
	v.VMCreationDate, 
	v.VMDeleteDate, 
	v.LastLoggedDate, 
	v.LastLoggedUser, 
	v.LastPowerOffDate, 
	v.LastPowerOnDate, 
	v.OwnerExists, 
	v.UsageIndex, 
	v.UsageIndexIgnoreBy, 
	v.IsDeleted, 
	v.IsMissing, 
	v.IsRogue, 
	v.IsRunning, 
	v.RecCreationTime, 
	v.RecDeleteTime, 
	v.RecUpdateTime, 
	v.Flags, 
	v.Text1, 
	v.Text2, 
	v.VMCPUs, 
	v.VMTotalMemoryMB, 
	v.VMTotalStorageGB, 
	v.GuestOSFamily, 
	v.VirtualMachineState,
	v.HostStorageReservationID, 
	v.IsTemplate, 
	v.ConnectToVdi, 
	v.VMDNSName, 
	v.VMUsedStorageGB, 
	v.FileLevelCloneImageName, 
	v.VMInitialUsedSpace, 
	v.VMEstimatedUsedSpace, 
	v.PhysicalMachineID,
	v.IsComponent,
	v.ParentMachineID,
	uApprover.UserName AS Approver,
	uOwner.UserName AS Owner,
	h.HostName, 
	hr.HostReservationName,
	r.ResourcePoolName,
	t.VirtualMachineTemplateName,
	g.GroupID,
	g.GroupName
FROM
	dbo.VirtualMachine AS v
	LEFT OUTER JOIN HostReservation hr ON hr.HostReservationID = v.HostReservationID
	LEFT OUTER JOIN Host h ON h.HostID = v.HostID
	LEFT OUTER JOIN VirtualMachineTemplate t ON t.VirtualMachineTemplateID = v.VirtualMachineTemplateID
	LEFT OUTER JOIN ProvisioningGroup g ON g.GroupID = hr.GroupID
	LEFT OUTER JOIN ResourcePool r ON r.ResourcePoolID = v.ResourcePoolID
	LEFT OUTER JOIN Users uOwner ON uOwner.UserID = v.Owner
	LEFT OUTER JOIN Users uApprover ON uApprover.UserID = v.Approver
WHERE v.Flags & 2 > 0
UNION 
SELECT     
	v.VirtualMachineID, 
	v.VirtualMachineTemplateID, 
	v.HostID, 
	v.HostReservationID, 
	v.ResourcePoolID, 
	v.VirtualMachineName, 
	v.Expires, 
	v.BlueprintType, 
	v.InitiatorType, 
	v.Notes, 
	v.GuestOS, 
	v.VMUniqueID, 
	v.PlatformDetails, 
	v.VMCreationDate, 
	v.VMDeleteDate, 
	v.LastLoggedDate, 
	v.LastLoggedUser, 
	v.LastPowerOffDate, 
	v.LastPowerOnDate, 
	v.OwnerExists, 
	v.UsageIndex, 
	v.UsageIndexIgnoreBy, 
	v.IsDeleted, 
	v.IsMissing, 
	v.IsRogue, 
	v.IsRunning, 
	v.RecCreationTime, 
	v.RecDeleteTime, 
	v.RecUpdateTime, 
	v.Flags, 
	v.Text1, 
	v.Text2, 
	v.VMCPUs, 
	v.VMTotalMemoryMB, 
	v.VMTotalStorageGB, 
	v.GuestOSFamily, 
	v.VirtualMachineState,
	v.HostStorageReservationID, 
	v.IsTemplate, 
	v.ConnectToVdi, 
	v.VMDNSName, 
	v.VMUsedStorageGB, 
	v.FileLevelCloneImageName, 
	v.VMInitialUsedSpace, 
	v.VMEstimatedUsedSpace, 
	v.PhysicalMachineID,
	v.IsComponent,
	v.ParentMachineID,
	uApprover.UserName AS Approver,
	uOwner.UserName AS Owner, 
	h.HostName, 
	hr.HostReservationName,
	r.ResourcePoolName,
	t.VirtualMachineTemplateName,
	g.GroupID,
	g.GroupName
FROM
	dbo.VirtualMachineHistory AS v
	LEFT OUTER JOIN HostReservation hr ON hr.HostReservationID = v.HostReservationID
	LEFT OUTER JOIN Host h ON h.HostID = v.HostID
	LEFT OUTER JOIN VirtualMachineTemplate t ON t.VirtualMachineTemplateID = v.VirtualMachineTemplateID
	LEFT OUTER JOIN ProvisioningGroup g ON g.GroupID = hr.GroupID
	LEFT OUTER JOIN ResourcePool r ON r.ResourcePoolID = v.ResourcePoolID
	LEFT OUTER JOIN Users uOwner ON uOwner.UserID = v.Owner
	LEFT OUTER JOIN Users uApprover ON uApprover.UserID = v.Approver
WHERE v.Flags & 2 > 0 OR v.Flags & 4 > 0
GO

PRINT N'Altering [dbo].[VirtualMachineInfo]'
GO
ALTER VIEW [dbo].[VirtualMachineInfo]
AS
	SELECT 
		VM.VirtualMachineName, 
		VM.Owner, 
		VM.Expires, 
		H.HostName
		,EP1.PropertyValue AS PhysicalHostName
		,EP2.PropertyValue AS ResourcePool
		,EP3.PropertyValue AS ApplicationID
		,EP4.PropertyValue AS CPUCount
		,EP5.PropertyValue AS Memory
	FROM VirtualMachine VM
		LEFT JOIN EntityProperties EP1 ON EP1.EntityID = VM.VirtualMachineID AND UPPER(EP1.PropertyName)=N'VIRTUALMACHINE.ADMIN.HOSTNAME'
		LEFT JOIN EntityProperties EP2 ON EP2.EntityID = VM.VirtualMachineID AND UPPER(EP2.PropertyName)=N'INFRASTRUCTURE.RESOURCEPOOL.NAME'
		LEFT JOIN EntityProperties EP3 ON EP3.EntityID = VM.VirtualMachineID AND UPPER(EP3.PropertyName)=N'VIRTUALMACHINE.ADMIN.APPLICATIONID' 
		LEFT JOIN EntityProperties EP4 ON EP4.EntityID = VM.VirtualMachineID AND UPPER(EP4.PropertyName)=N'VIRTUALMACHINE.CPU.COUNT'
		LEFT JOIN EntityProperties EP5 ON EP5.EntityID = VM.VirtualMachineID AND UPPER(EP5.PropertyName)=N'VIRTUALMACHINE.MEMORY.SIZE'
		LEFT JOIN HostReservation HR ON HR.HostReservationID = VM.HostReservationID
		LEFT JOIN Host H ON H.HostID = HR.HostID;
GO

PRINT N'Refreshing [dbo].[VirtualMachinePerDayCostView]'
GO
EXEC sp_refreshview N'[dbo].[VirtualMachinePerDayCostView]'
GO

PRINT N'Refreshing [dbo].[VirtualMachineCostView]'
GO
EXEC sp_refreshview N'[dbo].[VirtualMachineCostView]'
GO

PRINT N'Refreshing [dbo].[UserCapacitySummaryView]'
GO
EXEC sp_refreshview N'[dbo].[UserCapacitySummaryView]'
GO

PRINT N'Refreshing [dbo].[TemplateCapacitySummaryView]'
GO
EXEC sp_refreshview N'[dbo].[TemplateCapacitySummaryView]'
GO

PRINT N'Refreshing [dbo].[RogueVirtualMachineView]'
GO
EXEC sp_refreshview N'[dbo].[RogueVirtualMachineView]'
GO

PRINT N'Refreshing [dbo].[LeaseExtensionView]'
GO
EXEC sp_refreshview N'[dbo].[LeaseExtensionView]'
GO

PRINT N'Refreshing [dbo].[HostCapacityViewInt]'
GO
EXEC sp_refreshview N'[dbo].[HostCapacityViewInt]'
GO

PRINT N'Refreshing [dbo].[HostCapacityViewInt1]'
GO
EXEC sp_refreshview N'[dbo].[HostCapacityViewInt1]'
GO

PRINT N'Refreshing [dbo].[HostCapacityView]'
GO
EXEC sp_refreshview N'[dbo].[HostCapacityView]'
GO

PRINT N'Refreshing [dbo].[ReclaimedVirtualMachineCostView]'
GO
EXEC sp_refreshview N'[dbo].[ReclaimedVirtualMachineCostView]'
GO

PRINT N'Altering [dbo].[SecurityGroupsToReservations]'
GO
ALTER FUNCTION [dbo].[SecurityGroupsToReservations] (@VirtualMachineId uniqueidentifier)
RETURNS @ReservationList TABLE (HostReservationId uniqueidentifier)
AS
	BEGIN
		DECLARE @SecurityGroup nvarchar(max)
		DECLARE @CountOfSecurityGroups int
		SET @SecurityGroup = dbo.GetVirtualMachinePropertyValue(@VirtualMachineId, N'__amazon.securityGroups')
		SELECT @CountOfSecurityGroups = COUNT(*) FROM dbo.Split(@SecurityGroup, ',')
	
		IF (@SecurityGroup IS NULL OR @SecurityGroup = '')
		BEGIN
			-- Return all hostreservations
			INSERT INTO @ReservationList 
			SELECT HostReservationId FROM HostReservation
		END		
		ELSE
		BEGIN
			-- Return all hostreservations that contain all of the security groups
			INSERT INTO @ReservationList
			SELECT hr.HostReservationId
				FROM dbo.HostReservation hr 
					JOIN [DynamicOps.AmazonWSModel].[AmazonHostReservations] ahr ON hr.HostReservationID = ahr.HostReservationId
					JOIN [DynamicOps.AmazonWSModel].[CloudReservationSecurityGroup] crsg ON ahr.Id = crsg.CloudReservations_Id
					JOIN [DynamicOps.AmazonWSModel].[SecurityGroups] sg ON crsg.SecurityGroups_Id = sg.Id
					JOIN (SELECT sg2.Name FROM [DynamicOps.AmazonWSModel].[SecurityGroups] sg2
						JOIN dbo.Split(@SecurityGroup, ',') mysg ON mysg.Item = sg2.Id) sgnames ON sgnames.Name = sg.Name
				GROUP BY hr.HostReservationId
				HAVING COUNT(DISTINCT sg.Name) = @CountOfSecurityGroups
		END
	
		RETURN 
	END
GO

PRINT N'Refreshing [dbo].[HostPerDayCostView]'
GO
EXEC sp_refreshview N'[dbo].[HostPerDayCostView]'
GO

PRINT N'Altering [dbo].[Cluster]'
GO
ALTER TABLE [dbo].[Cluster] ALTER COLUMN [ClusterName] [nvarchar] (256) COLLATE SQL_Latin1_General_CP1_CI_AS NOT NULL
GO

PRINT N'Creating [dbo].[EndpointUsageHistory]'
GO
CREATE TABLE [dbo].[EndpointUsageHistory]
(
[Id] [uniqueidentifier] NOT NULL,
[DateTaken] [datetime] NOT NULL,
[EndpointName] [nvarchar] (256) COLLATE SQL_Latin1_General_CP1_CI_AS NOT NULL,
[EndpointId] [uniqueidentifier] NOT NULL,
[NumberOfServer] [int] NULL,
[NumberOfDesktop] [int] NULL
)
GO

PRINT N'Creating primary key [PK_EndpointUsageHistory] on [dbo].[EndpointUsageHistory]'
GO
ALTER TABLE [dbo].[EndpointUsageHistory] ADD CONSTRAINT [PK_EndpointUsageHistory] PRIMARY KEY CLUSTERED  ([Id])
GO

PRINT N'Creating [dbo].[LicenseKeys]'
GO
CREATE TABLE [dbo].[LicenseKeys]
(
[Id] [int] NOT NULL IDENTITY(1, 1),
[SerialNumber] [nvarchar] (29) COLLATE SQL_Latin1_General_CP1_CI_AS NOT NULL,
[LicenseEdition] [int] NOT NULL,
[ExpirationDate] [datetime] NULL,
[LicenseUnit] [int] NOT NULL,
[LicensedUnits] [int] NULL,
[UsedUnits] [int] NULL
)
GO

PRINT N'Creating primary key [PK_LicenseKeys] on [dbo].[LicenseKeys]'
GO
ALTER TABLE [dbo].[LicenseKeys] ADD CONSTRAINT [PK_LicenseKeys] PRIMARY KEY CLUSTERED  ([Id])
GO

PRINT N'Rebuilding [dbo].[Test]'
GO
CREATE TABLE [dbo].[tmp_rg_xx_Test]
(
[Result] [ntext] COLLATE SQL_Latin1_General_CP1_CI_AS NULL
)
GO

INSERT INTO [dbo].[tmp_rg_xx_Test]([Result]) SELECT CAST([Result] AS [ntext]) FROM [dbo].[Test]
GO

DROP TABLE [dbo].[Test]
GO

EXEC sp_rename N'[dbo].[tmp_rg_xx_Test]', N'Test'
GO

PRINT N'Altering [dbo].[HostTypes]'
GO
ALTER VIEW [dbo].[HostTypes]
AS
    SELECT N'Cloud' [TypeName], 2 [TypeValue]
    UNION ALL
    SELECT N'Virtual', 0
GO

PRINT N'Altering [dbo].[MachineTypes]'
GO
ALTER VIEW [dbo].[MachineTypes]
AS
    SELECT N'Cloud' [TypeName], 2 [TypeValue]
    UNION ALL
    SELECT N'Physical', 1
    UNION ALL
    SELECT N'Virtual', 0
GO

PRINT N'Adding constraints to [dbo].[Users]'
GO
ALTER TABLE [dbo].[Users] ADD CONSTRAINT [UQ__Users__C9F2845645BE5BA9] UNIQUE NONCLUSTERED  ([UserName])
GO

PRINT N'Adding constraints to [dbo].[VirtualMachineTemplate]'
GO
ALTER TABLE [dbo].[VirtualMachineTemplate] ADD CONSTRAINT [TUC_VirtualMachineTemplate_1] UNIQUE NONCLUSTERED  ([VirtualMachineTemplateName])
GO

PRINT N'Adding foreign keys to [dbo].[AppServiceComponentTemplates]'
GO
ALTER TABLE [dbo].[AppServiceComponentTemplates] ADD
CONSTRAINT [FK_VirtualMachineTemplates_AppServiceComponentTemplates_VirtualMachineTemplateId] FOREIGN KEY ([VirtualMachineTemplateId]) REFERENCES [dbo].[VirtualMachineTemplate] ([VirtualMachineTemplateID]) ON DELETE CASCADE
GO

PRINT N'Adding foreign keys to [dbo].[VirtualMachine]'
GO
ALTER TABLE [dbo].[VirtualMachine] ADD
CONSTRAINT [VirtualMachine_VirtualMachine] FOREIGN KEY ([ParentMachineID]) REFERENCES [dbo].[VirtualMachine] ([VirtualMachineID]),
CONSTRAINT [FK_VirtualMachine_VirtualMachineTemplate] FOREIGN KEY ([VirtualMachineTemplateID]) REFERENCES [dbo].[VirtualMachineTemplate] ([VirtualMachineTemplateID])
GO

PRINT N'Adding foreign keys to [dbo].[AppServiceTemplates]'
GO
ALTER TABLE [dbo].[AppServiceTemplates] ADD
CONSTRAINT [FK_AppServiceTemplates_VirtualMachineTemplates_AppServiceTemplateId] FOREIGN KEY ([VirtualMachineTemplateId]) REFERENCES [dbo].[VirtualMachineTemplate] ([VirtualMachineTemplateID]) ON DELETE CASCADE
GO

PRINT N'Adding foreign keys to [dbo].[MachineOperationVirtualMachineTemplate]'
GO
ALTER TABLE [dbo].[MachineOperationVirtualMachineTemplate] ADD
CONSTRAINT [FK_MachineOperationVirtualMachineTemplate_VirtualMachineTemplate] FOREIGN KEY ([VirtualMachineTemplates_VirtualMachineTemplateID]) REFERENCES [dbo].[VirtualMachineTemplate] ([VirtualMachineTemplateID]) ON DELETE CASCADE
GO

PRINT N'Adding foreign keys to [dbo].[VirtualMachineTemplateProperties]'
GO
ALTER TABLE [dbo].[VirtualMachineTemplateProperties] ADD
CONSTRAINT [FK_VirtualMachineTemplateProperties_VirtualMachineTemplate] FOREIGN KEY ([EntityID]) REFERENCES [dbo].[VirtualMachineTemplate] ([VirtualMachineTemplateID]) ON DELETE CASCADE
GO

PRINT N'Adding foreign keys to [dbo].[CredentialAssoc]'
GO
ALTER TABLE [dbo].[CredentialAssoc] ADD
CONSTRAINT [VirtualMachineTemplate_CredentialAssoc] FOREIGN KEY ([VirtualMachineTemplateID]) REFERENCES [dbo].[VirtualMachineTemplate] ([VirtualMachineTemplateID])
GO

PRINT N'Adding foreign keys to [dbo].[GroupToTemplate]'
GO
ALTER TABLE [dbo].[GroupToTemplate] ADD
CONSTRAINT [VirtualMachineTemplate_GroupToTemplate] FOREIGN KEY ([VirtualMachineTemplateID]) REFERENCES [dbo].[VirtualMachineTemplate] ([VirtualMachineTemplateID])
GO

PRINT N'Adding foreign keys to [dbo].[Request]'
GO
ALTER TABLE [dbo].[Request] ADD
CONSTRAINT [VirtualMachineTemplate_Request] FOREIGN KEY ([VirtualMachineTemplateID]) REFERENCES [dbo].[VirtualMachineTemplate] ([VirtualMachineTemplateID])
GO

PRINT N'Adding foreign keys to [dbo].[TemplateToGlobalProfiles]'
GO
ALTER TABLE [dbo].[TemplateToGlobalProfiles] ADD
CONSTRAINT [VirtualMachineTemplate_TemplateToGlobalProfiles] FOREIGN KEY ([VirtualMachineTemplateID]) REFERENCES [dbo].[VirtualMachineTemplate] ([VirtualMachineTemplateID])
GO

PRINT N'Adding foreign keys to [dbo].[VirtualMachineTemplate]'
GO
ALTER TABLE [dbo].[VirtualMachineTemplate] ADD
CONSTRAINT [VirtualMachineTemplate_VirtualMachineTemplate] FOREIGN KEY ([InheritsFromVMTemplateID]) REFERENCES [dbo].[VirtualMachineTemplate] ([VirtualMachineTemplateID]),
CONSTRAINT [WorkflowInfo_VirtualMachineTemplate] FOREIGN KEY ([WorkflowID]) REFERENCES [dbo].[WorkflowInfo] ([WorkflowID]),
CONSTRAINT [ApprovalPolicy_VirtualMachineTemplate] FOREIGN KEY ([ApprovalPolicyId]) REFERENCES [dbo].[ApprovalPolicy] ([PolicyId]),
CONSTRAINT [HostReservationPolicy_VirtualMachineTemplate] FOREIGN KEY ([ReservationPolicyID]) REFERENCES [dbo].[HostReservationPolicy] ([id]),
CONSTRAINT [VirtualMachineTemplate_InterfaceType] FOREIGN KEY ([InterfaceTypeId]) REFERENCES [dbo].[InterfaceTypes] ([InterfaceTypeId]),
CONSTRAINT [FK_VirtualMachineTemplateServiceProfileTemplate] FOREIGN KEY ([ServiceProfileTemplate_Id]) REFERENCES [dbo].[ServiceProfileTemplates] ([Id])
GO

PRINT N'Altering trigger [dbo].[trg_DeleteVirtualMachine] on [dbo].[VirtualMachine]'
GO
ALTER TRIGGER [dbo].[trg_DeleteVirtualMachine] 
ON [dbo].[VirtualMachine] FOR DELETE
AS
	SET NOCOUNT ON;
	DELETE FROM VirtualMachineHistory 
	WHERE VirtualMachineID in 
		(SELECT VirtualMachineID FROM deleted)
	INSERT VirtualMachineHistory 
		SELECT * 
		FROM deleted 
		WHERE ISNULL(Flags, 0) & 32 = 32
	UPDATE VirtualMachineHistory 
		SET VMDeleteDate = GETDATE() 
		FROM VirtualMachineHistory v 
		JOIN deleted d 
		ON v.VirtualMachineID = d.VirtualMachineID	
		
	DELETE FROM VirtualMachineHistoryProperties
	WHERE EntityID in 
		(SELECT VirtualMachineID FROM deleted)
		
	INSERT VirtualMachineHistoryProperties
		SELECT EntityID, PropertyName, PropertyValue, IsHidden, IsRuntime, IsEncrypted 
		FROM VirtualMachineProperties vmp
		JOIN deleted on vmp.EntityID = deleted.VirtualMachineID
		WHERE EntityID IN
			(SELECT VirtualMachineID FROM deleted)
		AND
			ISNULL(deleted.Flags, 0) & 32 = 32
	DELETE FROM VirtualMachineProperties
	WHERE EntityID in
		(SELECT VirtualMachineID FROM deleted)
		
	INSERT VMDiskHardwareHistory
		SELECT vmd.VMToStorageId, vmd.VirtualMachineID, vmd.Capacity, vmd.DiskName, 
		vmd.Text1, vmd.Text2, vmd.HostToStorageID, vmd.UsedCapacity, vmd.ExternalDiskID, vmd.DeviceID, vmd.IsFixed
		FROM VMDiskHardware vmd
		JOIN deleted on vmd.VirtualMachineID = deleted.VirtualMachineID
		WHERE vmd.VirtualMachineID IN
			(SELECT VirtualMachineID FROM deleted)
		AND
			ISNULL(deleted.Flags, 0) & 32 = 32
	DELETE FROM VMDiskHardware
	WHERE VirtualMachineID in
		(SELECT VirtualMachineID FROM deleted)
GO

PRINT N'Altering trigger [dbo].[trg_UpdateVirtualMachineFlags] on [dbo].[VirtualMachine]'
GO
ALTER TRIGGER [dbo].[trg_UpdateVirtualMachineFlags] 
ON [dbo].[VirtualMachine] AFTER UPDATE
AS
	SET NOCOUNT ON;
	IF UPDATE(VirtualMachineState)
	BEGIN
		-- set flag for machine was turned on as well move the bit that reclamation was started
		UPDATE VirtualMachine SET Flags = ISNULL(t.Flags, 0) + 32 + (ISNULL(t.Flags, 0) & 2 * 4) FROM VirtualMachine t JOIN inserted i
		On t.VirtualMachineID = i.VirtualMachineID WHERE i.VirtualMachineState = N'On' and ISNULL(t.Flags, 0) & 32 = 0
	END 	
GO

PRINT N'Creating extended properties'
GO
EXEC sp_addextendedproperty N'MS_Description', N'Host AllocationType', 'SCHEMA', N'dbo', 'TABLE', N'Host', 'COLUMN', N'AllocationType'
GO

EXEC sp_addextendedproperty N'MS_Description', N'Parent virtual machine id', 'SCHEMA', N'dbo', 'TABLE', N'VirtualMachine', 'COLUMN', N'ParentMachineID'
GO

EXEC sp_addextendedproperty N'MS_Description', N'Parent virtual machine id', 'SCHEMA', N'dbo', 'TABLE', N'VirtualMachineHistory', 'COLUMN', N'ParentMachineID'
GO

EXEC sp_addextendedproperty N'MS_Description', N'Blueprint for creating/cloning virtual machines', 'SCHEMA', N'dbo', 'TABLE', N'VirtualMachineTemplate', NULL, NULL
GO

EXEC sp_addextendedproperty N'MS_Description', N'Whether Blueprint is for creating servers', 'SCHEMA', N'dbo', 'TABLE', N'VirtualMachineTemplate', 'COLUMN', N'BlueprintType'
GO

EXEC sp_addextendedproperty N'MS_Description', N'Cost to be associated with the Blueprint for charge back reports', 'SCHEMA', N'dbo', 'TABLE', N'VirtualMachineTemplate', 'COLUMN', N'Cost'
GO

EXEC sp_addextendedproperty N'MS_Description', N'Number of CPUs to be allocated to virtual machine', 'SCHEMA', N'dbo', 'TABLE', N'VirtualMachineTemplate', 'COLUMN', N'CPUCount'
GO

EXEC sp_addextendedproperty N'MS_Description', N'Size of first disk in GB created in virtual machine', 'SCHEMA', N'dbo', 'TABLE', N'VirtualMachineTemplate', 'COLUMN', N'DiskSize0GB'
GO

EXEC sp_addextendedproperty N'MS_Description', N'Whether Blueprint is enabled', 'SCHEMA', N'dbo', 'TABLE', N'VirtualMachineTemplate', 'COLUMN', N'Enabled'
GO

EXEC sp_addextendedproperty N'MS_Description', N'Number of days for which a VM is active for', 'SCHEMA', N'dbo', 'TABLE', N'VirtualMachineTemplate', 'COLUMN', N'ExpireDays'
GO

EXEC sp_addextendedproperty N'MS_Description', N'Integer attribute which can be used for applying flags to the entity', 'SCHEMA', N'dbo', 'TABLE', N'VirtualMachineTemplate', 'COLUMN', N'Flags'
GO

EXEC sp_addextendedproperty N'MS_Description', N'This can be used to set inheritance among blueprint. A Blueprint could inherit properties of a anothe Blurprint and overriding some of the values ', 'SCHEMA', N'dbo', 'TABLE', N'VirtualMachineTemplate', 'COLUMN', N'InheritsFromVMTemplateID'
GO

EXEC sp_addextendedproperty N'MS_Description', N'Number of days for which a virtual machine is leased for', 'SCHEMA', N'dbo', 'TABLE', N'VirtualMachineTemplate', 'COLUMN', N'LeaseDays'
GO

EXEC sp_addextendedproperty N'MS_Description', N'Machine prefix for Blueprint. If not provided naming from group will be used', 'SCHEMA', N'dbo', 'TABLE', N'VirtualMachineTemplate', 'COLUMN', N'MachinePrefix'
GO

EXEC sp_addextendedproperty N'MS_Description', N'Whether it is a master', 'SCHEMA', N'dbo', 'TABLE', N'VirtualMachineTemplate', 'COLUMN', N'Master'
GO

EXEC sp_addextendedproperty N'MS_Description', N'Amount of memory in MB to be allocated to virtual machine that is created from the Blueprint', 'SCHEMA', N'dbo', 'TABLE', N'VirtualMachineTemplate', 'COLUMN', N'MemoryMB'
GO

EXEC sp_addextendedproperty N'MS_Description', N'Whether requires approval before creating VM', 'SCHEMA', N'dbo', 'TABLE', N'VirtualMachineTemplate', 'COLUMN', N'RequiresApproval'
GO

EXEC sp_addextendedproperty N'MS_Description', N'Generic text column with 256 bytes length', 'SCHEMA', N'dbo', 'TABLE', N'VirtualMachineTemplate', 'COLUMN', N'Text1'
GO

EXEC sp_addextendedproperty N'MS_Description', N'Generic text column with max length', 'SCHEMA', N'dbo', 'TABLE', N'VirtualMachineTemplate', 'COLUMN', N'Text2'
GO

EXEC sp_addextendedproperty N'MS_Description', N'Description of the Blueprint', 'SCHEMA', N'dbo', 'TABLE', N'VirtualMachineTemplate', 'COLUMN', N'VirtualMachineTemplateDescription'
GO

EXEC sp_addextendedproperty N'MS_Description', N'Primary key', 'SCHEMA', N'dbo', 'TABLE', N'VirtualMachineTemplate', 'COLUMN', N'VirtualMachineTemplateID'
GO

EXEC sp_addextendedproperty N'MS_Description', N'Name for the Blueprint', 'SCHEMA', N'dbo', 'TABLE', N'VirtualMachineTemplate', 'COLUMN', N'VirtualMachineTemplateName'
GO

EXEC sp_addextendedproperty N'MS_Description', N'Mac Address of network card', 'SCHEMA', N'dbo', 'TABLE', N'VMToNetwork', 'COLUMN', N'MacAddress'
GO


----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
-- Modified Seed Data


PRINT N'Adding [dbo].[AgentCapabilityType]'
GO
INSERT INTO [dbo].[AgentCapabilityType] ([AgentCapabilityName]) VALUES (N'Kvm')
GO

PRINT N'Adding [dbo].[UserFiter]'
GO
INSERT INTO [dbo].[UserFilter] (UserFilterID, DataSourceName, FilterName, ColumnLayout, FilterExpression, CreatedTime, ModifiedTime, AutoAdjustDateValues) VALUES ('e0bc2711-2c5b-4038-8eaf-b951d8db255c', N'VMReclamationList', N'Group Manager Notified',            N',VirtualMachine.VirtualMachineName,Status,RequestUser.UserName,VirtualMachine.VirtualMachineExt.UserName,RequestDate,RequestComments,RequestFilter,CostDaily,LastAction,LastActionState,LastActionUser,LastActionDate,SentToGroupManager|sort1|a0|visible13|t0|t1|t2|t3|t4|t5|f-1|t6|t7|t8|t9|t10|t11', '[SentToGroupManager] = True', '4/8/2009', '4/8/2009', 0)
GO

PRINT N'Adding [dbo].[FilterSpecGroup]'
GO
INSERT INTO [dbo].[FilterSpecGroup] (FilterSpecGroupID, FilterSpecGroupName, ScheduleID, DependsOnFilterSpecGroupID) VALUES ('3989ee8f-a0f2-4cd3-8792-cd7eb26b4b27', 'VCNSInventory', 'E862D230-436A-4729-B302-984245F08877', 'A7784CC2-4A04-44e9-8D0F-1295D4AB5D5F')
GO

PRINT N'Adding [dbo].[FilterSpec]'
GO
INSERT INTO [dbo].[FilterSpec] (FilterSpecID, FilterSpecGroupID, FilterSpecName, AgentCapabilityName) VALUES ('8a9ab7ce-9e50-444f-9184-db617008a6d2', '3989ee8f-a0f2-4cd3-8792-cd7eb26b4b27', 'vSphere', 'vSphereHypervisor')
GO
INSERT INTO [dbo].[FilterSpec] ([FilterSpecID], [FilterSpecName], [FilterSpecDesc], [FilterSpecNamespace], [FilterSpecPath], [FilterSpecQuery], [FilterSpecScript], [FilterSpecGroupID], [AgentCapabilityName]) VALUES ('9240399a-f5f4-4ecd-8e15-21c04571ef15', N'kvm', NULL, NULL, NULL, NULL, NULL, 'b1decb8c-d05d-4430-b4cb-72c8a985bd10', N'Kvm')
GO
INSERT INTO [dbo].[FilterSpec] ([FilterSpecID], [FilterSpecName], [FilterSpecDesc], [FilterSpecNamespace], [FilterSpecPath], [FilterSpecQuery], [FilterSpecScript], [FilterSpecGroupID], [AgentCapabilityName]) VALUES ('760bf6a3-1c7d-403a-85ee-dba399504d06', N'kvm', NULL, NULL, NULL, NULL, NULL, 'a7784cc2-4a04-44e9-8d0f-1295d4ab5d5f', N'Kvm')
GO

PRINT N'Adding [dbo].[DataCollectionStatus]'
INSERT INTO [dbo].[DataCollectionStatus] (AgentID ,LastCollectedStatus ,EntityID, DataCollectionStatusID, FilterSpecID, IsDisabled) SELECT AgentID,0,EntityID, NEWID(),'8a9ab7ce-9e50-444f-9184-db617008a6d2',0 FROM DataCollectionStatus WHERE FilterSpecID = '4B40AAD1-C007-4DC2-8141-3A11BFE0872A'
GO

PRINT N'Updating [dbo].[PropertySetXml]'
UPDATE [dbo].[PropertySetXml] SET [Description]= N'Specify miscellaneous vCAC settings' WHERE [SetName]= N'MiscellaneousVrmProperties'
GO

PRINT N'Updating [dbo].[BlueprintType]'
UPDATE [dbo].[VirtualMachine] SET [BlueprintType] = 3 WHERE [MachineType] = 3
GO

PRINT N'Updating [dbo].[VirtualMachineHistory]'
UPDATE [dbo].[VirtualMachineHistory] SET [BlueprintType] = 3 WHERE [MachineType] = 3
GO

PRINT N'Updating [dbo].VirtualMachineTemplate]'
UPDATE [dbo].[VirtualMachineTemplate] SET [BlueprintType] = 3 WHERE [MachineType] = 3
GO

PRINT N'Updating [dbo].[VirtualMachine]'
UPDATE [dbo].[VirtualMachine] SET ParentMachineID = c.AppServiceId
FROM dbo.VirtualMachine vm INNER JOIN [dbo].[AppServiceComponents] c ON vm.VirtualMachineID = c.VirtualMachineId
GO


----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
-- Upgrade vCloud Model

PRINT N'Updating [dbo].[Host]'
UPDATE [dbo].[Host] SET [MachineType]= 4
FROM Host
INNER JOIN 
ManagementEndpoints m ON
Host.ManagementEndpointID = m.ManagementEndpointID
WHERE InterfaceType=N'vCloud'
GO

PRINT N'Updating [dbo].[HostReservation]'
UPDATE [dbo].[HostReservation] SET [MachineType]= 4
FROM HostReservation r
INNER JOIN 
Host h
ON r.HostID = h.HostID
INNER JOIN
ManagementEndpoints m ON
h.ManagementEndpointID = m.ManagementEndpointID
WHERE InterfaceType=N'vCloud'
GO

PRINT N'Updating [dbo].[VirtualMachineTemplate]'
UPDATE [dbo].[VirtualMachineTemplate]
SET [MachineType]=4, [Enabled]=0, [WorkflowID]=NULL WHERE InterfaceTypeId=N'vCloud'
GO

PRINT N'Updating [dbo].[VirtualMachine]'
UPDATE [dbo].[VirtualMachine]
SET [MachineType]=4, [IsManaged]=0 , [HostReservationID]=NULL, [VirtualMachineTemplateID]=NULL
FROM VirtualMachine v
INNER JOIN
Host h
ON v.HostID = h.HostID
WHERE  h.MachineType = 4
GO

PRINT N'Adding [dbo].[AppServiceTemplates]'
INSERT [dbo].[AppServiceTemplates] ([VirtualMachineTemplateID])
SELECT VirtualMachineTemplateID FROM [dbo].[VirtualMachineTemplate] WHERE [MachineType]=4
GO

/*-- We can't drop old VCloud Model here we need Data Collection to run first and then manual upgrade script */

PRINT N'Creating [dbo].[AgentHasCapability]'
GO
CREATE FUNCTION [dbo].[AgentHasCapability] (@AgentId uniqueidentifier, @CapabilityName nvarchar(128))
RETURNS bit AS
BEGIN
    RETURN 
    (
        SELECT CAST(
            CASE WHEN EXISTS (SELECT AgentID 
                FROM [dbo].AgentCapabilities ac 
                WHERE ac.AgentID = @AgentId AND ac.AgentCapabilityName = @CapabilityName) THEN 1 
            ELSE 0 
            END 
        AS BIT))
END
GO

PRINT N'Altering [dbo].[HostDiscovery]'
GO
ALTER VIEW [dbo].[HostDiscovery]
AS
	select h.HostID
	,(select COUNT(*) from AdminGroupToHost eg where eg.HostID = h.HostID) [EGs]
	,(select COUNT(*) from HostReservation hr where hr.HostID = h.HostID) [Reservations]
	,(select COUNT(*) from VirtualMachine vm where vm.HostID = h.HostID and vm.IsTemplate = 0 and 
     (vm.IsManaged = 1 or vm.IsMissing = 0)) [Machines]
	,(select COUNT(*) from VirtualMachine vm where vm.HostID = h.HostID and vm.IsTemplate = 0 and vm.IsManaged = 0 and vm.IsMissing = 0) [Unmanaged]
	from Host h
	WHERE  ((MachineType = 0) AND (ClusterHostID IS NULL)) OR ((MachineType = 4) AND (ClusterHostID IS NOT NULL))
GO

PRINT N'Refreshing [dbo].[StorageCostByMachineView]'
GO
EXEC sp_refreshview N'[dbo].[StorageCostByMachineView]'
GO

PRINT N'Refreshing [dbo].[BaseMachineCostView]'
GO
EXEC sp_refreshview N'[dbo].[BaseMachineCostView]'
GO

PRINT N'Altering [dbo].[MachineCostView]'
GO
ALTER VIEW [dbo].[MachineCostView]
AS
SELECT
	bmcv.VirtualMachineID as VirtualMachineID,
	bmcv.TotalCost as DailyCost
FROM BaseMachineCostView bmcv
WHERE bmcv.MachineType NOT IN (3,4)
UNION ALL
SELECT  vm.VirtualMachineID,
		s.DailyCost
FROM (SELECT
		ISNULL(mm.AppServiceId, bmcv.VirtualMachineId) As 
        VirtualMachineID,
		SUM(bmcv.TotalCost) as DailyCost
		FROM BaseMachineCostView bmcv
		LEFT OUTER JOIN AppServiceComponents mm ON 
		mm.VirtualMachineId = bmcv.VirtualMachineID
		WHERE AppServiceID IS NOT NULL OR bmcv.MachineType IN (3,4)
		GROUP BY ISNULL(mm.AppServiceId, bmcv.VirtualMachineId)) s 
INNER JOIN VirtualMachine vm ON vm.VirtualMachineID = s.VirtualMachineID
WHERE vm.MachineType IN (3,4)
GO

PRINT N'Creating [dbo].[HostInterfaceInfo]'
GO
CREATE VIEW [dbo].[HostInterfaceInfo]
AS
	SELECT 
        HostId = h.HostID
        ,InterfaceTypeId = 
            CASE WHEN me.InterfaceType IS NOT NULL THEN me.InterfaceType
                 WHEN [dbo].AgentHasCapability(a.AgentID, N'TestHypervisor') = 1     THEN 'Test'
                 WHEN [dbo].AgentHasCapability(a.AgentID, N'VsphereHypervisor') = 1  THEN 'vSphere'
                 WHEN [dbo].AgentHasCapability(a.AgentID, N'HyperVHypervisor') = 1   THEN 'HyperV'
                 WHEN [dbo].AgentHasCapability(a.AgentID, N'XenHypervisor') = 1      THEN 'CitrixXen'
            END
        ,EndpointName = me.ManagementEndpointName            
    FROM [dbo].Host h
        LEFT OUTER JOIN [dbo].Agent a ON h.ProvisioningAgentID = a.AgentID
        LEFT OUTER JOIN [dbo].ManagementEndpoints me ON h.ManagementEndpointID = me.ManagementEndpointID
GO

PRINT N'Creating [dbo].[HostExt]'
GO
CREATE VIEW [dbo].[HostExt]
AS
SELECT 
    HostID = h.HostID
    ,HostName = h.HostName
    ,InterfaceTypeId = it.InterfaceTypeId
    ,InterfaceDisplayName = it.DisplayName
    ,EndpointName = 

hii.EndpointName
FROM [dbo].Host h
    INNER JOIN [dbo].[HostInterfaceInfo] hii ON h.HostID = hii.HostId
    LEFT OUTER JOIN [dbo].InterfaceTypes it ON hii.InterfaceTypeId = it.InterfaceTypeId
GO

/* Create VCNSModel and drop index from Host table and refresh views */
PRINT N'Creating schemata'
GO
CREATE SCHEMA [DynamicOps.VCNSModel]
AUTHORIZATION [dbo]
GO

PRINT N'Dropping index [IX_Host] from [dbo].[Host]'
GO
DROP INDEX [IX_Host] ON [dbo].[Host]
GO

PRINT N'Refreshing [dbo].[HostStorageReservationView]'
GO
EXEC sp_refreshview N'[dbo].[HostStorageReservationView]'
GO

PRINT N'Refreshing [dbo].[RequestLastAction]'
GO
EXEC sp_refreshview N'[dbo].[RequestLastAction]'
GO

PRINT N'Creating [DynamicOps.VCNSModel].[LoadBalancers]'
GO
CREATE TABLE [DynamicOps.VCNSModel].[LoadBalancers]
(
[Id] [int] NOT NULL IDENTITY(1, 1),
[Enabled] [bit] NOT NULL,
[Edge_Id] [int] NOT NULL
)
GO

PRINT N'Creating primary key [PK_LoadBalancers] on [DynamicOps.VCNSModel].[LoadBalancers]'
GO
ALTER TABLE [DynamicOps.VCNSModel].[LoadBalancers] ADD CONSTRAINT [PK_LoadBalancers] PRIMARY KEY CLUSTERED  ([Id])
GO

PRINT N'Creating index [IX_FK_LoadBalancerEdge] on [DynamicOps.VCNSModel].[LoadBalancers]'
GO
CREATE NONCLUSTERED INDEX [IX_FK_LoadBalancerEdge] ON [DynamicOps.VCNSModel].[LoadBalancers] ([Edge_Id])
GO

PRINT N'Creating [DynamicOps.VCNSModel].[Backendpools]'
GO
CREATE TABLE [DynamicOps.VCNSModel].[Backendpools]
(
[Id] [int] NOT NULL IDENTITY(1, 1),
[Name] [nvarchar] (max) COLLATE SQL_Latin1_General_CP1_CI_AS NOT NULL,
[Description] [nvarchar] (max) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[VCNSId] [int] NOT NULL,
[LoadBalancer_Id] [int] NOT NULL
)
GO

PRINT N'Creating primary key [PK_Backendpools] on [DynamicOps.VCNSModel].[Backendpools]'
GO
ALTER TABLE [DynamicOps.VCNSModel].[Backendpools] ADD CONSTRAINT [PK_Backendpools] PRIMARY KEY CLUSTERED  ([Id])
GO

PRINT N'Creating index [IX_FK_BackendpoolLoadBalancer] on [DynamicOps.VCNSModel].[Backendpools]'
GO
CREATE NONCLUSTERED INDEX [IX_FK_BackendpoolLoadBalancer] ON [DynamicOps.VCNSModel].[Backendpools] ([LoadBalancer_Id])
GO

PRINT N'Creating [DynamicOps.VCNSModel].[Members]'
GO
CREATE TABLE [DynamicOps.VCNSModel].[Members]
(
[Id] [int] NOT NULL IDENTITY(1, 1),
[Address] [nvarchar] (max) COLLATE SQL_Latin1_General_CP1_CI_AS NOT NULL,
[Weigh] [int] NOT NULL,
[BackendpoolId] [int] NOT NULL,
[VirtualMachineId] [uniqueidentifier] NULL
)
GO

PRINT N'Creating primary key [PK_Members] on [DynamicOps.VCNSModel].[Members]'
GO
ALTER TABLE [DynamicOps.VCNSModel].[Members] ADD CONSTRAINT [PK_Members] PRIMARY KEY CLUSTERED  ([Id])
GO

PRINT N'Creating index [IX_FK_BackendpoolMember] on [DynamicOps.VCNSModel].[Members]'
GO
CREATE NONCLUSTERED INDEX [IX_FK_BackendpoolMember] ON [DynamicOps.VCNSModel].[Members] ([BackendpoolId])
GO

PRINT N'Creating [DynamicOps.VCNSModel].[VCNSEndpoints]'
GO
CREATE TABLE [DynamicOps.VCNSModel].[VCNSEndpoints]
(
[Id] [int] NOT NULL IDENTITY(1, 1),
[ManagementEndpointId] [uniqueidentifier] NOT NULL,
[Address] [nvarchar] (max) COLLATE SQL_Latin1_General_CP1_CI_AS NOT NULL,
[ConnectionCredentialId] [nvarchar] (max) COLLATE SQL_Latin1_General_CP1_CI_AS NOT NULL
)
GO

PRINT N'Creating primary key [PK_VCNSEndpoints] on [DynamicOps.VCNSModel].[VCNSEndpoints]'
GO
ALTER TABLE [DynamicOps.VCNSModel].[VCNSEndpoints] ADD CONSTRAINT [PK_VCNSEndpoints] PRIMARY KEY CLUSTERED  ([Id])
GO

PRINT N'Creating [DynamicOps.VCNSModel].[Datacenters]'
GO
CREATE TABLE [DynamicOps.VCNSModel].[Datacenters]
(
[Id] [int] NOT NULL IDENTITY(1, 1),
[Revision] [int] NOT NULL,
[Name] [nvarchar] (max) COLLATE SQL_Latin1_General_CP1_CI_AS NOT NULL,
[ManagementObjectId] [nvarchar] (max) COLLATE SQL_Latin1_General_CP1_CI_AS NOT NULL,
[Description] [nvarchar] (max) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[VCNSEndpoint_Id] [int] NOT NULL
)
GO

PRINT N'Creating primary key [PK_Datacenters] on [DynamicOps.VCNSModel].[Datacenters]'
GO
ALTER TABLE [DynamicOps.VCNSModel].[Datacenters] ADD CONSTRAINT [PK_Datacenters] PRIMARY KEY CLUSTERED  ([Id])
GO

PRINT N'Creating index [IX_FK_DatacenterVCNSEndpoint] on [DynamicOps.VCNSModel].[Datacenters]'
GO
CREATE NONCLUSTERED INDEX [IX_FK_DatacenterVCNSEndpoint] ON [DynamicOps.VCNSModel].[Datacenters] ([VCNSEndpoint_Id])
GO

PRINT N'Creating [DynamicOps.VCNSModel].[Edges]'
GO
CREATE TABLE [DynamicOps.VCNSModel].[Edges]
(
[Id] [int] NOT NULL IDENTITY(1, 1),
[Name] [nvarchar] (max) COLLATE SQL_Latin1_General_CP1_CI_AS NOT NULL,
[Revision] [int] NOT NULL,
[Description] [nvarchar] (max) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[ManagementObjectId] [nvarchar] (max) COLLATE SQL_Latin1_General_CP1_CI_AS NOT NULL,
[State] [nvarchar] (max) COLLATE SQL_Latin1_General_CP1_CI_AS NOT NULL,
[Datacenter_Id] [int] NOT NULL
)
GO

PRINT N'Creating primary key [PK_Edges] on [DynamicOps.VCNSModel].[Edges]'
GO
ALTER TABLE [DynamicOps.VCNSModel].[Edges] ADD CONSTRAINT [PK_Edges] PRIMARY KEY CLUSTERED  ([Id])
GO

PRINT N'Creating index [IX_FK_EdgeDatacenter] on [DynamicOps.VCNSModel].[Edges]'
GO
CREATE NONCLUSTERED INDEX [IX_FK_EdgeDatacenter] ON [DynamicOps.VCNSModel].[Edges] ([Datacenter_Id])
GO

PRINT N'Creating [DynamicOps.VCNSModel].[SecurityGroups]'
GO
CREATE TABLE [DynamicOps.VCNSModel].[SecurityGroups]
(
[Id] [int] NOT NULL IDENTITY(1, 1),
[Revision] [int] NOT NULL,
[Description] [nvarchar] (max) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[Name] [nvarchar] (max) COLLATE SQL_Latin1_General_CP1_CI_AS NOT NULL,
[ManagementObjectId] [nvarchar] (max) COLLATE SQL_Latin1_General_CP1_CI_AS NOT NULL,
[InheritanceAllowed] [bit] NOT NULL,
[IsHidden] [bit] NOT NULL,
[Datacenter_Id] [int] NOT NULL
)
GO

PRINT N'Creating primary key [PK_SecurityGroups] on [DynamicOps.VCNSModel].[SecurityGroups]'
GO
ALTER TABLE [DynamicOps.VCNSModel].[SecurityGroups] ADD CONSTRAINT [PK_SecurityGroups] PRIMARY KEY CLUSTERED  ([Id])
GO

PRINT N'Creating index [IX_FK_SecurityGroupDatacenter] on [DynamicOps.VCNSModel].[SecurityGroups]'
GO
CREATE NONCLUSTERED INDEX [IX_FK_SecurityGroupDatacenter] ON [DynamicOps.VCNSModel].[SecurityGroups] ([Datacenter_Id])
GO

PRINT N'Creating [DynamicOps.VCNSModel].[SecurityTags]'
GO
CREATE TABLE [DynamicOps.VCNSModel].[SecurityTags]
(
[Id] [int] NOT NULL IDENTITY(1, 1),
[Name] [nvarchar] (max) COLLATE SQL_Latin1_General_CP1_CI_AS NOT NULL,
[Description] [nvarchar] (max) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[ManagementObjectId] [nvarchar] (max) COLLATE SQL_Latin1_General_CP1_CI_AS NOT NULL,
[Revision] [int] NOT NULL,
[VCNSEndpoint_Id] [int] NOT NULL
)
GO

PRINT N'Creating primary key [PK_SecurityTags] on [DynamicOps.VCNSModel].[SecurityTags]'
GO
ALTER TABLE [DynamicOps.VCNSModel].[SecurityTags] ADD CONSTRAINT [PK_SecurityTags] PRIMARY KEY CLUSTERED  ([Id])
GO

PRINT N'Creating index [IX_FK_SecurityTagVCNSEndpoint] on [DynamicOps.VCNSModel].[SecurityTags]'
GO
CREATE NONCLUSTERED INDEX [IX_FK_SecurityTagVCNSEndpoint] ON [DynamicOps.VCNSModel].[SecurityTags] ([VCNSEndpoint_Id])
GO

PRINT N'Refreshing [dbo].[HostBasicView]'
GO
EXEC sp_refreshview N'[dbo].[HostBasicView]'
GO

PRINT N'Refreshing [dbo].[LoggedOnCollectionStatusView]'
GO
EXEC sp_refreshview N'[dbo].[LoggedOnCollectionStatusView]'
GO

PRINT N'Refreshing [dbo].[ReservationStorageSizeView]'
GO
EXEC sp_refreshview N'[dbo].[ReservationStorageSizeView]'
GO

PRINT N'Refreshing [dbo].[ReservationUsedStorageSizeView]'
GO
EXEC sp_refreshview N'[dbo].[ReservationUsedStorageSizeView]'
GO

PRINT N'Refreshing [dbo].[HostReservationEbsVolumeCapacity]'
GO
EXEC sp_refreshview N'[dbo].[HostReservationEbsVolumeCapacity]'
GO

PRINT N'Refreshing [dbo].[HostReservationToStorageStats]'
GO
EXEC sp_refreshview N'[dbo].[HostReservationToStorageStats]'
GO

PRINT N'Refreshing [dbo].[HostReservationStats]'
GO
EXEC sp_refreshview N'[dbo].[HostReservationStats]'
GO

PRINT N'Refreshing [dbo].[uv_VirtualMachineCostView]'
GO
EXEC sp_refreshview N'[dbo].[uv_VirtualMachineCostView]'
GO

PRINT N'Refreshing [dbo].[uv_ProvisioningGroupCostView]'
GO
EXEC sp_refreshview N'[dbo].[uv_ProvisioningGroupCostView]'
GO

PRINT N'Refreshing [dbo].[RequestView]'
GO
EXEC sp_refreshview N'[dbo].[RequestView]'
GO

PRINT N'Refreshing [dbo].[LastLogonUserView]'
GO
EXEC sp_refreshview N'[dbo].[LastLogonUserView]'
GO

PRINT N'Refreshing [dbo].[uv_VirtualMachineView]'
GO
EXEC sp_refreshview N'[dbo].[uv_VirtualMachineView]'
GO

PRINT N'Refreshing [dbo].[VirtualMachineInfoView]'
GO
EXEC sp_refreshview N'[dbo].[VirtualMachineInfoView]'
GO

PRINT N'Refreshing [dbo].[ProvisioningGroupCostSavingsView]'
GO
EXEC sp_refreshview N'[dbo].[ProvisioningGroupCostSavingsView]'
GO

PRINT N'Refreshing [dbo].[VMStorageFromReservation]'
GO
EXEC sp_refreshview N'[dbo].[VMStorageFromReservation]'
GO

PRINT N'Refreshing [dbo].[VMStorageFromDisk]'
GO
EXEC sp_refreshview N'[dbo].[VMStorageFromDisk]'
GO

PRINT N'Refreshing [dbo].[VMStorageMismatch]'
GO
EXEC sp_refreshview N'[dbo].[VMStorageMismatch]'
GO

PRINT N'Refreshing [dbo].[MachineUsageByState]'
GO
EXEC sp_refreshview N'[dbo].[MachineUsageByState]'
GO

PRINT N'Refreshing [dbo].[HostDiscovery]'
GO
EXEC sp_refreshview N'[dbo].[HostDiscovery]'
GO

PRINT N'Refreshing [dbo].[StorageCostByMachineView]'
GO
EXEC sp_refreshview N'[dbo].[StorageCostByMachineView]'
GO

PRINT N'Refreshing [dbo].[BaseMachineCostView]'
GO
EXEC sp_refreshview N'[dbo].[BaseMachineCostView]'
GO

PRINT N'Refreshing [dbo].[MachineCostView]'
GO
EXEC sp_refreshview N'[dbo].[MachineCostView]'
GO

PRINT N'Refreshing [dbo].[TempHostReservationInfo]'
GO
EXEC sp_refreshview N'[dbo].[TempHostReservationInfo]'
GO

PRINT N'Refreshing [dbo].[ChargeBackMachineView]'
GO
EXEC sp_refreshview N'[dbo].[ChargeBackMachineView]'
GO

PRINT N'Refreshing [dbo].[DeletedMachinesCostView]'
GO
EXEC sp_refreshview N'[dbo].[DeletedMachinesCostView]'
GO

PRINT N'Refreshing [dbo].[ManagedHostsView]'
GO
EXEC sp_refreshview N'[dbo].[ManagedHostsView]'
GO

PRINT N'Refreshing [dbo].[ManagedHostsCapacityView]'
GO
EXEC sp_refreshview N'[dbo].[ManagedHostsCapacityView]'
GO

PRINT N'Refreshing [dbo].[ManagedGroupsCapacityView]'
GO
EXEC sp_refreshview N'[dbo].[ManagedGroupsCapacityView]'
GO

PRINT N'Refreshing [dbo].[PhysicalMachineView]'
GO
EXEC sp_refreshview N'[dbo].[PhysicalMachineView]'
GO

PRINT N'Refreshing [dbo].[CloudMachineView]'
GO
EXEC sp_refreshview N'[dbo].[CloudMachineView]'
GO

PRINT N'Refreshing [dbo].[HostReservationCompatView]'
GO
EXEC sp_refreshview N'[dbo].[HostReservationCompatView]'
GO

PRINT N'Refreshing [dbo].[VirtualMachineRequestView]'
GO
EXEC sp_refreshview N'[dbo].[VirtualMachineRequestView]'
GO

PRINT N'Refreshing [dbo].[HostReservationsView]'
GO
EXEC sp_refreshview N'[dbo].[HostReservationsView]'
GO

PRINT N'Refreshing [dbo].[HostReservationCostView]'
GO
EXEC sp_refreshview N'[dbo].[HostReservationCostView]'
GO

PRINT N'Refreshing [dbo].[HostBasicView1]'
GO
EXEC sp_refreshview N'[dbo].[HostBasicView1]'
GO

PRINT N'Refreshing [dbo].[HostCapacityViewInt]'
GO
EXEC sp_refreshview N'[dbo].[HostCapacityViewInt]'
GO

PRINT N'Refreshing [dbo].[ReclaimedVirtualMachineView]'
GO
EXEC sp_refreshview N'[dbo].[ReclaimedVirtualMachineView]'
GO

PRINT N'Refreshing [dbo].[ReservationView]'
GO
EXEC sp_refreshview N'[dbo].[ReservationView]'
GO

PRINT N'Refreshing [dbo].[HostCapacityViewInt1]'
GO
EXEC sp_refreshview N'[dbo].[HostCapacityViewInt1]'
GO

PRINT N'Refreshing [dbo].[ReclaimedVirtualMachineCostView]'
GO
EXEC sp_refreshview N'[dbo].[ReclaimedVirtualMachineCostView]'
GO

PRINT N'Refreshing [dbo].[HostCapacityView]'
GO
EXEC sp_refreshview N'[dbo].[HostCapacityView]'
GO

PRINT N'Refreshing [dbo].[ProvisioningGroupView]'
GO
EXEC sp_refreshview N'[dbo].[ProvisioningGroupView]'
GO

PRINT N'Refreshing [dbo].[DataCollectionStatusViewInt]'
GO
EXEC sp_refreshview N'[dbo].[DataCollectionStatusViewInt]'
GO

PRINT N'Refreshing [dbo].[DataCollectionStatusView]'
GO
EXEC sp_refreshview N'[dbo].[DataCollectionStatusView]'
GO

PRINT N'Refreshing [dbo].[VirtualMachineView]'
GO
EXEC sp_refreshview N'[dbo].[VirtualMachineView]'
GO

PRINT N'Refreshing [dbo].[HostStorageReservationUsedView]'
GO
EXEC sp_refreshview N'[dbo].[HostStorageReservationUsedView]'
GO

PRINT N'Refreshing [dbo].[ReservationInfoView]'
GO
EXEC sp_refreshview N'[dbo].[ReservationInfoView]'
GO

PRINT N'Refreshing [dbo].[EntityProperties]'
GO
EXEC sp_refreshview N'[dbo].[EntityProperties]'
GO

PRINT N'Refreshing [dbo].[HostReservationInfo]'
GO
EXEC sp_refreshview N'[dbo].[HostReservationInfo]'
GO

PRINT N'Refreshing [dbo].[ReservationInfoExView]'
GO
EXEC sp_refreshview N'[dbo].[ReservationInfoExView]'
GO

PRINT N'Refreshing [dbo].[ProvisioningGroupCapacityViewInt]'
GO
EXEC sp_refreshview N'[dbo].[ProvisioningGroupCapacityViewInt]'
GO

PRINT N'Refreshing [dbo].[ProvisioningGroupCapacityViewInt1]'
GO
EXEC sp_refreshview N'[dbo].[ProvisioningGroupCapacityViewInt1]'
GO

PRINT N'Refreshing [dbo].[ProvisioningGroupCapacityView]'
GO
EXEC sp_refreshview N'[dbo].[ProvisioningGroupCapacityView]'
GO

PRINT N'Refreshing [dbo].[HostInterfaceInfo]'
GO
EXEC sp_refreshview N'[dbo].[HostInterfaceInfo]'
GO

PRINT N'Refreshing [dbo].[HostExt]'
GO
EXEC sp_refreshview N'[dbo].[HostExt]'
GO

PRINT N'Altering [dbo].[VirtualMachineExt]'
GO
ALTER VIEW [dbo].[VirtualMachineExt] AS
    SELECT
        v.VirtualMachineID
        ,dbo.GetVirtualMachineUsedStoragePathsSummary(v.VirtualMachineID) StoragePathsSummary
        ,MachineName = NULLIF(v.VirtualMachineName, N'')
        ,[Status]  = 
        CASE
            WHEN v.IsMissing = 1 THEN N'Missing'
            WHEN v.IsManaged = 0 and v.HostReservationID IS NULL THEN N'Unmanaged'
            WHEN v.IsManaged = 0 and v.HostReservationID IS NOT NULL THEN N'Reserved'
            WHEN v.CurrentTask IS NOT NULL THEN v.VirtualMachineState + N' (' + v.CurrentTask + N')'
            ELSE v.VirtualMachineState
        END
        ,MachineType = 
        CASE
            WHEN v.MachineType = 1 THEN N'Physical' 
            WHEN v.MachineType = 2 THEN N'Cloud' 
            WHEN v.MachineType = 3 THEN N'Multi-Machine'
            ELSE N'Virtual'
        END
        ,BlueprintName = t.VirtualMachineTemplateName
        ,UserName = u.UserName
        ,HostName = 
        CASE
            WHEN v.MachineType IN (1,3) THEN NULL
            ELSE he.HostName
        END
        ,GroupName = pg.GroupName
        ,ReservationName = 
        CASE
            WHEN v.MachineType != 3 THEN hr.HostReservationName
            ELSE NULL
        END
        ,EndpointName = 
        CASE
            WHEN v.MachineType = 1 THEN epc.ManagementEndpointName
            ELSE he.EndpointName
        END
        ,EndpointInterfaceType = 
        CASE
            WHEN v.MachineType = 1 THEN epc.InterfaceType
            ELSE he.InterfaceTypeId
        END
        ,InterfaceDisplayName = 
		CASE
            WHEN v.MachineType = 1 THEN it.DisplayName
            ELSE he.InterfaceDisplayName
        END
        ,CostProfileName = cp.CostProfileName
        ,DestructionDate = DATEADD(day, ISNULL(v.ExpireDays, 0), v.Expires)
        ,VMCPUs=
        CASE
            WHEN v.MachineType = 1 THEN pm.ProcessorCount
            WHEN v.MachineType = 3 THEN NULL
            ELSE v.VMCPUs
        END
        ,VMTotalMemoryGB = 
        CASE
            WHEN v.MachineType = 1 THEN CAST(ROUND(CAST(pm.MemoryInMB AS FLOAT)/ 1024, 1) AS REAL)
            WHEN v.MachineType = 3 THEN NULL
            ELSE CAST(ROUND(CAST(ISNULL(v.VMTotalMemoryMB, 0) AS FLOAT)/ 1024, 1) AS REAL)
        END
        ,VMTotalStorageGB = 
        CASE
            WHEN v.MachineType IN (1,3) THEN NULL
            ELSE v.VMTotalStorageGB
        END
        ,OwnerExistsString = 
        CASE
            WHEN v.OwnerExists = 1 THEN N'Yes' ELSE N'No'
        END
        ,IsMissingString = 
        CASE
            WHEN v.IsMissing = 1 THEN N'Yes' ELSE N'No'
        END
    FROM [dbo].VirtualMachine v LEFT OUTER JOIN
         [dbo].VirtualMachineTemplate t ON v.VirtualMachineTemplateID = t.VirtualMachineTemplateID LEFT OUTER JOIN
         [dbo].Users u ON v.[Owner] = u.UserID LEFT OUTER JOIN
         [dbo].HostReservation hr ON v.HostReservationID = hr.HostReservationID LEFT OUTER JOIN
         [dbo].ProvisioningGroup pg ON hr.GroupID = pg.GroupID LEFT OUTER JOIN
         [dbo].PhysicalMachines pm ON v.PhysicalMachineID = pm.PhysicalMachineID LEFT OUTER JOIN
         [dbo].PhysicalControllers pc ON pm.PhysicalController_PhysicalControllerID = pc.PhysicalControllerID LEFT OUTER JOIN
         [dbo].ManagementEndpoints epc ON pc.ManagementEndpoint_ManagementEndpointID = epc.ManagementEndpointID LEFT OUTER JOIN         
         [dbo].InterfaceTypes it ON epc.InterfaceType = it.InterfaceTypeId LEFT OUTER JOIN
         [dbo].HostExt he ON v.HostID = he.HostID LEFT OUTER JOIN
         [dbo].CostProfile cp ON pm.CostProfileID = cp.CostProfileID 
GO

PRINT N'Refreshing [dbo].[VirtualMachineInfo]'
GO
EXEC sp_refreshview N'[dbo].[VirtualMachineInfo]'
GO

PRINT N'Refreshing [dbo].[HostPerDayCostView]'
GO
EXEC sp_refreshview N'[dbo].[HostPerDayCostView]'
GO

PRINT N'Refreshing [dbo].[VirtualMachinePerDayCostView]'
GO
EXEC sp_refreshview N'[dbo].[VirtualMachinePerDayCostView]'
GO

PRINT N'Refreshing [dbo].[UserCapacitySummaryView]'
GO
EXEC sp_refreshview N'[dbo].[UserCapacitySummaryView]'
GO

PRINT N'Refreshing [dbo].[TemplateCapacitySummaryView]'
GO
EXEC sp_refreshview N'[dbo].[TemplateCapacitySummaryView]'
GO

PRINT N'Refreshing [dbo].[RogueVirtualMachineView]'
GO
EXEC sp_refreshview N'[dbo].[RogueVirtualMachineView]'
GO

PRINT N'Refreshing [dbo].[LeaseExtensionView]'
GO
EXEC sp_refreshview N'[dbo].[LeaseExtensionView]'
GO

PRINT N'Refreshing [dbo].[VirtualMachineCostView]'
GO
EXEC sp_refreshview N'[dbo].[VirtualMachineCostView]'
GO

PRINT N'Adding foreign keys to [DynamicOps.VCNSModel].[Members]'
GO
ALTER TABLE [DynamicOps.VCNSModel].[Members] ADD
CONSTRAINT [FK_BackendpoolMember] FOREIGN KEY ([BackendpoolId]) REFERENCES [DynamicOps.VCNSModel].[Backendpools] ([Id]) ON DELETE CASCADE
GO

PRINT N'Adding foreign keys to [DynamicOps.VCNSModel].[Backendpools]'
GO
ALTER TABLE [DynamicOps.VCNSModel].[Backendpools] ADD
CONSTRAINT [FK_BackendpoolLoadBalancer] FOREIGN KEY ([LoadBalancer_Id]) REFERENCES [DynamicOps.VCNSModel].[LoadBalancers] ([Id]) ON DELETE CASCADE
GO

PRINT N'Adding foreign keys to [DynamicOps.VCNSModel].[Edges]'
GO
ALTER TABLE [DynamicOps.VCNSModel].[Edges] ADD
CONSTRAINT [FK_EdgeDatacenter] FOREIGN KEY ([Datacenter_Id]) REFERENCES [DynamicOps.VCNSModel].[Datacenters] ([Id]) ON DELETE CASCADE
GO

PRINT N'Adding foreign keys to [DynamicOps.VCNSModel].[SecurityGroups]'
GO
ALTER TABLE [DynamicOps.VCNSModel].[SecurityGroups] ADD
CONSTRAINT [FK_SecurityGroupDatacenter] FOREIGN KEY ([Datacenter_Id]) REFERENCES [DynamicOps.VCNSModel].[Datacenters] ([Id]) ON DELETE CASCADE
GO

PRINT N'Adding foreign keys to [DynamicOps.VCNSModel].[Datacenters]'
GO
ALTER TABLE [DynamicOps.VCNSModel].[Datacenters] ADD
CONSTRAINT [FK_DatacenterVCNSEndpoint] FOREIGN KEY ([VCNSEndpoint_Id]) REFERENCES [DynamicOps.VCNSModel].[VCNSEndpoints] ([Id]) ON DELETE CASCADE
GO

PRINT N'Adding foreign keys to [DynamicOps.VCNSModel].[LoadBalancers]'
GO
ALTER TABLE [DynamicOps.VCNSModel].[LoadBalancers] ADD
CONSTRAINT [FK_LoadBalancerEdge] FOREIGN KEY ([Edge_Id]) REFERENCES [DynamicOps.VCNSModel].[Edges] ([Id]) ON DELETE CASCADE
GO

PRINT N'Adding foreign keys to [DynamicOps.VCNSModel].[SecurityTags]'
GO
ALTER TABLE [DynamicOps.VCNSModel].[SecurityTags] ADD
CONSTRAINT [FK_SecurityTagVCNSEndpoint] FOREIGN KEY ([VCNSEndpoint_Id]) REFERENCES [DynamicOps.VCNSModel].[VCNSEndpoints] ([Id]) ON DELETE CASCADE
GO

PRINT N'Altering [DynamicOps.VCNSModel].[VCNSEndpoints]'
GO
ALTER TABLE [DynamicOps.VCNSModel].[VCNSEndpoints] ALTER COLUMN [ConnectionCredentialId] [uniqueidentifier] NOT NULL
GO

PRINT N'Creating [dbo].[HostToIso]'
GO
CREATE TABLE [dbo].[HostToIso]
(
[HostToIsoID] [int] NOT NULL IDENTITY(1, 1),
[HostID] [uniqueidentifier] NOT NULL,
[IsoID] [int] NOT NULL
)
GO

PRINT N'Creating primary key [PK__HostToIs__131B3AEC789EE131] on [dbo].[HostToIso]'
GO
ALTER TABLE [dbo].[HostToIso] ADD CONSTRAINT [PK__HostToIs__131B3AEC789EE131] PRIMARY KEY CLUSTERED  ([HostToIsoID])
GO

PRINT N'Creating [dbo].[Iso]'
GO
CREATE TABLE [dbo].[Iso]
(
[IsoID] [int] NOT NULL IDENTITY(1, 1),
[Name] [nvarchar] (256) COLLATE SQL_Latin1_General_CP1_CI_AS NOT NULL,
[Description] [nvarchar] (1000) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[Size] [int] NULL,
[HypervisorType] [nvarchar] (15) COLLATE SQL_Latin1_General_CP1_CI_AS NOT NULL,
[UniqueID] [nvarchar] (256) COLLATE SQL_Latin1_General_CP1_CI_AS NOT NULL
)
GO

PRINT N'Creating primary key [PK__Iso__6FE0442474CE504D] on [dbo].[Iso]'
GO
ALTER TABLE [dbo].[Iso] ADD CONSTRAINT [PK__Iso__6FE0442474CE504D] PRIMARY KEY CLUSTERED  ([IsoID])
GO

PRINT N'Altering [dbo].[HostInterfaceInfo]'
GO
ALTER VIEW [dbo].[HostInterfaceInfo]
AS
	SELECT 
        HostId = h.HostID
        ,InterfaceTypeId = 
            CASE WHEN me.InterfaceType IS NOT NULL THEN me.InterfaceType
                 WHEN [dbo].AgentHasCapability(a.AgentID, N'TestHypervisor') = 1     THEN N'Test'
                 WHEN [dbo].AgentHasCapability(a.AgentID, N'VsphereHypervisor') = 1  THEN N'vSphere'
                 WHEN [dbo].AgentHasCapability(a.AgentID, N'HyperVHypervisor') = 1   THEN N'HyperV'
                 WHEN [dbo].AgentHasCapability(a.AgentID, N'XenHypervisor') = 1      THEN N'CitrixXen'
				 WHEN h.MachineType = 3 THEN N'MultiMachine'
            END
        ,EndpointName = me.ManagementEndpointName            
    FROM [dbo].Host h
        LEFT OUTER JOIN [dbo].Agent a ON h.ProvisioningAgentID = a.AgentID
        LEFT OUTER JOIN [dbo].ManagementEndpoints me ON h.ManagementEndpointID = me.ManagementEndpointID
GO

PRINT N'Refreshing [dbo].[HostExt]'
GO
EXEC sp_refreshview N'[dbo].[HostExt]'
GO

PRINT N'Refreshing [dbo].[VirtualMachineExt]'
GO
EXEC sp_refreshview N'[dbo].[VirtualMachineExt]'
GO

PRINT N'Adding foreign keys to [dbo].[HostToIso]'
GO
ALTER TABLE [dbo].[HostToIso] ADD
CONSTRAINT [FK_HostToIso_ToHost] FOREIGN KEY ([HostID]) REFERENCES [dbo].[Host] ([HostID]) ON DELETE CASCADE,
CONSTRAINT [FK_HostToIso_ToIso] FOREIGN KEY ([IsoID]) REFERENCES [dbo].[Iso] ([IsoID]) ON DELETE CASCADE
GO

PRINT N'Dropping foreign keys from [dbo].[WorkItem]'
GO
ALTER TABLE [dbo].[WorkItem] DROP
CONSTRAINT [DataCollectionStatus_WorkItem]
GO

PRINT N'Adding foreign keys to [dbo].[WorkItem]'
GO
ALTER TABLE [dbo].[WorkItem] ADD
CONSTRAINT [DataCollectionStatus_WorkItem] FOREIGN KEY ([DataCollectionStatusID]) REFERENCES [dbo].[DataCollectionStatus] ([DataCollectionStatusID]) ON DELETE CASCADE
GO

PRINT N'Dropping constraints from [dbo].[VirtualMachineTemplate]'
GO
Exec DropConstraintFromTable N'VirtualMachineTemplate'
GO

PRINT N'Altering [dbo].[VirtualMachineTemplate]'
GO
ALTER TABLE [dbo].[VirtualMachineTemplate] ALTER COLUMN [BlueprintType] [tinyint] NOT NULL
ALTER TABLE [dbo].[VirtualMachineTemplate] ALTER COLUMN [Master] [bit] NOT NULL
ALTER TABLE [dbo].[VirtualMachineTemplate] ALTER COLUMN [IsGlobal] [bit] NOT NULL
ALTER TABLE [dbo].[VirtualMachineTemplate] ALTER COLUMN [IsReconfigureAllowed] [bit] NOT NULL
ALTER TABLE [dbo].[VirtualMachineTemplate] ALTER COLUMN [EnableStoragePolicy] [bit] NOT NULL
ALTER TABLE [dbo].[VirtualMachineTemplate] ALTER COLUMN [IsComponentOnly] [bit] NOT NULL
GO

PRINT N'Altering [dbo].[VMTemplateView]'
GO
ALTER VIEW [dbo].[VMTemplateView]
AS
	SELECT 
		VMT.VirtualMachineTemplateID
		,VMT.VirtualMachineTemplateName
		,VMT.VirtualMachineTemplateDescription
		,VMT.ExpireDays
		,VMT.LeaseDays
		,VMT.Enabled
		,VMT.RequiresApproval
		,VMT.Master
		,VMT.IsGlobal
		,VMT.BlueprintType
		,TG.GlobalProfileID
		,VMT.MemoryMB
		,VMT.MemoryMaxMB
		,VMT.DiskSize0GB
		,VMT.DiskSizeMaxGB
		,VMT.CPUCount
		,VMT.CPUCountMax
		,VMT.MachinePrefix
		,VMT.Cost
		,VMT.MaxVMsPerUser
		,VMT.InheritsFromVMTemplateID
		,G.GroupID
		,G.GroupName
		,G.AdministratorEmail
		,G.IsTestGroup
		,W.WorkflowID
		,W.WorkflowName
		,W.AssemblyFQN
		,W.WorkflowDescription
		,VMT.RecCreationTime
		,VMT.RecDeleteTime
		,VMT.RecUpdateTime
		,VMT.ApprovalPolicyId
		,VMT.LeaseDaysMax
		,VMT.ReservationPolicyID
		,VMT.MachineType
		,VMT.InterfaceTypeId
	FROM VirtualMachineTemplate AS VMT LEFT OUTER JOIN
	GroupToTemplate AS GT ON GT.VirtualMachineTemplateID = VMT.VirtualMachineTemplateID LEFT OUTER JOIN
	TemplateToGlobalProfiles AS TG ON TG.VirtualMachineTemplateID = VMT.VirtualMachineTemplateID LEFT OUTER JOIN
	[ProvisioningGroup] AS G ON G.GroupID = GT.GroupID LEFT OUTER JOIN
	[WorkflowInfo] AS W ON W.WorkflowID = VMT.WorkflowID
GO

PRINT N'Refreshing [dbo].[TemplatesView]'
GO
EXEC sp_refreshview N'[dbo].[TemplatesView]'
GO

PRINT N'Refreshing [dbo].[VirtualMachineRequestView]'
GO
EXEC sp_refreshview N'[dbo].[VirtualMachineRequestView]'
GO

PRINT N'Adding constraints to [dbo].[VirtualMachineTemplate]'
GO
ALTER TABLE [dbo].[VirtualMachineTemplate] ADD CONSTRAINT [DF__VirtualMa__Bluep__07C12930] DEFAULT ((0)) FOR [BlueprintType]
GO

ALTER TABLE [dbo].[VirtualMachineTemplate] ADD CONSTRAINT [DF__VirtualMa__Maste__08B54D69] DEFAULT ((0)) FOR [Master]
GO

ALTER TABLE [dbo].[VirtualMachineTemplate] ADD CONSTRAINT [DF__VirtualMa__IsGlo__09A971A2] DEFAULT ((0)) FOR [IsGlobal]
GO

ALTER TABLE [dbo].[VirtualMachineTemplate] ADD CONSTRAINT [DF__VirtualMa__IsRec__0A9D95DB] DEFAULT ((1)) FOR [IsReconfigureAllowed]
GO

ALTER TABLE [dbo].[VirtualMachineTemplate] ADD CONSTRAINT [DF__VirtualMa__Enabl__0B91BA14] DEFAULT ((0)) FOR [EnableStoragePolicy]
GO

ALTER TABLE [dbo].[VirtualMachineTemplate] ADD CONSTRAINT [DF__VirtualMa__IsCom__0C85DE4D] DEFAULT ((0)) FOR [IsComponentOnly]
GO

PRINT N'Dropping foreign keys from [dbo].[MachineOperationVirtualMachine]'
GO
ALTER TABLE [dbo].[MachineOperationVirtualMachine] DROP
CONSTRAINT [FK_MachineOperationVirtualMachine_MachineOperation],
CONSTRAINT [FK_MachineOperationVirtualMachine_VirtualMachine]
GO

PRINT N'Dropping constraints from [dbo].[MachineOperationVirtualMachine]'
GO
ALTER TABLE [dbo].[MachineOperationVirtualMachine] DROP CONSTRAINT [PK_MachineOperationVirtualMachine]
GO

PRINT N'Dropping index [IX_FK_MachineOperationVirtualMachine_VirtualMachine] from [dbo].[MachineOperationVirtualMachine]'
GO
DROP INDEX [IX_FK_MachineOperationVirtualMachine_VirtualMachine] ON [dbo].[MachineOperationVirtualMachine]
GO

PRINT N'Dropping [dbo].[MachineOperationVirtualMachine]'
GO
DROP TABLE [dbo].[MachineOperationVirtualMachine]
GO


PRINT N'Refreshing [dbo].[HostStorageReservationView]'
GO
EXEC sp_refreshview N'[dbo].[HostStorageReservationView]'
GO

PRINT N'Refreshing [dbo].[RequestLastAction]'
GO
EXEC sp_refreshview N'[dbo].[RequestLastAction]'
GO

PRINT N'Altering [dbo].[Host]'
GO
ALTER TABLE [dbo].[Host] ADD
[IsTpmEnabled] [bit] NULL
GO

PRINT N'Refreshing [dbo].[uv_ProvisioningGroupCostView]'
GO
EXEC sp_refreshview N'[dbo].[uv_ProvisioningGroupCostView]'
GO

PRINT N'Refreshing [dbo].[ManagedHostsView]'
GO
EXEC sp_refreshview N'[dbo].[ManagedHostsView]'
GO

PRINT N'Refreshing [dbo].[HostBasicView1]'
GO
EXEC sp_refreshview N'[dbo].[HostBasicView1]'
GO

PRINT N'Refreshing [dbo].[ReclaimedVirtualMachineView]'
GO
EXEC sp_refreshview N'[dbo].[ReclaimedVirtualMachineView]'
GO

PRINT N'Refreshing [dbo].[ReclaimedVirtualMachineCostView]'
GO
EXEC sp_refreshview N'[dbo].[ReclaimedVirtualMachineCostView]'
GO

PRINT N'Refreshing [dbo].[DataCollectionStatusViewInt]'
GO
EXEC sp_refreshview N'[dbo].[DataCollectionStatusViewInt]'
GO

PRINT N'Refreshing [dbo].[DataCollectionStatusView]'
GO
EXEC sp_refreshview N'[dbo].[DataCollectionStatusView]'
GO

PRINT N'Refreshing [dbo].[LoggedOnCollectionStatusView]'
GO
EXEC sp_refreshview N'[dbo].[LoggedOnCollectionStatusView]'
GO

PRINT N'Refreshing [dbo].[HostStorageReservationUsedView]'
GO
EXEC sp_refreshview N'[dbo].[HostStorageReservationUsedView]'
GO

PRINT N'Refreshing [dbo].[ReservationStorageSizeView]'
GO
EXEC sp_refreshview N'[dbo].[ReservationStorageSizeView]'
GO

PRINT N'Refreshing [dbo].[ReservationUsedStorageSizeView]'
GO
EXEC sp_refreshview N'[dbo].[ReservationUsedStorageSizeView]'
GO

PRINT N'Refreshing [dbo].[HostReservationEbsVolumeCapacity]'
GO
EXEC sp_refreshview N'[dbo].[HostReservationEbsVolumeCapacity]'
GO

PRINT N'Refreshing [dbo].[HostReservationToStorageStats]'
GO
EXEC sp_refreshview N'[dbo].[HostReservationToStorageStats]'
GO

PRINT N'Refreshing [dbo].[HostReservationStats]'
GO
EXEC sp_refreshview N'[dbo].[HostReservationStats]'
GO

PRINT N'Refreshing [dbo].[uv_VirtualMachineCostView]'
GO
EXEC sp_refreshview N'[dbo].[uv_VirtualMachineCostView]'
GO

PRINT N'Refreshing [dbo].[RequestView]'
GO
EXEC sp_refreshview N'[dbo].[RequestView]'
GO

PRINT N'Refreshing [dbo].[LastLogonUserView]'
GO
EXEC sp_refreshview N'[dbo].[LastLogonUserView]'
GO

PRINT N'Refreshing [dbo].[uv_VirtualMachineView]'
GO
EXEC sp_refreshview N'[dbo].[uv_VirtualMachineView]'
GO

PRINT N'Refreshing [dbo].[VirtualMachineInfoView]'
GO
EXEC sp_refreshview N'[dbo].[VirtualMachineInfoView]'
GO

PRINT N'Refreshing [dbo].[ProvisioningGroupCostSavingsView]'
GO
EXEC sp_refreshview N'[dbo].[ProvisioningGroupCostSavingsView]'
GO

PRINT N'Refreshing [dbo].[VMStorageFromReservation]'
GO
EXEC sp_refreshview N'[dbo].[VMStorageFromReservation]'
GO

PRINT N'Refreshing [dbo].[VMStorageFromDisk]'
GO
EXEC sp_refreshview N'[dbo].[VMStorageFromDisk]'
GO

PRINT N'Refreshing [dbo].[VMStorageMismatch]'
GO
EXEC sp_refreshview N'[dbo].[VMStorageMismatch]'
GO

PRINT N'Refreshing [dbo].[MachineUsageByState]'
GO
EXEC sp_refreshview N'[dbo].[MachineUsageByState]'
GO

PRINT N'Refreshing [dbo].[HostDiscovery]'
GO
EXEC sp_refreshview N'[dbo].[HostDiscovery]'
GO

PRINT N'Refreshing [dbo].[StorageCostByMachineView]'
GO
EXEC sp_refreshview N'[dbo].[StorageCostByMachineView]'
GO

PRINT N'Refreshing [dbo].[BaseMachineCostView]'
GO
EXEC sp_refreshview N'[dbo].[BaseMachineCostView]'
GO

PRINT N'Refreshing [dbo].[MachineCostView]'
GO
EXEC sp_refreshview N'[dbo].[MachineCostView]'
GO

PRINT N'Refreshing [dbo].[TempHostReservationInfo]'
GO
EXEC sp_refreshview N'[dbo].[TempHostReservationInfo]'
GO

PRINT N'Refreshing [dbo].[ChargeBackMachineView]'
GO
EXEC sp_refreshview N'[dbo].[ChargeBackMachineView]'
GO

PRINT N'Refreshing [dbo].[DeletedMachinesCostView]'
GO
EXEC sp_refreshview N'[dbo].[DeletedMachinesCostView]'
GO

PRINT N'Refreshing [dbo].[ManagedGroupsCapacityView]'
GO
EXEC sp_refreshview N'[dbo].[ManagedGroupsCapacityView]'
GO

PRINT N'Refreshing [dbo].[PhysicalMachineView]'
GO
EXEC sp_refreshview N'[dbo].[PhysicalMachineView]'
GO

PRINT N'Refreshing [dbo].[CloudMachineView]'
GO
EXEC sp_refreshview N'[dbo].[CloudMachineView]'
GO

PRINT N'Refreshing [dbo].[HostReservationCompatView]'
GO
EXEC sp_refreshview N'[dbo].[HostReservationCompatView]'
GO

PRINT N'Refreshing [dbo].[VirtualMachineRequestView]'
GO
EXEC sp_refreshview N'[dbo].[VirtualMachineRequestView]'
GO

PRINT N'Refreshing [dbo].[HostReservationsView]'
GO
EXEC sp_refreshview N'[dbo].[HostReservationsView]'
GO

PRINT N'Altering [dbo].[usp_InsertUpdateHost]'
GO

ALTER PROCEDURE [dbo].[usp_InsertUpdateHost] 
	@HostID uniqueidentifier
	,@ClusterHostID uniqueidentifier
	,@PhysicalLocationID uniqueidentifier
	,@CostProfileID uniqueidentifier
	,@ManagementEndpointID uniqueidentifier
	,@HostName nvarchar(256)
	,@HostStateID tinyint
	,@HostComments nvarchar(2048) = NULL 
	,@HostOSType NVARCHAR(256) = NULL
	,@HostManufacturer NVARCHAR(256) = NULL
	,@HostModel NVARCHAR(256) = NULL
	,@HostUniqueID nvarchar(256) = NULL
	,@IsCluster bit = NULL
	,@HostProcessors integer = NULL
	,@HostProcessorSpeed integer = NULL
	,@HostProcessorType nvarchar(256) = NULL
	,@RecCreationTime datetime = NULL
	,@RecDeleteTime datetime = NULL
	,@RecUpdateTime datetime = NULL
	,@HostTotalMemoryMB bigint = NULL
	,@HostTotalStorageGB bigint = NULL
	,@HostUsedMemoryMB bigint = NULL
	,@HostUsedStorageGB bigint = NULL
	,@ProvisioningAgentID uniqueidentifier = NULL
	,@EnterpriseAdminGroupID uniqueidentifier = NULL
	,@HostDNSName nvarchar(256) = NULL
	,@IsVRMManaged bit = NULL
	,@MachineType tinyint = 0
	,@HostUuid nvarchar(256) = NULL
	,@AllocationType tinyint = NULL
	,@IsTpmEnabled bit = NULL
AS
BEGIN
	SET NOCOUNT OFF;
	--BEGIN TRANSACTION;
	UPDATE [Host]
	SET 
		ClusterHostID = @ClusterHostID
		,PhysicalLocationID = @PhysicalLocationID
		,CostProfileID = @CostProfileID
		,ManagementEndpointID = @ManagementEndpointID
		,HostName = @HostName
		,HostComments = @HostComments
		,HostOSType = @HostOSType
		,HostManufacturer = @HostManufacturer
		,HostModel = @HostModel
		,HostUniqueID = @HostUniqueID
		,IsCluster = @IsCluster
		,HostProcessors = @HostProcessors
		,HostProcessorSpeed = @HostProcessorSpeed
		,HostProcessorType = @HostProcessorType
--		,RecCreationTime = @RecCreationTime
--		,RecDeleteTime = @RecDeleteTime
		,RecUpdateTime = GETDATE()
		,HostStateID = @HostStateID
		,HostTotalMemoryMB = @HostTotalMemoryMB
		,HostTotalStorageGB = @HostTotalStorageGB
		,HostUsedMemoryMB = @HostUsedMemoryMB
		,HostUsedStorageGB = @HostUsedStorageGB
		,ProvisioningAgentID = @ProvisioningAgentID
		,HostDNSName = @HostDNSName
		,IsVRMManaged = @IsVRMManaged
		,MachineType = @MachineType
		,HostUuid = @HostUuid
		,AllocationType = @AllocationType
		,IsTpmEnabled = @IsTpmEnabled
	WHERE 
		HostID = @HostID
		
	IF @@ROWCOUNT = 0 
		INSERT INTO [Host]
		(HostID
		,ClusterHostID
		,PhysicalLocationID
		,CostProfileID
		,ManagementEndpointID
		,HostName
		,HostComments
		,HostOSType
		,HostManufacturer
		,HostModel
		,HostUniqueID
		,IsCluster
		,HostProcessors
		,HostProcessorSpeed
		,HostProcessorType
		,RecCreationTime
--		,RecDeleteTime
--		,RecUpdateTime
		,HostStateID
		,HostTotalMemoryMB
		,HostTotalStorageGB
		,HostUsedMemoryMB
		,HostUsedStorageGB
		,ProvisioningAgentID
		,HostDNSName
		,IsVRMManaged
		,MachineType
		,HostUuid
		,AllocationType
		,IsTpmEnabled)
	 VALUES
		(@HostID
		,@ClusterHostID
		,@PhysicalLocationID
		,@CostProfileID
		,@ManagementEndpointID
		,@HostName
		,@HostComments
		,@HostOSType
		,@HostManufacturer
		,@HostModel
		,@HostUniqueID
		,@IsCluster
		,@HostProcessors
		,@HostProcessorSpeed
		,@HostProcessorType
		,GETDATE()
--		,@RecDeleteTime
--		,@RecUpdateTime
		,@HostStateID
		,@HostTotalMemoryMB
		,@HostTotalStorageGB
		,@HostUsedMemoryMB
		,@HostUsedStorageGB
		,@ProvisioningAgentID
		,@HostDNSName
		,@IsVRMManaged
		,@MachineType
		,@HostUuid
		,@AllocationType
		,@IsTpmEnabled)
	
	SELECT EnterpriseAdminID From EnterpriseAdminGroups WHERE EnterpriseAdminID = @EnterpriseAdminGroupID
	if @@ROWCOUNT = 1  
	BEGIN
		SELECT HostID From AdminGroupToHost WHERE EnterpriseAdminID = @EnterpriseAdminGroupID AND HostID = @HostID
		if @@ROWCOUNT = 0  
			INSERT INTO AdminGroupToHost(HostID, EnterpriseAdminID) VALUES(@HostID, @EnterpriseAdminGroupID)
	END
	--COMMIT TRANSACTION;
END
GO

PRINT N'Refreshing [dbo].[ManagedHostsCapacityView]'
GO
EXEC sp_refreshview N'[dbo].[ManagedHostsCapacityView]'
GO

PRINT N'Altering [dbo].[HostBasicView]'
GO
ALTER VIEW [dbo].[HostBasicView]
AS
	SELECT 
		Host.HostID
		,ClusterHostID
		,Host.PhysicalLocationID
		,Host.CostProfileID
		,Host.ManagementEndpointID
		,HostName
		,HostComments
		,HostOSType
		,HostManufacturer
		,HostModel
		,HostUniqueID
		,IsCluster
		,HostProcessors
		,HostProcessorSpeed
		,HostProcessorType
		,RecCreationTime
		,RecDeleteTime
		,RecUpdateTime
		,HostStateID
		,HostTotalMemoryMB
		,v1.HostUsedMemoryMB
		,v1.HostUsedStorageGB 
		,HostUsedFlCloneStorageGB  
		,HostTotalStorageGB
		,ProvisioningAgentID
		,(SELECT TOP 1 EnterpriseAdminID FROM AdminGroupToHost a WHERE a.HostID = Host.HostID) EnterpriseAdminGroupID         
		,dbo.GetEnterpriseAdminNamesForHost(Host.HostID) EnterpriseAdminGroups
		,CostProfileName
		,AgentName
		,AgentAlive
		,PhysicalLocationName        
		,NumOfVMsCreated  
		,NumOfVMsNonMissing
		,NumOfVMsManagedMissing
		,NumOfVMsCreatedHasReservation  
		,NumOfVMsUnregistered
		,(SELECT COUNT(r.HostReservationID) From HostReservation r WHERE r.HostID = Host.HostID) NumOfHostReservations
		,IsVRMManaged
		,HostDNSName
		,HostUuid
		,AllocationType 
		,IsTpmEnabled
	FROM [Host] LEFT OUTER JOIN 
		Agent ON Agent.AgentID = Host.ProvisioningAgentID LEFT OUTER JOIN
		CostProfile ON CostProfile.CostProfileID = Host.CostProfileID LEFT OUTER JOIN
		PhysicalLocation ON PhysicalLocation.PhysicalLocationID = Host.PhysicalLocationID
	LEFT OUTER JOIN
	(
		SELECT
				v.HostID
			,	SUM(CASE WHEN v.IsRunning = 1 THEN v.VMTotalMemoryMB END) AS HostUsedMemoryMB
			,	SUM(v.VMTotalStorageGB) AS HostUsedStorageGB
			,	SUM(v.VMUsedStorageGB) AS HostUsedFlCloneStorageGB
			,	SUM(CASE WHEN 
					v.IsTemplate = 0 and (v.IsMissing = 0 or v.VirtualMachineTemplateID is not null) 
					THEN 1 ELSE 0 END) AS NumOfVMsCreated
			,	SUM(CASE WHEN 
					v.IsTemplate = 0 and v.IsMissing = 0
					THEN 1 ELSE 0 END) AS NumOfVMsNonMissing
			,	SUM(CASE WHEN 
					v.IsTemplate = 0 and v.IsMissing = 1 and v.VirtualMachineTemplateID is not null
					THEN 1 ELSE 0 END) AS NumOfVMsManagedMissing
			,	SUM(CASE WHEN 
					v.HostReservationID is not null AND v.IsTemplate = 0
					THEN 1 ELSE 0 END) AS NumOfVMsCreatedHasReservation
			,	SUM(CASE WHEN 
					v.VirtualMachineTemplateID is null AND v.IsTemplate = 0 and v.IsMissing = 0
					THEN 1 ELSE 0 END) AS NumOfVMsUnregistered
		FROM VirtualMachine v
		GROUP BY v.HostID
	) v1 ON  v1.HostID = Host.HostID
GO

PRINT N'Refreshing [dbo].[HostReservationCostView]'
GO
EXEC sp_refreshview N'[dbo].[HostReservationCostView]'
GO

PRINT N'Refreshing [dbo].[HostCapacityViewInt]'
GO
EXEC sp_refreshview N'[dbo].[HostCapacityViewInt]'
GO

PRINT N'Refreshing [dbo].[ReservationView]'
GO
EXEC sp_refreshview N'[dbo].[ReservationView]'
GO

PRINT N'Refreshing [dbo].[HostCapacityViewInt1]'
GO
EXEC sp_refreshview N'[dbo].[HostCapacityViewInt1]'
GO

PRINT N'Refreshing [dbo].[HostCapacityView]'
GO
EXEC sp_refreshview N'[dbo].[HostCapacityView]'
GO

PRINT N'Refreshing [dbo].[ProvisioningGroupView]'
GO
EXEC sp_refreshview N'[dbo].[ProvisioningGroupView]'
GO

PRINT N'Refreshing [dbo].[VirtualMachineView]'
GO
EXEC sp_refreshview N'[dbo].[VirtualMachineView]'
GO

PRINT N'Refreshing [dbo].[ReservationInfoView]'
GO
EXEC sp_refreshview N'[dbo].[ReservationInfoView]'
GO

PRINT N'Refreshing [dbo].[EntityProperties]'
GO
EXEC sp_refreshview N'[dbo].[EntityProperties]'
GO

PRINT N'Refreshing [dbo].[HostReservationInfo]'
GO
EXEC sp_refreshview N'[dbo].[HostReservationInfo]'
GO

PRINT N'Refreshing [dbo].[ReservationInfoExView]'
GO
EXEC sp_refreshview N'[dbo].[ReservationInfoExView]'
GO

PRINT N'Altering [dbo].[usp_GetAvailableReservations]'
GO
ALTER PROCEDURE [dbo].[usp_GetAvailableReservations] 
	@VirtualMachineID uniqueidentifier,
	@GroupID uniqueidentifier,
	@VMDiskSize int,
	@VMCpuCount int,
	@ReservationPolicyID uniqueidentifier,
	@UserLocation nvarchar(256),
	@RequestedAllocationType tinyint = null
AS
BEGIN
	-- The following pertains to allocating virtual machine reservations.
	DECLARE @RuntimeReservationPolicyID uniqueidentifier
	SELECT @RuntimeReservationPolicyID = PropertyValue FROM VirtualMachineProperties
	WHERE PropertyName =N'__reservationPolicyID' AND EntityID = @VirtualMachineID
	
	IF (@RuntimeReservationPolicyID IS NOT NULL)
	BEGIN
		SET @ReservationPolicyID = @RuntimeReservationPolicyID;
	END
	
	DECLARE @DataCenterPolicy NVARCHAR(255)
	SELECT	@DataCenterPolicy = vmp.PropertyValue
	FROM	VirtualMachineProperties vmp
	WHERE	vmp.EntityID = @VirtualMachineID
	AND		vmp.PropertyName = N'VRM.Datacenter.Policy'
	
	DECLARE @IsTpmEnabled BIT
	SELECT	@IsTpmEnabled = vmp.PropertyValue
	FROM	VirtualMachineProperties vmp
	WHERE	vmp.EntityID = @VirtualMachineID
	AND		vmp.PropertyName = N'VirtualMachine.Host.TpmEnabled'
	-- reservation selection, filtered by group, active hosts, enabled, with aggregate storage
	-- sorted by best reservation, ordered by location, priority, then utiliztion ratio
	SELECT	hrl.HostReservationID
	FROM	HostReservation			hrl with (updlock)  -- force locking to execute on primary key
	JOIN	HostReservation			hr	ON hrl.HostReservationID = hr.HostReservationID
	JOIN	Host					h	ON hr.HostID = h.HostID
	LEFT JOIN HostProperties		hpl	on h.HostID = hpl.EntityID
										and hpl.PropertyName = N'Vrm.DataCenter.Location'
	LEFT JOIN HostReservationStats hrst on hr.HostReservationID = hrst.HostReservationID
	-- aggregate storage check								
	JOIN
	(
			SELECT	hrs.HostReservationID,
					SUM(hrs.MaxCapacity - hrss.StorageAllocated) AS AllocatedStorageAvailable,
					SUM(StorageFreeCapacityGB) AS PhysicalStorageAvailable
			FROM	HostReservationToStorage hrs
			JOIN	HostToStorage hs	on hrs.HostToStorageID = hs.HostToStorageID
										AND hs.Flags = 0
			JOIN	Storage s on hs.StorageID = s.StorageID			
			JOIN	HostReservationToStorageStats hrss	ON hrs.HostReservationToStorageID = hrss.HostReservationToStorageID
			WHERE	hrs.[Enabled] = 1
			GROUP BY hrs.HostReservationID
	) hrsst ON	hr.HostReservationID = hrsst.HostReservationID									
	WHERE	hr.GroupID = @GroupID 	-- Eliminate reservations not in the template group
	AND		h.HostStateID = 0		-- Only include active hosts
	AND		hr.[Enabled] = 1		-- Only include enabled reservations
	AND		(@ReservationPolicyID is null or hr.ReservationPolicyID = @ReservationPolicyID)
	-- data center location and policy check, by default uses the exact match
	AND		(@UserLocation IS NULL OR ISNULL(NULLIF(@DataCenterPolicy,N''), N'Exact') <> N'Exact' OR hpl.PropertyValue = @UserLocation)
	AND		(@IsTpmEnabled IS NULL OR @IsTpmEnabled = 0 OR h.IsTpmEnabled = 1) -- Only include hosts with trust hardware installed
	AND		(hrsst.AllocatedStorageAvailable >= @VMDiskSize OR (h.AllocationType = 2 AND hrsst.AllocatedStorageAvailable = 0)) -- Only include reservations with disk space free
	AND		(hrsst.PhysicalStorageAvailable >= @VMDiskSize OR h.AllocationType = 2) -- Only include where physical storage is greater than VM size
	-- placement preference for vCD (0 = indifferent, 1 = Non-PAYG only, 2 = PAYG only)
	AND		(@RequestedAllocationType IS NULL OR ((h.AllocationType = 2 OR NOT @RequestedAllocationType = 2) AND (NOT h.AllocationType = 2 OR NOT @RequestedAllocationType = 1)))
	ORDER BY
		-- location matches first, then by priority, then my allocation percentage
		CASE 
			WHEN @UserLocation = hpl.PropertyValue THEN 0
			ELSE 1
		END,
		hr.ReservationPriority, 
		CASE 
			WHEN hr.MaxVMsPowerOn = 0 AND hrst.MachinesAllocated = 0 THEN (-1)
			WHEN hr.MaxVMsPowerOn = 0 AND hrst.MachinesAllocated <> 0 THEN 1 - (CAST(1 AS FLOAT))/hrst.MachinesAllocated
			ELSE 1 + (CAST(hrst.MachinesAllocated AS FLOAT)) / hr.MaxVMsPowerOn 
		END
END
GO

PRINT N'Refreshing [dbo].[ProvisioningGroupCapacityViewInt]'
GO
EXEC sp_refreshview N'[dbo].[ProvisioningGroupCapacityViewInt]'
GO

PRINT N'Refreshing [dbo].[ProvisioningGroupCapacityViewInt1]'
GO
EXEC sp_refreshview N'[dbo].[ProvisioningGroupCapacityViewInt1]'
GO

PRINT N'Refreshing [dbo].[ProvisioningGroupCapacityView]'
GO
EXEC sp_refreshview N'[dbo].[ProvisioningGroupCapacityView]'
GO

PRINT N'Refreshing [dbo].[HostInterfaceInfo]'
GO
EXEC sp_refreshview N'[dbo].[HostInterfaceInfo]'
GO

PRINT N'Refreshing [dbo].[HostExt]'
GO
EXEC sp_refreshview N'[dbo].[HostExt]'
GO

PRINT N'Refreshing [dbo].[VirtualMachineExt]'
GO
EXEC sp_refreshview N'[dbo].[VirtualMachineExt]'
GO

PRINT N'Refreshing [dbo].[VirtualMachineInfo]'
GO
EXEC sp_refreshview N'[dbo].[VirtualMachineInfo]'
GO

PRINT N'Refreshing [dbo].[HostPerDayCostView]'
GO
EXEC sp_refreshview N'[dbo].[HostPerDayCostView]'
GO

PRINT N'Refreshing [dbo].[UserCapacitySummaryView]'
GO
EXEC sp_refreshview N'[dbo].[UserCapacitySummaryView]'
GO

PRINT N'Refreshing [dbo].[TemplateCapacitySummaryView]'
GO
EXEC sp_refreshview N'[dbo].[TemplateCapacitySummaryView]'
GO

PRINT N'Refreshing [dbo].[RogueVirtualMachineView]'
GO
EXEC sp_refreshview N'[dbo].[RogueVirtualMachineView]'
GO

PRINT N'Refreshing [dbo].[LeaseExtensionView]'
GO
EXEC sp_refreshview N'[dbo].[LeaseExtensionView]'
GO

PRINT N'Refreshing [dbo].[VirtualMachinePerDayCostView]'
GO
EXEC sp_refreshview N'[dbo].[VirtualMachinePerDayCostView]'
GO

PRINT N'Refreshing [dbo].[VirtualMachineCostView]'
GO
EXEC sp_refreshview N'[dbo].[VirtualMachineCostView]'
GO

PRINT N'Creating extended properties'
GO
EXEC sp_addextendedproperty N'MS_Description', N'Indicates if the host (or every host in the cluster) has a TPM device installed', 'SCHEMA', N'dbo', 'TABLE', N'Host', 'COLUMN', N'IsTpmEnabled'
GO

PRINT N'Creating schemata'
GO
CREATE SCHEMA [DynamicOps.WorkQueueModel]
AUTHORIZATION [dbo]
GO

PRINT N'Creating [DynamicOps.WorkQueueModel].[WorkQueueElementProperties]'
GO
CREATE TABLE [DynamicOps.WorkQueueModel].[WorkQueueElementProperties]
(
[Id] [int] NOT NULL IDENTITY(1, 1),
[Name] [nvarchar] (256) COLLATE SQL_Latin1_General_CP1_CI_AS NOT NULL,
[Value] [nvarchar] (256) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[IsHidden] [bit] NOT NULL,
[IsRuntime] [bit] NOT NULL,
[IsEncrypted] [bit] NOT NULL,
[WorkQueueElementId] [int] NOT NULL
)
GO

PRINT N'Creating primary key [PK_WorkQueueElementProperties] on [DynamicOps.WorkQueueModel].[WorkQueueElementProperties]'
GO
ALTER TABLE [DynamicOps.WorkQueueModel].[WorkQueueElementProperties] ADD CONSTRAINT [PK_WorkQueueElementProperties] PRIMARY KEY CLUSTERED  ([Id])
GO

PRINT N'Creating index [IX_WorkQueueElementPropertiesName] on [DynamicOps.WorkQueueModel].[WorkQueueElementProperties]'
GO
CREATE NONCLUSTERED INDEX [IX_WorkQueueElementPropertiesName] ON [DynamicOps.WorkQueueModel].[WorkQueueElementProperties] ([Name])
GO

PRINT N'Creating index [IX_FK_WorkQueueElementWorkQueueElementProperty] on [DynamicOps.WorkQueueModel].[WorkQueueElementProperties]'
GO
CREATE NONCLUSTERED INDEX [IX_FK_WorkQueueElementWorkQueueElementProperty] ON [DynamicOps.WorkQueueModel].[WorkQueueElementProperties] ([WorkQueueElementId])
GO

PRINT N'Creating [dbo].[GetWorkQueueElementProperty]'
GO
SET QUOTED_IDENTIFIER OFF
GO
CREATE FUNCTION [dbo].[GetWorkQueueElementProperty] (@id int, @name nvarchar(256))
       RETURNS nvarchar(256) 
       AS
       BEGIN
              DECLARE @value nvarchar(256) 
              SELECT @value = Value
              FROM [DynamicOps.WorkQueueModel].WorkQueueElementProperties
              WHERE WorkQueueElementId = @id AND Name = @name
              RETURN @value
       END
GO

PRINT N'Creating [DynamicOps.WorkQueueModel].[WorkQueueElements]'
GO
SET QUOTED_IDENTIFIER ON
GO
CREATE TABLE [DynamicOps.WorkQueueModel].[WorkQueueElements]
(
[Id] [int] NOT NULL IDENTITY(1, 1),
[EntityId] [nvarchar] (256) COLLATE SQL_Latin1_General_CP1_CI_AS NOT NULL,
[Status] [nvarchar] (256) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[Priority] [int] NOT NULL,
[WorkQueueId] [int] NOT NULL,
[TimeStamp] [datetime] NOT NULL
)
GO

PRINT N'Creating primary key [PK_WorkQueueElements] on [DynamicOps.WorkQueueModel].[WorkQueueElements]'
ALTER TABLE [DynamicOps.WorkQueueModel].[WorkQueueElements] ADD CONSTRAINT [PK_WorkQueueElements] PRIMARY KEY CLUSTERED  ([Id])
GO

PRINT N'Creating index [IX_WorkQueueElementsEntityId] on [DynamicOps.WorkQueueModel].[WorkQueueElements]'
GO
CREATE NONCLUSTERED INDEX [IX_WorkQueueElementsEntityId] ON [DynamicOps.WorkQueueModel].[WorkQueueElements] ([EntityId])
GO

PRINT N'Creating index [IX_FK_WorkQueueWorkQueueElement] on [DynamicOps.WorkQueueModel].[WorkQueueElements]'
GO
CREATE NONCLUSTERED INDEX [IX_FK_WorkQueueWorkQueueElement] ON [DynamicOps.WorkQueueModel].[WorkQueueElements] ([WorkQueueId])
GO

PRINT N'Creating [DynamicOps.WorkQueueModel].[WorkQueueTypes]'
GO
CREATE TABLE [DynamicOps.WorkQueueModel].[WorkQueueTypes]
(
[Id] [int] NOT NULL,
[Name] [nvarchar] (256) COLLATE SQL_Latin1_General_CP1_CI_AS NOT NULL,
[Description] [nvarchar] (256) COLLATE SQL_Latin1_General_CP1_CI_AS NULL
)
GO

PRINT N'Creating primary key [PK_WorkQueueTypes] on [DynamicOps.WorkQueueModel].[WorkQueueTypes]'
GO
ALTER TABLE [DynamicOps.WorkQueueModel].[WorkQueueTypes] ADD CONSTRAINT [PK_WorkQueueTypes] PRIMARY KEY CLUSTERED  ([Id])
GO

PRINT N'Creating [DynamicOps.WorkQueueModel].[WorkQueues]'
GO
CREATE TABLE [DynamicOps.WorkQueueModel].[WorkQueues]
(
[Id] [int] NOT NULL IDENTITY(1, 1),
[Name] [nvarchar] (256) COLLATE SQL_Latin1_General_CP1_CI_AS NOT NULL,
[Description] [nvarchar] (256) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[EntityType] [nvarchar] (256) COLLATE SQL_Latin1_General_CP1_CI_AS NOT NULL,
[Priority] [int] NOT NULL,
[Subtype] [nvarchar] (256) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[WorkQueueTypeId] [int] NOT NULL,
[Status] [nvarchar] (256) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[TotalNumber] [int] NOT NULL,
[RemainingNumber] [int] NOT NULL,
[TimeStamp] [datetime] NOT NULL
)
GO

PRINT N'Creating primary key [PK_WorkQueues] on [DynamicOps.WorkQueueModel].[WorkQueues]'
GO
ALTER TABLE [DynamicOps.WorkQueueModel].[WorkQueues] ADD CONSTRAINT [PK_WorkQueues] PRIMARY KEY CLUSTERED  ([Id])
GO

PRINT N'Creating index [IX_WorkQueueName] on [DynamicOps.WorkQueueModel].[WorkQueues]'
GO
CREATE NONCLUSTERED INDEX [IX_WorkQueueName] ON [DynamicOps.WorkQueueModel].[WorkQueues] ([Name])
GO

PRINT N'Creating index [IX_FK_WorkQueueTypeWorkQueue] on [DynamicOps.WorkQueueModel].[WorkQueues]'
GO
CREATE NONCLUSTERED INDEX [IX_FK_WorkQueueTypeWorkQueue] ON [DynamicOps.WorkQueueModel].[WorkQueues] ([WorkQueueTypeId])
GO

PRINT N'Creating [DynamicOps.WorkQueueModel].[WorkQueueProperties]'
GO
CREATE TABLE [DynamicOps.WorkQueueModel].[WorkQueueProperties]
(
[Id] [int] NOT NULL IDENTITY(1, 1),
[Name] [nvarchar] (256) COLLATE SQL_Latin1_General_CP1_CI_AS NOT NULL,
[Value] [nvarchar] (256) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[IsHidden] [bit] NOT NULL,
[IsRuntime] [bit] NOT NULL,
[IsEncrypted] [bit] NOT NULL,
[WorkQueueId] [int] NOT NULL
)
GO

PRINT N'Creating primary key [PK_WorkQueueProperties] on [DynamicOps.WorkQueueModel].[WorkQueueProperties]'
GO
ALTER TABLE [DynamicOps.WorkQueueModel].[WorkQueueProperties] ADD CONSTRAINT [PK_WorkQueueProperties] PRIMARY KEY CLUSTERED  ([Id])
GO

PRINT N'Creating index [IX_WorkQueuePropertiesName] on [DynamicOps.WorkQueueModel].[WorkQueueProperties]'
GO
CREATE NONCLUSTERED INDEX [IX_WorkQueuePropertiesName] ON [DynamicOps.WorkQueueModel].[WorkQueueProperties] ([Name])
GO

PRINT N'Creating index [IX_FK_WorkQueueWorkQueueProperty] on [DynamicOps.WorkQueueModel].[WorkQueueProperties]'
GO
CREATE NONCLUSTERED INDEX [IX_FK_WorkQueueWorkQueueProperty] ON [DynamicOps.WorkQueueModel].[WorkQueueProperties] ([WorkQueueId])
GO

PRINT N'Creating [dbo].[BulkImportDetails]'
GO
CREATE VIEW [dbo].[BulkImportDetails]
AS
       SELECT 
              wqe.Id, 
  			  wqe.WorkQueueId as WorkQueueId, 
              ISNULL(vm.VirtualMachineName, N'Unknown') as Machine,
              ISNULL(vm.MachineType, 0) as MachineType,
              hr.HostReservationName as Reservation,
              s.StorageName as Storage,
              vmt.VirtualMachineTemplateName as Blueprint,
              dbo.GetWorkQueueElementProperty(wqe.Id, N'__Register.Owner') as [Owner],
              wqe.[Status]
       FROM [DynamicOps.WorkQueueModel].WorkQueueElements wqe
       LEFT JOIN VirtualMachine vm
              ON wqe.EntityId = vm.VirtualMachineID
       LEFT JOIN HostReservation hr
              ON hr.HostReservationID = dbo.GetWorkQueueElementProperty(wqe.Id, N'__Register.ReservationId')
       LEFT JOIN Storage s
              ON s.StorageID = dbo.GetWorkQueueElementProperty(wqe.Id, N'__Register.StorageId')
       LEFT JOIN VirtualMachineTemplate vmt
              ON vmt.VirtualMachineTemplateID = dbo.GetWorkQueueElementProperty(wqe.Id, N'__Register.BlueprintId')
GO


PRINT N'Adding constraints to [DynamicOps.WorkQueueModel].[WorkQueues]'
GO
ALTER TABLE [DynamicOps.WorkQueueModel].[WorkQueues] ADD CONSTRAINT [UQ__WorkQueu__0CDDC7CB60B24907] UNIQUE NONCLUSTERED  ([Name], [WorkQueueTypeId])
GO

PRINT N'Adding constraints to [DynamicOps.WorkQueueModel].[WorkQueueTypes]'
GO
ALTER TABLE [DynamicOps.WorkQueueModel].[WorkQueueTypes] ADD CONSTRAINT [UQ__WorkQueu__737584F66482D9EB] UNIQUE NONCLUSTERED  ([Name])
GO

PRINT N'Adding foreign keys to [DynamicOps.WorkQueueModel].[WorkQueueElementProperties]'
GO
ALTER TABLE [DynamicOps.WorkQueueModel].[WorkQueueElementProperties] ADD
CONSTRAINT [FK_WorkQueueElementWorkQueueElementProperty] FOREIGN KEY ([WorkQueueElementId]) REFERENCES [DynamicOps.WorkQueueModel].[WorkQueueElements] ([Id]) ON DELETE CASCADE
GO

PRINT N'Adding foreign keys to [DynamicOps.WorkQueueModel].[WorkQueueElements]'
GO
ALTER TABLE [DynamicOps.WorkQueueModel].[WorkQueueElements] ADD
CONSTRAINT [FK_WorkQueueWorkQueueElement] FOREIGN KEY ([WorkQueueId]) REFERENCES [DynamicOps.WorkQueueModel].[WorkQueues] ([Id]) ON DELETE CASCADE
GO

PRINT N'Adding foreign keys to [DynamicOps.WorkQueueModel].[WorkQueueProperties]'
GO
ALTER TABLE [DynamicOps.WorkQueueModel].[WorkQueueProperties] ADD
CONSTRAINT [FK_WorkQueueWorkQueueProperty] FOREIGN KEY ([WorkQueueId]) REFERENCES [DynamicOps.WorkQueueModel].[WorkQueues] ([Id]) ON DELETE CASCADE
GO

PRINT N'Adding foreign keys to [DynamicOps.WorkQueueModel].[WorkQueues]'
GO
ALTER TABLE [DynamicOps.WorkQueueModel].[WorkQueues] ADD
CONSTRAINT [FK_WorkQueueTypeWorkQueue] FOREIGN KEY ([WorkQueueTypeId]) REFERENCES [DynamicOps.WorkQueueModel].[WorkQueueTypes] ([Id])
GO

PRINT N'Adding [DynamicOps.WorkQueueModel].[WorkQueues]'
-- Add row to [DynamicOps.WorkQueueModel].[WorkQueueTypes]
INSERT INTO [DynamicOps.WorkQueueModel].[WorkQueueTypes] ([Id], [Name], [Description]) VALUES (1, N'Register', N'Bulk Import VMs Queue Type')
GO

PRINT N'Dropping constraints from [dbo].[HostReservation]'
Exec DropConstraintFromTable N'HostReservation'
GO

PRINT N'Dropping constraints from [dbo].[VirtualMachine]'
Exec DropConstraintFromTable N'VirtualMachine'
GO

PRINT N'Dropping constraints from [dbo].[VirtualMachineHistory]'
GO
Exec DropConstraintFromTable 'VirtualMachineHistory'
GO


PRINT N'Dropping constraints from [dbo].[VirtualMachineHistoryProperties]'
GO
Exec DropConstraintFromTable 'VirtualMachineHistoryProperties'
GO

PRINT N'Dropping index [IDX_VirtualMachine_6] from [dbo].[VirtualMachine]'
GO
DROP INDEX [IDX_VirtualMachine_6] ON [dbo].[VirtualMachine]
GO

PRINT N'Altering [dbo].[VirtualMachineHistory]'
GO
ALTER TABLE [dbo].[VirtualMachineHistory] ALTER COLUMN [IsManaged] [bit] NOT NULL
ALTER TABLE [dbo].[VirtualMachineHistory] ALTER COLUMN [ExpireDays] [int] NOT NULL
ALTER TABLE [dbo].[VirtualMachineHistory] ALTER COLUMN [BlueprintType] [tinyint] NOT NULL
ALTER TABLE [dbo].[VirtualMachineHistory] ALTER COLUMN [OwnerExists] [bit] NOT NULL
ALTER TABLE [dbo].[VirtualMachineHistory] ALTER COLUMN [IsDeleted] [bit] NOT NULL
ALTER TABLE [dbo].[VirtualMachineHistory] ALTER COLUMN [IsMissing] [bit] NOT NULL
ALTER TABLE [dbo].[VirtualMachineHistory] ALTER COLUMN [IsRogue] [bit] NOT NULL
ALTER TABLE [dbo].[VirtualMachineHistory] ALTER COLUMN [IsRunning] [bit] NOT NULL
ALTER TABLE [dbo].[VirtualMachineHistory] ALTER COLUMN [IsTemplate] [bit] NOT NULL
ALTER TABLE [dbo].[VirtualMachineHistory] ALTER COLUMN [ConnectToVdi] [bit] NOT NULL
ALTER TABLE [dbo].[VirtualMachineHistory] ALTER COLUMN [IsComponent] [bit] NOT NULL
GO

PRINT N'Altering [dbo].[VirtualMachine]'
GO
ALTER TABLE [dbo].[VirtualMachine] ALTER COLUMN [IsManaged] [bit] NOT NULL
ALTER TABLE [dbo].[VirtualMachine] ALTER COLUMN [ExpireDays] [int] NOT NULL
ALTER TABLE [dbo].[VirtualMachine] ALTER COLUMN [BlueprintType] [tinyint] NOT NULL
ALTER TABLE [dbo].[VirtualMachine] ALTER COLUMN [OwnerExists] [bit] NOT NULL
ALTER TABLE [dbo].[VirtualMachine] ALTER COLUMN [IsDeleted] [bit] NOT NULL
ALTER TABLE [dbo].[VirtualMachine] ALTER COLUMN [IsMissing] [bit] NOT NULL
ALTER TABLE [dbo].[VirtualMachine] ALTER COLUMN [IsRogue] [bit] NOT NULL
ALTER TABLE [dbo].[VirtualMachine] ALTER COLUMN [IsRunning] [bit] NOT NULL
ALTER TABLE [dbo].[VirtualMachine] ALTER COLUMN [IsTemplate] [bit] NOT NULL
ALTER TABLE [dbo].[VirtualMachine] ALTER COLUMN [ConnectToVdi] [bit] NOT NULL
ALTER TABLE [dbo].[VirtualMachine] ALTER COLUMN [IsComponent] [bit] NOT NULL
GO

PRINT N'Creating index [IDX_VirtualMachine_6] on [dbo].[VirtualMachine]'
GO
CREATE NONCLUSTERED INDEX [IDX_VirtualMachine_6] ON [dbo].[VirtualMachine] ([HostReservationID], [IsRunning]) INCLUDE ([VMTotalMemoryMB], [VMTotalStorageGB], [VMUsedStorageGB])
GO

PRINT N'Altering [dbo].[HostReservation]'
GO
ALTER TABLE [dbo].[HostReservation] ALTER COLUMN [ReservationMemorySizeMB] [bigint] NULL
ALTER TABLE [dbo].[HostReservation] ALTER COLUMN [ReservationStorageSizeGB] [bigint] NULL
GO

PRINT N'Altering [dbo].[VirtualMachineProperties]'
GO
ALTER TABLE [dbo].[VirtualMachineProperties] ALTER COLUMN [IsHidden] [bit] NOT NULL
ALTER TABLE [dbo].[VirtualMachineProperties] ALTER COLUMN [IsRuntime] [bit] NOT NULL
ALTER TABLE [dbo].[VirtualMachineProperties] ALTER COLUMN [IsEncrypted] [bit] NOT NULL
GO

PRINT N'Altering [dbo].[VirtualMachineHistoryProperties]'
GO
ALTER TABLE [dbo].[VirtualMachineHistoryProperties] ALTER COLUMN [IsHidden] [bit] NOT NULL
ALTER TABLE [dbo].[VirtualMachineHistoryProperties] ALTER COLUMN [IsRuntime] [bit] NOT NULL
ALTER TABLE [dbo].[VirtualMachineHistoryProperties] ALTER COLUMN [IsEncrypted] [bit] NOT NULL
GO

PRINT N'Refreshing [dbo].[StorageCostByMachineView]'
GO
EXEC sp_refreshview N'[dbo].[StorageCostByMachineView]'
GO

PRINT N'Altering [dbo].[BaseMachineCostView]'
GO
ALTER VIEW [dbo].[BaseMachineCostView]
AS
SELECT	vmAll.VirtualMachineID, 
		vmAll.MachineType, 
		vmAll.VirtualMachineName,
		vmAll.ParentMachineID,
		pg.GroupName, 
		hr.HostReservationName, 
		u.UserName, 
		vmt.VirtualMachineTemplateName, 
		vmAll.VMCreationDate, 
		vmAll.VMDeleteDate, 
		vmAll.[Owner], 
		pg.GroupID, 
		cpus.CPUs,
		memory.Memory,
		storage.Storage,
		blueprintcost.BlueprintCost,
		cputotalcost.CPUCost,
		memorytotalcost.MemoryCost,
		storagetotalcost.StorageCost,
		blueprintcost.BlueprintCost 
			+ ISNULL(cputotalcost.CPUCost, 0)
			+ ISNULL(memorytotalcost.MemoryCost, 0)
			+ ISNULL(storagetotalcost.StorageCost, 0) AS TotalCost
FROM
(
	SELECT * FROM VirtualMachine
	UNION ALL
	SELECT * FROM VirtualMachineHistory
) vmAll
LEFT OUTER JOIN Users u					ON u.UserID = vmAll.[Owner] 
LEFT OUTER JOIN Host h					ON h.HostID = vmAll.HostID 
LEFT OUTER JOIN CostProfile cp			ON cp.CostProfileID = h.CostProfileID 
INNER JOIN HostReservation hr			ON hr.HostReservationID = vmAll.HostReservationID 
INNER JOIN ProvisioningGroup pg			ON pg.GroupID = hr.GroupID 
INNER JOIN VirtualMachineTemplate vmt   ON vmt.VirtualMachineTemplateID = vmAll.VirtualMachineTemplateID 
LEFT OUTER JOIN PhysicalMachines pm     ON pm.PhysicalMachineID = vmAll.PhysicalMachineID 
LEFT OUTER JOIN CostProfile cpp			ON cpp.CostProfileID = pm.CostProfileID 
LEFT OUTER JOIN StorageCostByMachineView storagetotalcost ON vmAll.VirtualMachineID = storagetotalcost.VirtualMachineID
-- calculated fields
CROSS APPLY (SELECT CASE WHEN vmall.MachineType != 1 THEN ISNULL(vmall.VMCPUs, 0) ELSE pm.ProcessorCount END) AS cpus(CPUs)
CROSS APPLY (SELECT CASE WHEN vmall.MachineType != 1 THEN ISNULL(vmAll.VMTotalMemoryMB, 0) ELSE pm.MemoryInMB END) AS memory(Memory)
CROSS APPLY (SELECT CASE WHEN vmall.MachineType != 1 THEN ISNULL(vmAll.VMTotalStorageGB, 0) ELSE NULL END) AS storage(Storage)
CROSS APPLY (SELECT ISNULL(vmt.Cost, 0)) AS blueprintcost(BlueprintCost)
CROSS APPLY (
	SELECT 
		CASE 
			WHEN vmall.MachineType IN (0,4) THEN ISNULL(cp.CpuCost, 0) 
			WHEN vmall.MachineType = 1 THEN ISNULL(cpp.CpuCost, 0) 
		ELSE NULL 
	END) AS cpucost(CPUCost)
CROSS APPLY (
	SELECT 
		CASE 
			WHEN vmall.MachineType IN (0,4) THEN ISNULL(cp.MemoryCost, 0) 
			WHEN vmall.MachineType = 1 THEN ISNULL(cpp.MemoryCost, 0) 
		ELSE NULL 
	END) AS memorycost(MemoryCost)
CROSS APPLY (SELECT cpus.CPUs * cpucost.CPUCost) AS cputotalcost(CPUCost)
CROSS APPLY (SELECT dbo.Divideasdecimal(memory.Memory, 1024) * memorycost.MemoryCost) AS memorytotalcost(MemoryCost)
WHERE vmAll.IsManaged = 1
GO

PRINT N'Altering [dbo].[MachineCostView]'
GO
ALTER VIEW [dbo].[MachineCostView]
AS
SELECT
	bmcv.VirtualMachineID as VirtualMachineID,
	bmcv.TotalCost as DailyCost
FROM	BaseMachineCostView bmcv
WHERE	bmcv.MachineType != 3
    AND (bmcv.MachineType != 4 OR bmcv.ParentMachineID IS NOT NULL)
UNION ALL
SELECT  vm.VirtualMachineID,
		s.DailyCost
FROM (SELECT
		ISNULL(mm.AppServiceId, bmcv.VirtualMachineId) As VirtualMachineID,
		SUM(bmcv.TotalCost) as DailyCost
		FROM BaseMachineCostView bmcv
			LEFT OUTER JOIN AppServiceComponents mm ON mm.VirtualMachineId = bmcv.VirtualMachineID
		WHERE AppServiceID IS NOT NULL 
		    OR bmcv.MachineType = 3
		    OR (bmcv.MachineType = 4 AND bmcv.ParentMachineID IS NULL)
		GROUP BY ISNULL(mm.AppServiceId, bmcv.VirtualMachineId)) s
INNER JOIN VirtualMachine vm ON vm.VirtualMachineID = s.VirtualMachineID
WHERE vm.MachineType = 3
    OR (vm.MachineType = 4 AND vm.ParentMachineID IS NULL)
GO

PRINT N'Altering [dbo].[BulkImportDetails]'
GO
SET QUOTED_IDENTIFIER OFF
GO
ALTER VIEW [dbo].[BulkImportDetails]
AS
       SELECT 
              wqe.Id, 
  			  wqe.WorkQueueId as WorkQueueId, 
              ISNULL(vm.VirtualMachineName, N'Unknown') as Machine,
              ISNULL(vm.MachineType, 0) as MachineType,
              hr.HostReservationName as Reservation,
              s.StorageName as Storage,
              vmt.VirtualMachineTemplateName as Blueprint,
              dbo.GetWorkQueueElementProperty(wqe.Id, N'__Register.Owner') as [Owner],
              wqe.[Status]
       FROM [DynamicOps.WorkQueueModel].WorkQueueElements wqe
       LEFT JOIN VirtualMachine vm
              ON wqe.EntityId = vm.VirtualMachineID
       LEFT JOIN HostReservation hr
              ON hr.HostReservationID = dbo.GetWorkQueueElementProperty(wqe.Id, N'__Register.ReservationId')
       LEFT JOIN Storage s
              ON s.StorageID = dbo.GetWorkQueueElementProperty(wqe.Id, N'__Register.StorageId')
       LEFT JOIN VirtualMachineTemplate vmt
              ON vmt.VirtualMachineTemplateID = dbo.GetWorkQueueElementProperty(wqe.Id, N'__Register.BlueprintId')
GO

PRINT N'Refreshing [dbo].[HostInterfaceInfo]'
GO
EXEC sp_refreshview N'[dbo].[HostInterfaceInfo]'
GO

PRINT N'Refreshing [dbo].[HostExt]'
GO
EXEC sp_refreshview N'[dbo].[HostExt]'
GO

PRINT N'Altering [dbo].[VirtualMachineExt]'
GO
SET QUOTED_IDENTIFIER ON
GO
ALTER VIEW [dbo].[VirtualMachineExt] AS
    SELECT
        v.VirtualMachineID
        ,dbo.GetVirtualMachineUsedStoragePathsSummary(v.VirtualMachineID) StoragePathsSummary
        ,MachineName = NULLIF(v.VirtualMachineName, N'')
        ,[Status]  = 
        CASE
            WHEN v.IsMissing = 1 THEN N'Missing'
            WHEN v.IsManaged = 0 and v.HostReservationID IS NULL THEN N'Unmanaged'
            WHEN v.IsManaged = 0 and v.HostReservationID IS NOT NULL THEN N'Reserved'
            WHEN v.CurrentTask IS NOT NULL THEN v.VirtualMachineState + N' (' + v.CurrentTask + N')'
            ELSE v.VirtualMachineState
        END
        ,MachineType = 
        CASE
            WHEN v.MachineType = 1 THEN N'Physical' 
            WHEN v.MachineType IN (2,4) THEN N'Cloud' 
            WHEN v.MachineType = 3 THEN N'Multi-Machine'
            ELSE N'Virtual'
        END
        ,BlueprintName = t.VirtualMachineTemplateName
        ,UserName = u.UserName
        ,HostName = 
        CASE
            WHEN v.MachineType IN (1,3) THEN NULL
            ELSE he.HostName
        END
        ,GroupName = pg.GroupName
        ,ReservationName = 
        CASE
            WHEN v.MachineType != 3 THEN hr.HostReservationName
            ELSE NULL
        END
        ,EndpointName = 
        CASE
            WHEN v.MachineType = 1 THEN epc.ManagementEndpointName
            ELSE he.EndpointName
        END
        ,EndpointInterfaceType = 
        CASE
            WHEN v.MachineType = 1 THEN epc.InterfaceType
            ELSE he.InterfaceTypeId
        END
        ,InterfaceDisplayName = 
		CASE
            WHEN v.MachineType = 1 THEN it.DisplayName
            ELSE he.InterfaceDisplayName
        END
        ,CostProfileName = cp.CostProfileName
        ,DestructionDate = DATEADD(day, ISNULL(v.ExpireDays, 0), v.Expires)
        ,VMCPUs=
        CASE
            WHEN v.MachineType = 1 THEN pm.ProcessorCount
            WHEN v.MachineType = 3 THEN NULL
            ELSE v.VMCPUs
        END
        ,VMTotalMemoryGB = 
        CASE
            WHEN v.MachineType = 1 THEN CAST(ROUND(CAST(pm.MemoryInMB AS FLOAT)/ 1024, 1) AS REAL)
            WHEN v.MachineType = 3 THEN NULL
            ELSE CAST(ROUND(CAST(ISNULL(v.VMTotalMemoryMB, 0) AS FLOAT)/ 1024, 1) AS REAL)
        END
        ,VMTotalStorageGB = 
        CASE
            WHEN v.MachineType IN (1,3) THEN NULL
            ELSE v.VMTotalStorageGB
        END
        ,OwnerExistsString = 
        CASE
            WHEN v.OwnerExists = 1 THEN N'Yes' ELSE N'No'
        END
        ,IsMissingString = 
        CASE
            WHEN v.IsMissing = 1 THEN N'Yes' ELSE N'No'
        END
    FROM [dbo].VirtualMachine v LEFT OUTER JOIN
         [dbo].VirtualMachineTemplate t ON v.VirtualMachineTemplateID = t.VirtualMachineTemplateID LEFT OUTER JOIN
         [dbo].Users u ON v.[Owner] = u.UserID LEFT OUTER JOIN
         [dbo].HostReservation hr ON v.HostReservationID = hr.HostReservationID LEFT OUTER JOIN
         [dbo].ProvisioningGroup pg ON hr.GroupID = pg.GroupID LEFT OUTER JOIN
         [dbo].PhysicalMachines pm ON v.PhysicalMachineID = pm.PhysicalMachineID LEFT OUTER JOIN
         [dbo].PhysicalControllers pc ON pm.PhysicalController_PhysicalControllerID = pc.PhysicalControllerID LEFT OUTER JOIN
         [dbo].ManagementEndpoints epc ON pc.ManagementEndpoint_ManagementEndpointID = epc.ManagementEndpointID LEFT OUTER JOIN         
         [dbo].InterfaceTypes it ON epc.InterfaceType = it.InterfaceTypeId LEFT OUTER JOIN
         [dbo].HostExt he ON v.HostID = he.HostID LEFT OUTER JOIN
         [dbo].CostProfile cp ON pm.CostProfileID = cp.CostProfileID 
GO

PRINT N'Adding constraints to [dbo].[HostReservation]'
GO
ALTER TABLE [dbo].[HostReservation] ADD CONSTRAINT [DF__HostReser__Reser__4CA06362] DEFAULT ((0)) FOR [ReservationMemorySizeMB]
GO

ALTER TABLE [dbo].[HostReservation] ADD CONSTRAINT [DF__HostReser__Reser__4D94879B] DEFAULT ((0)) FOR [ReservationStorageSizeGB]
GO

PRINT N'Adding constraints to [dbo].[VirtualMachine]'
GO
ALTER TABLE [dbo].[VirtualMachine] ADD CONSTRAINT [DF__VirtualMa__IsMan__5EBF139D] DEFAULT ((0)) FOR [IsManaged]
GO

ALTER TABLE [dbo].[VirtualMachine] ADD CONSTRAINT [DF__VirtualMa__Expir__5FB337D6] DEFAULT ((0)) FOR [ExpireDays]
GO

ALTER TABLE [dbo].[VirtualMachine] ADD CONSTRAINT [DF__VirtualMa__Bluep__60A75C0F] DEFAULT ((0)) FOR [BlueprintType]
GO

ALTER TABLE [dbo].[VirtualMachine] ADD CONSTRAINT [DF__VirtualMa__Owner__619B8048] DEFAULT ((0)) FOR [OwnerExists]
GO

ALTER TABLE [dbo].[VirtualMachine] ADD CONSTRAINT [DF__VirtualMa__IsDel__628FA481] DEFAULT ((0)) FOR [IsDeleted]
GO

ALTER TABLE [dbo].[VirtualMachine] ADD CONSTRAINT [DF__VirtualMa__IsMis__6383C8BA] DEFAULT ((0)) FOR [IsMissing]
GO

ALTER TABLE [dbo].[VirtualMachine] ADD CONSTRAINT [DF__VirtualMa__IsRog__6477ECF3] DEFAULT ((0)) FOR [IsRogue]
GO

ALTER TABLE [dbo].[VirtualMachine] ADD CONSTRAINT [DF__VirtualMa__IsRun__656C112C] DEFAULT ((0)) FOR [IsRunning]
GO

ALTER TABLE [dbo].[VirtualMachine] ADD CONSTRAINT [DF__VirtualMa__IsTem__66603565] DEFAULT ((0)) FOR [IsTemplate]
GO

ALTER TABLE [dbo].[VirtualMachine] ADD CONSTRAINT [DF__VirtualMa__Conne__6754599E] DEFAULT ((0)) FOR [ConnectToVdi]
GO

ALTER TABLE [dbo].[VirtualMachine] ADD CONSTRAINT [DF__VirtualMa__IsCom__68487DD7] DEFAULT ((0)) FOR [IsComponent]
GO

PRINT N'Adding constraints to [dbo].[VirtualMachineHistory]'
GO
ALTER TABLE [dbo].[VirtualMachineHistory] ADD CONSTRAINT [DF__VirtualMa__IsMan__382F5661] DEFAULT ((0)) FOR [IsManaged]
GO

ALTER TABLE [dbo].[VirtualMachineHistory] ADD CONSTRAINT [DF__VirtualMa__Expir__39237A9A] DEFAULT ((0)) FOR [ExpireDays]
GO

ALTER TABLE [dbo].[VirtualMachineHistory] ADD CONSTRAINT [DF__VirtualMa__Bluep__3A179ED3] DEFAULT ((0)) FOR [BlueprintType]
GO

ALTER TABLE [dbo].[VirtualMachineHistory] ADD CONSTRAINT [DF__VirtualMa__Owner__3B0BC30C] DEFAULT ((0)) FOR [OwnerExists]
GO

ALTER TABLE [dbo].[VirtualMachineHistory] ADD CONSTRAINT [DF__VirtualMa__IsDel__3BFFE745] DEFAULT ((0)) FOR [IsDeleted]
GO

ALTER TABLE [dbo].[VirtualMachineHistory] ADD CONSTRAINT [DF__VirtualMa__IsMis__3CF40B7E] DEFAULT ((0)) FOR [IsMissing]
GO

ALTER TABLE [dbo].[VirtualMachineHistory] ADD CONSTRAINT [DF__VirtualMa__IsRog__3DE82FB7] DEFAULT ((0)) FOR [IsRogue]
GO

ALTER TABLE [dbo].[VirtualMachineHistory] ADD CONSTRAINT [DF__VirtualMa__IsRun__3EDC53F0] DEFAULT ((0)) FOR [IsRunning]
GO

ALTER TABLE [dbo].[VirtualMachineHistory] ADD CONSTRAINT [DF__VirtualMa__IsTem__3FD07829] DEFAULT ((0)) FOR [IsTemplate]
GO

ALTER TABLE [dbo].[VirtualMachineHistory] ADD CONSTRAINT [DF__VirtualMa__Conne__40C49C62] DEFAULT ((0)) FOR [ConnectToVdi]
GO

ALTER TABLE [dbo].[VirtualMachineHistory] ADD CONSTRAINT [DF__VirtualMa__IsCom__41B8C09B] DEFAULT ((0)) FOR [IsComponent]
GO

PRINT N'Adding constraints to [dbo].[VirtualMachineHistoryProperties]'
GO
ALTER TABLE [dbo].[VirtualMachineHistoryProperties] ADD CONSTRAINT [DF__VirtualMa__IsHid__7CD98669] DEFAULT ((0)) FOR [IsHidden]
GO

ALTER TABLE [dbo].[VirtualMachineHistoryProperties] ADD CONSTRAINT [DF__VirtualMa__IsRun__7DCDAAA2] DEFAULT ((0)) FOR [IsRuntime]
GO

ALTER TABLE [dbo].[VirtualMachineHistoryProperties] ADD CONSTRAINT [DF__VirtualMa__IsEnc__7EC1CEDB] DEFAULT ((0)) FOR [IsEncrypted]
GO

PRINT N'Altering members of role state_persistence_users'
GO
EXEC sp_addrolemember N'state_persistence_users', N'Vrm_Manager'
GO

PRINT N'Altering [dbo].[HostReservationStats]'
GO
ALTER VIEW [dbo].[HostReservationStats]
AS
	select hr.HostReservationID
	,COUNT(vm.VirtualMachineID) [MachinesTotal]
	,ISNULL(SUM(CASE WHEN vm.IsManaged = 1 and (hr.MachineType = 1 or vm.IsRunning = 1) THEN 1 ELSE 0 END), 0) [MachinesAllocated]
	,ISNULL(SUM(CASE WHEN hr.MachineType != 1 and vm.IsManaged = 1 and vm.IsRunning = 1 THEN vm.VMTotalMemoryMB WHEN hr.MachineType = 1 and vm.IsManaged = 1 THEN pm.MemoryInMB ELSE 0 END), 0) [MemoryAllocated]
	,ISNULL(SUM(CASE WHEN hr.MachineType != 1 and vm.IsManaged = 1  THEN ms.TotalCapacity ELSE 0 END), 0) [StorageAllocated]
	,ISNULL(SUM(CASE WHEN hr.MachineType = 0 and vm.IsManaged = 1  THEN vm.VMUsedStorageGB ELSE 0 END), 0) [StorageUsed]
	,ISNULL(SUM(CASE WHEN hr.MachineType = 0 and vm.IsManaged = 1 THEN vm.VMTotalStorageGB - vm.VMEstimatedUsedSpace ELSE 0 END), 0) [StorageSaved]
	from HostReservation hr
	left outer join VirtualMachine vm on vm.HostReservationID = hr.HostReservationID and vm.MachineType = hr.MachineType and (vm.MachineType != 4 or vm.IsComponent = 1)
	left outer join PhysicalMachines pm on pm.PhysicalMachineID = vm.PhysicalMachineID
	left outer join
	(
		SELECT      m.VirtualMachineID,
			SUM(vdh.Capacity) AS TotalCapacity,
            SUM(vdh.UsedCapacity) AS TotalUsedCapacity
		FROM  VirtualMachine m
		INNER JOIN VMDiskHardWare vdh ON vdh.VirtualMachineID = m.VirtualMachineID
		GROUP BY m.VirtualMachineID
	) ms on vm.VirtualMachineID = ms.VirtualMachineID
	group by hr.HostReservationID
GO

PRINT N'Refreshing [dbo].[ManagedGroupsCapacityView]'
GO
EXEC sp_refreshview N'[dbo].[ManagedGroupsCapacityView]'
GO

PRINT N'Refreshing [dbo].[ManagedHostsCapacityView]'
GO
EXEC sp_refreshview N'[dbo].[ManagedHostsCapacityView]'
GO

PRINT N'Dropping constraints from [dbo].[HostProperties]'
GO
Exec DropConstraintFromTable N'HostProperties'
GO

PRINT N'Dropping constraints from [dbo].[VirtualMachineProperties]'
GO
Exec DropConstraintFromTable N'VirtualMachineProperties'
GO

PRINT N'Refreshing [dbo].[HostStorageReservationView]'
GO
EXEC sp_refreshview N'[dbo].[HostStorageReservationView]'
GO

PRINT N'Refreshing [dbo].[RequestLastAction]'
GO
EXEC sp_refreshview N'[dbo].[RequestLastAction]'
GO

PRINT N'Altering [dbo].[VirtualMachineProperties]'
GO
ALTER TABLE [dbo].[VirtualMachineProperties] ALTER COLUMN [IsHidden] [bit] NOT NULL
ALTER TABLE [dbo].[VirtualMachineProperties] ALTER COLUMN [IsRuntime] [bit] NOT NULL
ALTER TABLE [dbo].[VirtualMachineProperties] ALTER COLUMN [IsEncrypted] [bit] NOT NULL
GO

PRINT N'Refreshing [dbo].[HostBasicView1]'
GO
EXEC sp_refreshview N'[dbo].[HostBasicView1]'
GO

PRINT N'Refreshing [dbo].[ReclaimedVirtualMachineView]'
GO
EXEC sp_refreshview N'[dbo].[ReclaimedVirtualMachineView]'
GO

PRINT N'Refreshing [dbo].[ReclaimedVirtualMachineCostView]'
GO
EXEC sp_refreshview N'[dbo].[ReclaimedVirtualMachineCostView]'
GO

PRINT N'Refreshing [dbo].[LoggedOnCollectionStatusView]'
GO
EXEC sp_refreshview N'[dbo].[LoggedOnCollectionStatusView]'
GO

PRINT N'Refreshing [dbo].[HostStorageReservationUsedView]'
GO
EXEC sp_refreshview N'[dbo].[HostStorageReservationUsedView]'
GO

PRINT N'Refreshing [dbo].[ReservationStorageSizeView]'
GO
EXEC sp_refreshview N'[dbo].[ReservationStorageSizeView]'
GO

PRINT N'Refreshing [dbo].[ReservationUsedStorageSizeView]'
GO
EXEC sp_refreshview N'[dbo].[ReservationUsedStorageSizeView]'
GO

PRINT N'Refreshing [dbo].[HostReservationEbsVolumeCapacity]'
GO
EXEC sp_refreshview N'[dbo].[HostReservationEbsVolumeCapacity]'
GO

PRINT N'Refreshing [dbo].[HostReservationToStorageStats]'
GO
EXEC sp_refreshview N'[dbo].[HostReservationToStorageStats]'
GO

PRINT N'Refreshing [dbo].[HostReservationStats]'
GO
EXEC sp_refreshview N'[dbo].[HostReservationStats]'
GO

PRINT N'Altering [dbo].[HostProperties]'
GO
ALTER TABLE [dbo].[HostProperties] ALTER COLUMN [IsHidden] [bit] NOT NULL
ALTER TABLE [dbo].[HostProperties] ALTER COLUMN [IsRuntime] [bit] NOT NULL
ALTER TABLE [dbo].[HostProperties] ALTER COLUMN [IsEncrypted] [bit] NOT NULL
GO

PRINT N'Refreshing [dbo].[uv_VirtualMachineCostView]'
GO
EXEC sp_refreshview N'[dbo].[uv_VirtualMachineCostView]'
GO

PRINT N'Refreshing [dbo].[RequestView]'
GO
EXEC sp_refreshview N'[dbo].[RequestView]'
GO

PRINT N'Refreshing [dbo].[LastLogonUserView]'
GO
EXEC sp_refreshview N'[dbo].[LastLogonUserView]'
GO

PRINT N'Refreshing [dbo].[uv_VirtualMachineView]'
GO
EXEC sp_refreshview N'[dbo].[uv_VirtualMachineView]'
GO

PRINT N'Refreshing [dbo].[VirtualMachineInfoView]'
GO
EXEC sp_refreshview N'[dbo].[VirtualMachineInfoView]'
GO

PRINT N'Refreshing [dbo].[ProvisioningGroupCostSavingsView]'
GO
EXEC sp_refreshview N'[dbo].[ProvisioningGroupCostSavingsView]'
GO

PRINT N'Refreshing [dbo].[VMStorageFromReservation]'
GO
EXEC sp_refreshview N'[dbo].[VMStorageFromReservation]'
GO

PRINT N'Refreshing [dbo].[VMStorageFromDisk]'
GO
EXEC sp_refreshview N'[dbo].[VMStorageFromDisk]'
GO

PRINT N'Refreshing [dbo].[VMStorageMismatch]'
GO
EXEC sp_refreshview N'[dbo].[VMStorageMismatch]'
GO

PRINT N'Refreshing [dbo].[MachineUsageByState]'
GO
EXEC sp_refreshview N'[dbo].[MachineUsageByState]'
GO

PRINT N'Refreshing [dbo].[HostDiscovery]'
GO
EXEC sp_refreshview N'[dbo].[HostDiscovery]'

PRINT N'Refreshing [dbo].[StorageCostByMachineView]'
GO
EXEC sp_refreshview N'[dbo].[StorageCostByMachineView]'
GO

PRINT N'Refreshing [dbo].[BaseMachineCostView]'
GO
EXEC sp_refreshview N'[dbo].[BaseMachineCostView]'
GO

PRINT N'Refreshing [dbo].[MachineCostView]'
GO
EXEC sp_refreshview N'[dbo].[MachineCostView]'
GO

PRINT N'Refreshing [dbo].[TempHostReservationInfo]'
GO
EXEC sp_refreshview N'[dbo].[TempHostReservationInfo]'
GO

PRINT N'Refreshing [dbo].[ChargeBackMachineView]'
GO
EXEC sp_refreshview N'[dbo].[ChargeBackMachineView]'
GO

PRINT N'Refreshing [dbo].[ManagedGroupsCapacityView]'
GO
EXEC sp_refreshview N'[dbo].[ManagedGroupsCapacityView]'
GO

PRINT N'Refreshing [dbo].[PhysicalMachineView]'
GO
EXEC sp_refreshview N'[dbo].[PhysicalMachineView]'
GO

PRINT N'Refreshing [dbo].[CloudMachineView]'
GO
EXEC sp_refreshview N'[dbo].[CloudMachineView]'
GO

PRINT N'Refreshing [dbo].[VirtualMachineRequestView]'
GO
EXEC sp_refreshview N'[dbo].[VirtualMachineRequestView]'
GO

PRINT N'Refreshing [dbo].[BulkImportDetails]'
GO
EXEC sp_refreshview N'[dbo].[BulkImportDetails]'
GO

PRINT N'Refreshing [dbo].[ManagedHostsCapacityView]'
GO
EXEC sp_refreshview N'[dbo].[ManagedHostsCapacityView]'
GO

PRINT N'Refreshing [dbo].[HostBasicView]'
GO
EXEC sp_refreshview N'[dbo].[HostBasicView]'
GO

PRINT N'Refreshing [dbo].[HostCapacityViewInt]'
GO
EXEC sp_refreshview N'[dbo].[HostCapacityViewInt]'
GO

PRINT N'Refreshing [dbo].[ReservationView]'
GO
EXEC sp_refreshview N'[dbo].[ReservationView]'
GO

PRINT N'Refreshing [dbo].[HostCapacityViewInt1]'
GO
EXEC sp_refreshview N'[dbo].[HostCapacityViewInt1]'
GO

PRINT N'Refreshing [dbo].[HostCapacityView]'
GO
EXEC sp_refreshview N'[dbo].[HostCapacityView]'
GO

PRINT N'Refreshing [dbo].[ProvisioningGroupView]'
GO
EXEC sp_refreshview N'[dbo].[ProvisioningGroupView]'
GO

PRINT N'Refreshing [dbo].[VirtualMachineView]'
GO
EXEC sp_refreshview N'[dbo].[VirtualMachineView]'
GO

PRINT N'Refreshing [dbo].[ReservationInfoView]'
GO
EXEC sp_refreshview N'[dbo].[ReservationInfoView]'
GO

PRINT N'Refreshing [dbo].[EntityProperties]'
GO
EXEC sp_refreshview N'[dbo].[EntityProperties]'
GO

PRINT N'Refreshing [dbo].[HostReservationInfo]'
GO
EXEC sp_refreshview N'[dbo].[HostReservationInfo]'
GO

PRINT N'Refreshing [dbo].[ReservationInfoExView]'
GO
EXEC sp_refreshview N'[dbo].[ReservationInfoExView]'
GO

PRINT N'Altering [dbo].[usp_GetAvailableReservations]'
GO
ALTER PROCEDURE [dbo].[usp_GetAvailableReservations] 
	@VirtualMachineID uniqueidentifier,
	@GroupID uniqueidentifier,
	@VMDiskSize int,
	@VMCpuCount int,
	@ReservationPolicyID uniqueidentifier,
	@UserLocation nvarchar(256),
	@RequestedAllocationType tinyint = 3   -- Indifferent
AS
BEGIN
	-- The following pertains to allocating virtual machine reservations.
	DECLARE @RuntimeReservationPolicyID uniqueidentifier
	SELECT @RuntimeReservationPolicyID = PropertyValue FROM VirtualMachineProperties
	WHERE PropertyName =N'__reservationPolicyID' AND EntityID = @VirtualMachineID
	
	IF (@RuntimeReservationPolicyID IS NOT NULL)
	BEGIN
		SET @ReservationPolicyID = @RuntimeReservationPolicyID;
	END
	
	DECLARE @DataCenterPolicy NVARCHAR(255)
	SELECT	@DataCenterPolicy = vmp.PropertyValue
	FROM	VirtualMachineProperties vmp
	WHERE	vmp.EntityID = @VirtualMachineID
	AND		vmp.PropertyName = N'VRM.Datacenter.Policy'
	
	DECLARE @IsTpmEnabled BIT
	SELECT	@IsTpmEnabled = vmp.PropertyValue
	FROM	VirtualMachineProperties vmp
	WHERE	vmp.EntityID = @VirtualMachineID
	AND		vmp.PropertyName = N'VirtualMachine.Host.TpmEnabled'
	-- reservation selection, filtered by group, active hosts, enabled, with aggregate storage
	-- sorted by best reservation, ordered by location, priority, then utiliztion ratio
	SELECT	hrl.HostReservationID
	FROM	HostReservation			hrl with (updlock)  -- force locking to execute on primary key
	JOIN	HostReservation			hr	ON hrl.HostReservationID = hr.HostReservationID
	JOIN	Host					h	ON hr.HostID = h.HostID
	LEFT JOIN HostProperties		hpl	on h.HostID = hpl.EntityID
										and hpl.PropertyName = N'Vrm.DataCenter.Location'
	LEFT JOIN HostReservationStats hrst on hr.HostReservationID = hrst.HostReservationID
	-- aggregate storage check								
	JOIN
	(
			SELECT	hrs.HostReservationID,
					CASE 
						WHEN COUNT(hrs.MaxCapacity) != COUNT(*) THEN NULL /* If any storage path capacities are null, the total capacity should be null (i.e. unlimited) */
						ELSE SUM(hrs.MaxCapacity - hrss.StorageAllocated)
					END AS AllocatedStorageAvailable,
					SUM(StorageFreeCapacityGB) AS PhysicalStorageAvailable
			FROM	HostReservationToStorage hrs
			JOIN	HostToStorage hs	on hrs.HostToStorageID = hs.HostToStorageID
										AND hs.Flags = 0
			JOIN	Storage s on hs.StorageID = s.StorageID			
			JOIN	HostReservationToStorageStats hrss	ON hrs.HostReservationToStorageID = hrss.HostReservationToStorageID
			WHERE	hrs.[Enabled] = 1
			GROUP BY hrs.HostReservationID
	) hrsst ON	hr.HostReservationID = hrsst.HostReservationID									
	WHERE	hr.GroupID = @GroupID 	-- Eliminate reservations not in the template group
	AND		h.HostStateID = 0		-- Only include active hosts
	AND		hr.[Enabled] = 1		-- Only include enabled reservations
	AND		(@ReservationPolicyID is null or hr.ReservationPolicyID = @ReservationPolicyID)
	-- data center location and policy check, by default uses the exact match
	AND		(@UserLocation IS NULL OR ISNULL(NULLIF(@DataCenterPolicy,N''), N'Exact') <> N'Exact' OR hpl.PropertyValue = @UserLocation)
	AND		(@IsTpmEnabled IS NULL OR @IsTpmEnabled = 0 OR h.IsTpmEnabled = 1) -- Only include hosts with trust hardware installed
	AND		(hrsst.AllocatedStorageAvailable >= @VMDiskSize OR hrsst.AllocatedStorageAvailable IS NULL) -- Only include reservations with disk space free
	AND		(hrsst.PhysicalStorageAvailable >= @VMDiskSize OR h.AllocationType = 2) -- Only include where physical storage is greater than VM size
	-- requested allocation type for vCD (0 = guaranteed, 1 = limited, 2 = unlimited, 3 = indifferent)
	AND		(@RequestedAllocationType = 3 OR h.AllocationType = @RequestedAllocationType)
	ORDER BY
		-- location matches first, then by priority, then my allocation percentage
		CASE 
			WHEN @UserLocation = hpl.PropertyValue THEN 0
			ELSE 1
		END,
		hr.ReservationPriority, 
		CASE 
			WHEN hr.MaxVMsPowerOn = 0 AND hrst.MachinesAllocated = 0 THEN (-1)
			WHEN hr.MaxVMsPowerOn = 0 AND hrst.MachinesAllocated <> 0 THEN 1 - (CAST(1 AS FLOAT))/hrst.MachinesAllocated
			ELSE 1 + (CAST(hrst.MachinesAllocated AS FLOAT)) / hr.MaxVMsPowerOn 
		END
END
GO

PRINT N'Refreshing [dbo].[ProvisioningGroupCapacityViewInt]'
GO
EXEC sp_refreshview N'[dbo].[ProvisioningGroupCapacityViewInt]'
GO

PRINT N'Refreshing [dbo].[ProvisioningGroupCapacityViewInt1]'
GO
EXEC sp_refreshview N'[dbo].[ProvisioningGroupCapacityViewInt1]'
GO

PRINT N'Refreshing [dbo].[ProvisioningGroupCapacityView]'
GO
EXEC sp_refreshview N'[dbo].[ProvisioningGroupCapacityView]'
GO

PRINT N'Refreshing [dbo].[VirtualMachineExt]'
GO
EXEC sp_refreshview N'[dbo].[VirtualMachineExt]'
GO

PRINT N'Refreshing [dbo].[VirtualMachineInfo]'
GO
EXEC sp_refreshview N'[dbo].[VirtualMachineInfo]'
GO

PRINT N'Refreshing [dbo].[HostPerDayCostView]'
GO
EXEC sp_refreshview N'[dbo].[HostPerDayCostView]'
GO

PRINT N'Refreshing [dbo].[UserCapacitySummaryView]'
GO
EXEC sp_refreshview N'[dbo].[UserCapacitySummaryView]'
GO

PRINT N'Refreshing [dbo].[TemplateCapacitySummaryView]'
GO
EXEC sp_refreshview N'[dbo].[TemplateCapacitySummaryView]'
GO

PRINT N'Refreshing [dbo].[RogueVirtualMachineView]'
GO
EXEC sp_refreshview N'[dbo].[RogueVirtualMachineView]'
GO

PRINT N'Refreshing [dbo].[LeaseExtensionView]'
GO
EXEC sp_refreshview N'[dbo].[LeaseExtensionView]'
GO

PRINT N'Refreshing [dbo].[VirtualMachinePerDayCostView]'
GO
EXEC sp_refreshview N'[dbo].[VirtualMachinePerDayCostView]'
GO

PRINT N'Refreshing [dbo].[VirtualMachineCostView]'
GO
EXEC sp_refreshview N'[dbo].[VirtualMachineCostView]'
GO

PRINT N'Adding constraints to [dbo].[HostProperties]'
GO
ALTER TABLE [dbo].[HostProperties] ADD CONSTRAINT [DF__HostPrope__IsHid__5E54FF49] DEFAULT ((0)) FOR [IsHidden]
GO

ALTER TABLE [dbo].[HostProperties] ADD CONSTRAINT [DF__HostPrope__IsRun__5F492382] DEFAULT ((0)) FOR [IsRuntime]
GO

ALTER TABLE [dbo].[HostProperties] ADD CONSTRAINT [DF__HostPrope__IsEnc__603D47BB] DEFAULT ((0)) FOR [IsEncrypted]
GO

PRINT N'Adding constraints to [dbo].[VirtualMachineProperties]'
GO
ALTER TABLE [dbo].[VirtualMachineProperties] ADD CONSTRAINT [DF__VirtualMa__IsHid__589C25F3] DEFAULT ((0)) FOR [IsHidden]
GO

ALTER TABLE [dbo].[VirtualMachineProperties] ADD CONSTRAINT [DF__VirtualMa__IsRun__59904A2C] DEFAULT ((0)) FOR [IsRuntime]
GO

ALTER TABLE [dbo].[VirtualMachineProperties] ADD CONSTRAINT [DF__VirtualMa__IsEnc__5A846E65] DEFAULT ((0)) FOR [IsEncrypted]
GO

PRINT N'Altering trigger [dbo].[trg_UpdateStorageReservationSize] on [dbo].[HostReservationToStorage]'
GO
ALTER TRIGGER [dbo].[trg_UpdateStorageReservationSize] 
ON [dbo].[HostReservationToStorage] AFTER INSERT, UPDATE, DELETE
AS
      SET NOCOUNT ON;
      IF EXISTS (SELECT * FROM inserted) AND NOT UPDATE(MaxCapacity)
            RETURN
      UPDATE HostReservation 
      SET ReservationStorageSizeGB = 
      (
            SELECT 
                  CASE 
                        WHEN COUNT(s.MaxCapacity) != COUNT(*) THEN NULL  /* If any storage path capacities are null, the total capacity should be null (i.e. unlimited) */
                        ELSE SUM(s.MaxCapacity) 
                  END 
            FROM  HostReservationToStorage s 
            WHERE s.HostReservationID = r.HostReservationID 
            AND s.Enabled = 1
      )
      FROM HostReservation r 
      JOIN (
            SELECT HostReservationID FROM inserted UNION 
            SELECT HostReservationID FROM deleted 
            ) t ON r.HostReservationID = t.HostReservationID
GO



PRINT N'Dropping [dbo].[DropUniqueConstraintFromTable]'
GO
DROP PROCEDURE [dbo].[DropUniqueConstraintFromTable]
GO

PRINT N'Dropping [dbo].[DropConstraintFromTable]'
GO
DROP PROCEDURE [dbo].[DropConstraintFromTable]
GO



PRINT N'---------------------------------------------------'
PRINT N'The database update from 5.1.2 to 5.2.3 succeeded'
PRINT N'---------------------------------------------------'
GO
