#!/usr/bin/python

import sys
from bag import Bag
from resolv_conf import ResolvConf

resolv_conf_filename = '/etc/resolv.conf'
if len(sys.argv) > 1:
    resolv_conf_filename = sys.argv[1]

bag = Bag('properties.xml')

default_network_offset = 0
if bag.has_key('VirtualMachine.Network.Default'):
    default_network_offset = int(bag['VirtualMachine.Network.Default'])

current_resolv_conf_lines = open(resolv_conf_filename).readlines()

r = ResolvConf(bag, default_network_offset)
new_resolv_conf_lines = r.lines(current_resolv_conf_lines)

if len(new_resolv_conf_lines) > 0:
    open(resolv_conf_filename, 'w').write("\n".join(new_resolv_conf_lines) + "\n")

# vim: sw=4 ts=4 et
