#!/usr/bin/python
import sys
from xml.dom.minidom import parse
import string
import os

dict = {}
for node in parse("properties.xml").getElementsByTagName("property"):
	name = node.attributes['name'].nodeValue
	data = node.attributes['value'].nodeValue
	dict[name.lower()] = data

hostname = dict['virtualmachine.admin.name']
dns_suffix = ''

if dict.has_key('virtualmachine.network.default'):
	default_network_offset = dict['virtualmachine.network.default']
	default_network = 'virtualmachine.network%s.dnssuffix' % default_network_offset
	if dict.has_key(default_network):
		dns_suffix = dict[default_network]

hostname = "%s.%s" % (hostname, dns_suffix)
hostname = hostname.rstrip('.')
os.system('esxcfg-advcfg -s ' + hostname + ' /Misc/HostName')

if dict.has_key('virtualmachine.network0.address'):
	ipaddr = dict['virtualmachine.network0.address']
	os.system('esxcfg-vmknic -i ' + ipaddr + ' -n 255.255.0.0 "Management Network"')
