//////////////////////////////////////////////////
// diskpart.js
//
// @author: Christopher Boumenot

/** utility **************************************/

function include(filename) {
    var fso = new ActiveXObject("Scripting.FileSystemObject");
    var f = fso.OpenTextFile(filename);
    var s = f.ReadAll();
    f.Close();
    return s;
};

/** include **************************************/

eval(include("drive_letters.js"));
eval(include("workitem1.js"));

/** class ****************************************/

function DiskFormat(letter, offset, bag) {
    var driveLabel = "VirtualMachine.Disk" + offset + ".Label";
    var driveFS = "VirtualMachine.Disk" + offset + ".FS";
    if (bag.exists(driveLabel)) {
		label = bag.get(driveLabel);
	}
	else {
		// default to string like "d-drive"
		label = letter + "-drive";
	}
    if (bag.exists(driveFS)) {
		FS = bag.get(driveFS);
	}
	else {
		// default to ntfs filesystem
		FS = "ntfs";
	}
	
	var wso = new ActiveXObject("WScript.Shell");
	
	// build the command string, add format options if present
    var theCommand = "%comspec% /c format " + letter + ": /fs:" + FS + " /q /v:" + label + " /y";
	if (bag.exists("Command.Format.Options")) {
		theCommand = theCommand + " " + bag.get("Command.Format.Options");
	}
	
	//theCommand = theCommand + " 2>&1";

	// run format command
    var p = wso.Run(theCommand, 1, true);
    //WScript.Echo(p.StdOut.ReadAll());
}


//////////////////////////////////////////////////
// main

try {
    dl = new DriveLetters();
    bag = new WorkItem("..\\workitem.xml");
    var WshShell = WScript.CreateObject("WScript.Shell");
	var keys = bag.getkeys();
    var osver = WshShell.RegRead("HKLM\\Software\\Microsoft\\Windows NT\\CurrentVersion\\CurrentVersion");
    var majorVer = osver.substring(0, 1);
	
	// If major version < 6 (e.g. XP), diskpart doesn't do format
	// so we have to run format command after diskpart completes
	if (majorVer < 6) {
		var wmi = GetObject("winmgmts://./root/cimv2");    
		var physicalDisks = new Enumerator(wmi.ExecQuery("SELECT * FROM Win32_DiskDrive"));
	
		// skip c: drive
		physicalDisks.moveNext();
		for ( ; !physicalDisks.atEnd(); physicalDisks.moveNext()) {

			var physicalDisk = physicalDisks.item();
			var strCount = physicalDisk.DeviceID.substring(physicalDisk.DeviceID.search(/[0-9]/));
		
			if (strCount == "0") {
				continue;
			}

			var foundIt = false;
			for (var ii = 0; ii < keys.length; ii++) {
				if (keys[ii].indexOf("virtualmachine.disk" + strCount) == 0) {
					foundIt = true;
					break;
				}
			}
			
			if (!foundIt) {
				continue;
			}

			// don't try to format if this is a cloned disk
			if (bag.exists("VirtualMachine.disk" + strCount + ".isclone")) {
				if (bag.get("VirtualMachine.disk" + strCount + ".isclone").toLowerCase() == "true") {
					continue;
				}
			}

			// get disk letter, drop ":" character
			var letter;
			var driveLetter = "VirtualMachine.Disk" + strCount + ".Letter";
			if (bag.exists(driveLetter)) {
				letter = bag.get(driveLetter).substr(0, 1).toUpperCase();
				dl.allocate(letter);
			}
			else {
				letter = dl.getNextLocal();
			}
			// run format on the disk
			DiskFormat(letter, parseInt(strCount), bag);
		}
    }
} catch (e) {
    throw e;
}

