//////////////////////////////////////////////////
// workitem.js
//
// @author: Christopher Boumenot

function WorkItem(filename) {
    this.load = function(filename) {
		this.props = new Array();
		this.keys = new Array();

		var xml = new ActiveXObject("Microsoft.XMLDOM");
		xml.async = false;
		xml.load(filename);

		if (xml.parseError.errorCode != 0) {
			throw Error(xml.parseError.errorCode, xml.parseError.reason);
		}

		var wiNode = xml.selectSingleNode("/workitem");
		if (wiNode != null) {
			this.wiId = wiNode.getAttribute("id");
			this.wiTaskType = wiNode.getAttribute("type");
		}

		var nodes = xml.selectNodes("/workitem/properties/property");
		for (var i = 0; i < nodes.length; i++) {
			name = nodes[i].getAttribute("name");
			value = nodes[i].getAttribute("value");
			this.props[name.toLowerCase()] = value;
			this.keys[i] = name.toLowerCase();
		}
    };

this.exists = function(name) {
	return (name.toLowerCase() in this.props);
};

this.get = function(name) {
	return this.props[name.toLowerCase()];
};
	
this.getkeys = function () {
	return this.keys;
};

this.getID = function () {
	return this.wiId;
};

this.getType = function () {
	return this.wiTaskType;
};

// c-tor
this.load(filename);
}
