#!/usr/bin/python
import os, sys
from bag import Bag
from interface import RedHatInterface

ifcfg_eth_template = '/etc/sysconfig/network-scripts/ifcfg-eth%d'
if len(sys.argv) > 1:
    ifcfg_eth_template = sys.argv[1]

bag = Bag('properties.xml')

for i in range(32):
    sysfs_eth = '/sys/class/net/eth%s' % i

    if not os.path.exists(sysfs_eth):
        break

    if bag.has_key('VirtualMachine.Network%s.Address' % i):
        ifcfg_eth = ifcfg_eth_template % i
        ifcfg_eth_lines = []
        if os.path.exists(ifcfg_eth):
            ifcfg_eth_lines = open(ifcfg_eth).readlines()

        intf = RedHatInterface(bag, i)

        s = "\n".join(intf.lines(ifcfg_eth_lines)) + "\n"
        open(ifcfg_eth, 'w').write(s)

# vim: sw=4 ts=4 et
