/*
 * Decompiled with CFR 0.152.
 */
package org.hyperic.hq.hqapi1;

import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import org.hyperic.hq.hqapi1.BaseApi;
import org.hyperic.hq.hqapi1.HQConnection;
import org.hyperic.hq.hqapi1.XmlResponseHandler;
import org.hyperic.hq.hqapi1.types.AlertDefinition;
import org.hyperic.hq.hqapi1.types.AlertDefinitionResponse;
import org.hyperic.hq.hqapi1.types.AlertDefinitionsRequest;
import org.hyperic.hq.hqapi1.types.AlertDefinitionsResponse;
import org.hyperic.hq.hqapi1.types.Escalation;
import org.hyperic.hq.hqapi1.types.Resource;
import org.hyperic.hq.hqapi1.types.ResourcesRequest;
import org.hyperic.hq.hqapi1.types.StatusResponse;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AlertDefinitionApi
extends BaseApi {
    AlertDefinitionApi(HQConnection conn) {
        super(conn);
    }

    public AlertDefinitionResponse getAlertDefinition(Integer id) throws IOException {
        HashMap<String, String[]> params = new HashMap<String, String[]>();
        params.put("id", new String[]{id.toString()});
        return this.doGet("alertdefinition/get.hqu", params, new XmlResponseHandler<AlertDefinitionResponse>(AlertDefinitionResponse.class));
    }

    public AlertDefinitionsResponse getAlertDefinitions(boolean excludeTypeBased, Escalation escalation, String alertNameFilter, String resourceNameFilter, String groupName) throws IOException {
        HashMap<String, String[]> params = new HashMap<String, String[]>();
        params.put("excludeTypeBased", new String[]{Boolean.toString(excludeTypeBased)});
        if (alertNameFilter != null) {
            params.put("alertNameFilter", new String[]{alertNameFilter});
        }
        if (resourceNameFilter != null) {
            params.put("resourceNameFilter", new String[]{resourceNameFilter});
        }
        if (groupName != null) {
            params.put("groupName", new String[]{groupName});
        }
        if (escalation != null) {
            params.put("escalationId", new String[]{Integer.toString(escalation.getId())});
        }
        return this.doGet("alertdefinition/listDefinitions.hqu", params, new XmlResponseHandler<AlertDefinitionsResponse>(AlertDefinitionsResponse.class));
    }

    public AlertDefinitionsResponse getAlertDefinitions(boolean excludeTypeBased) throws IOException {
        return this.getAlertDefinitions(excludeTypeBased, null, null, null, null);
    }

    public AlertDefinitionsResponse getAlertDefinitions(AlertDefinition parent) throws IOException {
        HashMap<String, String[]> params = new HashMap<String, String[]>();
        params.put("parentId", new String[]{Integer.toString(parent.getId())});
        return this.doGet("alertdefinition/listDefinitions.hqu", params, new XmlResponseHandler<AlertDefinitionsResponse>(AlertDefinitionsResponse.class));
    }

    public AlertDefinitionsResponse getAlertDefinitions(Resource r, boolean children) throws IOException {
        HashMap<String, String[]> params = new HashMap<String, String[]>();
        params.put("resourceId", new String[]{Integer.toString(r.getId())});
        params.put("children", new String[]{Boolean.toString(children)});
        return this.doGet("alertdefinition/listDefinitions.hqu", params, new XmlResponseHandler<AlertDefinitionsResponse>(AlertDefinitionsResponse.class));
    }

    public AlertDefinitionsResponse getAlertDefinitions(List<Resource> resources) throws IOException {
        ResourcesRequest request = new ResourcesRequest();
        request.getResource().addAll(resources);
        return this.doPost("alertdefinition/listDefinitionsByResources.hqu", request, new XmlResponseHandler<AlertDefinitionsResponse>(AlertDefinitionsResponse.class));
    }

    public AlertDefinitionsResponse getTypeAlertDefinitions(boolean excludeIds) throws IOException {
        HashMap<String, String[]> params = new HashMap<String, String[]>();
        params.put("excludeIds", new String[]{Boolean.toString(excludeIds)});
        return this.doGet("alertdefinition/listTypeDefinitions.hqu", params, new XmlResponseHandler<AlertDefinitionsResponse>(AlertDefinitionsResponse.class));
    }

    public StatusResponse deleteAlertDefinition(int id) throws IOException {
        HashMap<String, String[]> params = new HashMap<String, String[]>();
        params.put("id", new String[]{Integer.toString(id)});
        return this.doGet("alertdefinition/delete.hqu", params, new XmlResponseHandler<StatusResponse>(StatusResponse.class));
    }

    public AlertDefinitionsResponse syncAlertDefinitions(List<AlertDefinition> definitions) throws IOException {
        AlertDefinitionsRequest request = new AlertDefinitionsRequest();
        request.getAlertDefinition().addAll(definitions);
        return this.doPost("alertdefinition/sync.hqu", request, new XmlResponseHandler<AlertDefinitionsResponse>(AlertDefinitionsResponse.class));
    }
}

