/*
 * Decompiled with CFR 0.152.
 */
package org.hyperic.hq.hqapi1;

import java.io.IOException;
import java.util.HashMap;
import org.hyperic.hq.hqapi1.BaseApi;
import org.hyperic.hq.hqapi1.HQConnection;
import org.hyperic.hq.hqapi1.XmlResponseHandler;
import org.hyperic.hq.hqapi1.types.ControlActionResponse;
import org.hyperic.hq.hqapi1.types.ControlHistoryResponse;
import org.hyperic.hq.hqapi1.types.Group;
import org.hyperic.hq.hqapi1.types.Resource;
import org.hyperic.hq.hqapi1.types.StatusResponse;

public class ControlApi
extends BaseApi {
    ControlApi(HQConnection conn) {
        super(conn);
    }

    public ControlHistoryResponse getHistory(Resource r) throws IOException {
        return this.getHistory(r.getId());
    }

    public ControlHistoryResponse getHistory(Group g) throws IOException {
        return this.getHistory(g.getResourceId());
    }

    private ControlHistoryResponse getHistory(Integer resourceId) throws IOException {
        HashMap<String, String[]> params = new HashMap<String, String[]>();
        params.put("resourceId", new String[]{Integer.toString(resourceId)});
        return this.doGet("control/history.hqu", params, new XmlResponseHandler<ControlHistoryResponse>(ControlHistoryResponse.class));
    }

    public ControlActionResponse getActions(Resource r) throws IOException {
        return this.getActions(r.getId());
    }

    public ControlActionResponse getActions(Group g) throws IOException {
        return this.getActions(g.getResourceId());
    }

    private ControlActionResponse getActions(Integer resourceId) throws IOException {
        HashMap<String, String[]> params = new HashMap<String, String[]>();
        params.put("resourceId", new String[]{Integer.toString(resourceId)});
        return this.doGet("control/actions.hqu", params, new XmlResponseHandler<ControlActionResponse>(ControlActionResponse.class));
    }

    public StatusResponse executeAction(Resource r, String action, String[] arguments) throws IOException {
        return this.executeAction(r.getId(), action, arguments);
    }

    public StatusResponse executeAction(Group g, String action, String[] arguments) throws IOException {
        return this.executeAction(g.getResourceId(), action, arguments);
    }

    private StatusResponse executeAction(Integer resourceId, String action, String[] arguments) throws IOException {
        HashMap<String, String[]> params = new HashMap<String, String[]>();
        params.put("resourceId", new String[]{Integer.toString(resourceId)});
        params.put("action", new String[]{action});
        params.put("arguments", arguments);
        return this.doGet("control/execute.hqu", params, new XmlResponseHandler<StatusResponse>(StatusResponse.class));
    }
}

