/*
 * Decompiled with CFR 0.152.
 */
package org.hyperic.hq.hqapi1;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLEncoder;
import java.nio.charset.Charset;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.UnrecoverableKeyException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Map;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLPeerUnverifiedException;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509TrustManager;
import javax.xml.bind.JAXBException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.HttpEntity;
import org.apache.http.HttpHost;
import org.apache.http.HttpResponse;
import org.apache.http.auth.AuthScheme;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.HttpClient;
import org.apache.http.client.HttpRequestRetryHandler;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.conn.scheme.Scheme;
import org.apache.http.conn.scheme.SchemeSocketFactory;
import org.apache.http.conn.ssl.AllowAllHostnameVerifier;
import org.apache.http.conn.ssl.SSLSocketFactory;
import org.apache.http.conn.ssl.X509HostnameVerifier;
import org.apache.http.entity.mime.FormBodyPart;
import org.apache.http.entity.mime.HttpMultipartMode;
import org.apache.http.entity.mime.MultipartEntity;
import org.apache.http.entity.mime.content.ContentBody;
import org.apache.http.entity.mime.content.FileBody;
import org.apache.http.entity.mime.content.StringBody;
import org.apache.http.impl.auth.BasicScheme;
import org.apache.http.impl.client.BasicAuthCache;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.impl.client.DefaultHttpRequestRetryHandler;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.protocol.BasicHttpContext;
import org.apache.http.protocol.HttpContext;
import org.hyperic.hq.hqapi1.Connection;
import org.hyperic.hq.hqapi1.ResponseHandler;
import org.hyperic.hq.hqapi1.XmlUtil;
import org.hyperic.hq.hqapi1.types.ServiceError;
import org.springframework.util.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class HQConnection
implements Connection {
    private static Log _log = LogFactory.getLog(HQConnection.class);
    private String _host;
    private int _port;
    private boolean _isSecure;
    private String _user;
    private String _password;

    HQConnection(URI uri, String user, String password) {
        this(uri.getHost(), uri.getPort(), uri.getScheme().equalsIgnoreCase("https"), user, password);
    }

    HQConnection(String host, int port, boolean isSecure, String user, String password) {
        this._host = host;
        this._port = port;
        this._isSecure = isSecure;
        this._user = user;
        this._password = password;
    }

    private String urlEncode(String s) throws IOException {
        return URLEncoder.encode(s, "UTF-8");
    }

    @Override
    public <T> T doGet(String path, Map<String, String[]> params, ResponseHandler<T> responseHandler) throws IOException {
        return this.runMethod((HttpRequestBase)new HttpGet(), this.buildUri(path, params), responseHandler);
    }

    private String buildUri(String path, Map<String, String[]> params) throws IOException {
        StringBuffer uri = new StringBuffer(path);
        if (uri.charAt(uri.length() - 1) != '?') {
            uri.append("?");
        }
        boolean append = false;
        for (Map.Entry<String, String[]> e : params.entrySet()) {
            for (String val : e.getValue()) {
                if (val == null) continue;
                if (append) {
                    uri.append("&");
                }
                uri.append(e.getKey()).append("=").append(this.urlEncode(val));
                append = true;
            }
        }
        return uri.toString();
    }

    @Override
    public <T> T doGet(String path, Map<String, String[]> params, File targetFile, ResponseHandler<T> responseHandler) throws IOException {
        return this.runMethod((HttpRequestBase)new HttpGet(), this.buildUri(path, params), responseHandler);
    }

    @Override
    public <T> T doPost(String path, Map<String, String[]> params, ResponseHandler<T> responseHandler) throws IOException {
        HttpPost post = new HttpPost();
        if (params != null && !params.isEmpty()) {
            ArrayList<BasicNameValuePair> postParams = new ArrayList<BasicNameValuePair>();
            for (Map.Entry<String, String[]> entry : params.entrySet()) {
                for (String value : entry.getValue()) {
                    postParams.add(new BasicNameValuePair(entry.getKey(), value));
                }
            }
            post.setEntity((HttpEntity)new UrlEncodedFormEntity(postParams, "UTF-8"));
        }
        return this.runMethod((HttpRequestBase)post, this.buildUri(path, params), responseHandler);
    }

    @Override
    public <T> T doPost(String path, Map<String, String> params, File file, ResponseHandler<T> responseHandler) throws IOException {
        HttpPost post = new HttpPost();
        MultipartEntity multipartEntity = new MultipartEntity(HttpMultipartMode.BROWSER_COMPATIBLE);
        multipartEntity.addPart(file.getName(), (ContentBody)new FileBody(file));
        for (Map.Entry<String, String> paramEntry : params.entrySet()) {
            multipartEntity.addPart(new FormBodyPart(paramEntry.getKey(), (ContentBody)new StringBody(paramEntry.getValue())));
        }
        post.setEntity((HttpEntity)multipartEntity);
        return this.runMethod((HttpRequestBase)post, path, responseHandler);
    }

    @Override
    public <T> T doPost(String path, Object o, ResponseHandler<T> responseHandler) throws IOException {
        HttpPost post = new HttpPost();
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        try {
            XmlUtil.serialize(o, bos, Boolean.FALSE);
        }
        catch (JAXBException e) {
            ServiceError error = new ServiceError();
            error.setErrorCode("UnexpectedError");
            error.setReasonText("Unable to serialize response");
            if (_log.isDebugEnabled()) {
                _log.debug((Object)"Unable to serialize response", (Throwable)e);
            }
            return responseHandler.getErrorResponse(error);
        }
        MultipartEntity multipartEntity = new MultipartEntity(HttpMultipartMode.BROWSER_COMPATIBLE);
        multipartEntity.addPart("postdata", (ContentBody)new StringBody(bos.toString("UTF-8"), Charset.forName("UTF-8")));
        post.setEntity((HttpEntity)multipartEntity);
        return this.runMethod((HttpRequestBase)post, path, responseHandler);
    }

    private <T> T runMethod(HttpRequestBase method, String uri, ResponseHandler<T> responseHandler) throws IOException {
        String protocol = this._isSecure ? "https" : "http";
        URL url = new URL(protocol, this._host, this._port, uri);
        try {
            method.setURI(url.toURI());
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException("The syntax of request url [" + uri + "] is invalid", e);
        }
        _log.debug((Object)("Setting URI: " + url.toString()));
        DefaultHttpClient client = new DefaultHttpClient();
        if (this._isSecure) {
            this.configureSSL((HttpClient)client);
        }
        if (this._user == null || this._user.length() == 0) {
            ServiceError error = new ServiceError();
            error.setErrorCode("LoginFailure");
            error.setReasonText("User name cannot be null or empty");
            return responseHandler.getErrorResponse(error);
        }
        if (this._password == null || this._password.length() == 0) {
            ServiceError error = new ServiceError();
            error.setErrorCode("LoginFailure");
            error.setReasonText("Password cannot be null or empty");
            return responseHandler.getErrorResponse(error);
        }
        UsernamePasswordCredentials defaultcreds = new UsernamePasswordCredentials(this._user, this._password);
        client.getCredentialsProvider().setCredentials(AuthScope.ANY, (Credentials)defaultcreds);
        BasicAuthCache authCache = new BasicAuthCache();
        BasicScheme basicAuth = new BasicScheme();
        HttpHost host = new HttpHost(this._host, this._port, protocol);
        authCache.put(host, (AuthScheme)basicAuth);
        BasicHttpContext localContext = new BasicHttpContext();
        localContext.setAttribute("http.auth.auth-cache", (Object)authCache);
        method.getParams().setParameter("http.protocol.handle-authentication", (Object)true);
        method.getParams().setParameter("http.auth.credential-charset", (Object)"UTF-8");
        client.setHttpRequestRetryHandler((HttpRequestRetryHandler)new DefaultHttpRequestRetryHandler(0, true));
        HttpResponse response = client.execute((HttpUriRequest)method, (HttpContext)localContext);
        return responseHandler.handleResponse(response);
    }

    private KeyStore getKeyStore(String keyStorePath, String keyStorePassword) throws KeyStoreException, IOException {
        FileInputStream keyStoreFileInputStream = null;
        try {
            KeyStore keystore = KeyStore.getInstance(KeyStore.getDefaultType());
            File file = new File(keyStorePath);
            char[] password = null;
            if (!file.exists()) {
                if (StringUtils.hasText((String)keyStorePath)) {
                    throw new IOException("User specified keystore [" + keyStorePath + "] does not exist.");
                }
                password = keyStorePassword.toCharArray();
            }
            keyStoreFileInputStream = new FileInputStream(file);
            keystore.load(keyStoreFileInputStream, password);
            KeyStore keyStore = keystore;
            return keyStore;
        }
        catch (NoSuchAlgorithmException e) {
            throw new KeyStoreException(e);
        }
        catch (CertificateException e) {
            throw new KeyStoreException(e);
        }
        finally {
            if (keyStoreFileInputStream != null) {
                keyStoreFileInputStream.close();
                keyStoreFileInputStream = null;
            }
        }
    }

    private KeyManagerFactory getKeyManagerFactory(KeyStore keystore, String password) throws KeyStoreException {
        try {
            KeyManagerFactory keyManagerFactory = KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
            keyManagerFactory.init(keystore, password.toCharArray());
            return keyManagerFactory;
        }
        catch (NoSuchAlgorithmException e) {
            throw new KeyStoreException(e);
        }
        catch (UnrecoverableKeyException e) {
            throw new KeyStoreException(e);
        }
    }

    private TrustManagerFactory getTrustManagerFactory(KeyStore keystore) throws KeyStoreException, IOException {
        try {
            TrustManagerFactory trustManagerFactory = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
            trustManagerFactory.init(keystore);
            return trustManagerFactory;
        }
        catch (NoSuchAlgorithmException e) {
            throw new KeyStoreException(e);
        }
    }

    private void configureSSL(HttpClient client) throws IOException {
        String keyStorePath = System.getProperty("javax.net.ssl.keyStore");
        String keyStorePassword = System.getProperty("javax.net.ssl.keyStorePassword");
        boolean validateSSLCertificates = StringUtils.hasText((String)keyStorePath) && StringUtils.hasText((String)keyStorePassword);
        X509TrustManager customTrustManager = null;
        KeyManager[] keyManagers = null;
        try {
            if (validateSSLCertificates) {
                KeyStore keystore = this.getKeyStore(keyStorePath, keyStorePassword);
                KeyManagerFactory keyManagerFactory = this.getKeyManagerFactory(keystore, keyStorePassword);
                TrustManagerFactory trustManagerFactory = this.getTrustManagerFactory(keystore);
                keyManagers = keyManagerFactory.getKeyManagers();
                customTrustManager = (X509TrustManager)trustManagerFactory.getTrustManagers()[0];
            } else {
                customTrustManager = new X509TrustManager(){

                    public void checkClientTrusted(X509Certificate[] chain, String authType) {
                    }

                    public void checkServerTrusted(X509Certificate[] chain, String authType) {
                    }

                    public boolean isClientTrusted(X509Certificate[] chain) {
                        return true;
                    }

                    public boolean isServerTrusted(X509Certificate[] chain) {
                        return true;
                    }

                    public X509Certificate[] getAcceptedIssuers() {
                        return null;
                    }
                };
            }
            SSLContext sslContext = SSLContext.getInstance("TLS");
            sslContext.init(keyManagers, new TrustManager[]{customTrustManager}, new SecureRandom());
            Object hostnameVerifier = null;
            hostnameVerifier = validateSSLCertificates ? new AllowAllHostnameVerifier() : new X509HostnameVerifier(){
                private AllowAllHostnameVerifier internalVerifier = new AllowAllHostnameVerifier();

                public boolean verify(String host, SSLSession session) {
                    return this.internalVerifier.verify(host, session);
                }

                public void verify(String host, String[] cns, String[] subjectAlts) throws SSLException {
                    this.internalVerifier.verify(host, cns, subjectAlts);
                }

                public void verify(String host, X509Certificate cert) throws SSLException {
                    this.internalVerifier.verify(host, cert);
                }

                public void verify(String host, SSLSocket ssl) throws IOException {
                    try {
                        this.internalVerifier.verify(host, ssl);
                    }
                    catch (SSLPeerUnverifiedException sSLPeerUnverifiedException) {
                        // empty catch block
                    }
                }
            };
            client.getConnectionManager().getSchemeRegistry().register(new Scheme("https", 443, (SchemeSocketFactory)new SSLSocketFactory(sslContext, (X509HostnameVerifier)hostnameVerifier)));
        }
        catch (Exception e) {
            throw new IOException(e);
        }
    }
}

