/*
 * Decompiled with CFR 0.152.
 */
package org.hyperic.hq.hqapi1;

import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import org.hyperic.hq.hqapi1.BaseApi;
import org.hyperic.hq.hqapi1.HQConnection;
import org.hyperic.hq.hqapi1.XmlResponseHandler;
import org.hyperic.hq.hqapi1.types.DataPoint;
import org.hyperic.hq.hqapi1.types.DataPointsRequest;
import org.hyperic.hq.hqapi1.types.Group;
import org.hyperic.hq.hqapi1.types.LastMetricDataResponse;
import org.hyperic.hq.hqapi1.types.LastMetricsDataResponse;
import org.hyperic.hq.hqapi1.types.Metric;
import org.hyperic.hq.hqapi1.types.MetricDataResponse;
import org.hyperic.hq.hqapi1.types.MetricsDataResponse;
import org.hyperic.hq.hqapi1.types.MetricsDataSummaryResponse;
import org.hyperic.hq.hqapi1.types.Resource;
import org.hyperic.hq.hqapi1.types.StatusResponse;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MetricDataApi
extends BaseApi {
    MetricDataApi(HQConnection conn) {
        super(conn);
    }

    public MetricDataResponse getData(Metric metric, long start, long end) throws IOException {
        HashMap<String, String[]> params = new HashMap<String, String[]>();
        params.put("id", new String[]{Integer.toString(metric.getId())});
        params.put("start", new String[]{Long.toString(start)});
        params.put("end", new String[]{Long.toString(end)});
        return this.doGet("metricData/get.hqu", params, new XmlResponseHandler<MetricDataResponse>(MetricDataResponse.class));
    }

    public LastMetricDataResponse getData(Metric metric) throws IOException {
        HashMap<String, String[]> params = new HashMap<String, String[]>();
        params.put("id", new String[]{Integer.toString(metric.getId())});
        return this.doGet("metricData/getLast.hqu", params, new XmlResponseHandler<LastMetricDataResponse>(LastMetricDataResponse.class));
    }

    public MetricsDataResponse getData(List<Metric> metrics, long start, long end) throws IOException {
        HashMap<String, String[]> params = new HashMap<String, String[]>();
        String[] ids = new String[metrics.size()];
        for (int i = 0; i < metrics.size(); ++i) {
            ids[i] = Integer.toString(metrics.get(i).getId());
        }
        params.put("id", ids);
        params.put("start", new String[]{Long.toString(start)});
        params.put("end", new String[]{Long.toString(end)});
        return this.doGet("metricData/getMulti.hqu", params, new XmlResponseHandler<MetricsDataResponse>(MetricsDataResponse.class));
    }

    public LastMetricsDataResponse getData(List<Metric> metrics) throws IOException {
        HashMap<String, String[]> params = new HashMap<String, String[]>();
        String[] ids = new String[metrics.size()];
        for (int i = 0; i < metrics.size(); ++i) {
            ids[i] = Integer.toString(metrics.get(i).getId());
        }
        params.put("id", ids);
        return this.doGet("metricData/getMultiLast.hqu", params, new XmlResponseHandler<LastMetricsDataResponse>(LastMetricsDataResponse.class));
    }

    public MetricsDataSummaryResponse getSummary(Resource resource, long start, long end) throws IOException {
        return this.getSummary(resource.getId(), start, end);
    }

    public MetricsDataSummaryResponse getSummary(Group group, long start, long end) throws IOException {
        return this.getSummary(group.getResourceId(), start, end);
    }

    private MetricsDataSummaryResponse getSummary(Integer resourceId, long start, long end) throws IOException {
        HashMap<String, String[]> params = new HashMap<String, String[]>();
        params.put("resourceId", new String[]{resourceId.toString()});
        params.put("start", new String[]{Long.toString(start)});
        params.put("end", new String[]{Long.toString(end)});
        return this.doGet("metricData/getSummary.hqu", params, new XmlResponseHandler<MetricsDataSummaryResponse>(MetricsDataSummaryResponse.class));
    }

    public StatusResponse addData(Metric metric, List<DataPoint> data) throws IOException {
        DataPointsRequest request = new DataPointsRequest();
        request.setMetricId(metric.getId());
        request.getDataPoint().addAll(data);
        return this.doPost("metricData/put.hqu", request, new XmlResponseHandler<StatusResponse>(StatusResponse.class));
    }
}

