/*
 * Decompiled with CFR 0.152.
 */
package org.hyperic.hq.hqapi1;

import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import org.hyperic.hq.hqapi1.BaseApi;
import org.hyperic.hq.hqapi1.HQConnection;
import org.hyperic.hq.hqapi1.XmlResponseHandler;
import org.hyperic.hq.hqapi1.types.ResourceEdge;
import org.hyperic.hq.hqapi1.types.ResourceEdgesRequest;
import org.hyperic.hq.hqapi1.types.ResourceEdgesResponse;
import org.hyperic.hq.hqapi1.types.ResourcesResponse;
import org.hyperic.hq.hqapi1.types.StatusResponse;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ResourceEdgeApi
extends BaseApi {
    ResourceEdgeApi(HQConnection conn) {
        super(conn);
    }

    public ResourceEdgesResponse getResourceEdges(String resourceRelation, Integer resourceId, String prototype, String name) throws IOException {
        HashMap<String, String[]> params = new HashMap<String, String[]>();
        params.put("resourceRelation", new String[]{resourceRelation});
        params.put("prototype", new String[]{prototype});
        params.put("name", new String[]{name});
        if (resourceId != null) {
            params.put("id", new String[]{resourceId.toString()});
        }
        return this.doGet("resource/getResourceEdges.hqu", params, new XmlResponseHandler<ResourceEdgesResponse>(ResourceEdgesResponse.class));
    }

    public ResourcesResponse getParentResourcesByRelation(String resourceRelation, String prototype, String name, boolean hasChildren) throws IOException {
        HashMap<String, String[]> params = new HashMap<String, String[]>();
        params.put("prototype", new String[]{prototype});
        params.put("name", new String[]{name});
        params.put("resourceRelation", new String[]{resourceRelation});
        params.put("hasChildren", new String[]{Boolean.valueOf(hasChildren).toString()});
        return this.doGet("resource/getParentResourcesByRelation.hqu", params, new XmlResponseHandler<ResourcesResponse>(ResourcesResponse.class));
    }

    public ResourcesResponse getResourcesByNoRelation(String resourceRelation, String prototype, String name) throws IOException {
        HashMap<String, String[]> params = new HashMap<String, String[]>();
        params.put("prototype", new String[]{prototype});
        params.put("name", new String[]{name});
        params.put("resourceRelation", new String[]{resourceRelation});
        return this.doGet("resource/getResourcesByNoRelation.hqu", params, new XmlResponseHandler<ResourcesResponse>(ResourcesResponse.class));
    }

    public StatusResponse syncResourceEdges(List<ResourceEdge> edges) throws IOException {
        ResourceEdgesRequest request = new ResourceEdgesRequest();
        request.getResourceEdge().addAll(edges);
        return this.doPost("resource/syncResourceEdges.hqu", request, new XmlResponseHandler<StatusResponse>(StatusResponse.class));
    }

    public StatusResponse createResourceEdges(List<ResourceEdge> edges) throws IOException {
        ResourceEdgesRequest request = new ResourceEdgesRequest();
        request.getResourceEdge().addAll(edges);
        return this.doPost("resource/createResourceEdges.hqu", request, new XmlResponseHandler<StatusResponse>(StatusResponse.class));
    }

    public StatusResponse deleteResourceEdges(List<ResourceEdge> edges) throws IOException {
        ResourceEdgesRequest request = new ResourceEdgesRequest();
        request.getResourceEdge().addAll(edges);
        return this.doPost("resource/deleteResourceEdges.hqu", request, new XmlResponseHandler<StatusResponse>(StatusResponse.class));
    }

    public StatusResponse deleteResourceEdges(String resourceRelation, int id) throws IOException {
        HashMap<String, String[]> params = new HashMap<String, String[]>();
        params.put("resourceRelation", new String[]{resourceRelation});
        params.put("id", new String[]{Integer.toString(id)});
        return this.doGet("resource/deleteAllResourceEdges.hqu", params, new XmlResponseHandler<StatusResponse>(StatusResponse.class));
    }
}

