/*
 * Decompiled with CFR 0.152.
 */
package org.hyperic.hq.plugin.db2jdbc;

import java.util.ArrayList;
import java.util.List;
import org.hyperic.hq.plugin.db2jdbc.DataBaseServerDetector;
import org.hyperic.hq.product.PluginException;
import org.hyperic.hq.product.ServiceResource;
import org.hyperic.util.config.ConfigResponse;

public class DataBase8ServerDetector
extends DataBaseServerDetector {
    protected List discoverServices(ConfigResponse config) throws PluginException {
        ArrayList<ServiceResource> res = new ArrayList<ServiceResource>();
        String type = this.getTypeInfo().getName();
        String schema = config.getValue("db2.jdbc.user").toUpperCase();
        for (String tbName : this.getList(config, "select TABLE_NAME from table (SNAPSHOT_TABLE('sample', -2)) as T")) {
            ServiceResource tb = new ServiceResource();
            tb.setType(type + " Table");
            tb.setServiceName("Table " + schema + "." + tbName);
            ConfigResponse conf = new ConfigResponse();
            conf.setValue("table", tbName);
            conf.setValue("schema", schema);
            this.setProductConfig(tb, conf);
            tb.setMeasurementConfig();
            tb.setResponseTimeConfig(new ConfigResponse());
            tb.setControlConfig();
            res.add(tb);
        }
        for (String tbspName : this.getList(config, "select TABLESPACE_NAME from table (SNAPSHOT_TBS('sample', -2)) as T")) {
            ServiceResource bpS = new ServiceResource();
            bpS.setType(type + " Table Space");
            bpS.setServiceName("Table Space " + tbspName);
            ConfigResponse conf = new ConfigResponse();
            conf.setValue("tablespace", tbspName);
            this.setProductConfig(bpS, conf);
            bpS.setMeasurementConfig();
            bpS.setResponseTimeConfig(new ConfigResponse());
            bpS.setControlConfig();
            res.add(bpS);
        }
        for (String bpName : this.getList(config, "select BP_NAME from table (SNAPSHOT_BP('sample', -2)) as T")) {
            ServiceResource bpS = new ServiceResource();
            bpS.setType(type + " Buffer Pool");
            bpS.setServiceName("Buffer Pool " + bpName);
            ConfigResponse conf = new ConfigResponse();
            conf.setValue("bufferpool", bpName);
            this.setProductConfig(bpS, conf);
            bpS.setMeasurementConfig();
            bpS.setResponseTimeConfig(new ConfigResponse());
            bpS.setControlConfig();
            res.add(bpS);
        }
        return res;
    }

    public List getServerResources(ConfigResponse pconf) {
        ArrayList res = new ArrayList();
        return res;
    }
}

