/*
 * Decompiled with CFR 0.152.
 */
package org.hyperic.hq.plugin.wsmq.cmd;

import com.ibm.mq.MQException;
import com.ibm.mq.pcf.PCFMessage;
import java.util.Arrays;
import java.util.List;
import java.util.Properties;
import org.hyperic.hq.plugin.wsmq.cmd.InquireDefault;
import org.hyperic.hq.product.Metric;
import org.hyperic.hq.product.MetricUnreachableException;

public class InquireChannel
extends InquireDefault {
    public static final String PROP_CH = "Channel";
    private static final int[] ATTRS = new int[]{1527, 1534, 1539, 1538, 1536, 1535};
    private static final List ATTR_NAMES = Arrays.asList("Availability", "Msgs", "BuffersReceived", "BuffersSent", "BytesReceived", "BytesSent");

    public PCFMessage getRequest(Properties properties) {
        this.getLog().debug((Object)("getRequest(" + properties + ")"));
        String chName = properties.getProperty(PROP_CH);
        this.getLog().debug((Object)("PCFConstants.MQCACH_CHANNEL_NAME => '" + chName + "'"));
        PCFMessage msg = new PCFMessage(42);
        msg.addParameter(3501, chName);
        return msg;
    }

    public List getAttributesName() {
        return ATTR_NAMES;
    }

    public int[] getAttributes() {
        return ATTRS;
    }

    public double processPCFExceptionForAvail(MQException e) throws MetricUnreachableException {
        this.getLog().debug((Object)("processPCFExceptionForAvail(" + e.getMessage() + ")"));
        if (e.reasonCode == 3065) {
            return -0.01;
        }
        assert (false) : e;
        throw new MetricUnreachableException(e.getMessage(), (Throwable)e);
    }

    public double processPCFExceptionForMetric(Metric metric, MQException e) throws MetricUnreachableException {
        this.getLog().debug((Object)("processPCFExceptionForMetric(" + metric.getAttributeName() + "," + e.getMessage() + ")"));
        if (e.reasonCode == 3065) {
            return Double.NaN;
        }
        assert (false) : e;
        throw new MetricUnreachableException(e.getMessage(), (Throwable)e);
    }

    public final double processValue(String metricName, PCFMessage[] responses) {
        double res = 0.0;
        int attr = this.getAttributes()[this.getAttributesName().indexOf(metricName)];
        for (int n = 0; n < responses.length; ++n) {
            PCFMessage response = responses[n];
            res += ((Integer)response.getParameterValue(attr)).doubleValue();
        }
        return res;
    }

    public double getAvail(PCFMessage[] responses) {
        assert (responses.length == 1) : responses.length;
        int res = (Integer)responses[0].getParameterValue(1527);
        this.getLog().debug((Object)("getAvail => res=" + res));
        switch (res) {
            case 3: {
                res = 1;
                break;
            }
            case 8: {
                res = 0;
                break;
            }
            default: {
                res = 0;
            }
        }
        return res;
    }
}

