/*
 * Decompiled with CFR 0.152.
 */
package org.hyperic.hq.plugin.wsmq.cmd;

import com.ibm.mq.MQException;
import com.ibm.mq.pcf.PCFMessage;
import com.ibm.mq.pcf.PCFMessageAgent;
import java.util.Arrays;
import java.util.List;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hyperic.hq.plugin.wsmq.MQSeriesProductPlugin;
import org.hyperic.hq.product.Metric;
import org.hyperic.hq.product.MetricNotFoundException;
import org.hyperic.hq.product.MetricUnreachableException;
import org.hyperic.hq.product.PluginException;

public abstract class InquireDefault {
    public static final String PROP_MGR = "Mgr";
    public static final String AVAIL = "Availability";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final Double getValue(Metric metric) throws PluginException, MetricNotFoundException, MetricUnreachableException {
        this.getLog().debug((Object)("getValue(" + metric + ")"));
        PCFMessage request = this.getRequest(metric.getObjectProperties());
        PCFMessageAgent agent = null;
        String metricName = metric.getAttributeName();
        double res = Double.NaN;
        try {
            String mgr = metric.getObjectProperties().getProperty(PROP_MGR);
            this.getLog().debug((Object)("mgr='" + mgr + "'"));
            try {
                agent = new PCFMessageAgent(mgr);
                PCFMessage[] responses = agent.send(request);
                if (MQSeriesProductPlugin.isTraceEnabled() && this.getLog().isDebugEnabled()) {
                    this.getLog().trace((Object)("responses = " + Arrays.asList(responses)));
                }
                res = this.getValue(metricName, responses);
            }
            catch (MQException ex) {
                this.getLog().debug((Object)("getValue error: " + ex.getMessage()));
                res = metric.isAvail() ? this._processPCFExceptionForAvail(ex) : this.processPCFExceptionForMetric(metric, ex);
            }
            catch (Exception ex) {
                assert (false) : ex;
                throw new MetricUnreachableException(metric.toString(), (Throwable)ex);
            }
        }
        finally {
            if (agent != null) {
                try {
                    agent.disconnect();
                }
                catch (MQException e) {
                    this.getLog().error((Object)("agent.disconnect() : " + e.getMessage()));
                }
            }
        }
        if (res == Double.NaN) {
            MetricUnreachableException ex = new MetricUnreachableException(metric.toString());
            assert (false) : ex;
            throw ex;
        }
        return new Double(res);
    }

    public final double getValue(String metricName, PCFMessage[] responses) {
        double res = -1.0;
        res = metricName.equals(AVAIL) ? this.getAvail(responses) : this.processValue(metricName, responses);
        return res;
    }

    public final Log getLog() {
        return LogFactory.getLog(this.getClass());
    }

    public abstract double processValue(String var1, PCFMessage[] var2);

    public abstract double getAvail(PCFMessage[] var1);

    private double _processPCFExceptionForAvail(MQException e) throws MetricUnreachableException {
        double res;
        assert (false) : e;
        switch (e.reasonCode) {
            case 2058: {
                this.getLog().error((Object)"!!! error !!! Bad QManager name.", (Throwable)e);
            }
            case 2059: {
                res = 0.0;
                break;
            }
            default: {
                res = this.processPCFExceptionForAvail(e);
            }
        }
        return res;
    }

    public double processPCFExceptionForMetric(Metric metric, MQException ex) throws MetricUnreachableException {
        throw new MetricUnreachableException(metric.toString(), (Throwable)ex);
    }

    public abstract double processPCFExceptionForAvail(MQException var1) throws MetricUnreachableException;

    public abstract int[] getAttributes();

    public abstract List getAttributesName();

    public abstract PCFMessage getRequest(Properties var1);

    static {
        MQException.logExclude((Integer)new Integer(2033));
        MQException.logExclude((Integer)new Integer(2085));
        MQException.logExclude((Integer)new Integer(2059));
        MQException.logExclude((Integer)new Integer(3308));
        MQException.logExclude((Integer)new Integer(3065));
    }
}

