/*
 * Decompiled with CFR 0.152.
 */
package org.hyperic.hq.autoinventory.scanimpl;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hyperic.hq.autoinventory.AutoinventoryException;
import org.hyperic.hq.autoinventory.ServerSignature;
import org.hyperic.hq.autoinventory.scanimpl.ScanMethodBase;
import org.hyperic.hq.product.PluginException;
import org.hyperic.hq.product.RegistryServerDetector;
import org.hyperic.hq.product.ServerDetector;
import org.hyperic.sigar.win32.RegistryKey;
import org.hyperic.sigar.win32.Win32Exception;
import org.hyperic.util.PluginLoader;
import org.hyperic.util.StringUtil;
import org.hyperic.util.config.ConfigOption;
import org.hyperic.util.config.ConfigResponse;
import org.hyperic.util.timer.StopWatch;

public class WindowsRegistryScan
extends ScanMethodBase {
    private ConfigResponse platformConfig;
    private Log _log = LogFactory.getLog((String)WindowsRegistryScan.class.getName());

    public WindowsRegistryScan() {
        this._authorityLevel = 7;
    }

    protected ConfigOption[] getOptionsArray() {
        return new ConfigOption[0];
    }

    public String getName() {
        return "RegistryScan";
    }

    public String getDisplayName() {
        return "Registry Scan";
    }

    public String getDescription() {
        return "Scan the Windows registry";
    }

    private String getPluginName(Object detector) {
        String name = detector.getClass().getName();
        int ix = name.lastIndexOf(".");
        return name.substring(ix + 1, name.length());
    }

    public void scan(ConfigResponse platformConfig, ServerDetector[] serverDetectors) throws AutoinventoryException {
        this.platformConfig = platformConfig;
        String scanName = "Windows Registry Scan";
        HashMap<String, ArrayList<RegistryServerDetector>> detectorMap = new HashMap<String, ArrayList<RegistryServerDetector>>();
        StopWatch timer = null;
        StopWatch totalTimer = null;
        boolean isDebug = this._log.isDebugEnabled();
        if (isDebug) {
            totalTimer = new StopWatch();
            timer = new StopWatch();
        }
        this._log.debug((Object)(scanName + " starting..."));
        this._state.setScanStatus(this, "scan started");
        for (int i = 0; i < serverDetectors.length; ++i) {
            if (!(serverDetectors[i] instanceof RegistryServerDetector)) continue;
            RegistryServerDetector detector = (RegistryServerDetector)((Object)serverDetectors[i]);
            List keys = detector.getRegistryScanKeys();
            for (int j = 0; j < keys.size(); ++j) {
                String key = (String)keys.get(j);
                ArrayList<RegistryServerDetector> detectors = (ArrayList<RegistryServerDetector>)detectorMap.get(key);
                if (detectors == null) {
                    detectors = new ArrayList<RegistryServerDetector>();
                    detectorMap.put(key, detectors);
                }
                detectors.add(detector);
            }
        }
        Iterator it = detectorMap.entrySet().iterator();
        while (it.hasNext()) {
            if (this._scanner.getIsInterrupted()) {
                this._log.info((Object)"Scanner interrupted.");
                return;
            }
            Map.Entry entry = it.next();
            String key = (String)entry.getKey();
            List detectors = (List)entry.getValue();
            String status = "scanning: " + key + " with " + detectors.size() + " detectors";
            this._state.setScanStatus(this, status);
            if (isDebug) {
                timer.reset();
            }
            this.recursiveSearch(detectors, key);
            if (!isDebug) continue;
            this._log.debug((Object)(status + " (took " + timer + ")"));
        }
        if (isDebug) {
            this._log.debug((Object)(scanName + " completed, took: " + totalTimer));
        }
        this._state.setScanStatus(this, scanName + " completed");
    }

    private RegistryKey openRootKey(String key) {
        try {
            return RegistryKey.LocalMachine.openSubKey(key);
        }
        catch (Win32Exception e) {
            this._log.debug((Object)("Could not open registry key '" + key + "': " + e.getMessage()));
            return null;
        }
    }

    private void recursiveSearch(List detectors, String key) {
        if (!key.endsWith("*")) {
            RegistryKey start = this.openRootKey(key);
            if (start == null) {
                return;
            }
            this.searchKey(detectors, start);
            return;
        }
        int ix = key.lastIndexOf("\\");
        if (ix == -1) {
            this._log.error((Object)("Malformed key pattern: " + key));
            return;
        }
        String root = key.substring(0, ix);
        key = key.substring(ix + 1, key.length() - 1);
        RegistryKey start = this.openRootKey(root);
        if (start == null) {
            return;
        }
        this._log.debug((Object)("Narrowing search of '" + root + "' to ^" + key + "*"));
        String[] keyNames = start.getSubKeyNames();
        for (int i = 0; i < keyNames.length; ++i) {
            RegistryKey subkey;
            if (!keyNames[i].startsWith(key)) continue;
            try {
                subkey = start.openSubKey(keyNames[i]);
            }
            catch (Win32Exception e) {
                this._log.debug((Object)("Could not open registry key '" + key + "'"));
                continue;
            }
            this.searchKey(detectors, subkey);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void searchValues(List detectors, RegistryKey curr) {
        for (int i = 0; i < detectors.size(); ++i) {
            RegistryServerDetector detector = (RegistryServerDetector)detectors.get(i);
            ServerSignature sig = ((ServerDetector)((Object)detector)).getServerSignature();
            String[] patterns = sig.getRegistryMatchPatterns();
            for (int j = 0; j < patterns.length; ++j) {
                List detectedServers;
                String matchValue;
                block13: {
                    try {
                        matchValue = curr.getStringValue(patterns[j]);
                        if (matchValue == null) break block13;
                        matchValue = matchValue.trim();
                    }
                    catch (Win32Exception e) {
                        continue;
                    }
                }
                String msg = "Error running " + this.getPluginName(detector) + ": ";
                PluginLoader.setClassLoader((Object)detector);
                try {
                    detectedServers = detector.getServerResources(this.platformConfig, matchValue, curr);
                }
                catch (PluginException e) {
                    this._log.error((Object)(msg + e.getMessage()), (Throwable)((Object)e));
                    continue;
                }
                catch (Exception e) {
                    detectedServers = null;
                    this._log.error((Object)("Unexpected " + msg + e.getMessage()), (Throwable)e);
                }
                catch (NoClassDefFoundError e) {
                    detectedServers = null;
                    this._log.error((Object)("NoClassDefFoundError " + msg + e.getMessage()), (Throwable)e);
                }
                finally {
                    PluginLoader.resetClassLoader((Object)detector);
                }
                if (detectedServers == null || detectedServers.size() <= 0) continue;
                this._log.debug((Object)("DETECTED SERVERS=" + StringUtil.listToString((List)detectedServers)));
                this._state.addServers(this, detectedServers);
            }
        }
    }

    private void searchKey(List detectors, RegistryKey curr) {
        this.searchValues(detectors, curr);
        this.searchNextKey(detectors, curr);
    }

    private void searchNextKey(List detectors, RegistryKey curr) {
        String[] keyNames = curr.getSubKeyNames();
        for (int i = 0; i < keyNames.length; ++i) {
            RegistryKey next = null;
            try {
                next = curr.openSubKey(keyNames[i]);
            }
            catch (Win32Exception e) {
                this._log.debug((Object)("Unable to open registry key: " + keyNames[i]));
                continue;
            }
            this.searchValues(detectors, next);
            this.searchNextKey(detectors, next);
        }
    }
}

