/*
 * Decompiled with CFR 0.152.
 */
package org.hyperic.hq.product;

import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hyperic.hq.product.Collector;
import org.hyperic.hq.product.LogTrackPlugin;
import org.hyperic.hq.product.MetricValue;

public class CollectorResult {
    private static Log log = LogFactory.getLog((String)CollectorResult.class.getName());
    boolean collected = false;
    boolean reported = false;
    long timestamp;
    int level = -1;
    String source;
    String message;
    HashMap values;

    CollectorResult() {
        this.timestamp = 0L;
        this.values = new HashMap();
    }

    CollectorResult(Collector collector) {
        this(collector.result);
    }

    CollectorResult(CollectorResult result) {
        this.timestamp = result.timestamp;
        this.level = result.level;
        this.source = result.source;
        this.message = result.message;
        this.values = new HashMap(result.values.size());
        this.values.putAll(result.values);
    }

    public long getTimeStamp() {
        return this.timestamp;
    }

    public int getLevel() {
        return this.level;
    }

    public String getSource() {
        return this.source;
    }

    public String getMessage() {
        return this.message;
    }

    public MetricValue getMetricValue(String attr) {
        Double doubleVal;
        Object value = Collector.getCompatValue(this.values, attr);
        if (value == null) {
            log.debug((Object)("Attribute '" + attr + "' not found"));
            return MetricValue.NONE;
        }
        if (value instanceof Double) {
            doubleVal = (Double)value;
        } else {
            try {
                doubleVal = Double.valueOf(value.toString());
            }
            catch (NumberFormatException e) {
                log.error((Object)("NumberFormatException: " + attr + "=" + value));
                return MetricValue.NONE;
            }
        }
        long timeNow = System.currentTimeMillis();
        return new MetricValue((Number)doubleVal, timeNow);
    }

    public Map getValues() {
        return this.values;
    }

    public void addValues(Map values) {
        this.values.putAll(values);
    }

    public void setValue(String key, double val) {
        this.values.put(key, new Double(val));
    }

    public void setValue(String key, String val) {
        this.values.put(key, val);
    }

    public String toString() {
        String msg = "(" + this.source + ") " + this.message;
        if (this.level != -1) {
            msg = "[" + LogTrackPlugin.getLogLevelLabel(this.level) + "] " + msg;
        }
        return new Date(this.timestamp) + " " + msg + " values=" + this.values;
    }
}

