/*
 * Decompiled with CFR 0.152.
 */
package org.hyperic.hq.product;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hyperic.hq.product.ConfigTrackPlugin;
import org.hyperic.hq.product.PluginException;
import org.hyperic.hq.product.TrackEvent;
import org.hyperic.hq.product.TypeInfo;
import org.hyperic.sigar.FileInfo;
import org.hyperic.sigar.FileWatcher;
import org.hyperic.sigar.Sigar;
import org.hyperic.sigar.SigarException;
import org.hyperic.util.StringUtil;
import org.hyperic.util.config.ConfigOption;
import org.hyperic.util.config.ConfigResponse;
import org.hyperic.util.config.ConfigSchema;
import org.hyperic.util.config.StringConfigOption;

public class ConfigFileTrackPlugin
extends ConfigTrackPlugin {
    private static Sigar sigar = null;
    static final String PROP_FILES = "config_track.files";
    private static final String[] FILES_PROPS = ConfigFileTrackPlugin.createTypeLabels("config_track.files");
    public static final String PROP_FILES_PLATFORM = FILES_PROPS[1];
    public static final String PROP_FILES_SERVER = FILES_PROPS[2];
    public static final String PROP_FILES_SERVICE = FILES_PROPS[3];
    protected static Log log = LogFactory.getLog((String)ConfigTrackPlugin.class.getName());
    protected FileWatcher watcher = null;

    static void cleanup() {
        if (sigar != null) {
            sigar.close();
        }
    }

    protected FileWatcher getFileWatcher() {
        if (this.watcher == null) {
            if (sigar == null) {
                sigar = new Sigar();
            }
            log.info((Object)("init file watcher for: " + this.getName()));
            this.watcher = new FileWatcher(sigar){

                public void onChange(FileInfo info) {
                    log.debug((Object)("Config file changed: " + info.getName()));
                    TrackEvent event = new TrackEvent(ConfigFileTrackPlugin.this.getName(), System.currentTimeMillis(), 6, info.getName(), info.diff());
                    ConfigFileTrackPlugin.this.getManager().reportEvent(event);
                }
            };
            this.getManager().addFileWatcher(this.watcher);
        }
        return this.watcher;
    }

    protected String getDefaultConfigFile(TypeInfo info, ConfigResponse config) {
        String file = this.getTypeProperty("DEFAULT_CONFIG_FILE");
        if (file == null) {
            return "";
        }
        file = info.isWin32Platform() ? StringUtil.replace((String)file, (String)"/", (String)"\\") : StringUtil.replace((String)file, (String)"\\", (String)"/");
        return file;
    }

    protected ConfigOption getFilesOption(TypeInfo info, ConfigResponse config) {
        StringConfigOption option = new StringConfigOption(FILES_PROPS[info.getType()], "Configuration Files", this.getDefaultConfigFile(info, config));
        option.setOptional(true);
        return option;
    }

    public ConfigSchema getConfigSchema(TypeInfo info, ConfigResponse config) {
        ConfigSchema schema = super.getConfigSchema(info, config);
        ConfigOption option = this.getFilesOption(info, config);
        if (option != null) {
            schema.addOption(option);
        }
        return schema;
    }

    public String[] getFiles(ConfigResponse config) {
        int type = this.getTypeInfo().getType();
        String files = config.getValue(FILES_PROPS[type]);
        String installpath = config.getValue("installpath");
        return this.getAbsoluteFiles(files, installpath);
    }

    public void configure(ConfigResponse config) throws PluginException {
        super.configure(config);
        try {
            this.getFileWatcher().add(this.getFiles(config));
        }
        catch (SigarException e) {
            throw new PluginException(e.getMessage(), e);
        }
    }

    public void shutdown() throws PluginException {
        if (this.watcher != null) {
            this.getManager().removeFileWatcher(this.watcher);
        }
        super.shutdown();
    }
}

