/*
 * Decompiled with CFR 0.152.
 */
package org.hyperic.hq.product;

import org.hyperic.hq.product.ConfigTrackPluginManager;
import org.hyperic.hq.product.GenericPlugin;
import org.hyperic.hq.product.PluginException;
import org.hyperic.hq.product.PluginManager;
import org.hyperic.hq.product.TypeInfo;
import org.hyperic.util.config.BooleanConfigOption;
import org.hyperic.util.config.ConfigOption;
import org.hyperic.util.config.ConfigResponse;
import org.hyperic.util.config.ConfigSchema;

public abstract class ConfigTrackPlugin
extends GenericPlugin {
    static final String PROP_ENABLE = "config_track.enable";
    private static final String[] ENABLE_PROPS = ConfigTrackPlugin.createTypeLabels("config_track.enable");
    private ConfigTrackPluginManager manager;

    public static boolean isEnabled(ConfigResponse config, int type) {
        String option = config.getValue(ENABLE_PROPS[type]);
        if (option == null) {
            return false;
        }
        return option.equals("true");
    }

    public static void setEnabled(ConfigResponse config, int type) {
        config.setValue(ENABLE_PROPS[type], "true");
    }

    protected ConfigOption getEnableOption(TypeInfo info, ConfigResponse config) {
        String defaultValue = this.getTypeProperty("DEFAULT_CONFIG_TRACK_ENABLE");
        boolean enable = "true".equals(defaultValue);
        BooleanConfigOption option = new BooleanConfigOption(ENABLE_PROPS[info.getType()], "Enable Config Tracking", enable);
        option.setOptional(true);
        return option;
    }

    public ConfigSchema getConfigSchema(TypeInfo info, ConfigResponse config) {
        ConfigSchema schema = new ConfigSchema();
        ConfigOption enableOption = this.getEnableOption(info, config);
        if (enableOption != null) {
            schema.addOption(enableOption);
        }
        return schema;
    }

    public void init(PluginManager manager) throws PluginException {
        super.init(manager);
        this.manager = (ConfigTrackPluginManager)manager;
    }

    public ConfigTrackPluginManager getManager() {
        return this.manager;
    }
}

