/*
 * Decompiled with CFR 0.152.
 */
package org.hyperic.hq.product;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hyperic.hq.product.GenericPlugin;
import org.hyperic.hq.product.LogMessageFolder;
import org.hyperic.hq.product.LogTrackPluginManager;
import org.hyperic.hq.product.PluginException;
import org.hyperic.hq.product.PluginManager;
import org.hyperic.hq.product.StringMatcher;
import org.hyperic.hq.product.TrackEvent;
import org.hyperic.hq.product.TypeInfo;
import org.hyperic.util.StringUtil;
import org.hyperic.util.config.BooleanConfigOption;
import org.hyperic.util.config.ConfigOption;
import org.hyperic.util.config.ConfigResponse;
import org.hyperic.util.config.ConfigSchema;
import org.hyperic.util.config.EnumerationConfigOption;
import org.hyperic.util.config.StringConfigOption;

public class LogTrackPlugin
extends GenericPlugin {
    private static HashMap logLevelCache = new HashMap();
    private static Log log = LogFactory.getLog((String)LogTrackPlugin.class.getName());
    static final boolean debugLogging = "true".equals(System.getProperty("log_track.debug"));
    public static final int LOGLEVEL_ANY = -1;
    public static final int LOGLEVEL_ERROR = 3;
    public static final int LOGLEVEL_WARN = 4;
    public static final int LOGLEVEL_INFO = 6;
    public static final int LOGLEVEL_DEBUG = 7;
    public static final String LOGLEVEL_ERROR_LABEL = "Error";
    public static final String LOGLEVEL_WARN_LABEL = "Warn";
    public static final String LOGLEVEL_INFO_LABEL = "Info";
    public static final String LOGLEVEL_DEBUG_LABEL = "Debug";
    private static final int[] LOG_LEVELS = new int[]{3, 4, 6, 7};
    private static final Integer[] LOG_LEVELS_INTEGER;
    static final String PROP_LEVEL = "log_track.level";
    static final String PROP_ENABLE = "log_track.enable";
    private static final String PROP_PATTERN = "log_track.pattern";
    static final String PROP_INCLUDE = "log_track.include";
    static final String PROP_EXCLUDE = "log_track.exclude";
    private static final String[] ENABLE_PROPS;
    private static final String[] PATTERN_PROPS;
    private static final String[] INCLUDE_PROPS;
    private static final String[] EXCLUDE_PROPS;
    private static final String[] LEVEL_PROPS;
    private LogTrackPluginManager manager;
    private int logLevel;
    private StringMatcher matcher = null;
    private Map logLevelMap = null;
    private LogMessageFolder folder;
    static String[] LOGLEVEL_LABELS;

    public static int[] getLogLevels() {
        return LOG_LEVELS;
    }

    public static String getLogLevelLabel(int level) {
        switch (level) {
            case 3: {
                return LOGLEVEL_ERROR_LABEL;
            }
            case 4: {
                return LOGLEVEL_WARN_LABEL;
            }
            case 6: {
                return LOGLEVEL_INFO_LABEL;
            }
            case 7: {
                return LOGLEVEL_DEBUG_LABEL;
            }
        }
        throw new IllegalArgumentException("Invalid log level: " + level);
    }

    protected int getLogLevel(String label) {
        for (int x = 0; x < LOGLEVEL_LABELS.length; ++x) {
            if (!LOGLEVEL_LABELS[x].equals(label)) continue;
            return LOG_LEVELS[x];
        }
        throw new IllegalArgumentException("Invalid log level label: " + label);
    }

    public String[] getLogLevelAliases() {
        return LOGLEVEL_LABELS;
    }

    protected Map getLogLevelMap() {
        return this.logLevelMap;
    }

    private static Map createLogLevelMap(String[] mapping) {
        HashMap<String, Integer> map = new HashMap<String, Integer>();
        int len = LOGLEVEL_LABELS.length;
        if (mapping.length != len) {
            String msg = "mapping.length != " + len;
            throw new IllegalArgumentException(msg);
        }
        for (int i = 0; i < len; ++i) {
            Integer level = LOG_LEVELS_INTEGER[i];
            StringTokenizer tok = new StringTokenizer(mapping[i], ",");
            while (tok.hasMoreTokens()) {
                map.put(tok.nextToken(), level);
            }
        }
        return map;
    }

    public static boolean isEnabled(ConfigResponse config, int type) {
        String option = config.getValue(ENABLE_PROPS[type]);
        if (option == null) {
            return false;
        }
        return option.equals("true");
    }

    public static void setEnabled(ConfigResponse config, int type, int level) {
        if (level == -1) {
            return;
        }
        config.setValue(ENABLE_PROPS[type], "true");
        config.setValue(LEVEL_PROPS[type], LogTrackPlugin.getLogLevelLabel(level));
    }

    protected boolean supportsLogLevels() {
        return true;
    }

    protected boolean shouldDebugLog() {
        return true;
    }

    protected boolean shouldLog(int level) {
        if (this.supportsLogLevels()) {
            return level <= this.getLogLevel();
        }
        if (debugLogging) {
            this.debugLog("Log levels not supported");
        }
        return true;
    }

    protected int getLogLevel() {
        return this.logLevel;
    }

    protected void setLogLevel(int level) {
        this.logLevel = level;
    }

    protected boolean messageMatches(TrackEvent event) {
        String message = event.getMessage();
        if (this.matcher == null) {
            if (debugLogging) {
                this.debugLog(message, "No pattern match configured");
            }
            return !this.folder.shouldFold(event, ".*");
        }
        message = this.stripNewLines(message);
        boolean matches = this.matcher.matches(message);
        if (debugLogging) {
            String debugMsg = matches ? "Matches" : "Does not match";
            this.debugLog(message, debugMsg + " '" + this.matcher + "'");
        }
        if (matches) {
            List lastMatches = this.matcher.getLastMatches();
            return !this.folder.shouldFold(event, lastMatches);
        }
        return false;
    }

    protected TrackEvent newTrackEvent(long time, String level, String source, String message) {
        if (this.supportsLogLevels()) {
            Integer intLevel = (Integer)this.getLogLevelMap().get(level);
            if (intLevel == null) {
                if (debugLogging) {
                    this.debugLog(message, "no level mapped to '" + level + "'");
                }
                return null;
            }
            return this.newTrackEvent(time, intLevel, source, message);
        }
        return this.newTrackEvent(time, 0, source, message);
    }

    void debugLog(String debugMsg) {
        this.debugLog(null, debugMsg);
    }

    void debugLog(String message, String debugMsg) {
        if (!debugLogging) {
            return;
        }
        if (!this.shouldDebugLog()) {
            return;
        }
        message = message != null ? " for message='" + message + "'," : "";
        log.debug((Object)(debugMsg + message + " plugin=" + this.getName() + " [" + this.getTypeInfo().getName() + "]"));
    }

    protected String stripNewLines(String message) {
        message = StringUtil.replace((String)message, (String)"\r", (String)"");
        message = StringUtil.replace((String)message, (String)"\n", (String)"");
        return message;
    }

    protected TrackEvent newTrackEvent(long time, int level, String source, String message) {
        TrackEvent event;
        if (!this.shouldLog(level)) {
            if (debugLogging) {
                this.debugLog(message, "Ignoring, level " + LogTrackPlugin.getLogLevelLabel(level) + " > " + LogTrackPlugin.getLogLevelLabel(this.getLogLevel()));
            }
            return null;
        }
        if (debugLogging) {
            this.debugLog(message, "Accepting, level " + LogTrackPlugin.getLogLevelLabel(level) + " <= " + LogTrackPlugin.getLogLevelLabel(this.getLogLevel()));
        }
        if (!this.messageMatches(event = new TrackEvent(this.getName(), time, level, source, message))) {
            return null;
        }
        if (debugLogging) {
            this.debugLog(message, "Reporting Event");
        }
        return event;
    }

    public void reportEvent(long time, int level, String source, String message) {
        TrackEvent event = this.newTrackEvent(time, level, source, message);
        if (event != null) {
            this.getManager().reportEvent(event);
        }
    }

    public void configure(ConfigResponse config) throws PluginException {
        String excludes;
        String includes;
        int type;
        super.configure(config);
        if (this.supportsLogLevels()) {
            type = this.getTypeInfo().getType();
            String level = config.getValue(LEVEL_PROPS[type]);
            if (level == null) {
                this.setLogLevel(3);
            } else {
                this.setLogLevel(this.getLogLevel(level));
            }
            if (debugLogging) {
                this.debugLog("Configured log level=" + LogTrackPlugin.getLogLevelLabel(this.getLogLevel()));
            }
            String[] logLevels = this.getLogLevelAliases();
            this.logLevelMap = (Map)logLevelCache.get(logLevels);
            if (this.logLevelMap == null) {
                log.debug((Object)("Creating log level map for: " + this.getTypeInfo().getName()));
                this.logLevelMap = LogTrackPlugin.createLogLevelMap(logLevels);
                logLevelCache.put(logLevels, this.logLevelMap);
            }
        }
        if ("".equals(includes = config.getValue(INCLUDE_PROPS[type = this.getTypeInfo().getType()]))) {
            includes = null;
        }
        if (includes == null && "".equals(includes = config.getValue(PATTERN_PROPS[type]))) {
            includes = null;
        }
        if ("".equals(excludes = config.getValue(EXCLUDE_PROPS[type]))) {
            excludes = null;
        }
        if (includes != null || excludes != null) {
            this.matcher = new StringMatcher();
            try {
                this.matcher.setIncludes(includes);
            }
            catch (Exception e) {
                String msg = "Invalid " + INCLUDE_PROPS[type] + ": " + e;
                throw new PluginException(msg);
            }
            try {
                this.matcher.setExcludes(excludes);
            }
            catch (Exception e) {
                String msg = "Invalid " + EXCLUDE_PROPS[type] + ": " + e;
                throw new PluginException(msg);
            }
        }
        this.matcher = null;
        if (debugLogging) {
            if (this.matcher == null) {
                this.debugLog("No pattern match configured");
            } else {
                this.debugLog("Pattern match configured to '" + this.matcher + "'");
            }
        }
        this.folder = new LogMessageFolder(this);
        if (this.matcher == null && this.folder.getRepeatMax() == 2L) {
            this.folder.setRepeatMax(100L);
        }
    }

    protected boolean supportsPatternMatching() {
        return true;
    }

    protected ConfigOption getIncludeOption(TypeInfo info, ConfigResponse config) {
        if (this.supportsPatternMatching()) {
            String defaultValue = config.getValue(PATTERN_PROPS[info.getType()]);
            if (defaultValue == null) {
                defaultValue = this.getTypeProperty("DEFAULT_LOG_INCLUDE");
            }
            if (defaultValue == null) {
                defaultValue = "";
            }
            StringConfigOption option = new StringConfigOption(INCLUDE_PROPS[info.getType()], "Log Pattern Match", defaultValue);
            option.setOptional(true);
            return option;
        }
        return null;
    }

    protected ConfigOption getExcludeOption(TypeInfo info, ConfigResponse config) {
        if (this.supportsPatternMatching()) {
            String defaultValue = this.getTypeProperty("DEFAULT_LOG_EXCLUDE");
            if (defaultValue == null) {
                defaultValue = "";
            }
            StringConfigOption option = new StringConfigOption(EXCLUDE_PROPS[info.getType()], "Log Pattern Exclude", defaultValue);
            option.setOptional(true);
            return option;
        }
        return null;
    }

    protected ConfigOption getEnableOption(TypeInfo info, ConfigResponse config) {
        String defaultValue = this.getTypeProperty("DEFAULT_LOG_TRACK_ENABLE");
        boolean enable = "true".equals(defaultValue);
        BooleanConfigOption option = new BooleanConfigOption(ENABLE_PROPS[info.getType()], "Enable Log Tracking", enable);
        option.setOptional(true);
        return option;
    }

    public ConfigSchema getConfigSchema(TypeInfo info, ConfigResponse config) {
        ConfigOption excludesOption;
        ConfigOption includeOption;
        int type = info.getType();
        ConfigSchema schema = new ConfigSchema();
        ConfigOption enableOption = this.getEnableOption(info, config);
        if (enableOption != null) {
            schema.addOption(enableOption);
        }
        if (this.supportsLogLevels()) {
            String defaultLevel = this.getTypeProperty("DEFAULT_LOG_LEVEL");
            if (defaultLevel == null) {
                defaultLevel = LOGLEVEL_ERROR_LABEL;
            }
            EnumerationConfigOption option = new EnumerationConfigOption(LEVEL_PROPS[type], "Track event log level", defaultLevel, LOGLEVEL_LABELS);
            option.setOptional(true);
            schema.addOption((ConfigOption)option);
        }
        if ((includeOption = this.getIncludeOption(info, config)) != null) {
            schema.addOption(includeOption);
        }
        if ((excludesOption = this.getExcludeOption(info, config)) != null) {
            schema.addOption(excludesOption);
        }
        return schema;
    }

    public void init(PluginManager manager) throws PluginException {
        super.init(manager);
        this.manager = (LogTrackPluginManager)manager;
    }

    public LogTrackPluginManager getManager() {
        return this.manager;
    }

    static {
        ENABLE_PROPS = LogTrackPlugin.createTypeLabels(PROP_ENABLE);
        PATTERN_PROPS = LogTrackPlugin.createTypeLabels(PROP_PATTERN);
        INCLUDE_PROPS = LogTrackPlugin.createTypeLabels(PROP_INCLUDE);
        EXCLUDE_PROPS = LogTrackPlugin.createTypeLabels(PROP_EXCLUDE);
        LEVEL_PROPS = LogTrackPlugin.createTypeLabels(PROP_LEVEL);
        Integer[] levels = new Integer[LOG_LEVELS.length];
        for (int i = 0; i < levels.length; ++i) {
            levels[i] = new Integer(LOG_LEVELS[i]);
        }
        LOG_LEVELS_INTEGER = levels;
        LOGLEVEL_LABELS = new String[]{LOGLEVEL_ERROR_LABEL, LOGLEVEL_WARN_LABEL, LOGLEVEL_INFO_LABEL, LOGLEVEL_DEBUG_LABEL};
    }
}

