/*
 * Decompiled with CFR 0.152.
 */
package org.hyperic.hq.product;

import java.util.LinkedList;
import java.util.List;
import org.hyperic.hq.product.IMonitorConfig;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MonitoredFolderConfig
implements IMonitorConfig {
    private String path;
    private String filter;
    private boolean recursive;
    private List<MonitoredFolderConfig> subFolders;

    public MonitoredFolderConfig(String path, String filter, boolean recursive) {
        this.path = path;
        this.filter = filter;
        this.recursive = recursive;
    }

    public String getPath() {
        return this.path;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public String getFilter() {
        return this.filter;
    }

    public void setFilter(String filter) {
        this.filter = filter;
    }

    public boolean isRecursive() {
        return this.recursive;
    }

    public void setRecursive(boolean recursive) {
        this.recursive = recursive;
    }

    @Override
    public String dumpXML() {
        StringBuffer sb = new StringBuffer();
        sb.append("<folder recursive='" + (this.recursive ? "true" : "false") + "' path='" + this.getPath() + "' filter='" + this.getFilter());
        if (this.subFolders == null || this.subFolders.size() <= 0) {
            sb.append("' />");
            return sb.toString();
        }
        sb.append("'>");
        for (MonitoredFolderConfig config : this.subFolders) {
            sb.append(config.dumpXML());
        }
        sb.append("<folder>");
        return sb.toString();
    }

    public String toString() {
        return this.getPath() + ";" + this.isRecursive() + ";" + this.getFilter() + ";";
    }

    public List<MonitoredFolderConfig> getSubFolders() {
        return this.subFolders;
    }

    public void setSubFolders(List<MonitoredFolderConfig> subFolders) {
        this.subFolders = subFolders;
    }

    public void addSubFolder(MonitoredFolderConfig subFolder) {
        if (this.subFolders == null) {
            this.subFolders = new LinkedList<MonitoredFolderConfig>();
        }
        this.subFolders.add(subFolder);
    }
}

