/*
 * Decompiled with CFR 0.152.
 */
package org.hyperic.hq.product.logparse;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.Date;
import java.util.StringTokenizer;
import org.hyperic.hq.product.RtStat;
import org.hyperic.hq.product.logparse.BaseLogParser;

public class SimpleLogParser
extends BaseLogParser {
    static SimpleLogParser instance = null;
    double tm;

    public static SimpleLogParser getInstance() {
        if (instance == null) {
            instance = new SimpleLogParser();
        }
        return instance;
    }

    public void initConfig(double timeMultiplier, String regex) {
        this.tm = timeMultiplier;
    }

    public RtStat parseLine(String current) {
        if (current.equals("-") || current.trim().length() == 0) {
            return null;
        }
        try {
            StringTokenizer st = new StringTokenizer(current);
            String url = st.nextToken();
            long msec = Long.parseLong(st.nextToken());
            double time_taken = Double.parseDouble(st.nextToken()) * this.tm;
            Integer status = Integer.valueOf(st.nextToken());
            String ip = null;
            if (st.hasMoreTokens()) {
                ip = st.nextToken();
                String[] strips = ip.split("^\\d+\\.\\d+\\.\\d+\\.\\d+");
                for (int i = 0; i < strips.length; ++i) {
                    if (strips[i].length() <= 0) continue;
                    int index = ip.indexOf(strips[i]);
                    ip = ip.substring(0, index);
                    break;
                }
            }
            RtStat rs = new RtStat(this.id, this.svcType, ip);
            rs.recompute(url, new Date(msec), time_taken, status);
            return rs;
        }
        catch (Exception e) {
            this.log.debug((Object)("Problem parsing line: " + current));
            return null;
        }
    }

    public void postFileParse(File f) throws IOException {
        try {
            String mode = "rws";
            RandomAccessFile toTrunc = new RandomAccessFile(f, mode);
            toTrunc.setLength(0L);
            toTrunc.close();
        }
        catch (SecurityException e) {
        }
        catch (FileNotFoundException e) {
            this.log.error((Object)("Encountered file error truncating log: " + e));
        }
    }
}

