/*
 * Decompiled with CFR 0.152.
 */
package org.hyperic.hq.product.pluginxml;

import org.hyperic.hq.product.MeasurementPlugin;
import org.hyperic.hq.product.PlatformDetector;
import org.hyperic.hq.product.SNMPMeasurementPlugin;
import org.hyperic.hq.product.ServerTypeInfo;
import org.hyperic.hq.product.ServiceTypeInfo;
import org.hyperic.hq.product.pluginxml.BaseTag;
import org.hyperic.hq.product.pluginxml.ResourceTag;
import org.hyperic.hq.product.pluginxml.ServerTag;
import org.hyperic.util.xmlparser.XmlAttrException;
import org.hyperic.util.xmlparser.XmlEndAttrHandler;

class ServiceTag
extends ResourceTag
implements XmlEndAttrHandler {
    private static final String ATTR_INTERNAL = "internal";
    private static final String ATTR_SERVER = "server";
    private static final String[] REQUIRED_ATTRS = new String[]{"name"};
    private static final String[] OPTIONAL_ATTRS = new String[]{"internal", "description", "server", "version", "platform"};
    private static final String[] SERVER_ATTRS = new String[]{"server", "version"};
    private boolean isDefaultServer;
    private ServerTag server = null;
    String serverType = null;
    String platformType = null;

    ServiceTag(BaseTag parent) {
        super(parent);
        if (parent instanceof ServerTag) {
            this.server = (ServerTag)parent;
        }
    }

    int getResourceType() {
        return 3;
    }

    public String getName() {
        return "service";
    }

    public String[] getRequiredAttributes() {
        return REQUIRED_ATTRS;
    }

    public String[] getOptionalAttributes() {
        return OPTIONAL_ATTRS;
    }

    private void checkAttributes(boolean required) throws XmlAttrException {
        for (int i = 0; i < SERVER_ATTRS.length; ++i) {
            String attr = SERVER_ATTRS[i];
            String value = this.getAttribute(attr);
            if (required) {
                if (attr.equals("version") || value != null) continue;
                String msg = "Missing required attribute: " + attr;
                throw new XmlAttrException(msg);
            }
            if (value == null) continue;
            String msg = "Attribute not allowed here: " + attr;
            throw new XmlAttrException(msg);
        }
    }

    public void endAttributes() throws XmlAttrException {
        ServiceTypeInfo service;
        this.isDefaultServer = false;
        boolean isInternal = "true".equals(this.getAttribute(ATTR_INTERNAL));
        String name = this.getAttribute("name");
        String description = this.getAttribute("description");
        if (this.server != null) {
            this.checkAttributes(false);
            this.serverType = this.server.typeName;
            service = this.server.addService(name, isInternal);
            if (description != null) {
                service.setDescription(description);
            }
            this.typeName = service.getName();
            this.isDefaultServer = true;
        } else {
            boolean hasServerVersion;
            String platform = this.getAttribute("platform");
            String serverName = this.getAttribute(ATTR_SERVER);
            String serverVersion = this.getAttribute("version");
            if (serverName == null) {
                if (platform != null && !PlatformDetector.isSupportedPlatform(platform)) {
                    serverName = platform + " Server";
                    this.platformType = platform;
                } else {
                    serverName = "NetworkServer";
                }
                this.isDefaultServer = true;
            }
            if (serverVersion != null && !serverVersion.equals("x")) {
                serverName = serverName + " " + serverVersion;
                hasServerVersion = true;
            } else {
                hasServerVersion = false;
            }
            ServerTypeInfo server = new ServerTypeInfo(serverName, null, serverVersion);
            server.setDescription(server.getName());
            if (platform != null) {
                server.setValidPlatformTypes(new String[]{platform});
            }
            this.serverType = server.getName();
            this.typeName = hasServerVersion ? this.serverType + " " + name : name;
            if (description == null) {
                description = this.typeName;
            }
            service = new ServiceTypeInfo(this.typeName, description, server);
            this.data.addServiceExtension(service);
        }
        this.setNameProperty(name);
        service.setInternal(isInternal);
    }

    private String getPlatformType() {
        if (this.server != null && this.server.platform != null) {
            return this.server.platform.typeName;
        }
        return this.platformType;
    }

    public void endTag() {
        String platform;
        if (this.collectMetrics && this.data.getMetrics(this.typeName) == null) {
            return;
        }
        String type = "measurement";
        String name = this.typeName;
        String plugin = this.data.getPlugin(type, name);
        if (plugin != null) {
            return;
        }
        plugin = this.data.getPlugin(type, this.serverType);
        if (plugin == null && (platform = this.getPlatformType()) != null) {
            plugin = this.data.getPlugin(type, platform);
        }
        if (plugin == null && this.isDefaultServer) {
            plugin = this.data.getProperty("MIBS") != null ? SNMPMeasurementPlugin.class.getName() : MeasurementPlugin.class.getName();
        }
        if (plugin != null) {
            this.data.addPlugin(type, name, plugin);
        }
    }
}

