/*
 * Decompiled with CFR 0.152.
 */
package org.hyperic.cm.filemonitor;

import java.io.File;
import java.io.IOException;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.hyperic.cm.filemonitor.ChangeEventProcessor;
import org.hyperic.cm.filemonitor.data.WatchedDirInfo;
import org.hyperic.cm.filemonitor.dto.ConfigDefDto;
import org.hyperic.cm.filemonitor.dto.ConfigFolderDto;
import org.hyperic.cm.filemonitor.dto.PropsFileDto;
import org.hyperic.cm.filemonitor.dto.XmlFileDto;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConfigProcessor {
    private static Logger log = LoggerFactory.getLogger(ChangeEventProcessor.class);

    public void process(Map<String, WatchedDirInfo> dirs, String installPath, ConfigDefDto configDef) {
        if (configDef instanceof XmlFileDto) {
            this.process(dirs, installPath, (XmlFileDto)configDef);
        } else if (configDef instanceof PropsFileDto) {
            this.process(dirs, installPath, (PropsFileDto)configDef);
        } else if (configDef instanceof ConfigFolderDto) {
            this.process(dirs, installPath, (ConfigFolderDto)configDef);
        } else {
            return;
        }
    }

    public void process(Map<String, WatchedDirInfo> dirs, String installPath, XmlFileDto xmlFile) {
        DocumentBuilderFactory domFactory = DocumentBuilderFactory.newInstance();
        domFactory.setNamespaceAware(true);
        DocumentBuilder builder = null;
        NodeList nodes = null;
        try {
            builder = domFactory.newDocumentBuilder();
            Document doc = builder.parse(String.valueOf(installPath) + File.separator + xmlFile.getPath());
            log.info("Reading xml from " + installPath + File.separator + xmlFile.getPath());
            XPathFactory factory = XPathFactory.newInstance();
            for (ConfigFolderDto xPath : xmlFile.getFolders()) {
                XPath xpath = factory.newXPath();
                Object result = null;
                try {
                    XPathExpression expr = xpath.compile(xPath.getPath());
                    result = expr.evaluate(doc, XPathConstants.NODESET);
                }
                catch (XPathExpressionException e) {
                    log.error("Invalid XPath (" + xPath.getPath() + "): " + e.getMessage(), (Throwable)e);
                    continue;
                }
                nodes = (NodeList)result;
                int i = 0;
                while (i < nodes.getLength()) {
                    dirs.put(nodes.item(i).getNodeValue(), new WatchedDirInfo(null, xPath.isRecursive(), xPath.getFilter()));
                    ++i;
                }
            }
        }
        catch (IOException e) {
            log.error("Error reading file " + xmlFile.getPath() + ": " + e.getMessage(), (Throwable)e);
            return;
        }
        catch (Exception e) {
            log.error("Error parsing xml (" + xmlFile.getPath() + "): " + e.getMessage(), (Throwable)e);
            return;
        }
    }

    public void process(Map<String, WatchedDirInfo> dirs, String installPath, ConfigFolderDto folder) {
        File dir;
        String dirName = folder.getPath();
        dirName = this.replaceSysVariable(dirName);
        if (installPath != null) {
            dirName = this.getFullPath(installPath, dirName);
        }
        if (log.isDebugEnabled()) {
            log.debug("Adding monitored directory: " + dirName);
        }
        if (!(dir = new File(dirName)).isDirectory()) {
            if (log.isDebugEnabled()) {
                log.debug(String.valueOf(dirName) + " is not a directory. Skipping...");
            }
            return;
        }
        dirs.put(dirName, new WatchedDirInfo(null, folder.isRecursive(), folder.getFilter()));
    }

    public void process(Map<String, WatchedDirInfo> dirs, String installPath, PropsFileDto propsFile) {
    }

    private String getFullPath(String installDir, String relPath) {
        if (relPath == null || relPath.length() <= 0) {
            return installDir;
        }
        File f = new File(relPath);
        boolean isAbsolute = f.isAbsolute() || relPath.charAt(1) == ':' || relPath.charAt(0) == '/' || relPath.startsWith("~/");
        String basePath = isAbsolute ? "" : String.valueOf(installDir) + File.separator;
        return String.valueOf(basePath) + relPath;
    }

    private String replaceSysVariable(String path) {
        int pos = -1;
        if (path.startsWith("%") && (pos = path.indexOf(37, 1)) > 0) {
            String sysPropName = path.substring(0, pos);
            String pathSuffix = path.substring(pos, path.length());
            String sysProp = System.getProperty(sysPropName);
            return String.valueOf(sysProp) + pathSuffix;
        }
        return path;
    }
}

