/*
 * Decompiled with CFR 0.152.
 */
package org.hyperic.hq.plugin.sharepoint;

import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hyperic.hq.plugin.sharepoint.SharePointServerDetectorDefault;
import org.hyperic.hq.product.PluginException;
import org.hyperic.hq.product.Win32ControlPlugin;
import org.hyperic.sigar.win32.Service;
import org.hyperic.sigar.win32.Win32Exception;
import org.hyperic.util.config.ConfigResponse;
import org.hyperic.util.exec.Execute;
import org.hyperic.util.exec.ExecuteStreamHandler;
import org.hyperic.util.exec.ExecuteWatchdog;
import org.hyperic.util.exec.PumpStreamHandler;

public class SharePointServerControl
extends Win32ControlPlugin {
    List<String> services;
    List<String> webs;
    private Log log = LogFactory.getLog(SharePointServerDetectorDefault.class);

    public void configure(ConfigResponse config) throws PluginException {
        this.log.debug((Object)("[configure] config=" + config));
        String w = config.getValue("sharepoint.control.webs");
        this.webs = w != null ? Arrays.asList(w.split(",")) : new ArrayList<String>();
        String s = config.getValue("sharepoint.control.services");
        this.services = s != null ? Arrays.asList(s.split(",")) : new ArrayList<String>();
        this.setTimeout(60);
    }

    public List getActions() {
        return Arrays.asList("start", "stop", "restart");
    }

    public void doAction(String action) throws PluginException {
        int i;
        for (i = 0; i < this.webs.size(); ++i) {
            String web = this.webs.get(i).trim();
            if (action.equals("start")) {
                this.controlWebServer("start", web);
                continue;
            }
            if (action.equals("stop")) {
                this.controlWebServer("stop", web);
                continue;
            }
            if (!action.equals("restart")) continue;
            this.controlWebServer("stop", web);
            this.controlWebServer("start", web);
        }
        for (i = 0; i < this.services.size(); ++i) {
            String s = this.services.get(i).trim();
            if (action.equals("start")) {
                this.startService(s);
                continue;
            }
            if (action.equals("stop")) {
                this.stopService(s);
                continue;
            }
            if (!action.equals("restart")) continue;
            this.stopService(s);
            this.startService(s);
        }
        this.setResult(0);
    }

    private void stopService(String service) throws PluginException {
        try {
            Service s = new Service(service);
            this.log.debug((Object)("[stopService] stoping:" + s.getConfig().getDisplayName()));
            if (this.isRunning(s)) {
                s.stop();
                this.waitForStop(s);
            }
            this.log.debug((Object)"[stopService] Done");
        }
        catch (Win32Exception ex) {
            throw new PluginException("Error stoping service '" + service + "'", (Throwable)ex);
        }
    }

    private void startService(String service) throws PluginException {
        try {
            Service s = new Service(service);
            this.log.debug((Object)("[startService] staring:" + s.getConfig().getDisplayName()));
            if (!this.isRunning(s)) {
                s.start();
                this.waitForStart(s);
            }
            this.log.debug((Object)"[startService] Done");
        }
        catch (Win32Exception ex) {
            throw new PluginException("Error starting service '" + service + "'", (Throwable)ex);
        }
    }

    private void waitForStart(Service svc) throws PluginException, Win32Exception {
        int timeout = this.getTimeoutMillis();
        long timeStart = System.currentTimeMillis();
        while (!this.isRunning(svc) && System.currentTimeMillis() - timeStart < (long)timeout) {
            try {
                Thread.sleep(500L);
            }
            catch (InterruptedException e) {}
        }
        if (!this.isRunning(svc)) {
            throw new PluginException("Service '" + svc.getConfig().getDisplayName() + "' not stopped - Timeout");
        }
    }

    private void waitForStop(Service svc) throws PluginException, Win32Exception {
        int timeout = this.getTimeoutMillis();
        long timeStart = System.currentTimeMillis();
        while (this.isRunning(svc) && System.currentTimeMillis() - timeStart < (long)timeout) {
            try {
                Thread.sleep(500L);
            }
            catch (InterruptedException e) {}
        }
        if (this.isRunning(svc)) {
            throw new PluginException("Service '" + svc.getConfig().getDisplayName() + "' not stopped - Timeout");
        }
    }

    private void controlWebServer(String action, String webserver) throws PluginException {
        this.log.debug((Object)("[controlWebServer] action=" + action + ", webserver=" + webserver));
        String[] cmd = new String[]{"C:/Windows/System32/inetsrv/appcmd.exe", action, "site", webserver};
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        ExecuteWatchdog wdog = new ExecuteWatchdog(60000);
        Execute exec = new Execute((ExecuteStreamHandler)new PumpStreamHandler((OutputStream)output), wdog);
        exec.setCommandline(cmd);
        try {
            int exitStatus = exec.execute();
            if (exitStatus != 0 || wdog.killedProcess()) {
                throw new PluginException("exitStatus:" + exitStatus + ", output=" + output.toString());
            }
            this.log.debug((Object)("[controlWebServer] action=" + action + ", webserver=" + webserver + ", output=" + output));
        }
        catch (Exception e) {
            this.log.debug((Object)("[controlWebServer] action=" + action + ", webserver=" + webserver + ", error=" + e.getMessage()), (Throwable)e);
            throw new PluginException(Arrays.asList(cmd) + ": " + e);
        }
    }
}

