/*
 * Decompiled with CFR 0.152.
 */
package org.hyperic.hq.plugin.netdevice;

import java.util.Properties;
import java.util.StringTokenizer;
import org.apache.commons.logging.Log;
import org.hyperic.hq.plugin.netdevice.NetworkDeviceDetector;
import org.hyperic.hq.product.PlatformDetector;
import org.hyperic.hq.product.PlatformResource;
import org.hyperic.hq.product.PluginException;
import org.hyperic.hq.product.PluginManager;
import org.hyperic.snmp.SNMPClient;
import org.hyperic.snmp.SNMPException;
import org.hyperic.snmp.SNMPSession;
import org.hyperic.snmp.SNMPValue;
import org.hyperic.util.config.ConfigResponse;

public class NetworkDevicePlatformDetector
extends PlatformDetector {
    private static final String PROP_VERSION = "Version";
    private Properties props;
    private boolean autoDefaults;

    public void init(PluginManager manager) throws PluginException {
        super.init(manager);
        this.props = manager.getProperties();
        this.autoDefaults = "true".equals(this.props.getProperty("snmp.autoDefaults"));
        if (!this.autoDefaults) {
            this.autoDefaults = this.props.getProperty("snmpCommunity") != null;
        }
    }

    private SNMPSession getSession(ConfigResponse config) {
        try {
            return NetworkDeviceDetector.getSession(config);
        }
        catch (PluginException e) {
            this.getLog().error((Object)e.getMessage(), (Throwable)e);
            return null;
        }
    }

    private String getString(SNMPSession session, String oid) {
        try {
            SNMPValue obj = session.getSingleValue(oid);
            if (obj == null) {
                return null;
            }
            String value = obj.toString();
            return value;
        }
        catch (SNMPException e) {
            this.getLog().warn((Object)("Error getting '" + oid + "': " + e.getMessage()));
            return null;
        }
    }

    private String getIpProp(String key, String ip, String defVal) {
        String propDefault = this.props.getProperty(key, defVal);
        return this.props.getProperty(key + "." + ip, propDefault);
    }

    public PlatformResource getPlatformResource(ConfigResponse config) throws PluginException {
        String description;
        SNMPSession session;
        ConfigResponse cprops;
        ConfigResponse metricConfig;
        boolean hasConfig;
        Log log;
        PlatformResource platform;
        block16: {
            String platformIp = config.getValue("platform.ip");
            platformIp = this.getIpProp("snmpIp", platformIp, platformIp);
            String defaultVersion = this.getIpProp("snmpVersion", platformIp, SNMPClient.VALID_VERSIONS[1]);
            String fallbackVersion = SNMPClient.VALID_VERSIONS[0];
            platform = super.getPlatformResource(config);
            log = this.getLog();
            boolean bl = hasConfig = config.getValue("snmpIp") != null;
            if (hasConfig) {
                metricConfig = config;
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Using approved snmp config=" + metricConfig));
                }
            } else if (this.autoDefaults) {
                metricConfig = new ConfigResponse();
                metricConfig.setValue("snmpIp", platformIp);
                metricConfig.setValue("snmpVersion", defaultVersion);
                metricConfig.setValue("snmpCommunity", this.getIpProp("snmpCommunity", platformIp, SNMPClient.DEFAULT_COMMUNITY));
                metricConfig.setValue("snmpPort", this.getIpProp("snmpPort", platformIp, SNMPClient.DEFAULT_PORT_STRING));
                metricConfig.setValue(NetworkDeviceDetector.PROP_IF_IX, this.getIpProp(NetworkDeviceDetector.PROP_IF_IX, platformIp, "ifDescr"));
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Using default snmp config=" + metricConfig));
                }
            } else {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Need user input for snmp config=" + config));
                }
                return platform;
            }
            cprops = new ConfigResponse();
            session = this.getSession(metricConfig);
            if (session == null) {
                return platform;
            }
            try {
                session.getSingleValue("sysName");
            }
            catch (SNMPException e) {
                this.getLog().debug((Object)("Unable to connect using " + defaultVersion + ", trying version " + fallbackVersion));
                metricConfig.setValue("snmpVersion", fallbackVersion);
                session = this.getSession(metricConfig);
                if (session != null) break block16;
                return platform;
            }
        }
        String[] keys = this.getCustomPropertiesSchema().getOptionNames();
        for (int i = 0; i < keys.length; ++i) {
            String key = keys[i];
            if (Character.isUpperCase(key.charAt(0))) continue;
            String val = this.getString(session, key);
            if (val == null) {
                log.debug((Object)("'" + key + "'==null"));
                continue;
            }
            cprops.setValue(key, val);
        }
        if (!hasConfig) {
            config.merge(metricConfig, false);
            platform.setProductConfig(config);
            platform.setMeasurementConfig(new ConfigResponse());
            log.debug((Object)("Setting measurement config=" + metricConfig));
        }
        if ((description = this.getString(session, "sysDescr")) != null) {
            boolean hasVersionCprop;
            platform.setDescription(description);
            boolean bl = hasVersionCprop = this.getCustomPropertiesSchema().getOption(PROP_VERSION) != null;
            if (hasVersionCprop) {
                StringTokenizer tok = new StringTokenizer(description, " ,");
                while (tok.hasMoreTokens()) {
                    String s = tok.nextToken();
                    if (!s.equalsIgnoreCase(PROP_VERSION) || !tok.hasMoreTokens()) continue;
                    String version = tok.nextToken();
                    cprops.setValue(PROP_VERSION, version);
                    break;
                }
            }
        }
        platform.setCustomProperties(cprops);
        return platform;
    }
}

