/*
 * Decompiled with CFR 0.152.
 */
package com.hyperic.hq.transport;

import com.hyperic.hq.transport.SSLTransportClientFactory;
import com.hyperic.hq.transport.unidirectional.ServerInvocationHandler;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.LinkedBlockingQueue;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hyperic.hq.transport.PollerClient;
import org.hyperic.hq.transport.unidirectional.PollerService;
import org.hyperic.hq.transport.util.AsynchronousInvocationHandler;
import org.hyperic.hq.transport.util.AsynchronousInvoker;
import org.hyperic.hq.transport.util.HQInvokerLocator;
import org.hyperic.hq.transport.util.TransportUtils;
import org.jboss.remoting.InvocationRequest;
import org.jboss.remoting.InvokerLocator;
import org.jboss.remoting.InvokerRegistry;
import org.jboss.remoting.ServerInvoker;
import org.jboss.remoting.transporter.TransporterClient;

public class PollerClientImpl
implements PollerClient {
    public static final String CONNECT_INTERVAL = "com.hq.unidirectional.poller.connect.interval";
    public static final int DEFAULT_CONNECT_INTERVAL = 10000;
    private static long _connectInterval = Long.getLong("com.hq.unidirectional.poller.connect.interval", 10000L);
    private final Thread _pollingThread;
    private final PollingRunnable _runnable;
    private final AsynchronousInvoker _asyncInvoker;
    private final InvokerLocator _remoteEndpointLocator;

    public PollerClientImpl(InetSocketAddress address, String path, boolean encrypted, long frequency, String agentToken, int asyncThreadPoolSize) {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("force_remote", "true");
        InvokerRegistry.registerInvokerFactories((String)"https", SSLTransportClientFactory.class, null);
        HQInvokerLocator invokerLocator = agentToken == null ? new HQInvokerLocator(TransportUtils.getHttpTransport((boolean)encrypted), address.getHostName(), address.getPort(), path, params) : new HQInvokerLocator(TransportUtils.getHttpTransport((boolean)encrypted), address.getHostName(), address.getPort(), path, params, agentToken);
        this._asyncInvoker = new AsynchronousInvoker(asyncThreadPoolSize);
        this._runnable = new PollingRunnable(invokerLocator, this._asyncInvoker, frequency);
        this._pollingThread = new Thread((Runnable)this._runnable, "Poller Client");
        this._pollingThread.setDaemon(true);
        this._remoteEndpointLocator = invokerLocator.toInvokerLocator();
    }

    public void start() {
        this._asyncInvoker.start();
        this._pollingThread.start();
    }

    public void stop() throws InterruptedException {
        this._asyncInvoker.stop();
        this._runnable.stopPolling();
        this._pollingThread.interrupt();
        this._pollingThread.join(30000L);
    }

    public void updateAgentToken(String agentToken) {
        this._runnable.updateAgentToken(agentToken);
    }

    public InvokerLocator getRemoteEndpointLocator() {
        return this._remoteEndpointLocator;
    }

    private static class PollingRunnable
    implements Runnable {
        private static final Log _log = LogFactory.getLog(PollingRunnable.class);
        private final Object _lock = new Object();
        private HQInvokerLocator _locator;
        private final AsynchronousInvoker _invoker;
        private final LinkedBlockingQueue _responseQueue;
        private final long _frequency;
        private boolean _isPolling;

        public PollingRunnable(HQInvokerLocator locator, AsynchronousInvoker invoker, long frequency) {
            if (invoker == null) {
                throw new NullPointerException("no asynchronous invoker specified");
            }
            this._locator = locator;
            this._invoker = invoker;
            this._responseQueue = new LinkedBlockingQueue();
            this._frequency = frequency;
            this.setPolling(true);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void updateAgentToken(String agentToken) {
            Object object = this._lock;
            synchronized (object) {
                this._locator = this._locator.cloneWithNewAgentToken(agentToken);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private HQInvokerLocator getInvokerLocator() {
            Object object = this._lock;
            synchronized (object) {
                return this._locator;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            PollerService poller = null;
            try {
                poller = this.connectToPollerService();
                this.doPolling(poller);
            }
            finally {
                if (poller != null) {
                    TransporterClient.destroyTransporterClient((Object)poller);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private PollerService connectToPollerService() {
            ClassLoader currentContext = Thread.currentThread().getContextClassLoader();
            Thread.currentThread().setContextClassLoader(PollerService.class.getClassLoader());
            PollerService poller = null;
            try {
                boolean connected = false;
                while (this.isPolling() && !connected) {
                    try {
                        poller = (PollerService)TransporterClient.createTransporterClient((InvokerLocator)this.getInvokerLocator(), PollerService.class);
                        connected = true;
                    }
                    catch (Throwable t) {
                        _log.error((Object)("Error connecting the undirection poller client to the hq server: " + t), t);
                        try {
                            Thread.sleep(_connectInterval);
                        }
                        catch (InterruptedException e) {
                            _log.debug((Object)e, (Throwable)e);
                        }
                    }
                }
            }
            finally {
                Thread.currentThread().setContextClassLoader(currentContext);
            }
            return poller;
        }

        private void doPolling(PollerService poller) {
            long dispatchSleepTime = 50L;
            long sleepTime = Math.max(this._frequency - dispatchSleepTime, 0L);
            while (this.isPolling()) {
                try {
                    List invocations;
                    HQInvokerLocator locator;
                    if (sleepTime > 0L) {
                        Thread.sleep(sleepTime);
                    }
                    if ((locator = this.getInvokerLocator()).isAgentTokenKnown() && !(invocations = poller.retrieveRequests(locator.getAgentToken())).isEmpty()) {
                        this.dispatchInvocationRequests(invocations, this._responseQueue);
                    }
                    Thread.sleep(dispatchSleepTime);
                    ArrayList responses = new ArrayList();
                    this._responseQueue.drainTo(responses);
                    if (responses.isEmpty()) continue;
                    poller.sendReponses(responses);
                }
                catch (InterruptedException e) {
                }
                catch (Throwable t) {
                    _log.info((Object)("Exception while polling: " + t), t);
                }
            }
        }

        private void dispatchInvocationRequests(List invocations, LinkedBlockingQueue responseQueue) {
            ServerInvoker[] invokers = InvokerRegistry.getServerInvokers();
            for (InvocationRequest invocation : invocations) {
                boolean dispatched = false;
                for (int i = 0; i < invokers.length && !dispatched; ++i) {
                    ServerInvoker invoker = invokers[i];
                    if (!invoker.hasInvocationHandler(invocation.getSubsystem())) continue;
                    ServerInvocationHandler handler = new ServerInvocationHandler(invoker, invocation, responseQueue);
                    this._invoker.invoke((AsynchronousInvocationHandler)handler);
                    dispatched = true;
                }
            }
        }

        public void stopPolling() {
            this.setPolling(false);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean isPolling() {
            Object object = this._lock;
            synchronized (object) {
                return this._isPolling;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void setPolling(boolean polling) {
            Object object = this._lock;
            synchronized (object) {
                this._isPolling = polling;
            }
        }
    }
}

