/*
 * Decompiled with CFR 0.152.
 */
package org.hyperic.hq.agent.stats;

import java.util.ArrayList;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import javax.management.MBeanServer;
import javax.management.MBeanServerFactory;
import org.hyperic.hq.stats.AbstractStatsCollector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AgentStatsCollector
extends AbstractStatsCollector {
    private ScheduledThreadPoolExecutor executor = new ScheduledThreadPoolExecutor(2, new ThreadFactory(){
        private final AtomicLong num = new AtomicLong(0L);

        public Thread newThread(Runnable r) {
            Thread rtn = new Thread(r, "agentstats-" + this.num.getAndIncrement());
            rtn.setDaemon(true);
            return rtn;
        }
    });
    private static final AgentStatsCollector instance = new AgentStatsCollector();
    public static final String SCHEDULE_THREAD_METRICS_COLLECTED_TIME = "SCHEDULE_THREAD_METRICS_COLLECTED_TIME";
    public static final String SCHEDULE_THREAD_METRIC_TASKS_SUBMITTED = "SCHEDULE_THREAD_METRIC_TASKS_SUBMITTED";
    public static final String SCHEDULE_THREAD_METRIC_COLLECT_FAILED = "SCHEDULE_THREAD_METRIC_COLLECT_FAILED";
    public static final String COLLECTOR_THREAD_METRIC_COLLECTED_TIME = "COLLECTOR_THREAD_METRIC_COLLECTED_TIME";
    public static final String SENDER_THREAD_SEND_NUM_METRICS = "SENDER_THREAD_NUM_SEND_METRICS";
    public static final String SENDER_THREAD_SEND_METRICS_TIME = "SENDER_THREAD_SEND_METRICS_TIME";
    public static final String DISK_LIST_DISK_ITERATOR_REMOVE_TIME = "DISK_LIST_DISK_ITERATOR_REMOVE_TIME";
    public static final String DISK_LIST_READ_RECORD_TIME = "DISK_LIST_READ_RECORD_TIME";
    public static final String DISK_LIST_ADD_TO_LIST_TIME = "DISK_LIST_ADD_TO_LIST_TIME";
    public static final String DISK_LIST_DELETE_ALL_RECORDS_TIME = "DISK_LIST_DELETE_ALL_RECORDS_TIME";
    public static final String DISK_LIST_KEYVALS_FLUSH_TIME = "DISK_LIST_KEYVALS_FLUSH_TIME";

    private AgentStatsCollector() {
        super(AgentStatsCollector.getMBeanServer());
    }

    private static MBeanServer getMBeanServer() {
        ArrayList<MBeanServer> servers = MBeanServerFactory.findMBeanServer(null);
        return servers.isEmpty() ? null : (MBeanServer)servers.get(0);
    }

    protected ScheduledFuture<?> scheduleAtFixedRate(Runnable runnable, long millis) {
        return this.executor.scheduleAtFixedRate(runnable, millis, millis, TimeUnit.MILLISECONDS);
    }

    public static AgentStatsCollector getInstance() {
        return instance;
    }
}

