/*
 * Decompiled with CFR 0.152.
 */
package org.hyperic.hq.bizapp.agent.client;

import java.net.URI;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hyperic.hq.agent.AgentKeystoreConfig;
import org.hyperic.hq.agent.server.AgentDaemon;
import org.hyperic.hq.bizapp.agent.CommandsAPIInfo;
import org.hyperic.hq.bizapp.agent.ProviderInfo;
import org.hyperic.hq.hqapi1.HQApi;
import org.hyperic.hq.product.PluginException;

public class HQApiFactory {
    private static final Log _log = LogFactory.getLog((String)HQApiFactory.class.getName());
    private static final String HQ_USER = "agent.setup.camLogin";
    private static final String HQ_PASS = "agent.setup.camPword";
    private static final String JAVA_SSL_KEYSTORE = "javax.net.ssl.keyStore";
    private static final String JAVA_SSL_KEYSTORE_PASSWORD = "javax.net.ssl.keyStorePassword";

    public static HQApi getHQApi(AgentDaemon agent, Properties bootProps) throws PluginException {
        try {
            ProviderInfo providerInfo = CommandsAPIInfo.getProvider(agent.getStorageProvider());
            URI uri = new URI(providerInfo.getProviderAddress());
            String user = bootProps.getProperty(HQ_USER, "hqadmin");
            String pass = bootProps.getProperty(HQ_PASS, "hqadmin");
            if (uri.getScheme().equalsIgnoreCase("https")) {
                HQApiFactory.configureSSLKeystore();
            }
            HQApi api = new HQApi(uri, user, pass);
            if (_log.isDebugEnabled()) {
                _log.debug((Object)("Using HQApi at " + uri.getScheme() + "://" + uri.getHost() + ":" + uri.getPort()));
            }
            return api;
        }
        catch (Exception e) {
            throw new PluginException("Could not get HQApi connection: " + e.getMessage(), (Throwable)e);
        }
    }

    private static void configureSSLKeystore() {
        AgentKeystoreConfig keystoreConfig = new AgentKeystoreConfig();
        if (!keystoreConfig.isAcceptUnverifiedCert()) {
            String keyStorePath = System.getProperty(JAVA_SSL_KEYSTORE);
            String keyStorePassword = System.getProperty(JAVA_SSL_KEYSTORE_PASSWORD);
            if (keyStorePath == null || keyStorePassword == null) {
                String filePath = keystoreConfig.getFilePath();
                System.setProperty(JAVA_SSL_KEYSTORE, filePath);
                System.setProperty(JAVA_SSL_KEYSTORE_PASSWORD, keystoreConfig.getFilePassword());
                if (_log.isDebugEnabled()) {
                    _log.debug((Object)("Setting Java system property javax.net.ssl.keyStore to " + filePath));
                }
            }
        }
    }
}

