/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vfabric.hyperic.plugin.vfws;

import com.vmware.vfabric.hyperic.plugin.vfws.BmxQuery;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.HttpResponse;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BmxResult {
    private static final String _logCtx = BmxQuery.class.getName();
    private static final Log _log = LogFactory.getLog((String)_logCtx);
    Properties props = null;
    HttpResponse _response = null;

    public BmxResult(HttpResponse response) {
        this._response = response;
    }

    public Properties getProperties() {
        return this.props;
    }

    public List<String> parseForNames() throws IllegalStateException, IOException {
        String line;
        InputStream is = this._response.getEntity().getContent();
        InputStreamReader reader = new InputStreamReader(is);
        BufferedReader bufferedReader = new BufferedReader(reader);
        ArrayList<String> list = new ArrayList<String>();
        while ((line = bufferedReader.readLine()) != null) {
            if (!line.startsWith("Name:")) continue;
            String[] ent = line.split(":");
            list.add(ent[2]);
        }
        return list;
    }

    public Properties parseToProperties() throws IOException {
        InputStream is = this._response.getEntity().getContent();
        this.props = new Properties();
        Manifest manifest = new Manifest(is);
        Attributes attributes = manifest.getMainAttributes();
        if (null == attributes) {
            _log.error((Object)"Unable to parse results. No attributes found");
            return null;
        }
        for (Attributes.Name name : attributes.keySet()) {
            if (name == null) {
                _log.debug((Object)"Skipping null key");
                continue;
            }
            Object value = attributes.get(name);
            if (value.getClass() != String.class) {
                _log.error((Object)"Attribute value not of class String");
                continue;
            }
            String keyName = name.toString();
            String val = (String)value;
            this.props.put(keyName, val);
        }
        return this.props;
    }
}

