/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vfabric.hyperic.plugin.vfws;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.List;
import org.hyperic.util.StringUtil;

public class Listen {
    private static final List<String> PROTOCOLS = new ArrayList<String>();
    private int _port = 0;
    private String _address = null;
    private String _proto = null;

    public Listen(String line) {
        String[] ent;
        String hostname = null;
        String port = null;
        String[] exploded = StringUtil.explodeQuoted((String)line);
        if (exploded.length > 1) {
            try {
                this.setProto(exploded[1]);
            }
            catch (IllegalArgumentException e) {
                // empty catch block
            }
        }
        if ((ent = exploded[0].split(":")).length > 1) {
            hostname = ent[0];
            port = ent[1];
        } else {
            port = exploded[0];
        }
        try {
            this.setPort(port);
        }
        catch (IllegalArgumentException e) {
            // empty catch block
        }
        try {
            this.setAddress(hostname);
        }
        catch (IllegalArgumentException e) {
            // empty catch block
        }
    }

    public boolean isValid() {
        return this._port != 0 || this._address != null;
    }

    public void setPort(int port) {
        this._port = port;
    }

    public void setPort(String port) {
        try {
            this._port = Integer.parseInt(port);
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException();
        }
    }

    public int getPort() {
        return this._port;
    }

    public void setAddress(String address) {
        try {
            InetAddress.getByName(address);
        }
        catch (UnknownHostException e) {
            return;
        }
        this._address = address;
    }

    public String getAddress() {
        return this._address;
    }

    public void setProto(String proto) {
        if (!PROTOCOLS.contains(proto.toLowerCase())) {
            throw new IllegalArgumentException();
        }
        this._proto = proto;
    }

    public String getProto() {
        return this._proto;
    }

    static {
        PROTOCOLS.add("http");
        PROTOCOLS.add("https");
    }
}

