/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vfabric.hyperic.plugin.vfws;

import java.io.IOException;
import java.io.InputStream;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.HttpResponse;
import org.hyperic.hq.plugin.netservices.HTTPCollector;

public class VfwsCollector
extends HTTPCollector {
    private static final Log log = LogFactory.getLog((String)VfwsCollector.class.getName());

    public void collect() {
        this.setMethod("GET");
        super.collect();
    }

    private void parse(HttpResponse response) throws IOException {
        InputStream is = response.getEntity().getContent();
        if (is == null) {
            log.error((Object)"Unable to retrieve results. InputStream is null");
            return;
        }
        Manifest manifest = new Manifest(is);
        Attributes attributes = manifest.getMainAttributes();
        if (null == attributes) {
            log.error((Object)"Unable to parse results. No attributes found");
            return;
        }
        for (Attributes.Name name : attributes.keySet()) {
            if (name == null) {
                log.debug((Object)"Skipping null key");
                continue;
            }
            Object value = attributes.get(name);
            if (value.getClass() != String.class) {
                log.error((Object)"Attribute value not of class String");
                continue;
            }
            String keyName = name.toString();
            String val = (String)value;
            if (keyName.contains("Workers")) {
                this.setWorkers(keyName, val);
                continue;
            }
            if (keyName.contains("StartTime")) {
                this.setStartTime(keyName, val);
                continue;
            }
            this.setValue(keyName, val);
        }
    }

    private void setWorkers(String key, String value) {
        this.setValue(key, value.substring(0, value.length() - 1));
    }

    private void setStartTime(String key, String value) {
        Long startTime = Long.valueOf(value) / 1000L;
        this.setValue(key, startTime.toString());
    }

    protected void parseResults(HttpResponse response) {
        try {
            this.parse(response);
        }
        catch (IOException e) {
            log.error((Object)("Exception parsing: " + this.getURL()), (Throwable)e);
        }
    }

    protected void netstat() {
    }
}

