/*
 * Decompiled with CFR 0.152.
 */
package org.hyperic.hq.plugin.apache;

import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.OutputStream;
import java.io.StringReader;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hyperic.hq.plugin.apache.ApacheServerDetector;
import org.hyperic.hq.product.PlatformDetector;
import org.hyperic.sigar.CpuTimer;
import org.hyperic.util.StringUtil;
import org.hyperic.util.exec.Execute;
import org.hyperic.util.exec.ExecuteStreamHandler;
import org.hyperic.util.exec.ExecuteWatchdog;
import org.hyperic.util.exec.PumpStreamHandler;
import org.hyperic.util.file.FileUtil;

public class ApacheBinaryInfo {
    private static final Log log = LogFactory.getLog((String)ApacheBinaryInfo.class.getName());
    private static final String[] CTL_SCRIPTS = new String[]{"apachectl", "apache2ctl"};
    private static HashMap cache = null;
    private static final String APACHE_VERSION = "Apache/";
    private static final String SERVER_VERSION = "Server version:";
    private static final String SERVER_BUILT = "Server built:";
    private static final String MPM_DIR = "-D APACHE_MPM_DIR=\"";
    public String version = null;
    public String root = null;
    public String conf;
    public String binary;
    public String ctl;
    public String built;
    public String mpm;
    public String name;
    public long pid = 0L;
    public String errmsg = "";
    private long lastModified = 0L;

    ApacheBinaryInfo() {
    }

    private ApacheBinaryInfo(ApacheBinaryInfo info) {
        this.version = info.version;
        this.root = info.root;
        this.conf = info.conf;
        this.binary = info.binary;
        this.ctl = info.ctl;
        this.built = info.built;
        this.mpm = info.mpm;
        this.name = info.name;
        this.errmsg = info.errmsg;
        this.lastModified = info.lastModified;
    }

    public static synchronized ApacheBinaryInfo getInfo(String binary) {
        ApacheBinaryInfo info = new ApacheBinaryInfo();
        if (binary.startsWith("\"")) {
            binary = binary.substring(1, binary.indexOf("\"", 1));
        }
        info.binary = binary;
        info.ctl = binary;
        try {
            info.getApacheBinaryInfo(binary);
        }
        catch (IOException e) {
            log.debug((Object)e, (Throwable)e);
        }
        return info;
    }

    public static ApacheBinaryInfo getInfo(String binary, String wantedVersion) {
        ApacheBinaryInfo info = ApacheBinaryInfo.getInfo(binary);
        if (info.version == null) {
            return null;
        }
        if (info.version.startsWith(wantedVersion)) {
            return info;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Map parseConfig(String file) {
        HashMap<String, String> values = new HashMap<String, String>();
        BufferedReader reader = null;
        try {
            String line;
            reader = new BufferedReader(new FileReader(file));
            while ((line = reader.readLine()) != null) {
                String[] ent;
                char chr;
                if (line.length() == 0 || (chr = line.charAt(0)) == '#' || chr == '<' || Character.isWhitespace(chr)) continue;
                int ix = line.indexOf(35);
                if (ix != -1) {
                    line = line.substring(0, ix);
                }
                if ((ent = StringUtil.explodeQuoted((String)(line = line.trim()))).length != 2) continue;
                values.put(ent[0], ent[1]);
            }
        }
        catch (IOException e) {
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (IOException e) {}
            }
        }
        return values;
    }

    public static String getVersion(String binary, String wantedVersion) {
        ApacheBinaryInfo info = ApacheBinaryInfo.getInfo(binary);
        if (info == null) {
            return null;
        }
        if (info.version.startsWith(wantedVersion)) {
            return info.version;
        }
        return null;
    }

    public static String getRootDir(String binary, String wantedVersion) {
        ApacheBinaryInfo info = ApacheBinaryInfo.getInfo(binary);
        if (info == null) {
            return null;
        }
        if (info.version.startsWith(wantedVersion)) {
            return info.root;
        }
        return null;
    }

    private boolean findVersion(String binary) throws IOException {
        if (this.version != null) {
            return true;
        }
        this.errmsg = "";
        String line = FileUtil.findString((String)binary, (String)APACHE_VERSION);
        if (line == null) {
            this.errmsg = "Unable to find 'Apache/' in: " + binary;
            return false;
        }
        int ix = line.indexOf(" ");
        if (ix != -1) {
            line = line.substring(0, ix);
        }
        ix = line.lastIndexOf(47);
        this.version = line.substring(ix + 1);
        return true;
    }

    private String findDefine(String binary, String name) throws IOException {
        this.errmsg = "";
        String define = "-D " + name + "=\"";
        String line = FileUtil.findString((String)binary, (String)define);
        if (line == null) {
            this.errmsg = "Unable to find -D " + name + " in: " + binary;
            return null;
        }
        String value = line.substring(define.length(), line.length() - 1);
        if (value.length() == 0) {
            this.errmsg = "Found -D " + name + " in: " + binary + " but value is empty";
            value = null;
        }
        return value;
    }

    private boolean findRoot(String binary) throws IOException {
        File conf;
        String file;
        this.root = this.findDefine(binary, "HTTPD_ROOT");
        if (this.root == null && (file = this.findDefine(binary, "SERVER_CONFIG_FILE")) != null && (conf = new File(file)).isAbsolute() && conf.exists()) {
            this.root = conf.getParent();
        }
        return this.root != null;
    }

    public File serverRootRelative(String name) {
        File file = new File(name);
        if (!file.isAbsolute() && this.root != null) {
            return new File(this.root, name);
        }
        return file;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void getVersionCmdInfo(String binary) {
        ByteArrayOutputStream stdOut = new ByteArrayOutputStream();
        ByteArrayOutputStream stdErr = new ByteArrayOutputStream();
        ExecuteWatchdog watchdog = new ExecuteWatchdog(1000);
        Execute ex = new Execute((ExecuteStreamHandler)new PumpStreamHandler((OutputStream)stdOut, (OutputStream)stdErr), watchdog);
        if (!PlatformDetector.isWin32()) {
            File lib = new File(new File(binary).getParentFile().getParentFile(), "lib");
            String[] env = new String[]{"LD_LIBRARY_PATH=" + lib.getAbsolutePath()};
            ex.setEnvironment(env);
        }
        ex.setCommandline(new String[]{binary, "-V"});
        BufferedReader is = null;
        try {
            String line;
            ex.execute();
            is = new BufferedReader(new StringReader(stdOut.toString()));
            while ((line = is.readLine()) != null) {
                int ix;
                if ((line = line.trim()).startsWith(SERVER_VERSION)) {
                    ix = (line = line.substring(SERVER_VERSION.length()).trim()).indexOf(47);
                    if (ix == -1) continue;
                    if ((ix = (line = line.substring(ix + 1)).indexOf(32)) != -1) {
                        line = line.substring(0, ix);
                    }
                    this.version = line;
                    continue;
                }
                if (line.startsWith(SERVER_BUILT)) {
                    this.built = line = line.substring(SERVER_BUILT.length()).trim();
                    continue;
                }
                if (!line.startsWith(MPM_DIR)) continue;
                ix = (line = line.substring(MPM_DIR.length()).trim()).lastIndexOf(34);
                if (ix != -1) {
                    line = line.substring(0, ix);
                }
                if ((ix = line.lastIndexOf("/")) != -1) {
                    line = line.substring(ix + 1);
                }
                this.mpm = line;
            }
        }
        catch (Exception e) {
            String msg = "Error running binary '" + binary + "': " + e.getMessage();
            log.debug((Object)msg, (Throwable)e);
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException e) {}
            }
        }
        log.debug((Object)("[getVersionCmdInfo] this=" + this));
    }

    private void getApacheBinaryInfo(String binary) throws IOException {
        File binaryFile = new File(binary);
        if (!binaryFile.exists()) {
            this.errmsg = "'" + binaryFile + "' not found";
            return;
        }
        if (binaryFile.isDirectory()) {
            this.errmsg = "'" + binaryFile + "' is a directory";
            return;
        }
        this.getVersionCmdInfo(binary);
        boolean isDLL = false;
        File libhttpd = null;
        File bindir = binaryFile.getParentFile();
        if (bindir == null) {
            throw new IOException(binary + " has no parent directory");
        }
        if (ApacheServerDetector.isWin32()) {
            libhttpd = new File(bindir, "libhttpd.dll");
            if (libhttpd.exists()) {
                isDLL = true;
            }
        } else {
            libhttpd = bindir.getParentFile();
            if (libhttpd != null && (libhttpd = new File(libhttpd, "libexec/libhttpd.so")).exists()) {
                binary = libhttpd.getAbsolutePath();
            }
        }
        for (int i = 0; i < CTL_SCRIPTS.length; ++i) {
            File script = new File(bindir, CTL_SCRIPTS[i]);
            if (!script.exists()) continue;
            this.ctl = script.toString();
        }
        if (!(this.findVersion(binary) || isDLL && this.findVersion(libhttpd.getAbsolutePath()))) {
            return;
        }
        if (!this.findRoot(binary)) {
            return;
        }
    }

    public Properties toProperties() {
        Properties props = new Properties();
        props.setProperty("exe", this.binary);
        if (this.mpm != null) {
            props.setProperty("mpm", this.mpm);
        }
        if (this.built != null) {
            props.setProperty("built", this.built);
        }
        return props;
    }

    public String toString() {
        String info = "version=" + this.version + ", root=" + this.root + ", binary=" + this.binary + ", ctl=" + this.ctl;
        if (this.mpm != null) {
            info = info + ", mpm=" + this.mpm;
        }
        if (this.built != null) {
            info = info + ", build=" + this.built;
        }
        if (this.errmsg.length() > 0) {
            info = info + ", errmsg=" + this.errmsg;
        }
        return info;
    }

    public static void main(String[] args) {
        CpuTimer cpu = new CpuTimer();
        cpu.start();
        String binary = args[0];
        System.out.println(ApacheBinaryInfo.getInfo(binary));
        cpu.stop();
        cpu.list(System.out);
    }
}

